/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.net.URL;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;

public class FxServiceDemo {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.fx.multi.FxServiceDemo");
    @FXML
    private Button disconnectButton;
    @FXML
    private Button cancelButton;
    @FXML
    private Label messagesLabel;
    @FXML
    private Button connectButton;
    private ConnectService connectService;
    private DisconnectService disconnectService;
    private StringProperty statusMessagesProperty;
    private BooleanProperty connectedProperty;

    public FxServiceDemo() {
        if (FxServiceDemo.logger.level >= 7) {
            logger.lvlBuild(7, "FxServiceDemo()", 78).log();
        }
    }

    public static Node getRootNode() {
        if (FxServiceDemo.logger.level >= 7) {
            logger.lvlBuild(7, "getRootNode()", 90).log();
        }
        try {
            return (Node)FXMLLoader.load((URL)FxServiceDemo.class.getResource("FxServiceDemo.fxml"));
        }
        catch (Throwable throwable) {
            System.err.println("Unable to load fxml file!");
            return null;
        }
    }

    @FXML
    public void initialize() {
        if (FxServiceDemo.logger.level >= 7) {
            logger.lvlBuild(7, "initialize()", 105).log();
        }
        this.connectService = new ConnectService();
        this.disconnectService = new DisconnectService();
        BooleanBinding booleanBinding = this.connectService.runningProperty().or((ObservableBooleanValue)this.disconnectService.runningProperty());
        this.cancelButton.visibleProperty().bind((ObservableValue)booleanBinding);
        this.messagesLabel.textProperty().bind((ObservableValue)this.statusMessagesProperty());
        this.connectService.messageProperty().addListener((observableValue, string, string2) -> this.statusMessagesProperty().set(string2));
        this.disconnectService.messageProperty().addListener((observableValue, string, string2) -> this.statusMessagesProperty().set(string2));
        this.statusMessagesProperty().set((Object)"Disconnected.");
    }

    @FXML
    public void cancel() {
        if (FxServiceDemo.logger.level >= 7) {
            logger.lvlBuild(7, "cancel()", 130).log();
        }
        this.connectService.cancel();
        this.disconnectService.cancel();
    }

    @FXML
    public void connect() {
        if (FxServiceDemo.logger.level >= 7) {
            logger.lvlBuild(7, "connect()", 139).log();
        }
        this.disconnectService.cancel();
        this.connectService.restart();
    }

    @FXML
    public void disconnect() {
        if (FxServiceDemo.logger.level >= 7) {
            logger.lvlBuild(7, "disconnect()", 148).log();
        }
        this.connectService.cancel();
        this.disconnectService.restart();
    }

    private StringProperty statusMessagesProperty() {
        if (FxServiceDemo.logger.level >= 7) {
            logger.lvlBuild(7, "statusMessagesProperty()", 156).log();
        }
        if (this.statusMessagesProperty == null) {
            this.statusMessagesProperty = new SimpleStringProperty();
        }
        return this.statusMessagesProperty;
    }

    private BooleanProperty connectedProperty() {
        if (FxServiceDemo.logger.level >= 7) {
            logger.lvlBuild(7, "connectedProperty()", 166).log();
        }
        if (this.connectedProperty == null) {
            this.connectedProperty = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
        }
        return this.connectedProperty;
    }

    private class DisconnectService
    extends Service {
        private DisconnectService() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "DisconnectService.DisconnectService()", 231).log();
            }
        }

        protected void succeeded() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "DisconnectService.succeeded()", 238).log();
            }
            FxServiceDemo.this.statusMessagesProperty().set((Object)"");
            FxServiceDemo.this.connectedProperty().set(false);
        }

        protected void cancelled() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "DisconnectService.cancelled()", 247).log();
            }
            FxServiceDemo.this.statusMessagesProperty().set((Object)"Disconnecting cancelled.");
            FxServiceDemo.this.connectedProperty().set(false);
        }

        protected Task createTask() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "DisconnectService.createTask()", 256).log();
            }
            return new Task(){

                protected Void call() throws Exception {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "DisconnectService.createTask().Task<Void>.call()", 259).log();
                    }
                    this.updateMessage("Disconnecting....");
                    Thread.sleep(2000L);
                    this.updateMessage("Waiting for server feedback.");
                    Thread.sleep(2000L);
                    return null;
                }
            };
        }
    }

    private class ConnectService
    extends Service {
        private ConnectService() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ConnectService.ConnectService()", 177).log();
            }
        }

        protected void succeeded() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ConnectService.succeeded()", 182).log();
            }
            FxServiceDemo.this.statusMessagesProperty().set((Object)"Connected.");
            FxServiceDemo.this.connectedProperty().set(true);
        }

        protected void failed() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ConnectService.failed()", 191).log();
            }
            if (logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "ConnectService.failed()", 192).add("getException()", (Object)this.getException())).log();
            }
            FxServiceDemo.this.statusMessagesProperty().set((Object)"Connecting failed.");
            FxServiceDemo.this.connectedProperty().set(false);
        }

        protected void cancelled() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ConnectService.cancelled()", 201).log();
            }
            FxServiceDemo.this.statusMessagesProperty().set((Object)"Connecting cancelled.");
            FxServiceDemo.this.connectedProperty().set(false);
        }

        protected Task createTask() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ConnectService.createTask()", 210).log();
            }
            return new Task(){

                protected Void call() throws Exception {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "ConnectService.createTask().Task<Void>.call()", 213).log();
                    }
                    this.updateMessage("Connecting....");
                    Thread.sleep(2000L);
                    this.updateMessage("Waiting for server feedback.");
                    Thread.sleep(2000L);
                    return null;
                }
            };
        }
    }
}

