/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.MultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.behavior.MenuButtonBehavior;
import com.sun.javafx.scene.control.behavior.MenuButtonBehaviorBase;
import com.sun.javafx.scene.control.behavior.TextBinding;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusPopupBehavior;
import com.sun.javafx.scene.control.skin.EmbeddedTextContextMenuContent;
import com.sun.javafx.scene.control.skin.MenuButtonSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javafx.application.Application;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.Mnemonic;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class FxSpecialMenuItem
extends Application {
    public static void main(String[] stringArray) {
        FxSpecialMenuItem.launch((String[])stringArray);
    }

    public static Node getRootNode() {
        MenuButton menuButton = new MenuButton("javafx");
        for (int i = 0; i < 101; ++i) {
            MenuItem menuItem = new MenuItem("menu-item-" + i);
            menuButton.getItems().add((Object)menuItem);
        }
        MenuButton menuButton2 = new MenuButton("extender");
        menuButton2.setSkin((Skin)new EnhancedMenuButtonSkin(menuButton2));
        for (int i = 0; i < 101; ++i) {
            MenuItem menuItem = new MenuItem("menu-item-" + i);
            menuButton2.getItems().add((Object)menuItem);
        }
        HBox hBox = new HBox(new Node[]{menuButton, menuButton2});
        hBox.setSpacing(10.0);
        hBox.setPadding(new Insets(10.0));
        return hBox;
    }

    public void start(Stage stage) {
        MenuItem menuItem;
        stage.setResizable(false);
        MenuButton menuButton = new MenuButton("javafx");
        for (int i = 0; i < 101; ++i) {
            MenuItem menuItem2 = new MenuItem("menu-item-" + i);
            menuButton.getItems().add((Object)menuItem2);
        }
        MenuButton menuButton2 = new MenuButton("extender");
        menuButton2.setSkin((Skin)new EnhancedMenuButtonSkin(menuButton2));
        for (int i = 0; i < 101; ++i) {
            menuItem = new MenuItem("menu-item-" + i);
            menuButton2.getItems().add((Object)menuItem);
        }
        HBox hBox = new HBox(new Node[]{menuButton, menuButton2});
        hBox.setSpacing(10.0);
        hBox.setPadding(new Insets(10.0));
        menuItem = new Scene((Parent)hBox, 200.0, 100.0);
        stage.setScene((Scene)menuItem);
        stage.setTitle("Scrolled menu");
        stage.show();
    }

    public static void reconfigurePopup(Node node, PopupWindow popupWindow) {
        Bounds bounds = node.localToScreen(node.getLayoutBounds());
        double d = bounds.getMinX();
        double d2 = bounds.getMaxX();
        double d3 = bounds.getMaxY();
        double d4 = popupWindow.getWidth();
        double d5 = d;
        Window window = node.getScene().getWindow();
        Rectangle2D rectangle2D = new Rectangle2D(window.getX(), window.getY(), window.getWidth(), window.getHeight());
        if (d2 + d4 > rectangle2D.getMaxX()) {
            d5 = Math.min(d5, rectangle2D.getMaxX() - d4);
            d5 = Math.max(d5, rectangle2D.getMinX());
        } else {
            d5 = Math.max(d5, rectangle2D.getMinX());
            d5 = Math.min(d5, rectangle2D.getMaxX() - d4);
        }
        Point2D point2D = new Point2D(d5, d3);
        popupWindow.setAutoFix(false);
        popupWindow.setAnchorX(point2D.getX());
        popupWindow.setAnchorY(point2D.getY());
    }

    public static void addMnemonics(ContextMenu contextMenu, Scene scene, boolean bl) {
        if (!PlatformUtil.isMac()) {
            EnhancedContextMenuContent enhancedContextMenuContent = (EnhancedContextMenuContent)contextMenu.getSkin().getNode();
            for (int i = 0; i < contextMenu.getItems().size(); ++i) {
                TextBinding textBinding;
                int n;
                MenuItem menuItem = (MenuItem)contextMenu.getItems().get(i);
                if (!menuItem.isMnemonicParsing() || (n = (textBinding = new TextBinding(menuItem.getText())).getMnemonicIndex()) < 0) continue;
                KeyCombination keyCombination = textBinding.getMnemonicKeyCombination();
                Mnemonic mnemonic = new Mnemonic((Node)enhancedContextMenuContent.getLabelAt(i), keyCombination);
                scene.addMnemonic(mnemonic);
                enhancedContextMenuContent.getLabelAt(i).impl_setShowMnemonics(bl);
            }
        }
    }

    public static void removeMnemonics(ContextMenu contextMenu, Scene scene) {
        if (!PlatformUtil.isMac()) {
            EnhancedContextMenuContent enhancedContextMenuContent = (EnhancedContextMenuContent)contextMenu.getSkin().getNode();
            for (int i = 0; i < contextMenu.getItems().size(); ++i) {
                TextBinding textBinding;
                int n;
                MenuItem menuItem = (MenuItem)contextMenu.getItems().get(i);
                if (!menuItem.isMnemonicParsing() || (n = (textBinding = new TextBinding(menuItem.getText())).getMnemonicIndex()) < 0) continue;
                KeyCombination keyCombination = textBinding.getMnemonicKeyCombination();
                ObservableList observableList = (ObservableList)scene.getMnemonics().get((Object)keyCombination);
                if (observableList == null) continue;
                for (int j = 0; j < observableList.size(); ++j) {
                    if (((Mnemonic)observableList.get(j)).getNode() != enhancedContextMenuContent.getLabelAt(i)) continue;
                    observableList.remove(j);
                }
            }
        }
    }

    public static boolean canDisableRightButtonClick(MouseEvent mouseEvent, Control control) {
        if (mouseEvent.isSecondaryButtonDown()) {
            return control.getContextMenu() == null;
        }
        return false;
    }

    public static Window getMainWindow(PopupWindow popupWindow) {
        Window window = popupWindow.getOwnerWindow();
        if (window instanceof PopupWindow) {
            return FxSpecialMenuItem.getMainWindow((PopupWindow)popupWindow.getOwnerWindow());
        }
        return window;
    }

    public static int compare(double d, double d2) {
        long l;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        long l2 = Double.doubleToLongBits(d);
        if (l2 == (l = Double.doubleToLongBits(d2))) {
            return 0;
        }
        return l2 < l ? -1 : 1;
    }

    private static class MenuItemContainer
    extends Region {
        private static final PseudoClass SELECTED_PSEUDO_CLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
        private static final PseudoClass DISABLED_PSEUDO_CLASS_STATE = PseudoClass.getPseudoClass((String)"disabled");
        private static final PseudoClass CHECKED_PSEUDO_CLASS_STATE = PseudoClass.getPseudoClass((String)"checked");
        private final EnhancedContextMenuContent enhancedContextMenuContent;
        private final MenuItem item;
        private final EventHandler actionEventHandler;
        private Node left;
        private Node graphic;
        private Label label;
        private Node right;
        private EventHandler mouseEnteredEventHandler;
        private EventHandler mouseReleasedEventHandler;
        private EventHandler customMenuItemMouseClickedHandler;
        private final MultiplePropertyChangeListenerHandler listener = new MultiplePropertyChangeListenerHandler(string -> {
            this.handlePropertyChanged((String)string);
            return null;
        });

        public MenuItemContainer(EnhancedContextMenuContent enhancedContextMenuContent, MenuItem menuItem) {
            this.enhancedContextMenuContent = enhancedContextMenuContent;
            this.getStyleClass().addAll((Collection)menuItem.getStyleClass());
            this.setId(menuItem.getId());
            this.setFocusTraversable(!(menuItem instanceof CustomMenuItem));
            this.item = menuItem;
            this.createChildren();
            if (menuItem instanceof Menu) {
                ReadOnlyBooleanProperty readOnlyBooleanProperty = ((Menu)menuItem).showingProperty();
                this.listener.registerChangeListener((ObservableValue)readOnlyBooleanProperty, "MENU_SHOWING");
                this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS_STATE, readOnlyBooleanProperty.get());
                this.setAccessibleRole(AccessibleRole.MENU);
            } else if (menuItem instanceof RadioMenuItem) {
                BooleanProperty booleanProperty = ((RadioMenuItem)menuItem).selectedProperty();
                this.listener.registerChangeListener((ObservableValue)booleanProperty, "RADIO_ITEM_SELECTED");
                this.pseudoClassStateChanged(CHECKED_PSEUDO_CLASS_STATE, booleanProperty.get());
                this.setAccessibleRole(AccessibleRole.RADIO_MENU_ITEM);
            } else if (menuItem instanceof CheckMenuItem) {
                BooleanProperty booleanProperty = ((CheckMenuItem)menuItem).selectedProperty();
                this.listener.registerChangeListener((ObservableValue)booleanProperty, "CHECK_ITEM_SELECTED");
                this.pseudoClassStateChanged(CHECKED_PSEUDO_CLASS_STATE, booleanProperty.get());
                this.setAccessibleRole(AccessibleRole.CHECK_MENU_ITEM);
            } else {
                this.setAccessibleRole(AccessibleRole.MENU_ITEM);
            }
            this.setAccessibleText((String)menuItem.getProperties().get((Object)"AccessibleText"));
            this.setAccessibleHelp((String)menuItem.getProperties().get((Object)"AccessibleHelp"));
            this.setDisable(menuItem.isDisable());
            this.pseudoClassStateChanged(DISABLED_PSEUDO_CLASS_STATE, menuItem.disableProperty().get());
            this.listener.registerChangeListener((ObservableValue)menuItem.disableProperty(), "DISABLE");
            this.getProperties().put(MenuItem.class, (Object)menuItem);
            this.listener.registerChangeListener((ObservableValue)menuItem.graphicProperty(), "GRAPHIC");
            this.actionEventHandler = actionEvent -> {
                if (menuItem instanceof Menu) {
                    Menu menu = (Menu)menuItem;
                    if (enhancedContextMenuContent.getOpenSubMenu() == menu && enhancedContextMenuContent.getOpenSubMenu().isShowing()) {
                        return;
                    }
                    if (enhancedContextMenuContent.getOpenSubMenu() != null) {
                        enhancedContextMenuContent.hideSubmenu();
                    }
                    enhancedContextMenuContent.selectedBackground = this;
                    enhancedContextMenuContent.showMenu(menu);
                } else {
                    this.doSelect();
                }
            };
            this.addEventHandler(ActionEvent.ACTION, this.actionEventHandler);
        }

        public Node getLeft() {
            return this.left;
        }

        public Node getGraphic() {
            return this.graphic;
        }

        public Node getRight() {
            return this.right;
        }

        protected Label getLabel() {
            return this.label;
        }

        public MenuItem getItem() {
            return this.item;
        }

        public void dispose() {
            Node node;
            if (this.item instanceof CustomMenuItem && (node = ((CustomMenuItem)this.item).getContent()) != null) {
                node.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.customMenuItemMouseClickedHandler);
            }
            this.listener.dispose();
            this.removeEventHandler(ActionEvent.ACTION, this.actionEventHandler);
            if (this.label != null) {
                this.label.textProperty().unbind();
            }
            this.left = null;
            this.graphic = null;
            this.label = null;
            this.right = null;
        }

        private void handlePropertyChanged(String string) {
            switch (string) {
                case "MENU_SHOWING": {
                    Menu menu = (Menu)this.item;
                    this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS_STATE, menu.isShowing());
                    break;
                }
                case "RADIO_ITEM_SELECTED": {
                    RadioMenuItem radioMenuItem = (RadioMenuItem)this.item;
                    this.pseudoClassStateChanged(CHECKED_PSEUDO_CLASS_STATE, radioMenuItem.isSelected());
                    break;
                }
                case "CHECK_ITEM_SELECTED": {
                    CheckMenuItem checkMenuItem = (CheckMenuItem)this.item;
                    this.pseudoClassStateChanged(CHECKED_PSEUDO_CLASS_STATE, checkMenuItem.isSelected());
                    break;
                }
                case "DISABLE": {
                    this.pseudoClassStateChanged(DISABLED_PSEUDO_CLASS_STATE, this.item.isDisable());
                    this.setDisable(this.item.isDisable());
                    break;
                }
                case "GRAPHIC": {
                    this.createChildren();
                    this.enhancedContextMenuContent.computeVisualMetrics();
                    break;
                }
                case "ACCELERATOR": {
                    this.updateAccelerator();
                    break;
                }
                case "FOCUSED": {
                    if (!this.isFocused()) break;
                    this.enhancedContextMenuContent.setCurrentFocusedIndex(this.enhancedContextMenuContent.itemsContainer.getChildren().indexOf((Object)this));
                    break;
                }
            }
        }

        private void createChildren() {
            this.getChildren().clear();
            if (this.item instanceof CustomMenuItem) {
                this.createNodeMenuItemChildren((CustomMenuItem)this.item);
                if (this.mouseEnteredEventHandler == null) {
                    this.mouseEnteredEventHandler = mouseEvent -> this.shouldReturnFocus();
                } else {
                    this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
                }
                this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            } else {
                StackPane stackPane;
                Object var1_1 = null;
                if (var1_1 != null) {
                    stackPane = new StackPane();
                    stackPane.getStyleClass().add((Object)"left-container");
                    stackPane.getChildren().add(var1_1);
                    this.left = stackPane;
                    this.getChildren().add((Object)this.left);
                    this.left.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
                }
                if (this.item.getGraphic() != null) {
                    stackPane = this.item.getGraphic();
                    StackPane stackPane2 = new StackPane();
                    stackPane2.getStyleClass().add((Object)"graphic-container");
                    stackPane2.getChildren().add((Object)stackPane);
                    this.graphic = stackPane2;
                    this.getChildren().add((Object)this.graphic);
                }
                this.label = new MenuLabel(this.item, this);
                this.label.setStyle(this.item.getStyle());
                this.label.textProperty().bind((ObservableValue)this.item.textProperty());
                this.label.setMouseTransparent(true);
                this.label.setAccessibleText((String)this.item.getProperties().get((Object)"AccessibleText"));
                this.label.setAccessibleHelp((String)this.item.getProperties().get((Object)"AccessibleHelp"));
                this.getChildren().add((Object)this.label);
                this.listener.unregisterChangeListener((ObservableValue)this.focusedProperty());
                this.listener.registerChangeListener((ObservableValue)this.focusedProperty(), "FOCUSED");
                if (this.item instanceof Menu) {
                    this.createMenu();
                } else {
                    this.listener.unregisterChangeListener((ObservableValue)this.item.acceleratorProperty());
                    this.updateAccelerator();
                    if (this.mouseEnteredEventHandler == null) {
                        this.mouseEnteredEventHandler = mouseEvent -> {
                            if (this.enhancedContextMenuContent.getOpenSubMenu() != null) {
                                this.enhancedContextMenuContent.getOpenSubMenu().hide();
                            }
                            this.shouldReturnFocus();
                        };
                    } else {
                        this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
                    }
                    if (this.mouseReleasedEventHandler == null) {
                        this.mouseReleasedEventHandler = mouseEvent -> this.doSelect();
                    } else {
                        this.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
                    }
                    this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
                    this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
                    this.listener.registerChangeListener((ObservableValue)this.item.acceleratorProperty(), "ACCELERATOR");
                }
            }
        }

        private void createMenu() {
            Region region = new Region();
            region.setMouseTransparent(true);
            region.getStyleClass().add((Object)"arrow");
            StackPane stackPane = new StackPane();
            stackPane.setMouseTransparent(true);
            stackPane.getStyleClass().add((Object)"right-container");
            stackPane.getChildren().add((Object)region);
            this.right = stackPane;
            this.getChildren().add((Object)stackPane);
            if (this.mouseEnteredEventHandler == null) {
                this.mouseEnteredEventHandler = mouseEvent -> {
                    Menu menu;
                    if (this.enhancedContextMenuContent.getOpenSubMenu() != null && this.item != this.enhancedContextMenuContent.getOpenSubMenu()) {
                        this.enhancedContextMenuContent.hideSubmenu();
                    }
                    if ((menu = (Menu)this.item).isDisable()) {
                        return;
                    }
                    this.enhancedContextMenuContent.selectedBackground = this;
                    menu.show();
                    this.requestFocus();
                };
            } else {
                this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            }
            if (this.mouseReleasedEventHandler == null) {
                this.mouseReleasedEventHandler = mouseEvent -> this.item.fire();
            } else {
                this.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
            }
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
        }

        private void updateAccelerator() {
            if (this.item.getAccelerator() != null) {
                if (this.right != null) {
                    this.getChildren().remove((Object)this.right);
                }
                String string = this.item.getAccelerator().getDisplayText();
                this.right = new Label(string);
                this.right.setStyle(this.item.getStyle());
                this.right.getStyleClass().add((Object)"accelerator-text");
                this.getChildren().add((Object)this.right);
            } else {
                this.getChildren().remove((Object)this.right);
            }
        }

        void doSelect() {
            CheckMenuItem checkMenuItem;
            if (this.item.isDisable()) {
                return;
            }
            if (this.item instanceof CheckMenuItem) {
                checkMenuItem.setSelected(!(checkMenuItem = (CheckMenuItem)this.item).isSelected());
            } else if (this.item instanceof RadioMenuItem) {
                checkMenuItem.setSelected((checkMenuItem = (RadioMenuItem)this.item).getToggleGroup() != null || !checkMenuItem.isSelected());
            }
            this.item.fire();
            if (this.item instanceof CustomMenuItem) {
                checkMenuItem = (CustomMenuItem)this.item;
                if (checkMenuItem.isHideOnClick()) {
                    this.enhancedContextMenuContent.hideAllMenus(this.item);
                }
            } else {
                this.enhancedContextMenuContent.hideAllMenus(this.item);
            }
        }

        private void createNodeMenuItemChildren(CustomMenuItem customMenuItem) {
            Node node = customMenuItem.getContent();
            this.getChildren().add((Object)node);
            this.customMenuItemMouseClickedHandler = mouseEvent -> {
                if (customMenuItem.isDisable()) {
                    return;
                }
                customMenuItem.fire();
                if (customMenuItem.isHideOnClick()) {
                    this.enhancedContextMenuContent.hideAllMenus((MenuItem)customMenuItem);
                }
            };
            node.addEventHandler(MouseEvent.MOUSE_CLICKED, this.customMenuItemMouseClickedHandler);
        }

        protected void layoutChildren() {
            double d;
            double d2 = this.prefHeight(-1.0);
            if (this.left != null) {
                d = this.snappedLeftInset();
                this.left.resize(this.left.prefWidth(-1.0), this.left.prefHeight(-1.0));
                this.positionInArea(this.left, d, 0.0, this.enhancedContextMenuContent.getMaxLeftWidth(), d2, 0.0, HPos.LEFT, VPos.CENTER);
            }
            if (this.graphic != null) {
                d = this.snappedLeftInset() + this.enhancedContextMenuContent.getMaxLeftWidth();
                this.graphic.resize(this.graphic.prefWidth(-1.0), this.graphic.prefHeight(-1.0));
                this.positionInArea(this.graphic, d, 0.0, this.enhancedContextMenuContent.getMaxGraphicWidth(), d2, 0.0, HPos.LEFT, VPos.CENTER);
            }
            if (this.label != null) {
                d = this.snappedLeftInset() + this.enhancedContextMenuContent.getMaxLeftWidth() + this.enhancedContextMenuContent.getMaxGraphicWidth();
                this.label.resize(this.label.prefWidth(-1.0), this.label.prefHeight(-1.0));
                this.positionInArea((Node)this.label, d, 0.0, this.enhancedContextMenuContent.getMaxLabelWidth(), d2, 0.0, HPos.LEFT, VPos.CENTER);
            }
            if (this.right != null) {
                d = this.snappedLeftInset() + this.enhancedContextMenuContent.getMaxLeftWidth() + this.enhancedContextMenuContent.getMaxGraphicWidth() + this.enhancedContextMenuContent.getMaxLabelWidth();
                this.right.resize(this.right.prefWidth(-1.0), this.right.prefHeight(-1.0));
                this.positionInArea(this.right, d, 0.0, this.enhancedContextMenuContent.getMaxRightWidth(), d2, 0.0, HPos.RIGHT, VPos.CENTER);
            }
            if (this.item instanceof CustomMenuItem) {
                Node node = ((CustomMenuItem)this.item).getContent();
                if (this.item instanceof SeparatorMenuItem) {
                    double d3 = this.prefWidth(-1.0) - (this.snappedLeftInset() + this.enhancedContextMenuContent.getMaxGraphicWidth() + this.snappedRightInset());
                    node.resize(d3, node.prefHeight(-1.0));
                    this.positionInArea(node, this.snappedLeftInset() + this.enhancedContextMenuContent.getMaxGraphicWidth(), 0.0, this.prefWidth(-1.0), d2, 0.0, HPos.LEFT, VPos.CENTER);
                } else {
                    node.resize(node.prefWidth(-1.0), node.prefHeight(-1.0));
                    this.positionInArea(node, this.snappedLeftInset(), 0.0, this.getWidth(), d2, 0.0, HPos.LEFT, VPos.CENTER);
                }
            }
        }

        private void recalculateLabelPadding() {
            this.label.applyCss();
            double d = this.label.getFont().getSize() / Font.getDefault().getSize();
            Insets insets = this.label.getPadding();
            Insets insets2 = new Insets(this.snapSize(insets.getTop() * d), this.snapSize(insets.getRight() * d), this.snapSize(insets.getBottom() * d), this.snapSize(insets.getLeft() * d));
            this.label.setPadding(insets2);
        }

        private void shouldReturnFocus() {
            Styleable styleable = this.enhancedContextMenuContent.getStyleableParent().getStyleableParent();
            Node node = (Node)styleable;
            if (node != null) {
                Optional<String> optional = node.getPseudoClassStates().stream().map(PseudoClass::getPseudoClassName).filter("focused"::equals).findFirst();
                this.requestFocus();
                if (optional.isPresent()) {
                    node.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"focused"), true);
                }
            } else {
                this.requestFocus();
            }
        }

        protected double computePrefHeight(double d) {
            double d2 = 0.0;
            if (this.item instanceof CustomMenuItem) {
                d2 = this.getChildren().isEmpty() ? 0.0 : ((Node)this.getChildren().get(0)).prefHeight(-1.0);
            } else {
                this.recalculateLabelPadding();
                d2 = Math.max(d2, this.left != null ? this.left.prefHeight(-1.0) : 0.0);
                d2 = Math.max(d2, this.graphic != null ? this.graphic.prefHeight(-1.0) : 0.0);
                d2 = Math.max(d2, this.label != null ? this.label.prefHeight(-1.0) : 0.0);
                d2 = Math.max(d2, this.right != null ? this.right.prefHeight(-1.0) : 0.0);
            }
            return this.snappedTopInset() + d2 + this.snappedBottomInset();
        }

        protected double computePrefWidth(double d) {
            double d2 = 0.0;
            if (this.item instanceof CustomMenuItem && !(this.item instanceof SeparatorMenuItem)) {
                d2 = this.snappedLeftInset() + ((CustomMenuItem)this.item).getContent().prefWidth(-1.0) + this.snappedRightInset();
            }
            return Math.max(d2, this.snappedLeftInset() + this.enhancedContextMenuContent.getMaxLeftWidth() + this.enhancedContextMenuContent.getMaxGraphicWidth() + this.enhancedContextMenuContent.getMaxLabelWidth() + this.enhancedContextMenuContent.getMaxRightWidth() + this.snappedRightInset());
        }

        public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
            switch (accessibleAttribute) {
                case SELECTED: {
                    if (this.item instanceof CheckMenuItem) {
                        return ((CheckMenuItem)this.item).isSelected();
                    }
                    if (this.item instanceof RadioMenuItem) {
                        return ((RadioMenuItem)this.item).isSelected();
                    }
                    return false;
                }
                case ACCELERATOR: {
                    return this.item.getAccelerator();
                }
                case TEXT: {
                    return this.handleAccessibleAttributeText();
                }
                case MNEMONIC: {
                    return this.handleAccessibleAttributeMnemonic();
                }
                case DISABLED: {
                    return this.item.isDisable();
                }
                case SUBMENU: {
                    this.enhancedContextMenuContent.createSubmenu();
                    if (this.enhancedContextMenuContent.getSubMenu().getSkin() == null) {
                        this.enhancedContextMenuContent.getSubMenu().impl_styleableGetNode().impl_processCSS(true);
                    }
                    EnhancedContextMenuContent enhancedContextMenuContent = (EnhancedContextMenuContent)this.enhancedContextMenuContent.getSubMenu().getSkin().getNode();
                    return enhancedContextMenuContent.itemsContainer;
                }
            }
            return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
        }

        private Object handleAccessibleAttributeMnemonic() {
            String string;
            Label label = this.getLabel();
            if (label != null && (string = (String)label.queryAccessibleAttribute(AccessibleAttribute.MNEMONIC, new Object[0])) != null) {
                return string;
            }
            return null;
        }

        private Object handleAccessibleAttributeText() {
            String string;
            String string2;
            Object object;
            String string3 = "";
            if (this.graphic != null && (object = (String)this.graphic.queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                string3 = string3 + (String)object;
            }
            if ((object = this.getLabel()) != null && (string2 = (String)object.queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                string3 = string3 + string2;
            }
            if (this.item instanceof CustomMenuItem && (string2 = ((CustomMenuItem)this.item).getContent()) != null && (string = (String)string2.queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                string3 = string3 + string;
            }
            return string3;
        }

        public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
            switch (accessibleAction) {
                case SHOW_MENU: {
                    this.handleAccessibleActionShowMenu();
                    break;
                }
                case FIRE: {
                    this.doSelect();
                    break;
                }
                default: {
                    super.executeAccessibleAction(accessibleAction, new Object[0]);
                }
            }
        }

        private void handleAccessibleActionShowMenu() {
            if (this.item instanceof Menu) {
                Menu menu = (Menu)this.item;
                if (menu.isShowing()) {
                    menu.hide();
                } else {
                    menu.show();
                }
            }
        }

        private static final class MenuLabel
        extends Label {
            public MenuLabel(MenuItem menuItem, MenuItemContainer menuItemContainer) {
                super(menuItem.getText());
                this.setMnemonicParsing(menuItem.isMnemonicParsing());
                this.setLabelFor((Node)menuItemContainer);
            }
        }
    }

    private static class EnhancedContextMenuContent
    extends Region {
        private static final int MAX_VISIBLE_ITEMS = 7;
        private static final Set KEY_CODES = Collections.unmodifiableSet(EnumSet.of(KeyCode.DOWN, new KeyCode[]{KeyCode.UP, KeyCode.LEFT, KeyCode.RIGHT, KeyCode.SPACE, KeyCode.PAGE_UP, KeyCode.PAGE_DOWN}));
        MenuBoxContainer itemsContainer;
        Region selectedBackground;
        private ContextMenu contextMenu;
        private double maxGraphicWidth;
        private double maxRightWidth;
        private double maxLabelWidth;
        private double maxLeftWidth;
        private double oldWidth;
        private int currentFocusedIndex = -1;
        private boolean itemsDirty = true;
        private final ChangeListener popupShowingListener = (observableValue, bl, bl2) -> {
            this.updateItems();
            if (bl2.booleanValue()) {
                this.scrollToSelectedItem();
            }
        };
        private final WeakChangeListener weakPopupShowingListener = new WeakChangeListener(this.popupShowingListener);
        private ScrollPane scrollPane;
        private ChangeListener menuItemVisibleListener = (observableValue, bl, bl2) -> this.requestLayout();
        private Menu openSubmenu;
        private ContextMenu submenu;
        private ChangeListener menuShowingListener = (observableValue, bl, bl2) -> {
            ReadOnlyBooleanProperty readOnlyBooleanProperty = (ReadOnlyBooleanProperty)observableValue;
            Menu menu = (Menu)readOnlyBooleanProperty.getBean();
            if (bl.booleanValue() && !bl2.booleanValue()) {
                this.hideSubmenu();
            } else if (!bl.booleanValue() && bl2.booleanValue()) {
                this.showSubmenu(menu);
            }
        };
        private ListChangeListener contextMenuItemsListener = change -> {
            while (change.next()) {
                this.updateMenuShowingListeners(change.getRemoved(), false);
                this.updateMenuShowingListeners(change.getAddedSubList(), true);
            }
            this.itemsDirty = true;
            this.updateItems();
        };

        public EnhancedContextMenuContent(ContextMenu contextMenu) {
            this.contextMenu = contextMenu;
            this.initialize();
            this.setUpBinds();
            this.updateItems();
            contextMenu.showingProperty().addListener((ChangeListener)this.weakPopupShowingListener);
            if (Utils.isTwoLevelFocus()) {
                new TwoLevelFocusPopupBehavior((Node)this);
            }
        }

        public double getMaxGraphicWidth() {
            return this.maxGraphicWidth;
        }

        public double getMaxRightWidth() {
            return this.maxRightWidth;
        }

        public double getMaxLabelWidth() {
            return this.maxLabelWidth;
        }

        public double getMaxLeftWidth() {
            return this.maxLeftWidth;
        }

        private ScrollPane createScrollPane() {
            ScrollPane scrollPane = new ScrollPane((Node)this.itemsContainer);
            scrollPane.getStyleClass().setAll((Object[])new String[]{"context-menu-scroll-pane"});
            scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            scrollPane.setFitToWidth(true);
            scrollPane.setOnKeyPressed(keyEvent -> {
                if (keyEvent.getCode() == KeyCode.TAB) {
                    keyEvent.consume();
                    Window window = FxSpecialMenuItem.getMainWindow((PopupWindow)this.contextMenu);
                    EnhancedContextMenuContent.hideContextMenu(this.contextMenu);
                    if (window != null && window.getScene().getFocusOwner() != null) {
                        Event.fireEvent((EventTarget)window.getScene().getFocusOwner(), (Event)keyEvent);
                    }
                }
                if (KEY_CODES.contains(keyEvent.getCode())) {
                    keyEvent.consume();
                    Event.fireEvent((EventTarget)this, (Event)keyEvent);
                }
            });
            return scrollPane;
        }

        private static void hideContextMenu(ContextMenu contextMenu) {
            contextMenu.hide();
            if (contextMenu.getOwnerWindow() instanceof PopupWindow) {
                EnhancedContextMenuContent.hideContextMenu((ContextMenu)contextMenu.getOwnerWindow());
            }
        }

        public Pane getItemsContainer() {
            return this.itemsContainer;
        }

        void setCurrentFocusedIndex(int n) {
            if (n < this.itemsContainer.getChildren().size()) {
                this.currentFocusedIndex = n;
            }
        }

        private void updateItems() {
            if (this.itemsDirty) {
                this.updateVisualItems();
                this.itemsDirty = false;
            }
        }

        void computeVisualMetrics() {
            Object object;
            this.maxRightWidth = 0.0;
            this.maxLabelWidth = 0.0;
            this.maxGraphicWidth = 0.0;
            this.maxLeftWidth = 0.0;
            double d = 0.0;
            for (int i = 0; i < this.itemsContainer.getChildren().size(); ++i) {
                double d2;
                Node node = (Node)this.itemsContainer.getChildren().get(i);
                if (!(node instanceof MenuItemContainer) || !(object = (MenuItemContainer)((Object)this.itemsContainer.getChildren().get(i))).isVisible()) continue;
                Node node2 = ((MenuItemContainer)((Object)object)).getLeft();
                if (node2 != null) {
                    d2 = this.getAlt(node2);
                    this.maxLeftWidth = Math.max(this.maxLeftWidth, this.snapSize(node2.prefWidth(d2)));
                    d = Math.max(d, node2.prefHeight(-1.0));
                }
                if ((node2 = ((MenuItemContainer)((Object)object)).getGraphic()) != null) {
                    d2 = this.getAlt(node2);
                    this.maxGraphicWidth = Math.max(this.maxGraphicWidth, this.snapSize(node2.prefWidth(d2)));
                    d = Math.max(d, node2.prefHeight(-1.0));
                }
                if ((node2 = ((MenuItemContainer)((Object)object)).getLabel()) != null) {
                    d2 = this.getAlt(node2);
                    this.maxLabelWidth = Math.max(this.maxLabelWidth, this.snapSize(node2.prefWidth(d2)));
                    d = Math.max(d, node2.prefHeight(-1.0));
                }
                if ((node2 = ((MenuItemContainer)((Object)object)).getRight()) == null) continue;
                d2 = this.getAlt(node2);
                this.maxRightWidth = Math.max(this.maxRightWidth, this.snapSize(node2.prefWidth(d2)));
                d = Math.max(d, node2.prefHeight(-1.0));
            }
            double d3 = this.maxRightWidth + this.maxLabelWidth + this.maxGraphicWidth + this.maxLeftWidth;
            object = this.contextMenu.getOwnerWindow();
            if (object instanceof ContextMenu && this.contextMenu.getX() < object.getX() && FxSpecialMenuItem.compare(this.oldWidth, d3) != 0) {
                this.contextMenu.setX(this.contextMenu.getX() + this.oldWidth - d3);
            }
            this.oldWidth = d3;
        }

        private double getAlt(Node node) {
            double d = node.getContentBias() == Orientation.VERTICAL ? this.snapSize(node.prefHeight(-1.0)) : -1.0;
            return d;
        }

        private void updateVisualItems() {
            ObservableList observableList = this.itemsContainer.getChildren();
            this.disposeVisualItems();
            for (int i = 0; i < this.getItems().size(); ++i) {
                Object object;
                MenuItem menuItem = (MenuItem)this.getItems().get(i);
                if (menuItem instanceof CustomMenuItem && ((CustomMenuItem)menuItem).getContent() == null) continue;
                if (menuItem instanceof SeparatorMenuItem) {
                    object = ((CustomMenuItem)menuItem).getContent();
                    object.visibleProperty().bind((ObservableValue)menuItem.visibleProperty());
                    observableList.add(object);
                    object.getProperties().put(MenuItem.class, (Object)menuItem);
                    continue;
                }
                object = new MenuItemContainer(this, menuItem);
                object.visibleProperty().bind((ObservableValue)menuItem.visibleProperty());
                observableList.add(object);
            }
            if (!this.getItems().isEmpty()) {
                MenuItem menuItem = (MenuItem)this.getItems().get(0);
                this.getProperties().put(Menu.class, (Object)menuItem.getParentMenu());
            }
            this.impl_reapplyCSS();
        }

        private void disposeVisualItems() {
            ObservableList observableList = this.itemsContainer.getChildren();
            int n = observableList.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)observableList.get(i);
                if (!(node instanceof MenuItemContainer)) continue;
                MenuItemContainer menuItemContainer = (MenuItemContainer)node;
                menuItemContainer.visibleProperty().unbind();
                menuItemContainer.dispose();
            }
            observableList.clear();
        }

        public void dispose() {
            this.disposeBinds();
            this.disposeVisualItems();
            this.disposeContextMenu(this.submenu);
            this.submenu = null;
            this.openSubmenu = null;
            this.selectedBackground = null;
            if (this.contextMenu != null) {
                this.contextMenu.getItems().clear();
                this.contextMenu = null;
            }
        }

        public void disposeContextMenu(ContextMenu contextMenu) {
            if (contextMenu == null) {
                return;
            }
            Skin skin = contextMenu.getSkin();
            if (skin == null) {
                return;
            }
            EnhancedContextMenuContent enhancedContextMenuContent = (EnhancedContextMenuContent)skin.getNode();
            if (enhancedContextMenuContent == null) {
                return;
            }
            enhancedContextMenuContent.dispose();
        }

        private void scrollToSelectedItem() {
            Node node = null;
            for (Node node2 : this.itemsContainer.getChildren()) {
                if (!(node2 instanceof MenuItemContainer)) continue;
                MenuItem menuItem = ((MenuItemContainer)node2).getItem();
                if (menuItem instanceof CheckMenuItem) {
                    if (((CheckMenuItem)menuItem).isSelected()) {
                        node = node2;
                    }
                } else if (menuItem instanceof RadioMenuItem && ((RadioMenuItem)menuItem).isSelected()) {
                    node = node2;
                }
                if (node == null) continue;
                break;
            }
            Iterator iterator = node;
            Platform.runLater(() -> this.lambda$scrollToSelectedItem$5((Node)iterator));
        }

        protected void layoutChildren() {
            if (this.itemsContainer.getChildren().isEmpty()) {
                return;
            }
            double d = this.snappedLeftInset();
            double d2 = this.snappedTopInset();
            double d3 = this.getWidth() - d - this.snappedRightInset();
            double d4 = this.snapSize(this.getContentHeight());
            this.scrollPane.resize(d3, d4);
            this.scrollPane.relocate(d, d2);
        }

        protected double computePrefWidth(double d) {
            this.computeVisualMetrics();
            if (this.itemsContainer.getChildren().isEmpty()) {
                return 0.0;
            }
            double d2 = 0.0;
            for (Node node : this.itemsContainer.getChildren()) {
                if (!node.isVisible()) continue;
                d2 = Math.max(d2, this.snapSize(node.prefWidth(-1.0)));
            }
            return this.snappedLeftInset() + this.snapSize(d2) + this.snappedRightInset();
        }

        protected double computePrefHeight(double d) {
            if (this.itemsContainer.getChildren().isEmpty()) {
                return 0.0;
            }
            double d2 = this.getScreenHeight();
            double d3 = this.getContentHeight();
            double d4 = this.snappedTopInset() + this.snapSize(d3) + this.snappedBottomInset();
            return d2 <= 0.0 ? d4 : Math.min(d4, d2);
        }

        protected double computeMinHeight(double d) {
            return 0.0;
        }

        protected double computeMaxHeight(double d) {
            return this.getScreenHeight();
        }

        private double getScreenHeight() {
            if (this.contextMenu == null || this.contextMenu.getOwnerWindow() == null || this.contextMenu.getOwnerWindow().getScene() == null) {
                return -1.0;
            }
            return this.snapSize(com.sun.javafx.util.Utils.getScreen((Object)this.contextMenu.getOwnerWindow().getScene().getRoot()).getVisualBounds().getHeight());
        }

        private double getContentHeight() {
            double d = 0.0;
            int n = 0;
            ObservableList observableList = this.itemsContainer.getChildren();
            int n2 = 7;
            for (int i = 0; i < observableList.size() && n < n2; ++i) {
                Node node = (Node)observableList.get(i);
                if (!(node instanceof MenuItemContainer) || ((MenuItemContainer)node).getItem() instanceof CustomMenuItem) {
                    // empty if block
                }
                if (node instanceof Separator) {
                    ++n2;
                }
                if (!node.isVisible()) continue;
                d += this.snapSize(node.prefHeight(-1.0));
                ++n;
            }
            return d;
        }

        private void ensureFocusedMenuItemIsVisible(Node node) {
            if (node == null) {
                return;
            }
            Bounds bounds = this.scrollPane.getViewportBounds();
            Bounds bounds2 = node.getBoundsInParent();
            ObservableList observableList = this.itemsContainer.getChildren();
            int n = observableList.indexOf((Object)node);
            double d = 0.0;
            if (bounds2.getMaxY() >= bounds.getMaxY()) {
                Node node2;
                int n2 = 0;
                Iterator iterator = observableList.iterator();
                while (iterator.hasNext() && !((node2 = (Node)iterator.next()).getBoundsInParent().getMaxY() > bounds.getMaxY() - bounds.getMinY())) {
                    ++n2;
                }
                int n3 = observableList.size() - n2;
                double d2 = 1.0 / (double)n3;
                d = d2 * (double)(n - n2 + 1);
            }
            this.scrollPane.setVvalue(d);
        }

        protected ObservableList getItems() {
            return this.contextMenu.getItems();
        }

        private final void initialize() {
            this.itemsContainer = new MenuBoxContainer();
            this.scrollPane = this.createScrollPane();
            this.getChildren().add((Object)this.scrollPane);
            this.contextMenu.focusedProperty().addListener((observableValue, bl, bl2) -> {
                if (bl2.booleanValue()) {
                    this.currentFocusedIndex = -1;
                    this.requestFocus();
                }
            });
            this.contextMenu.addEventHandler(Menu.ON_SHOWN, event -> {
                for (Node node : this.itemsContainer.getChildren()) {
                    MenuItem menuItem;
                    if (!(node instanceof MenuItemContainer) || !"choice-box-menu-item".equals((menuItem = ((MenuItemContainer)node).getItem()).getId()) || !((RadioMenuItem)menuItem).isSelected()) continue;
                    node.requestFocus();
                    break;
                }
                this.currentFocusedIndex = -1;
                this.selectedBackground = null;
                this.scrollPane.setVvalue(0.0);
            });
            this.setOnKeyPressed(this::handleOnKeyPressed);
        }

        private void handleOnKeyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getCode()) {
                case LEFT: {
                    if (this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                        this.processRightKey(keyEvent);
                        break;
                    }
                    this.processLeftKey(keyEvent);
                    break;
                }
                case RIGHT: {
                    if (this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                        this.processLeftKey(keyEvent);
                        break;
                    }
                    this.processRightKey(keyEvent);
                    break;
                }
                case CANCEL: {
                    keyEvent.consume();
                    break;
                }
                case ESCAPE: {
                    this.contextMenu.hide();
                    keyEvent.consume();
                    break;
                }
                case DOWN: {
                    this.moveToNextSibling();
                    keyEvent.consume();
                    break;
                }
                case UP: {
                    this.moveToPreviousSibling();
                    keyEvent.consume();
                    break;
                }
                case SPACE: 
                case ENTER: {
                    this.selectMenuItem();
                    keyEvent.consume();
                    break;
                }
                case PAGE_DOWN: {
                    this.moveToLast();
                    keyEvent.consume();
                    break;
                }
                case PAGE_UP: {
                    this.moveToFirst();
                    keyEvent.consume();
                    break;
                }
            }
            this.forwardToParent(keyEvent);
        }

        private void forwardToParent(KeyEvent keyEvent) {
            Node node;
            if (!keyEvent.isConsumed() && (node = this.contextMenu.getOwnerNode()) instanceof MenuItemContainer) {
                Parent parent;
                for (parent = node.getParent(); parent != null && !(parent instanceof EnhancedContextMenuContent); parent = parent.getParent()) {
                }
                if (parent instanceof EnhancedContextMenuContent) {
                    parent.getOnKeyPressed().handle((Event)keyEvent);
                }
            }
        }

        private void processLeftKey(KeyEvent keyEvent) {
            Menu menu;
            MenuItem menuItem;
            Node node;
            if (this.currentFocusedIndex != -1 && (node = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex)) instanceof MenuItemContainer && (menuItem = ((MenuItemContainer)node).getItem()) instanceof Menu && (menu = (Menu)menuItem) == this.openSubmenu && this.submenu != null && this.submenu.isShowing()) {
                this.hideSubmenu();
                keyEvent.consume();
            }
        }

        private void processRightKey(KeyEvent keyEvent) {
            MenuItem menuItem;
            Node node;
            if (this.currentFocusedIndex != -1 && (node = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex)) instanceof MenuItemContainer && (menuItem = ((MenuItemContainer)node).getItem()) instanceof Menu) {
                Menu menu = (Menu)menuItem;
                if (menu.isDisable()) {
                    return;
                }
                this.selectedBackground = (MenuItemContainer)node;
                if (this.openSubmenu == menu && this.submenu != null && this.submenu.isShowing()) {
                    return;
                }
                this.showMenu(menu);
                keyEvent.consume();
            }
        }

        void showMenu(Menu menu) {
            menu.show();
            EnhancedContextMenuContent enhancedContextMenuContent = (EnhancedContextMenuContent)this.submenu.getSkin().getNode();
            if (enhancedContextMenuContent != null) {
                if (!enhancedContextMenuContent.itemsContainer.getChildren().isEmpty()) {
                    MenuItem menuItem;
                    Node node = (Node)enhancedContextMenuContent.itemsContainer.getChildren().get(0);
                    node.requestFocus();
                    if (node instanceof MenuItemContainer && (menuItem = ((MenuItemContainer)node).getItem()) instanceof CustomMenuItem) {
                        ((CustomMenuItem)menuItem).getContent().getProperties().put((Object)"baseComponent,", (Object)this.contextMenu.getOwnerNode());
                        ((CustomMenuItem)menuItem).getContent().requestFocus();
                    }
                    enhancedContextMenuContent.currentFocusedIndex = 0;
                } else {
                    enhancedContextMenuContent.requestFocus();
                }
            }
        }

        private void selectMenuItem() {
            Node node;
            if (this.currentFocusedIndex != -1 && (node = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex)) instanceof MenuItemContainer) {
                MenuItem menuItem = ((MenuItemContainer)node).getItem();
                if (menuItem instanceof Menu) {
                    Menu menu = (Menu)menuItem;
                    if (this.openSubmenu != null) {
                        this.hideSubmenu();
                    }
                    if (menu.isDisable()) {
                        return;
                    }
                    this.selectedBackground = (MenuItemContainer)node;
                    menu.show();
                } else {
                    ((MenuItemContainer)node).doSelect();
                }
            }
        }

        private int findNext(int n) {
            Node node;
            int n2;
            for (n2 = n; n2 < this.itemsContainer.getChildren().size(); ++n2) {
                node = (Node)this.itemsContainer.getChildren().get(n2);
                if (node.isDisabled() || !(node instanceof MenuItemContainer)) continue;
                return n2;
            }
            for (n2 = 0; n2 < n; ++n2) {
                node = (Node)this.itemsContainer.getChildren().get(n2);
                if (node.isDisabled() || !(node instanceof MenuItemContainer)) continue;
                return n2;
            }
            return -1;
        }

        private void moveToNextSibling() {
            if (this.currentFocusedIndex < 0 || this.currentFocusedIndex < this.itemsContainer.getChildren().size() - 1) {
                this.currentFocusedIndex = this.findNext(this.currentFocusedIndex + 1);
                Node node = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex);
                this.selectedBackground = (MenuItemContainer)node;
                node.requestFocus();
                this.ensureFocusedMenuItemIsVisible(node);
            }
        }

        private int findPrevious(int n) {
            Node node;
            int n2;
            for (n2 = n; n2 >= 0; --n2) {
                node = (Node)this.itemsContainer.getChildren().get(n2);
                if (node.isDisabled() || !(node instanceof MenuItemContainer)) continue;
                return n2;
            }
            for (n2 = this.itemsContainer.getChildren().size() - 1; n2 > n; --n2) {
                node = (Node)this.itemsContainer.getChildren().get(n2);
                if (node.isDisabled() || !(node instanceof MenuItemContainer)) continue;
                return n2;
            }
            return -1;
        }

        private void moveToPreviousSibling() {
            if ((this.currentFocusedIndex > 0 || this.selectedBackground == null) && this.currentFocusedIndex < this.itemsContainer.getChildren().size()) {
                this.currentFocusedIndex = this.selectedBackground == null ? this.findPrevious(this.itemsContainer.getChildren().size() - 1) : this.findPrevious(this.currentFocusedIndex - 1);
                Node node = (Node)this.itemsContainer.getChildren().get(this.currentFocusedIndex);
                this.selectedBackground = (MenuItemContainer)node;
                node.requestFocus();
                this.ensureFocusedMenuItemIsVisible(node);
            }
        }

        private void moveToFirst() {
            ObservableList observableList = this.itemsContainer.getChildren();
            for (Node node : observableList) {
                if (!(node instanceof MenuItemContainer)) continue;
                this.selectedBackground = (MenuItemContainer)node;
                node.requestFocus();
                this.ensureFocusedMenuItemIsVisible(node);
                break;
            }
        }

        private void moveToLast() {
            ObservableList observableList = this.itemsContainer.getChildren();
            for (int i = observableList.size() - 1; i >= 0; --i) {
                Node node = (Node)observableList.get(i);
                if (!(node instanceof MenuItemContainer)) continue;
                this.selectedBackground = (MenuItemContainer)node;
                node.requestFocus();
                this.ensureFocusedMenuItemIsVisible(node);
                break;
            }
        }

        private void setUpBinds() {
            this.updateMenuShowingListeners((List)this.contextMenu.getItems(), true);
            this.contextMenu.getItems().addListener(this.contextMenuItemsListener);
        }

        private void disposeBinds() {
            this.updateMenuShowingListeners((List)this.contextMenu.getItems(), false);
            this.contextMenu.getItems().removeListener(this.contextMenuItemsListener);
        }

        private void updateMenuShowingListeners(List list, boolean bl) {
            for (MenuItem menuItem : list) {
                if (menuItem instanceof Menu) {
                    Menu menu = (Menu)menuItem;
                    if (bl) {
                        menu.showingProperty().addListener(this.menuShowingListener);
                    } else {
                        menu.showingProperty().removeListener(this.menuShowingListener);
                    }
                }
                if (bl) {
                    menuItem.visibleProperty().addListener(this.menuItemVisibleListener);
                    continue;
                }
                menuItem.visibleProperty().removeListener(this.menuItemVisibleListener);
            }
        }

        public ContextMenu getSubMenu() {
            return this.submenu;
        }

        Menu getOpenSubMenu() {
            return this.openSubmenu;
        }

        void createSubmenu() {
            if (this.submenu == null) {
                this.submenu = new ContextMenu();
                this.submenu.setSkin((Skin)new EnhancedContextMenuSkin(this.submenu));
                this.submenu.showingProperty().addListener((observableValue, bl, bl2) -> {
                    if (!this.submenu.isShowing()) {
                        for (Node node : this.itemsContainer.getChildren()) {
                            Menu menu;
                            if (!(node instanceof MenuItemContainer) || !(((MenuItemContainer)node).getItem() instanceof Menu) || !(menu = (Menu)((MenuItemContainer)node).getItem()).isShowing()) continue;
                            menu.hide();
                        }
                    }
                });
            }
        }

        private void showSubmenu(Menu menu) {
            this.openSubmenu = menu;
            this.createSubmenu();
            this.submenu.getItems().setAll((Collection)menu.getItems());
            this.submenu.show((Node)this.selectedBackground, Side.RIGHT, 0.0, 0.0);
        }

        void hideSubmenu() {
            if (this.submenu == null) {
                return;
            }
            this.submenu.hide();
            this.openSubmenu = null;
            this.disposeContextMenu(this.submenu);
            this.submenu = null;
        }

        void hideAllMenus(MenuItem menuItem) {
            Menu menu;
            if (this.contextMenu != null) {
                this.contextMenu.hide();
            }
            while ((menu = menuItem.getParentMenu()) != null) {
                menu.hide();
                menuItem = menu;
            }
            if (menuItem.getParentPopup() != null) {
                menuItem.getParentPopup().hide();
            }
        }

        public Styleable getStyleableParent() {
            return this.contextMenu;
        }

        public static List getClassCssMetaData() {
            return StyleableProperties.STYLEABLES;
        }

        public List getCssMetaData() {
            return EnhancedContextMenuContent.getClassCssMetaData();
        }

        public Label getLabelAt(int n) {
            return ((MenuItemContainer)((Object)this.itemsContainer.getChildren().get(n))).getLabel();
        }

        private /* synthetic */ void lambda$scrollToSelectedItem$5(Node node) {
            this.ensureFocusedMenuItemIsVisible(node);
        }

        class MenuBoxContainer
        extends VBox {
            MenuBoxContainer() {
                this.setAccessibleRole(AccessibleRole.CONTEXT_MENU);
            }

            public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
                switch (accessibleAttribute) {
                    case VISIBLE: {
                        return EnhancedContextMenuContent.this.contextMenu.isShowing();
                    }
                    case PARENT_MENU: {
                        return EnhancedContextMenuContent.this.contextMenu.getOwnerNode();
                    }
                }
                return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
            }
        }

        private static class StyleableProperties {
            private static final List STYLEABLES;

            private StyleableProperties() {
            }

            static {
                ArrayList<CssMetaData> arrayList = new ArrayList<CssMetaData>(Region.getClassCssMetaData());
                List list = Node.getClassCssMetaData();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    CssMetaData cssMetaData = (CssMetaData)list.get(i);
                    if (!"effect".equals(cssMetaData.getProperty())) continue;
                    arrayList.add(cssMetaData);
                    break;
                }
                STYLEABLES = Collections.unmodifiableList(arrayList);
            }
        }
    }

    private static class EnhancedContextMenuSkin
    implements Skin {
        protected static final boolean IS_TOUCH_SUPPORTED = Platform.isSupported((ConditionalFeature)ConditionalFeature.INPUT_TOUCH);
        private final EventHandler shownEventEventHandler;
        private final EventHandler hiddenEventEventHandler;
        private final EventHandler windowHiddenEventEventHandler;
        private ContextMenu popupMenu;
        private Region root;
        private TwoLevelFocusPopupBehavior tlFocus;
        private final EventHandler keyListener = keyEvent -> {
            if (keyEvent.getEventType() != KeyEvent.KEY_PRESSED) {
                return;
            }
            KeyCode keyCode = keyEvent.getCode();
            if (keyCode == KeyCode.TAB) {
                Window window = this.popupMenu.getOwnerWindow();
                keyEvent.consume();
                this.popupMenu.hide();
                if (window != null) {
                    Event.fireEvent((EventTarget)window.getScene().getFocusOwner(), (Event)keyEvent);
                }
            }
            if (!this.root.isFocused()) {
                return;
            }
            if (keyCode == KeyCode.ENTER || keyCode == KeyCode.SPACE) {
                this.popupMenu.hide();
            }
        };

        public EnhancedContextMenuSkin(ContextMenu contextMenu) {
            this.popupMenu = contextMenu;
            this.shownEventEventHandler = event -> {
                Node node = contextMenu.getSkin().getNode();
                if (node != null) {
                    node.requestFocus();
                    if (node instanceof EnhancedContextMenuContent) {
                        Pane pane = ((EnhancedContextMenuContent)node).getItemsContainer();
                        pane.notifyAccessibleAttributeChanged(AccessibleAttribute.VISIBLE);
                    }
                }
                this.root.addEventHandler(KeyEvent.KEY_PRESSED, this.keyListener);
            };
            contextMenu.addEventHandler(Menu.ON_SHOWN, this.shownEventEventHandler);
            this.hiddenEventEventHandler = event -> {
                Node node = contextMenu.getSkin().getNode();
                if (node != null) {
                    node.requestFocus();
                }
                this.root.removeEventHandler(KeyEvent.KEY_PRESSED, this.keyListener);
            };
            contextMenu.addEventHandler(Menu.ON_HIDDEN, this.hiddenEventEventHandler);
            this.windowHiddenEventEventHandler = event -> {
                Node node = contextMenu.getSkin().getNode();
                if (node instanceof EnhancedContextMenuContent) {
                    Pane pane = ((EnhancedContextMenuContent)node).getItemsContainer();
                    pane.notifyAccessibleAttributeChanged(AccessibleAttribute.VISIBLE);
                }
            };
            contextMenu.addEventFilter(WindowEvent.WINDOW_HIDING, this.windowHiddenEventEventHandler);
            this.root = IS_TOUCH_SUPPORTED && contextMenu.getStyleClass().contains((Object)"text-input-context-menu") ? new EmbeddedTextContextMenuContent(contextMenu) : new EnhancedContextMenuContent(contextMenu);
            this.root.idProperty().bind((ObservableValue)contextMenu.idProperty());
            this.root.styleProperty().bind((ObservableValue)contextMenu.styleProperty());
            this.root.getStyleClass().addAll((Collection)contextMenu.getStyleClass());
            if (Utils.isTwoLevelFocus()) {
                this.tlFocus = new TwoLevelFocusPopupBehavior((PopupControl)contextMenu);
            }
        }

        public ContextMenu getSkinnable() {
            return this.popupMenu;
        }

        public Node getNode() {
            return this.root;
        }

        public void dispose() {
            this.popupMenu.removeEventHandler(Menu.ON_SHOWN, this.shownEventEventHandler);
            this.popupMenu.removeEventHandler(Menu.ON_HIDDEN, this.hiddenEventEventHandler);
            this.popupMenu.removeEventFilter(WindowEvent.WINDOW_HIDING, this.windowHiddenEventEventHandler);
            this.root.idProperty().unbind();
            this.root.styleProperty().unbind();
            if (this.tlFocus != null) {
                this.tlFocus.dispose();
            }
        }
    }

    private static class EnhancedMenuButtonBehavior
    extends MenuButtonBehavior {
        public EnhancedMenuButtonBehavior(MenuButton menuButton) {
            super(menuButton);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (FxSpecialMenuItem.canDisableRightButtonClick(mouseEvent, this.getControl())) {
                mouseEvent.consume();
                return;
            }
            super.mousePressed(mouseEvent);
        }
    }

    private static class EnhancedMenuButtonSkin
    extends MenuButtonSkinBase {
        private static final String AUTO_HIDE = "autoHide";

        protected EnhancedMenuButtonSkin(MenuButton menuButton, EnhancedMenuButtonBehavior enhancedMenuButtonBehavior) {
            super(menuButton, (MenuButtonBehaviorBase)enhancedMenuButtonBehavior);
        }

        public EnhancedMenuButtonSkin(MenuButton menuButton) {
            super(menuButton, (MenuButtonBehaviorBase)new EnhancedMenuButtonBehavior(menuButton));
            this.popup.setSkin((Skin)new EnhancedContextMenuSkin(this.popup));
            this.popup.setOnAutoHide(event -> {
                MenuButton menuButton = (MenuButton)this.getSkinnable();
                if (!menuButton.getProperties().containsKey((Object)AUTO_HIDE)) {
                    menuButton.getProperties().put((Object)AUTO_HIDE, (Object)Boolean.TRUE);
                }
            });
            this.popup.setOnShown(windowEvent -> {
                Node node = this.popup.getSkin().getNode();
                if (node != null) {
                    node.requestFocus();
                }
            });
            if (menuButton.getOnAction() == null) {
                menuButton.setOnAction(actionEvent -> menuButton.show());
            }
            this.label.setLabelFor((Node)menuButton);
        }

        protected void handleControlPropertyChanged(String string) {
            if ("SHOWING".equals(string)) {
                super.handleControlPropertyChanged(string);
                if (((MenuButton)this.getSkinnable()).isShowing()) {
                    FxSpecialMenuItem.reconfigurePopup((Node)this.getSkinnable(), (PopupWindow)this.popup);
                }
            } else if ("POPUP_VISIBLE".equals(string)) {
                if (this.popup.getSkin().getNode() instanceof EnhancedContextMenuContent) {
                    if (!this.popup.isShowing() && ((MenuButton)this.getSkinnable()).isShowing()) {
                        ((MenuButton)this.getSkinnable()).hide();
                    }
                    if (this.popup.isShowing()) {
                        FxSpecialMenuItem.addMnemonics(this.popup, ((MenuButton)this.getSkinnable()).getScene(), ((MenuButton)this.getSkinnable()).impl_isShowMnemonics());
                    } else {
                        FxSpecialMenuItem.removeMnemonics(this.popup, ((MenuButton)this.getSkinnable()).getScene());
                    }
                } else {
                    super.handleControlPropertyChanged(string);
                }
            } else {
                super.handleControlPropertyChanged(string);
            }
        }
    }
}

