/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.apps.qftest.demo.fx.multi.FxMultiItem;
import de.qfs.lib.log.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Slider;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.ChoiceBoxTableCell;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.ProgressBarTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class FxTableDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.fx.multi.FxTableDemo");

    public static Node getRootNode() {
        if (FxTableDemo.logger.level >= 7) {
            logger.log(7, "getRootNode()", "");
        }
        GridPane gridPane = new GridPane();
        gridPane.setHgap(4.0);
        gridPane.setVgap(6.0);
        gridPane.setPadding(new Insets(18.0, 18.0, 18.0, 18.0));
        gridPane.setStyle("-fx-background-color: grey;");
        gridPane.setId("TableDemo2");
        ObservableList observableList = FXCollections.observableArrayList((Object[])new FxMultiItem[]{new FxMultiItem("Alpha"), new FxMultiItem("Bravo"), new FxMultiItem("Charlie"), new FxMultiItem("Delta"), new FxMultiItem("Echo"), new FxMultiItem("Foxtrot"), new FxMultiItem("Golf"), new FxMultiItem("Hotel"), new FxMultiItem("Alpha"), new FxMultiItem("Bravo"), new FxMultiItem("Charlie"), new FxMultiItem("Delta"), new FxMultiItem("Echo"), new FxMultiItem("Foxtrot"), new FxMultiItem("Golf"), new FxMultiItem("Hotel"), new FxMultiItem("Alpha"), new FxMultiItem("Bravo"), new FxMultiItem("Charlie"), new FxMultiItem("Delta"), new FxMultiItem("Echo"), new FxMultiItem("Foxtrot"), new FxMultiItem("Golf"), new FxMultiItem("Hotel"), new FxMultiItem("Alpha"), new FxMultiItem("Bravo"), new FxMultiItem("Charlie"), new FxMultiItem("Delta"), new FxMultiItem("Echo"), new FxMultiItem("Foxtrot"), new FxMultiItem("Golf"), new FxMultiItem("Hotel")});
        ObservableList observableList2 = FXCollections.observableArrayList((Object[])new String[]{"add", "edit", "delete"});
        ObservableList observableList3 = FXCollections.observableArrayList((Object[])new String[]{"red", "green", "blue"});
        if (FxTableDemo.logger.level >= 9) {
            logger.build("getRootNode()").add("items: ").add((Object)observableList).log(9);
        }
        TableView tableView = new TableView(observableList);
        tableView.setId("DemoTableView");
        tableView.setMaxSize(400.0, 1000.0);
        tableView.setTableMenuButtonVisible(true);
        tableView.setItems(observableList);
        final TableColumn tableColumn = new TableColumn("Check");
        tableColumn.setMinWidth(20.0);
        tableColumn.setId("CheckColumn");
        final TableColumn tableColumn2 = new TableColumn("");
        tableColumn2.setMinWidth(50.0);
        Label label = new Label("Name");
        label.setTooltip(new Tooltip("Name column"));
        tableColumn2.setGraphic((Node)label);
        tableColumn2.setId("NameColumn");
        tableColumn2.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell();
                tableCell.setTooltip(new Tooltip("Header: Name"));
                return tableCell;
            }
        });
        TableColumn tableColumn3 = new TableColumn("Action");
        tableColumn3.setMinWidth(80.0);
        tableColumn3.setId("ActionColumn");
        TableColumn tableColumn4 = new TableColumn("Color");
        tableColumn4.setMinWidth(80.0);
        tableColumn4.setId("ColorColumn");
        TableColumn tableColumn5 = new TableColumn("Progress");
        tableColumn5.setMinWidth(100.0);
        tableColumn5.setId("ProgressColumn");
        TableColumn tableColumn6 = new TableColumn("Slider");
        tableColumn6.setMinWidth(100.0);
        tableColumn6.setId("SliderColumn");
        TableColumn tableColumn7 = new TableColumn("Value");
        tableColumn7.setMinWidth(100.0);
        tableColumn7.setId("ValueColumn");
        TableColumn tableColumn8 = new TableColumn("Name");
        tableColumn8.setMinWidth(80.0);
        tableColumn8.setMaxWidth(150.0);
        tableColumn8.setId("TextAreaColumn");
        tableView.getColumns().addAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3, tableColumn4, tableColumn5, tableColumn6, tableColumn7, tableColumn8});
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        tableColumn.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)tableColumn));
        tableColumn.setEditable(true);
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("text"));
        final Callback callback = TextFieldTableCell.forTableColumn();
        tableColumn2.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = (TableCell)callback.call((Object)tableColumn);
                tableCell.setTooltip(new Tooltip("Header: Name"));
                MenuItem menuItem = new MenuItem("Popup");
                ContextMenu contextMenu = new ContextMenu(new MenuItem[]{menuItem});
                tableCell.setContextMenu(contextMenu);
                return tableCell;
            }
        });
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("action"));
        tableColumn3.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)observableList2));
        tableColumn4.setCellValueFactory((Callback)new PropertyValueFactory("color"));
        tableColumn4.setCellFactory(ChoiceBoxTableCell.forTableColumn((ObservableList)observableList2));
        tableColumn5.setCellValueFactory((Callback)new PropertyValueFactory("progress"));
        tableColumn5.setCellFactory(ProgressBarTableCell.forTableColumn());
        tableColumn6.setCellValueFactory((Callback)new PropertyValueFactory("progress"));
        tableColumn6.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                SliderCell sliderCell = new SliderCell();
                return sliderCell;
            }
        });
        tableColumn7.setCellValueFactory((Callback)new PropertyValueFactory("progress"));
        tableColumn7.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new StringConverter(){

            public Double fromString(String string) {
                try {
                    return Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return 0.0;
                }
            }

            public String toString(Double d) {
                if (null != d) {
                    return d.toString();
                }
                return "0";
            }
        }));
        tableColumn8.setCellValueFactory((Callback)new PropertyValueFactory("text"));
        tableColumn8.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TextAreaCell textAreaCell = new TextAreaCell();
                return textAreaCell;
            }
        });
        tableView.setEditable(true);
        if (FxTableDemo.logger.level >= 9) {
            logger.build("getRootNode()").add("lv: ").add((Object)tableView).log(9);
        }
        Label label2 = new Label("ListView");
        label2.setLabelFor((Node)tableView);
        final TableView tableView2 = tableView;
        RadioButton radioButton = new RadioButton("Single Selection");
        radioButton.setId("SingleSelectionRadio");
        radioButton.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                tableView2.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            }
        });
        RadioButton radioButton2 = new RadioButton("Multiple Selection");
        radioButton2.setId("MultiSelectionRadio");
        radioButton2.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                tableView2.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            }
        });
        CheckBox checkBox = new CheckBox("Cell Selection");
        checkBox.setId("CellSelectionCheckBox");
        checkBox.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                tableView2.getSelectionModel().setCellSelectionEnabled(((CheckBox)actionEvent.getSource()).isSelected());
            }
        });
        CheckBox checkBox2 = new CheckBox("Hide first two columns");
        checkBox2.setId("HideColumnsCheckBox");
        checkBox2.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                tableColumn.setVisible(!((CheckBox)actionEvent.getSource()).isSelected());
                tableColumn2.setVisible(!((CheckBox)actionEvent.getSource()).isSelected());
            }
        });
        ToggleGroup toggleGroup = new ToggleGroup();
        radioButton.setToggleGroup(toggleGroup);
        radioButton2.setToggleGroup(toggleGroup);
        toggleGroup.selectToggle((Toggle)radioButton);
        VBox vBox = new VBox(10.0);
        vBox.setId("SelectionTypeVBox");
        vBox.getChildren().addAll((Object[])new Node[]{radioButton, radioButton2, checkBox, checkBox2});
        gridPane.add((Node)label2, 0, 0);
        gridPane.add((Node)tableView, 1, 0);
        gridPane.add((Node)vBox, 3, 0);
        return gridPane;
    }

    static class TextAreaCell
    extends TableCell {
        public TextArea text = new TextArea();

        public TextAreaCell() {
            this.text.setPrefRowCount(4);
            this.setEditable(true);
            this.setGraphic((Node)this.text);
        }

        protected void updateItem(String string, boolean bl) {
            super.updateItem((Object)string, bl);
            if (string != null) {
                this.text.setText(string);
                this.setGraphic((Node)this.text);
            } else {
                this.setGraphic((Node)this.text);
            }
        }
    }

    static class SliderCell
    extends TableCell {
        public Slider slider = new Slider(0.0, 1.0, 0.0);
        private ObservableValue ov;

        public SliderCell() {
            this.setEditable(true);
            this.slider.valueProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observableValue, Number number, Number number2) {
                    ((FxMultiItem)this.getTableView().getItems().get(this.getIndex())).progressProperty().set(number2.doubleValue());
                }
            });
            this.setGraphic((Node)this.slider);
        }

        protected void updateItem(Double d, boolean bl) {
            super.updateItem((Object)d, bl);
            if (d != null) {
                this.slider.setValue(d.doubleValue());
                this.setGraphic((Node)this.slider);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

