/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.w3c.dom.Document;

public class FxWebViewDemo {
    public static Node getRootNode() {
        String string = "about:blank";
        final WebView webView = new WebView();
        final WebEngine webEngine = webView.getEngine();
        webEngine.load(string);
        final TextField textField = new TextField(string);
        EventHandler eventHandler = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (webView.isFocused()) {
                    return;
                }
                String string = textField.getText();
                if (!string.contains("://") && !string.startsWith("about:")) {
                    string = "http://" + string;
                }
                webEngine.load(string);
            }
        };
        EventHandler eventHandler2 = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                try {
                    webEngine.getHistory().go(-1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        };
        EventHandler eventHandler3 = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                try {
                    webEngine.getHistory().go(1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        };
        Button button = new Button("go");
        button.setDefaultButton(true);
        button.setOnAction(eventHandler);
        Button button2 = new Button("<");
        button2.setOnAction(eventHandler2);
        Button button3 = new Button(">");
        button3.setOnAction(eventHandler3);
        HBox hBox = new HBox(5.0);
        hBox.getChildren().setAll((Object[])new Node[]{textField, button, button2, button3});
        HBox.setHgrow((Node)textField, (Priority)Priority.ALWAYS);
        webEngine.setOnAlert(new EventHandler(){

            public void handle(WebEvent webEvent) {
                String string = (String)webEvent.getData();
                FxWebViewDemo.showMessageBox((Stage)webView.getScene().getWindow(), "Alert", string);
            }
        });
        final Label label = new Label("foo");
        webEngine.getLoadWorker().stateProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Worker.State state, Worker.State state2) {
                if (state2 == Worker.State.SCHEDULED) {
                    label.setText("Loading " + webEngine.getLocation());
                } else if (state2 == Worker.State.SUCCEEDED) {
                    textField.setText(webEngine.getLocation());
                    label.setText("Done.");
                    Document document = webEngine.getDocument();
                }
            }
        });
        VBox vBox = new VBox(5.0);
        vBox.setId("WebViewDemo");
        hBox.setStyle("-fx-border:solid; -fx-background-color:#ddddff;");
        vBox.setStyle("-fx-border:solid; -fx-background-color:#ccccee;");
        webView.setPrefHeight(400.0);
        webView.setPrefWidth(400.0);
        vBox.getChildren().setAll((Object[])new Node[]{hBox, webView, label});
        VBox.setVgrow((Node)webView, (Priority)Priority.ALWAYS);
        return vBox;
    }

    private static void showMessageBox(Stage stage, String string, String string2) {
        final Stage stage2 = new Stage();
        stage2.initOwner((Window)stage);
        stage2.initModality(Modality.WINDOW_MODAL);
        stage2.setTitle(string);
        stage2.setResizable(false);
        Label label = new Label(string2);
        Button button = new Button("Ok");
        button.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                stage2.close();
            }
        });
        VBox vBox = new VBox(5.0);
        vBox.setAlignment(Pos.CENTER);
        vBox.getChildren().setAll((Object[])new Node[]{label, button});
        stage2.setScene(new Scene((Parent)vBox, 250.0, 100.0));
        stage2.setX(stage.getX() + 200.0);
        stage2.setY(stage.getY() + 100.0);
        stage2.show();
    }
}

