/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class EditorPaneDemo
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.EditorPaneDemo");
    private Window win;
    private Grid grid;
    private Container pane;
    private Container panel;

    public EditorPaneDemo(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        EditorPaneDemo editorPaneDemo = new EditorPaneDemo(false);
        BaseDemo.setupAndRun(stringArray, editorPaneDemo);
    }

    @Override
    protected void showFrameOrDialog() {
        Container container;
        if (EditorPaneDemo.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            container = new JDialog(new JFrame(), "EditorPaneDemo [dialog]", !this.isAsNonModal());
            this.win = container;
            this.pane = container.getContentPane();
        } else {
            this.frame = new JFrame("EditorPaneDemo [ Frame ]");
            this.win = this.frame;
            this.pane = ((JFrame)this.frame).getContentPane();
        }
        this.win.setName("EditorPaneDemo");
        this.grid = new Grid();
        this.grid.setName("grid");
        container = new JLabel("EditorPane Type: text/html");
        this.grid.addLine(new Component[]{container});
        String string = "<html><body>Some<br/><b>HTML formatted</b><br/>text</body></html>";
        JEditorPane jEditorPane = new JEditorPane("text/html", string);
        jEditorPane.setName("HtmlEditorPane");
        this.grid.addLine(new Component[]{jEditorPane});
        container = new JLabel("EditorPane Type: text/plain");
        this.grid.addLine(new Component[]{container});
        string = "Some\nplain\ntext";
        jEditorPane = new JEditorPane("text/plain", string);
        jEditorPane.setName("PlainEditorPane");
        this.grid.addLine(new Component[]{jEditorPane});
        container = new JLabel("EditorPane Type: text/rtf");
        this.grid.addLine(new Component[]{container});
        jEditorPane = new JEditorPane("text/rft", "");
        try {
            jEditorPane.getDocument().insertString(0, "Bla bla", null);
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
        jEditorPane.setName("RtfEditorPane");
        this.grid.addLine(new Component[]{jEditorPane});
        container = new JLabel("TextPane");
        this.grid.addLine(new Component[]{container});
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(simpleAttributeSet, 8);
        StyleConstants.setForeground(simpleAttributeSet, new Color(42, 161, 152));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setName("TextPane");
        jTextPane.setText("Some text with text formatting.");
        jTextPane.getStyledDocument().setCharacterAttributes(5, 14, simpleAttributeSet, true);
        this.grid.addLine(new Component[]{jTextPane});
        this.pane.add((Component)this.grid);
        this.finishWindow(this.win, 400, 350);
    }
}

