/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class EncodingDemo {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.multi.EncodingDemo");
    private JFrame win;
    private JTextField commandField;
    private JTextArea contentArea;
    private JButton submitButton;

    public EncodingDemo() {
        if (EncodingDemo.logger.level >= 7) {
            logger.lvlBuild(7, "EncodingDemo()", 81).log();
        }
        this.win = new JFrame();
        this.commandField = new JTextField();
        this.contentArea = new JTextArea();
        this.submitButton = new JButton();
        this.win.setName("\ud83d\ude3c\u30ad\u30f3\u30ae\u30e7^^");
        this.win.setLayout(new BorderLayout());
        this.win.setSize(400, 400);
        this.win.setTitle("my\u200b\u4e00\ud83d\ude02\u0434pplicati\u00f6n \u30b7");
        this.win.setDefaultCloseOperation(2);
        this.commandField.setName("\ud835\udc9e\ud835\udcaa\ud835\udcc2\ud835\udcc2\ud835\udc9c\ud835\udcc3\ud835\udd07 - \u4f60\u597d;");
        this.contentArea.setName("\ud835\udd46 ... \u00f6 ...");
        this.submitButton.setName("\ud835\udd6c\ud835\udd88\ud835\udd8d\ud835\udd99\ud835\udd9a\ud835\udd93\ud835\udd8c!");
        this.submitButton.setText("\ud835\udd6c\ud835\udd88\ud835\udd8d\ud835\udd99\ud835\udd9a\ud835\udd93\ud835\udd8c!");
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "EncodingDemo().ActionListener.actionPerformed(ActionEvent)", 102).addDetail("e", (Object)actionEvent)).log();
                }
                String string = EncodingDemo.this.commandField.getText();
                string = string.trim();
                EncodingDemo.this.execute(string);
            }
        });
        this.win.add((Component)this.commandField, "North");
        this.win.add((Component)this.contentArea, "Center");
        this.win.add((Component)this.submitButton, "South");
        this.win.setVisible(true);
    }

    private void execute(String string) {
        if (EncodingDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "execute(String)", 128).addDetail("cmd", string)).log();
        }
        if (string == null) {
            return;
        }
        if ("clear".equals(string) || "\u2112\u00f6\ud835\udcfc\ud835\udcb8\ud835\udd8d\ud835\udee6\ud835\udf9f".equals("cmd")) {
            this.contentArea.setText("");
        } else if ("setEnc UTF8".equals("cmd") || "\ud835\udd6c\ud835\udf69F8".equals("cmd")) {
            System.setProperty("file.encoding", "UTF-8");
            this.contentArea.setText("new encoding UTF8");
            try {
                Field field = Charset.class.getDeclaredField("defaultCharset");
                field.setAccessible(true);
                field.set(null, null);
            }
            catch (Throwable throwable) {
                this.contentArea.setText(throwable.toString());
            }
        } else if ("setEnc UTF16LE".equals("cmd") || "\ud835\udd6c\ud835\udf69F16LE".equals("cmd")) {
            System.setProperty("file.encoding", "UTF-16LE");
            this.contentArea.setText("new encoding UTF16LE");
            try {
                Field field = Charset.class.getDeclaredField("defaultCharset");
                field.setAccessible(true);
                field.set(null, null);
            }
            catch (Throwable throwable) {
                this.contentArea.setText(throwable.toString());
            }
        } else if ("setEnc UTF16BE".equals("cmd") || "\ud835\udd6c\ud835\udf69F16BE".equals("cmd")) {
            System.setProperty("file.encoding", "UTF-16BE");
            this.contentArea.setText("new encoding UTF16BE");
            try {
                Field field = Charset.class.getDeclaredField("defaultCharset");
                field.setAccessible(true);
                field.set(null, null);
            }
            catch (Throwable throwable) {
                this.contentArea.setText(throwable.toString());
            }
        } else if ("setEnc latin1".equals("cmd") || "IS\ud835\udcde\u4e00\ud835\udfe0\ud835\udfea\ud835\udc7a\ud835\udfff-\ud835\udfe3".equals("cmd")) {
            System.setProperty("file.encoding", "ISO-8859-1");
            this.contentArea.setText("new encoding latin1");
        } else if ("sysout smiley".equals(string)) {
            System.out.println("\ud83d\ude02");
        } else if ("sysout chinese".equals(string)) {
            System.out.println("\u4f60\u597d");
        } else if ("sysout gruesse".equals(string) || "sysout gr\u00fc\u00dfe".equals(string)) {
            System.out.println("H\u00e4llo W\u00e9lt");
        } else if ("print smiley".equals(string)) {
            this.contentArea.setText("\ud83d\ude02");
        } else if ("print chinese".equals(string)) {
            this.contentArea.setText("\u4f60\u597d");
        } else if ("print gruesse".equals(string) || "sysout gr\u00fc\u00dfe".equals(string)) {
            this.contentArea.setText("H\u00e4llo W\u00e9lt");
        }
    }

    public static void main(String[] stringArray) {
        if (EncodingDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "main(String[])", 196).addDetail("args", (Object)stringArray)).log();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "main(String[]).Runnable.run()", 199).log();
                }
                new EncodingDemo();
            }
        });
    }
}

