/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.Logger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LayeredPaneDemo
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.multi.LayeredPaneDemo");
    private static Frame pFrame;

    public LayeredPaneDemo(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        LayeredPaneDemo layeredPaneDemo = new LayeredPaneDemo(false);
        BaseDemo.setupAndRun(stringArray, layeredPaneDemo);
    }

    @Override
    protected void showFrameOrDialog() {
        JLayeredPane jLayeredPane;
        Container container;
        Window window;
        JDialog jDialog;
        if (LayeredPaneDemo.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            jDialog = new JDialog(new JFrame(), "LayeredPaneDemo [dialog]", true);
            window = jDialog;
            container = jDialog.getContentPane();
            jLayeredPane = jDialog.getRootPane().getLayeredPane();
        } else {
            this.frame = new JFrame("LayeredPaneDemo [ Frame ]");
            window = this.frame;
            container = ((JFrame)this.frame).getContentPane();
            jLayeredPane = ((JFrame)this.frame).getRootPane().getLayeredPane();
        }
        window.setName("LayeredPaneDemo");
        jDialog = new Grid();
        jDialog.setName("grid");
        JButton jButton = new JButton("Test");
        jButton.setName("buttonTest");
        final JLabel jLabel = new JLabel("Test:     ");
        jLabel.setName("labelOK");
        JButton jButton2 = new JButton("Clear");
        jButton2.setName("buttonClear");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jLabel.setText("Test: OK");
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jLabel.setText("Test:   ");
            }
        });
        jDialog.addLine(new Component[]{jButton, jLabel, jButton2});
        container.add(jDialog);
        JPanel jPanel = new JPanel(){

            @Override
            public void paintChildren(Graphics graphics) {
                container.paint(graphics);
            }
        };
        jPanel.setName("interceptor");
        jLayeredPane.setLayer(jPanel, 0);
        jLayeredPane.add(jPanel);
        jPanel.addMouseListener(new ExtraDispatcher(container));
        this.finishWindow(window);
        jPanel.setLocation(container.getLocation());
        jPanel.setSize(container.getSize());
        jLayeredPane.revalidate();
    }

    protected class ExtraDispatcher
    implements MouseListener {
        private Container pane;
        private Component mouseEventTarget = null;
        private Component dragSource = null;
        private boolean isDragging;

        public ExtraDispatcher(Container container) {
            this.pane = container;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        private void forwardMouseEvent(MouseEvent mouseEvent) {
            Component component = this.findComponentAt(this.pane, mouseEvent.getX(), mouseEvent.getY());
            int n = mouseEvent.getID();
            switch (n) {
                case 504: {
                    if (component != this.mouseEventTarget) {
                        this.mouseEventTarget = component;
                    }
                    this.retargetMouseEvent(n, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 501: {
                    if (component != this.mouseEventTarget) {
                        this.mouseEventTarget = component;
                    }
                    this.retargetMouseEvent(n, mouseEvent, this.mouseEventTarget);
                    this.dragSource = component;
                    break;
                }
                case 505: {
                    this.retargetMouseEvent(n, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 500: {
                    this.retargetMouseEvent(n, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 503: {
                    if (component != this.mouseEventTarget) {
                        this.retargetMouseEvent(505, mouseEvent, this.mouseEventTarget);
                        this.mouseEventTarget = component;
                        this.retargetMouseEvent(504, mouseEvent, this.mouseEventTarget);
                    }
                    this.retargetMouseEvent(n, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 506: {
                    if (!this.isDragging) {
                        this.isDragging = true;
                    }
                    this.retargetMouseEvent(n, mouseEvent, this.dragSource);
                    break;
                }
                case 502: {
                    if (this.isDragging) {
                        this.retargetMouseEvent(n, mouseEvent, this.dragSource);
                        this.isDragging = false;
                        break;
                    }
                    this.retargetMouseEvent(n, mouseEvent, this.mouseEventTarget);
                }
            }
        }

        private Component findComponentAt(Container container, int n, int n2) {
            return container.findComponentAt(n, n2);
        }

        private void retargetMouseEvent(int n, MouseEvent mouseEvent, Component component) {
            if (component == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint(this.pane, mouseEvent.getX(), mouseEvent.getY(), component);
            MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            component.dispatchEvent(mouseEvent2);
        }
    }
}

