/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableDemo
extends BaseDemo {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.multi.TableDemo");
    private static Frame pFrame;
    Object[][] tableData = new Object[][]{{"table item 1", 35, "blue", "EUR"}, {"table item 2", 1, "green", "USD"}, {"table item 3", 59, "black", "EUR"}};
    String[] tableHeaders = new String[]{"Label", "Value", "Color", "Currency"};
    public JTable table;

    public TableDemo(boolean bl) {
        super(bl);
        if (TableDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "TableDemo(boolean)", 104).addDetail("asDialog", bl)).log();
        }
    }

    public static void main(String[] stringArray) {
        if (TableDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "main(String[])", 122).addDetail("args", (Object)stringArray)).log();
        }
        TableDemo tableDemo = new TableDemo(false);
        BaseDemo.setupAndRun(stringArray, tableDemo);
    }

    @Override
    protected void showFrameOrDialog() {
        Container container;
        Window window;
        JDialog jDialog;
        if (TableDemo.logger.level >= 7) {
            logger.lvlBuild(7, "showFrameOrDialog()", 139).log();
        }
        if (this.asDialog) {
            jDialog = new JDialog(new JFrame(), "TableDemo [dialog]", true);
            window = jDialog;
            container = jDialog.getContentPane();
        } else {
            this.frame = new JFrame("TableDemo [ Frame ]");
            window = this.frame;
            container = ((JFrame)this.frame).getContentPane();
        }
        window.setName("TableDemo");
        jDialog = new Grid();
        jDialog.setName("grid");
        final JLabel jLabel = new JLabel("Clicked Column: None");
        jLabel.setName("ClickedColumnLabel");
        final JLabel jLabel2 = new JLabel("Modifiers: None");
        jLabel2.setName("ClickedColumnLabel");
        DefaultTableModel defaultTableModel = new DefaultTableModel(this.tableData, this.tableHeaders){

            public Class getColumnClass(int n) {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return Integer.class;
                    }
                    case 3: {
                        return String.class;
                    }
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 > 0;
            }
        };
        this.table = new JTable(defaultTableModel);
        this.table.setName("Table");
        this.table.getTableHeader().setName("TableHeader");
        this.table.getTableHeader().setDefaultRenderer(new TooltipTableCellRenderer());
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "showFrameOrDialog().MouseAdapter.mouseClicked(MouseEvent)", 204).addDetail("e", (Object)mouseEvent)).log();
                }
                int n = TableDemo.this.table.columnAtPoint(mouseEvent.getPoint());
                int n2 = mouseEvent.getModifiers();
                jLabel.setText("Clicked Column: " + TableDemo.this.table.getColumnName(n));
                jLabel2.setText("Modifiers: " + mouseEvent.getModifiers());
            }
        });
        String[] stringArray = new String[]{"EUR", "USD"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(3);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn.setCellRenderer(new TooltipTableCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setName("TablePane");
        jScrollPane.setPreferredSize(new Dimension(250, 80));
        jDialog.addLine(new Component[]{jScrollPane});
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn2 = new TableColumn();
        tableColumn2.setHeaderValue("Solo");
        defaultTableColumnModel.addColumn(tableColumn2);
        tableColumn2 = new TableColumn();
        tableColumn2.setHeaderValue("Table");
        if (!Misc.IS_JAVA_VERSION_AT_LEAST_10) {
            tableColumn2.setHeaderRenderer(new TooltipTableCellRenderer());
        }
        defaultTableColumnModel.addColumn(tableColumn2);
        tableColumn2 = new TableColumn();
        tableColumn2.setHeaderValue("Header");
        defaultTableColumnModel.addColumn(tableColumn2);
        JTableHeader jTableHeader = new JTableHeader(defaultTableColumnModel);
        jTableHeader.setName("soloHeader");
        jDialog.addLine(new Component[]{jTableHeader});
        jDialog.addLine(new Component[]{jLabel, jLabel2});
        container.add(jDialog);
        this.finishWindow(window, 300, 200);
    }

    private class TooltipTableCellRenderer
    extends DefaultTableCellRenderer {
        private TooltipTableCellRenderer() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "TooltipTableCellRenderer.TooltipTableCellRenderer()", 258).log();
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "TooltipTableCellRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 262).addDetail("table", (Object)jTable)).addDetail("value", object)).addDetail("isSelected", bl)).addDetail("hasFocus", bl2)).addDetail("row", n)).addDetail("column", n2)).log();
            }
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "TooltipTableCellRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 267).add("com", (Object)component)).log();
            }
            ((JComponent)component).setToolTipText("Row: " + n + " Col: " + n2);
            return component;
        }
    }
}

