/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.AdapterTreeModel;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Logger;
import de.qfs.lib.tree.MutableTreeAdapter;
import de.qfs.lib.tree.TreeAdapter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TreeItems
extends BaseDemo {
    private static final String XML_DOCUMENT_BUILDER_FACTORY_SYSPROP_KEY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String XML_DOCUMENT_BUILDER_FACTORY_SYSPROP_DEFAULT = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.multi.TreeItems");
    private static final String DOM = "<root-node><top-level-node><sub-node>some text</sub-node><sub-node>more text</sub-node></top-level-node><top-level-node>bla<!--some comment--></top-level-node><top-level-node>more senseless stuff</top-level-node></root-node>";

    public TreeItems(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        TreeItems treeItems = new TreeItems(false);
        BaseDemo.setupAndRun(stringArray, treeItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void showFrameOrDialog() {
        JTree jTree;
        Object object;
        Container container;
        Window window;
        if (TreeItems.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            this.dialog = new JDialog(new Frame(), "TreeItem Demo [ Dialog ]", !this.isAsNonModal());
            window = this.dialog;
            container = ((JDialog)this.dialog).getContentPane();
        } else {
            window = this.frame = new JFrame("TreeItem Demo [ Frame ]");
            container = ((JFrame)this.frame).getContentPane();
        }
        window.setName("TreeItem demo");
        String string = System.getProperty(XML_DOCUMENT_BUILDER_FACTORY_SYSPROP_KEY);
        try {
            System.setProperty(XML_DOCUMENT_BUILDER_FACTORY_SYSPROP_KEY, XML_DOCUMENT_BUILDER_FACTORY_SYSPROP_DEFAULT);
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = ((DocumentBuilder)object).parse(new ByteArrayInputStream(DOM.getBytes()));
            DefaultDOMAdapter defaultDOMAdapter = new DefaultDOMAdapter(){

                @Override
                public boolean isLeaf(Object object) {
                    return ((Node)object).getNodeType() != 1;
                }
            };
            jTree = new JTree((TreeModel)new AdapterTreeModel((TreeAdapter)defaultDOMAdapter, (Object)document.getDocumentElement())){

                @Override
                public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    Node node = (Node)object;
                    if (node.getNodeType() == 1) {
                        return "cvtt: <" + ((Element)object).getTagName() + ">";
                    }
                    if (node.getNodeType() == 3) {
                        return "cvtt: " + node.getNodeValue();
                    }
                    if (node.getNodeType() == 8) {
                        return "cvtt: <!-- " + node.getNodeValue() + " -->";
                    }
                    return "cvtt: " + object.toString();
                }
            };
            jTree.setEditable(true);
            jTree.setCellRenderer(new DOMRenderer());
            ToolTipManager.sharedInstance().registerComponent(jTree);
        }
        catch (Throwable throwable) {
            if (TreeItems.logger.level >= 1) {
                logger.log(1, "showFrameOrDialog()", throwable);
            }
            jTree = new JTree();
        }
        finally {
            if (string == null) {
                System.getProperties().remove(XML_DOCUMENT_BUILDER_FACTORY_SYSPROP_KEY);
            } else {
                System.setProperty(XML_DOCUMENT_BUILDER_FACTORY_SYSPROP_KEY, string);
            }
        }
        jTree.setName("tree");
        SwingUtil.expandAll((JTree)jTree, (TreePath)new TreePath(jTree.getModel().getRoot()), (int)100);
        object = new JScrollPane(jTree);
        ((Component)object).setName("scroll");
        container.add((Component)object);
        this.finishWindow(window, 300, 400);
    }

    private static class NodeEnumeration
    implements Enumeration {
        private NodeList list;
        private int index;

        public NodeEnumeration(NodeList nodeList) {
            this.list = nodeList;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.list.getLength();
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.index < this.list.getLength()) {
                return this.list.item(this.index++);
            }
            throw new NoSuchElementException();
        }
    }

    public class DefaultDOMAdapter
    implements DOMAdapter,
    MutableTreeAdapter {
        public boolean isIndexBased() {
            return true;
        }

        public Object getParentNode(Object object) {
            return ((Node)object).getParentNode();
        }

        public boolean isLeaf(Object object) {
            return false;
        }

        public Object[] getChildren(Object object) {
            Object[] objectArray = new Object[this.getChildCount(object)];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.getChildNode(object, i);
            }
            return objectArray;
        }

        public int getChildCount(Object object) {
            return ((Node)object).getChildNodes().getLength();
        }

        public Object getChildNode(Object object, int n) throws IndexOutOfBoundsException {
            return ((Node)object).getChildNodes().item(n);
        }

        public int getIndexOfChildNode(Object object, Object object2) {
            NodeList nodeList = ((Node)object).getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i) != object2) continue;
                return i;
            }
            return -1;
        }

        public boolean isLinkBased() {
            return true;
        }

        public Object getFirstChildNode(Object object) {
            return ((Node)object).getFirstChild();
        }

        public Object getLastChildNode(Object object) {
            return ((Node)object).getLastChild();
        }

        public Object getPreviousSibling(Object object) {
            return ((Node)object).getPreviousSibling();
        }

        public Object getNextSibling(Object object) {
            return ((Node)object).getNextSibling();
        }

        public boolean isEnumerationBased() {
            return false;
        }

        public Enumeration enumerateChildren(Object object) {
            return new NodeEnumeration(((Node)object).getChildNodes());
        }

        public void setParentNode(Object object, Object object2) {
        }

        public boolean addNode(Object object, Object object2) {
            ((Node)object).appendChild((Node)object2);
            return true;
        }

        public boolean addNode(Object object, int n, Object object2) {
            int n2 = this.getChildCount(object);
            if (n == n2) {
                return this.addNode(object, object2);
            }
            Node node = (Node)this.getChildNode(object, n);
            ((Node)object).insertBefore((Node)object2, node);
            return true;
        }

        public Object removeNode(Object object, int n) throws IndexOutOfBoundsException {
            Node node = (Node)this.getChildNode(object, n);
            ((Node)object).removeChild(node);
            return node;
        }

        public boolean removeNode(Object object, Object object2) {
            try {
                ((Node)object).removeChild((Node)object2);
                return true;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }

        public Object cloneNode(Object object) {
            return ((Node)object).cloneNode(false);
        }

        public boolean insertNodeBefore(Object object, Object object2, Object object3) {
            try {
                ((Node)object).insertBefore((Node)object2, (Node)object3);
                return true;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }

        public boolean insertNodeAfter(Object object, Object object2, Object object3) {
            if (object3 == null) {
                return this.insertNodeBefore(object, object2, ((Node)object).getFirstChild());
            }
            return this.insertNodeBefore(object, object2, ((Node)object3).getNextSibling());
        }

        @Override
        public int getNodeType(Object object) {
            return ((Node)object).getNodeType();
        }

        @Override
        public String getNodeName(Object object) {
            return ((Node)object).getNodeName();
        }

        @Override
        public String getNodeValue(Object object) {
            return ((Node)object).getNodeValue();
        }

        @Override
        public Object getAttributes(Object object) {
            return ((Node)object).getAttributes();
        }

        @Override
        public int getAttributeCount(Object object) {
            return object == null ? 0 : ((NamedNodeMap)object).getLength();
        }

        @Override
        public String getAttributeName(Object object, int n) {
            return object == null ? null : ((NamedNodeMap)object).item(n).getNodeName();
        }

        @Override
        public String getAttributeValue(Object object, int n) {
            return object == null ? null : ((NamedNodeMap)object).item(n).getNodeValue();
        }

        @Override
        public String getAttributeValue(Object object, String string) {
            return object == null ? null : ((NamedNodeMap)object).getNamedItem(string).getNodeValue();
        }

        @Override
        public boolean getAttributeSpecified(Object object, int n) {
            return object == null ? false : ((Attr)((NamedNodeMap)object).item(n)).getSpecified();
        }

        @Override
        public boolean getAttributeSpecified(Object object, String string) {
            return object == null ? false : ((Attr)((NamedNodeMap)object).getNamedItem(string)).getSpecified();
        }
    }

    public static class DOMRenderer
    implements TreeCellRenderer {
        private JPanel panel = new JPanel();
        private JLabel label = new JLabel();
        private boolean showLabels;

        public DOMRenderer() {
            this.panel.setOpaque(false);
            this.panel.setBorder(null);
            this.label.setBorder(null);
            this.panel.add(this.label);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (logger.level >= 7) {
                logger.log(7, "getTreeCellRendererComponent(JTree,Object,boolean,boolean,boolean,int,boolean)", logger.level < 8 ? "" : "tree: " + jTree + ", value: " + object + ", selected: " + bl + ", expanded: " + bl2 + ", leaf: " + bl3 + ", row: " + n + ", hasFocus: " + bl4);
            }
            Node node = (Node)object;
            String string = null;
            if (node.getNodeType() == 1) {
                this.label.setText("<" + ((Element)object).getTagName() + ">");
                string = "Element: " + ((Element)object).getTagName();
            } else if (node.getNodeType() == 3) {
                this.label.setText("<html><body><strong>" + node.getNodeValue() + "</strong></body></html>");
                string = "Text: " + node.getNodeValue();
            } else if (node.getNodeType() == 8) {
                this.label.setText("<html><body><em>&lt;!-- " + node.getNodeValue() + " --&gt;</em></body></html>");
                string = "Comment: " + node.getNodeValue();
            } else {
                this.label.setText(object.toString());
                string = "Other: " + node.getNodeValue();
            }
            if (logger.level >= 9) {
                logger.build("getTreeCellRendererComponent(JTree,Object,boolean,boolean,boolean,int,boolean)").add("tooltip: ").add(string).log(9);
            }
            if (this.showLabels) {
                this.label.setToolTipText(string);
                return this.label;
            }
            this.panel.add(this.label);
            this.panel.setToolTipText(string);
            return this.panel;
        }

        public void setLabel(boolean bl) {
            this.showLabels = bl;
        }
    }

    public static interface DOMAdapter {
        public int getNodeType(Object var1);

        public String getNodeName(Object var1);

        public String getNodeValue(Object var1);

        public Object getAttributes(Object var1);

        public int getAttributeCount(Object var1);

        public String getAttributeName(Object var1, int var2);

        public String getAttributeValue(Object var1, int var2);

        public String getAttributeValue(Object var1, String var2);

        public boolean getAttributeSpecified(Object var1, int var2);

        public boolean getAttributeSpecified(Object var1, String var2);
    }
}

