/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.chat.component;

import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.component.ChatBox;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.model.ModelMessage;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing.Button;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing.ChatEvent;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing.RoundPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing.TextField;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing.scroll.ScrollBar;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ChatArea
extends JPanel {
    private List events = new ArrayList();
    final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private JLayeredPane layeredPane;
    private JPanel body;
    private JPanel bottom;
    private TextField textMessage;
    private JScrollPane scrollBody;
    int row = 0;
    private JPanel bodyFiller;
    final MapResourceBundle rb;

    public void addChatEvent(ChatEvent chatEvent) {
        this.events.add(chatEvent);
    }

    public ChatArea(MapResourceBundle mapResourceBundle) {
        this.rb = mapResourceBundle;
        this.init();
    }

    private void init() {
        this.setOpaque(false);
        this.body = this.createBody();
        this.bottom = this.createBottom();
        this.layeredPane = this.createLayeredPane();
        this.scrollBody = this.createScroll();
        this.scrollBody.setViewportView(this.body);
        this.scrollBody.setVerticalScrollBar(new ScrollBar());
        this.scrollBody.setHorizontalScrollBarPolicy(31);
        this.scrollBody.getViewport().setOpaque(false);
        this.layeredPane.add(this.scrollBody);
        this.setLayout(new BorderLayout());
        this.add((Component)this.layeredPane, "Center");
        this.add((Component)this.bottom, "South");
        this.bodyFiller = new JPanel();
        this.bodyFiller.setOpaque(false);
    }

    private JPanel createBody() {
        RoundPanel roundPanel = new RoundPanel();
        roundPanel.setName("body");
        roundPanel.setBackground(new Color(0, 0, 0, 0));
        roundPanel.setLayout(new GridBagLayout());
        roundPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return roundPanel;
    }

    private JPanel createBottom() {
        RoundPanel roundPanel = new RoundPanel();
        roundPanel.setName("bottom");
        roundPanel.setBackground(new Color(255, 255, 255, 20));
        roundPanel.setLayout(new BorderLayout(2, 2));
        final Button button = new Button();
        button.setName("cmdSend");
        button.setFocusable(false);
        button.setIcon(this.rb.getIcon("icon.CarConfig.chat.send", null));
        this.textMessage = new TextField();
        this.textMessage.setName("textMessage");
        this.textMessage.setHint(this.rb.getString("dialog.CarConfig.chat.msgHint", ""));
        this.textMessage.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ChatArea.this.revalidate();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                ChatArea.this.runEventKeyTyped(keyEvent);
            }
        });
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChatArea.this.runEventMousePressedSendButton(actionEvent);
            }
        });
        JScrollPane jScrollPane = this.createScroll();
        jScrollPane.setViewportView(this.textMessage);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        jScrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 0));
        roundPanel.add((Component)jScrollPane, "Center");
        roundPanel.add((Component)button, "East");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(Misc.OS_IS_MAC_OS_X ? "meta ENTER" : "ctrl ENTER");
        this.textMessage.getInputMap(0).put(keyStroke, "submitAction");
        this.textMessage.getActionMap().put("submitAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                button.doClick();
            }
        });
        button.setToolTipText(new MessageFormat(this.rb.getString("dialog.CarConfig.chat.send.tooltip", "{0}")).format(new Object[]{KeyEvent.getKeyModifiersText(keyStroke.getModifiers()) + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode())}));
        return roundPanel;
    }

    private JLayeredPane createLayeredPane() {
        JLayeredPane jLayeredPane = new JLayeredPane();
        jLayeredPane.setLayout(new BorderLayout());
        return jLayeredPane;
    }

    private JScrollPane createScroll() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setName("scrollBody");
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(null);
        jScrollPane.setOpaque(false);
        return jScrollPane;
    }

    public void addChatBox(ModelMessage modelMessage, ChatBox.BoxType boxType) {
        this.body.remove(this.bodyFiller);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.row++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        ChatBox chatBox = new ChatBox(boxType, modelMessage);
        JPanel jPanel = new JPanel(new BorderLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.setOpaque(false);
        if (boxType == ChatBox.BoxType.RIGHT) {
            jPanel.add((Component)chatBox, "East");
        } else {
            jPanel.add((Component)chatBox, "West");
        }
        this.body.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = this.row;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.body.add((Component)this.bodyFiller, gridBagConstraints);
        this.body.repaint();
        this.body.revalidate();
        this.scrollBody.revalidate();
        this.bottom.revalidate();
        this.scheduledExecutorService.schedule(() -> SwingUtilities.invokeLater(this::scrollToBottom), 50L, TimeUnit.MILLISECONDS);
    }

    public void clearChatBox() {
        this.row = 0;
        this.body.removeAll();
        this.body.repaint();
        this.body.revalidate();
    }

    private void scrollToBottom() {
        this.scrollBody.getVerticalScrollBar().setValue(this.scrollBody.getVerticalScrollBar().getMaximum());
    }

    private void runEventMousePressedSendButton(ActionEvent actionEvent) {
        for (ChatEvent chatEvent : this.events) {
            chatEvent.mousePressedSendButton(actionEvent);
        }
    }

    private void runEventMousePressedFileButton(ActionEvent actionEvent) {
        for (ChatEvent chatEvent : this.events) {
            chatEvent.mousePressedFileButton(actionEvent);
        }
    }

    private void runEventKeyTyped(KeyEvent keyEvent) {
        for (ChatEvent chatEvent : this.events) {
            chatEvent.keyTyped(keyEvent);
        }
    }

    public String getText() {
        return this.textMessage.getText();
    }

    public void setText(String string) {
        this.textMessage.setText(string);
    }

    public void textGrabFocus() {
        this.textMessage.grabFocus();
    }

    public void clearTextAndGrabFocus() {
        this.textMessage.setText("");
        this.textMessage.grabFocus();
    }
}

