/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.chat.component;

import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.model.ModelMessage;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing.AutoWrapText;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing.ImageAvatar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ChatBox
extends JComponent {
    private final BoxType boxType;
    private final ModelMessage message;

    public ChatBox(BoxType boxType, ModelMessage modelMessage) {
        this.boxType = boxType;
        this.message = modelMessage;
        this.init();
    }

    private void init() {
        this.initBox();
    }

    private void initBox() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ImageAvatar imageAvatar = new ImageAvatar();
        imageAvatar.setPreferredSize(new Dimension(40, 40));
        imageAvatar.setMinimumSize(new Dimension(40, 40));
        imageAvatar.setMaximumSize(new Dimension(40, 40));
        imageAvatar.setBorderSize(1);
        imageAvatar.setBorderSpace(1);
        imageAvatar.setImage(this.message.getIcon());
        final JTextPane jTextPane = new JTextPane(){

            @Override
            public Dimension getPreferredSize() {
                int n;
                Container container;
                Dimension dimension = super.getPreferredSize();
                Container container2 = container = this.getParent() != null ? this.getParent().getParent() : null;
                if (container != null && dimension.width > (n = (int)((double)container.getWidth() * 0.8))) {
                    dimension.width = n;
                }
                return dimension;
            }
        };
        jTextPane.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                Container container = jTextPane.getParent().getParent();
                if (container != null) {
                    container.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent componentEvent) {
                            jTextPane.revalidate();
                            jTextPane.repaint();
                        }
                    });
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        jTextPane.setEditorKit(new AutoWrapText());
        jTextPane.setText(this.message.getMessage());
        jTextPane.setBackground(new Color(0, 0, 0, 0));
        jTextPane.setForeground(new Color(242, 242, 242));
        jTextPane.setSelectionColor(new Color(200, 200, 200, 100));
        jTextPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jTextPane.setOpaque(false);
        jTextPane.setEditable(false);
        JLabel jLabel = new JLabel(this.message.getName() + " | " + this.message.getDate());
        jLabel.setForeground(new Color(127, 127, 127));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = this.boxType == BoxType.RIGHT ? 1 : 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        this.add((Component)imageAvatar, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 5, 0, 0);
        this.add((Component)jTextPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, this.boxType == BoxType.RIGHT ? 0 : 20, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.boxType == BoxType.LEFT) {
            Area area = new Area(new RoundRectangle2D.Double(25.0, 25.0, n - 25, n2 - 25 - 16 - 10, 5.0, 5.0));
            area.subtract(new Area(new Ellipse2D.Double(5.0, 5.0, 45.0, 45.0)));
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 94, 98, 240), n, 0.0f, new Color(255, 153, 102, 240)));
            graphics2D.fill(area);
        } else {
            Area area = new Area(new RoundRectangle2D.Double(0.0, 25.0, n - 25, n2 - 25 - 16 - 10, 5.0, 5.0));
            area.subtract(new Area(new Ellipse2D.Double(n - 50, 5.0, 45.0, 45.0)));
            graphics2D.setColor(new Color(255, 255, 255, 20));
            graphics2D.fill(area);
        }
        graphics2D.dispose();
        super.paintComponent(graphics);
    }

    public BoxType getBoxType() {
        return this.boxType;
    }

    public ModelMessage getMessage() {
        return this.message;
    }

    public static enum BoxType {
        LEFT,
        RIGHT;

    }
}

