/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.chat.swing;

import de.qfs.lib.gui.SVGIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ImageAvatar
extends JComponent {
    private Icon image;
    private int borderSize = 6;
    private int borderSpace = 5;
    private Color gradientColor1 = new Color(255, 90, 90);
    private Color gradientColor2 = new Color(42, 199, 80);

    public Icon getImage() {
        return this.image;
    }

    public void setImage(Icon icon) {
        this.image = icon;
        this.repaint();
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(int n) {
        this.borderSize = n;
        this.repaint();
    }

    public int getBorderSpace() {
        return this.borderSpace;
    }

    public void setBorderSpace(int n) {
        this.borderSpace = n;
        this.repaint();
    }

    public Color getGradientColor1() {
        return this.gradientColor1;
    }

    public void setGradientColor1(Color color) {
        this.gradientColor1 = color;
        this.repaint();
    }

    public Color getGradientColor2() {
        return this.gradientColor2;
    }

    public void setGradientColor2(Color color) {
        this.gradientColor2 = color;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.createBorder(graphics2D);
        if (this.image != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = Math.min(n, n2) - (this.borderSize * 2 + this.borderSpace * 2);
            int n4 = (n - n3) / 2;
            int n5 = (n2 - n3) / 2;
            Rectangle rectangle = this.getAutoSize(this.image, n3);
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.fillOval(0, 0, n3, n3);
            Composite composite = graphics2D2.getComposite();
            graphics2D2.setComposite(AlphaComposite.SrcIn);
            graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D2.drawImage(this.toImage(this.image, rectangle.width, rectangle.height), rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
            graphics2D2.setComposite(composite);
            graphics2D2.dispose();
            graphics2D.drawImage((Image)bufferedImage, n4, n5, null);
        }
        graphics2D.dispose();
        super.paintComponent(graphics);
    }

    private void createBorder(Graphics2D graphics2D) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = Math.min(n, n2);
        int n4 = (n - n3) / 2;
        int n5 = (n2 - n3) / 2;
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillOval(n4, n5, n3, n3);
        }
        Area area = new Area(new Ellipse2D.Double(n4, n5, n3, n3));
        int n6 = n3 -= this.borderSize * 2;
        area.subtract(new Area(new Ellipse2D.Double(n4 + this.borderSize, n5 + this.borderSize, n6, n6)));
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.gradientColor1, n, n2, this.gradientColor2));
        graphics2D.fill(area);
    }

    private Rectangle getAutoSize(Icon icon, int n) {
        int n2 = n;
        int n3 = n;
        int n4 = icon.getIconWidth();
        int n5 = icon.getIconHeight();
        double d = (double)n2 / (double)n4;
        double d2 = (double)n3 / (double)n5;
        double d3 = Math.max(d, d2);
        int n6 = (int)(d3 * (double)n4);
        int n7 = (int)(d3 * (double)n5);
        if (n6 < 1) {
            n6 = 1;
        }
        if (n7 < 1) {
            n7 = 1;
        }
        int n8 = n;
        int n9 = n;
        int n10 = (n8 - n6) / 2;
        int n11 = (n9 - n7) / 2;
        return new Rectangle(new Point(n10, n11), new Dimension(n6, n7));
    }

    private Image toImage(Icon icon, double d, double d2) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        if (icon instanceof SVGIcon) {
            SVGIcon sVGIcon = (SVGIcon)icon;
            return sVGIcon.getImage(d / (double)sVGIcon.getIconWidth(), d2 / (double)sVGIcon.getIconHeight());
        }
        return null;
    }
}

