/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.controller;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCController;
import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFXFactory;
import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCLoginController;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.AccessoryPane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.CCViewFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.CalculatorPane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.FXRunner;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.SpecialsPane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.VehiclesPane;
import javafx.application.Application;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class CCControllerFX
extends CCController {
    private CCViewFX view;
    Font font;
    FXRunner runnerClass;
    boolean fxInitialized = false;
    boolean showSplash = false;

    public CCControllerFX(CCModel cCModel) {
        this.ccmodel = cCModel;
    }

    @Override
    public void showSplash() {
        this.showSplash = true;
    }

    @Override
    protected void startView() {
        if (!this.fxInitialized) {
            this.fxInitialized = true;
            Application.launch(((Object)((Object)new FXRunner(this))).getClass(), (String[])new String[0]);
        } else {
            Stage stage = new Stage();
            new FXRunner(this).setupStage(stage);
        }
    }

    @Override
    public void accessoryPriceAddedChanged(Boolean bl) {
        if (this.view.getAccessoryPane().accessoryChkBox.isSelected() != bl.booleanValue()) {
            this.view.getAccessoryPane().accessoryChkBox.setSelected(bl.booleanValue());
        }
    }

    @Override
    public void specialPriceChanged(double d) {
        this.view.getCalculatorPane().setSpecialsPrice(d);
    }

    @Override
    public void discountValueChanged(int n) {
        this.view.getCalculatorPane().setDiscountText(n);
    }

    @Override
    public void basePriceChanged(double d) {
        this.view.getCalculatorPane().setBasePrice(d);
    }

    @Override
    public void updateAfterCalculation(double d, double d2) {
        this.view.getCalculatorPane().setBasePrice(this.ccmodel.getM_baseprice());
        this.view.getCalculatorPane().setSpecialsPrice(this.ccmodel.getM_specialprice());
        this.view.getCalculatorPane().setAccessoriesPrice(d2);
        this.view.getCalculatorPane().setCalculatedPrice(d);
    }

    @Override
    public void resetAllView() {
        this.resetVehiclePane(this.view.getVehiclesPane());
        this.resetAccessoryPane(this.view.getAccessoryPane());
        this.resetSpecialsPane(this.view.getSpecialsPane());
        this.resetCalculatorPane(this.view.getCalculatorPane());
    }

    private void resetVehiclePane(VehiclesPane vehiclesPane) {
        vehiclesPane.updateVehiclesPane();
    }

    private void resetSpecialsPane(SpecialsPane specialsPane) {
        specialsPane.updateSpecialsPane();
    }

    private void resetAccessoryPane(AccessoryPane accessoryPane) {
        accessoryPane.updateAccessoryPane();
        this.ccmodel.setTakeAccessoryPriceIntoAccount(true);
    }

    private void resetCalculatorPane(CalculatorPane calculatorPane) {
        calculatorPane.reset();
        this.updateCalculatedPrice();
    }

    @Override
    public void showDiscountError(String string) {
        this.view.getCalculatorPane().showDiscountError(string);
    }

    @Override
    public void logout() {
        CCControllerFXFactory cCControllerFXFactory = new CCControllerFXFactory();
        CCLoginController cCLoginController = cCControllerFXFactory.getLoginController(this);
        cCLoginController.logout();
    }

    @Override
    public void exit(int n) {
        System.exit(n);
    }

    public void setFontFamilyName(String string) {
        this.font = new Font(string, this.font.getSize());
    }

    public void setFontSize(double d) {
        this.font = new Font(this.font.getName(), d);
    }

    public String getCSSString() {
        return ".root{-fx-font-family: \"" + this.font.getFamily() + "\";-fx-font-size: " + this.font.getSize() + "pt;}";
    }

    public CCViewFX getView() {
        return this.view;
    }

    public CCControllerFX setView(CCViewFX cCViewFX) {
        this.view = cCViewFX;
        return this;
    }

    public CCControllerFX setFont(Font font) {
        this.font = font;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public FXRunner getRunnerClass() {
        return this.runnerClass;
    }

    public boolean isShowSplash() {
        return this.showSplash;
    }
}

