/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.controller;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCController;
import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwingFactory;
import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCLoginController;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.AccessoryTablePanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.CCView;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.CalculatorPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.CarSplashWindow;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SortFilterModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SpecialsPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.VehicleTablePanel;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class CCControllerSwing
extends CCController {
    private CCView view;

    public CCControllerSwing(CCModel cCModel) {
        this.ccmodel = cCModel;
        this.view = CCView.getInstance();
        this.view.addController(this);
    }

    @Override
    public void showSplash() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    CarSplashWindow.instance().setVisible(true);
                }
            });
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
        }
    }

    @Override
    protected void startView() {
        if (this.ccmodel.getM_params().isSplash()) {
            CarSplashWindow.instance().dispose();
        }
        this.view.build();
    }

    @Override
    public void updateAfterCalculation(double d, double d2) {
        this.view.getCalculatorPanel().setBasePrice(this.ccmodel.getM_baseprice());
        this.view.getCalculatorPanel().setSpecialsPrice(this.ccmodel.getM_specialprice());
        this.view.getCalculatorPanel().setAccessoriesPrice(d2);
        this.view.getCalculatorPanel().setDiscountText(this.ccmodel.getM_discount());
        this.view.getCalculatorPanel().setCalculatedPrice(d);
    }

    @Override
    public void accessoryPriceAddedChanged(Boolean bl) {
        this.view.getAccessoryTablePanel().getTakeAccessoryPriceIntoAccount().setSelected(bl);
    }

    @Override
    public void specialPriceChanged(double d) {
        this.view.getCalculatorPanel().setSpecialsPrice(d);
    }

    @Override
    public void discountValueChanged(int n) {
        this.view.getCalculatorPanel().setDiscountText(n);
    }

    @Override
    public void basePriceChanged(double d) {
        this.view.getCalculatorPanel().setBasePrice(d);
    }

    @Override
    public void resetAllView() {
        this.resetVehicleTablePanel(this.view.getVehicleTablePanel());
        this.resetAccessoryTablePanel(this.view.getAccessoryTablePanel());
        this.resetSpecialsPanel(this.view.getSpecialsPanel());
        this.resetCalculatorPanel(this.view.getCalculatorPanel());
    }

    public void resetVehicleTablePanel(VehicleTablePanel vehicleTablePanel) {
        vehicleTablePanel.getTable().clearSelection();
        vehicleTablePanel.getModel().setDataVector((Map)this.ccmodel.getVehicleCellsBase(), (Object[])this.ccmodel.getVehicleColumnNames());
        vehicleTablePanel.setTableLayout(this.ccmodel.getVehicleColumnNames(), this.ccmodel.getVehicleColumnMaxWidth());
        ((SortFilterModel)vehicleTablePanel.getSorter()).updateData();
    }

    public void resetAccessoryTablePanel(AccessoryTablePanel accessoryTablePanel) {
        accessoryTablePanel.getTable().clearSelection();
        accessoryTablePanel.getModel().setDataVector((Map)this.ccmodel.getAccessoryCellsBase(), (Object[])this.ccmodel.getAccessoryColumnNames());
        accessoryTablePanel.setTableLayout(this.ccmodel.getAccessoryColumnNames(), this.ccmodel.getAccessoryColumnMaxWidth());
        ((SortFilterModel)accessoryTablePanel.getSorter()).updateData();
        this.ccmodel.setTakeAccessoryPriceIntoAccount(true);
    }

    public void resetSpecialsPanel(SpecialsPanel specialsPanel) {
        this.ccmodel.setSpecialsEntries(this.ccmodel.getSpecialsEntries());
        specialsPanel.reset();
    }

    public void resetCalculatorPanel(CalculatorPanel calculatorPanel) {
        calculatorPanel.reset();
    }

    @Override
    public void showDiscountError(String string) {
        this.view.getCalculatorPanel().showDiscountError(string);
    }

    public void updateSortedBy(int n) {
        this.ccmodel.setSortedBy(n);
    }

    @Override
    public void logout() {
        CCControllerSwingFactory cCControllerSwingFactory = new CCControllerSwingFactory();
        CCLoginController cCLoginController = cCControllerSwingFactory.getLoginController(this);
        cCLoginController.logout();
    }

    @Override
    public void exit(int n) {
        if (this.ccmodel.isM_exitOnClose()) {
            System.exit(n);
        } else if (this.view.frame != null) {
            this.view.frame.dispose();
            this.view.frame = null;
        }
    }
}

