/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.main;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCController;
import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFXFactory;
import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwingFactory;
import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCFactory;
import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCLoginController;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCParams;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;

public class CarConfigurator {
    public static void main(String[] stringArray) {
        try {
            CCParams cCParams = CarConfigurator.getCCParams(stringArray);
            CCModel cCModel = CarConfigurator.getAndConfigureModel(cCParams);
            cCModel.initRb();
            cCModel.initializeDataFromJson();
            cCModel.initTableData();
            CCController cCController = null;
            CCLoginController cCLoginController = null;
            CCFactory cCFactory = CarConfigurator.getCCFactory(cCModel);
            if (!Arrays.asList(stringArray).contains("-fontsize")) {
                cCModel.getM_params().setMinimumFontsize(cCFactory.getDefaultFontsize());
            }
            cCController = cCFactory.getController(cCModel);
            if (cCModel.getM_params().isLogin()) {
                cCLoginController = cCFactory.getLoginController(cCController);
            }
            if (cCModel.getM_params().isSplash()) {
                cCController.showSplash();
            }
            if (cCModel.getM_params().isLogin()) {
                cCLoginController.login();
            } else {
                cCController.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public static CCParams getCCParams(String[] stringArray) {
        int n = 14;
        boolean bl = false;
        String string = Locale.getDefault().getLanguage();
        String string2 = "swing";
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n2 = 0;
        int n3 = 0;
        boolean bl8 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (!stringArray[i].startsWith("-")) {
                try {
                    string = stringArray[i];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ("-fontsize".equalsIgnoreCase(stringArray[i])) {
                try {
                    n = Integer.valueOf(stringArray[++i]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-pos.x".equalsIgnoreCase(stringArray[i])) {
                try {
                    n2 = Integer.valueOf(stringArray[++i]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-pos.y".equalsIgnoreCase(stringArray[i])) {
                try {
                    n3 = Integer.valueOf(stringArray[++i]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-loadtest".equalsIgnoreCase(stringArray[i])) {
                bl = true;
                continue;
            }
            if ("-splash".equalsIgnoreCase(stringArray[i])) {
                bl2 = true;
                continue;
            }
            if ("-login".equalsIgnoreCase(stringArray[i])) {
                bl5 = true;
                continue;
            }
            if ("-cleannames".equalsIgnoreCase(stringArray[i])) {
                bl6 = true;
                continue;
            }
            if ("-buggy".equalsIgnoreCase(stringArray[i])) {
                bl4 = true;
                continue;
            }
            if ("-egg".equalsIgnoreCase(stringArray[i])) {
                bl3 = true;
                continue;
            }
            if ("-noexit".equalsIgnoreCase(stringArray[i])) {
                bl7 = true;
                continue;
            }
            if ("-lang".equalsIgnoreCase(stringArray[i])) {
                try {
                    string = stringArray[++i];
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-engine".equalsIgnoreCase(stringArray[i])) {
                try {
                    string2 = stringArray[++i];
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-oldtimer".equalsIgnoreCase(stringArray[i])) {
                bl8 = true;
                continue;
            }
            if (!"-help".equalsIgnoreCase(stringArray[i])) continue;
            CarConfigurator.exitUsage(bl3);
        }
        CCParams cCParams = CCParams.builder().engine(string2.toLowerCase()).minimumFontsize(n).xpos(n2).ypos(n3).loadtest(bl).splash(bl2).login(bl5).cleanname(bl6).buggy(bl4).noExit(bl7).lang(string.toLowerCase()).oldtimer(bl8).build();
        return cCParams;
    }

    public static CCModel getAndConfigureModel(CCParams cCParams) {
        CCModel cCModel = CCModel.getInstance();
        cCModel.setM_params(cCParams);
        cCModel.setM_exitOnClose(!cCParams.isNoExit());
        String string = cCParams.getLang();
        if (string == null) {
            string = Locale.getDefault().getLanguage();
        }
        if (string != null && string.toLowerCase().startsWith("de")) {
            Locale.setDefault(Locale.GERMANY);
            cCModel.setM_language(CCModel.getGERMAN());
            cCModel.setM_numberFormatter(NumberFormat.getNumberInstance(Locale.GERMANY));
            cCModel.setM_currencyFormatter(NumberFormat.getCurrencyInstance(Locale.GERMANY));
        } else {
            Locale.setDefault(Locale.US);
            cCModel.setM_language(CCModel.getENGLISH());
            cCModel.setM_numberFormatter(NumberFormat.getNumberInstance(Locale.US));
            cCModel.setM_currencyFormatter(NumberFormat.getCurrencyInstance(Locale.US));
        }
        cCModel.getM_numberFormatter().setGroupingUsed(false);
        cCModel.setSpecial_accessories(new HashSet());
        return cCModel;
    }

    protected static CCFactory getCCFactory(CCModel cCModel) {
        switch (cCModel.getM_params().getEngine()) {
            case "swing": {
                return new CCControllerSwingFactory();
            }
            case "fx": {
                return new CCControllerFXFactory();
            }
        }
        throw new IllegalArgumentException("Creating controller failed; please enter a valid engine.");
    }

    public static void exitUsage(boolean bl) {
        String string = "Call the script as follows:\n\nrun_car.bat or run_car.sh [-lang <language>] [-engine <engine>] [-loadtest] [-buggy] [-fontsize <font-size>] [-pos.x <x.position>] [-pos.y <y.position>] [-splash] [-login]\n\n[-lang <language>] ... specifies the language to start.\n[-engine <engine>] ... specifies the UI-engine to use (swing, fx...).\n[-fontsize <font-size>]  ... specifies the font-size to use.\n[-pos.x <x-position>]  ... specifies the X position of the frame for launching.\n[-pos.y <y-position>]  ... specifies the Y position of the frame for launching.\n[-splash] ... starts the application with splash screen (5 seconds delay until main dialog appears)\n[-login] ... starts with login dialog. Use tester/tester (all permissions) or user/user (limited permissions).\n[-cleannames] ... starts with clean component names for single sourcing.\n[-loadtest] ... starts the application in load test mode.\n[-buggy] ... starts the application in buggy mode.";
        if (bl) {
            string = string + "\n      _____                   _______                   _____                                                                \n     |\\    \\                 /::\\    \\                 /\\    \\                                                               \n     |:\\____\\               /::::\\    \\               /::\\____\\                                                              \n     |::|   |              /::::::\\    \\             /:::/    /                                                              \n     |::|   |             /::::::::\\    \\           /:::/    /                                                               \n     |::|   |            /:::/~~\\:::\\    \\         /:::/    /                                                                \n     |::|   |           /:::/    \\:::\\    \\       /:::/    /                                                                 \n     |::|   |          /:::/    / \\:::\\    \\     /:::/    /                                                                  \n     |::|___|______   /:::/____/   \\:::\\____\\   /:::/    /      _____                                                        \n     /::::::::\\    \\ |:::|    |     |:::|    | /:::/____/      /\\    \\                                                       \n    /::::::::::\\____\\|:::|____|     |:::|    ||:::|    /      /::\\____\\                                                      \n   /:::/~~~~/~~       \\:::\\    \\   /:::/    / |:::|____\\     /:::/    /                                                      \n  /:::/    /           \\:::\\    \\ /:::/    /   \\:::\\    \\   /:::/    /                                                       \n /:::/    /             \\:::\\    /:::/    /     \\:::\\    \\ /:::/    /                                                        \n/:::/    /               \\:::\\__/:::/    /       \\:::\\    /:::/    /                                                         \n\\::/    /                 \\::::::::/    /         \\:::\\__/:::/    /                                                          \n \\/____/                   \\::::::/    /           \\::::::::/    /                                                           \n                            \\::::/    /             \\::::::/    /                                                            \n                             \\::/____/               \\::::/    /                                                             \n                              ~~                      \\::/____/                                                              \n          _____                   _______              ~~   _____                    _____                    _____          \n         /\\    \\                 /::\\    \\                 /\\    \\                  /\\    \\                  /\\    \\         \n        /::\\    \\               /::::\\    \\               /::\\____\\                /::\\____\\                /::\\    \\        \n       /::::\\    \\             /::::::\\    \\             /:::/    /               /::::|   |               /::::\\    \\       \n      /::::::\\    \\           /::::::::\\    \\           /:::/    /               /:::::|   |              /::::::\\    \\      \n     /:::/\\:::\\    \\         /:::/~~\\:::\\    \\         /:::/    /               /::::::|   |             /:::/\\:::\\    \\     \n    /:::/__\\:::\\    \\       /:::/    \\:::\\    \\       /:::/    /               /:::/|::|   |            /:::/  \\:::\\    \\    \n   /::::\\   \\:::\\    \\     /:::/    / \\:::\\    \\     /:::/    /               /:::/ |::|   |           /:::/    \\:::\\    \\   \n  /::::::\\   \\:::\\    \\   /:::/____/   \\:::\\____\\   /:::/    /      _____    /:::/  |::|   | _____    /:::/    / \\:::\\    \\  \n /:::/\\:::\\   \\:::\\    \\ |:::|    |     |:::|    | /:::/____/      /\\    \\  /:::/   |::|   |/\\    \\  /:::/    /   \\:::\\ ___\\ \n/:::/  \\:::\\   \\:::\\____\\|:::|____|     |:::|    ||:::|    /      /::\\____\\/:: /    |::|   /::\\____\\/:::/____/     \\:::|    |\n\\::/    \\:::\\   \\::/    / \\:::\\    \\   /:::/    / |:::|____\\     /:::/    /\\::/    /|::|  /:::/    /\\:::\\    \\     /:::|____|\n \\/____/ \\:::\\   \\/____/   \\:::\\    \\ /:::/    /   \\:::\\    \\   /:::/    /  \\/____/ |::| /:::/    /  \\:::\\    \\   /:::/    / \n          \\:::\\    \\        \\:::\\    /:::/    /     \\:::\\    \\ /:::/    /           |::|/:::/    /    \\:::\\    \\ /:::/    /  \n           \\:::\\____\\        \\:::\\__/:::/    /       \\:::\\    /:::/    /            |::::::/    /      \\:::\\    /:::/    /   \n            \\::/    /         \\::::::::/    /         \\:::\\__/:::/    /             |:::::/    /        \\:::\\  /:::/    /    \n             \\/____/           \\::::::/    /           \\::::::::/    /              |::::/    /          \\:::\\/:::/    /     \n                                \\::::/    /             \\::::::/    /               /:::/    /            \\::::::/    /      \n                                 \\::/____/               \\::::/    /               /:::/    /              \\::::/    /       \n                                  ~~                      \\::/____/                \\::/    /                \\::/____/        \n          _____                    _____                   ~~                       \\/____/                  ~~              \n         /\\    \\                  /\\    \\                                                                                    \n        /::\\____\\                /::\\    \\                                                                                   \n       /::::|   |               /::::\\    \\                                                                                  \n      /:::::|   |              /::::::\\    \\                                                                                 \n     /::::::|   |             /:::/\\:::\\    \\                                                                                \n    /:::/|::|   |            /:::/__\\:::\\    \\                                                                               \n   /:::/ |::|   |           /::::\\   \\:::\\    \\                                                                              \n  /:::/  |::|___|______    /::::::\\   \\:::\\    \\                                                                             \n /:::/   |::::::::\\    \\  /:::/\\:::\\   \\:::\\    \\                                                                            \n/:::/    |:::::::::\\____\\/:::/__\\:::\\   \\:::\\____\\                                                                           \n\\::/    / ~~~~~/:::/    /\\:::\\   \\:::\\   \\::/    /                                                                           \n \\/____/      /:::/    /  \\:::\\   \\:::\\   \\/____/                                                                            \n             /:::/    /    \\:::\\   \\:::\\    \\                                                                                \n            /:::/    /      \\:::\\   \\:::\\____\\                                                                               \n           /:::/    /        \\:::\\   \\::/    /                                                                               \n          /:::/    /          \\:::\\   \\/____/                                                                                \n         /:::/    /            \\:::\\    \\                                                                                    \n        /:::/    /              \\:::\\____\\                                                                                   \n        \\::/    /                \\::/    /                                                                                   \n         \\/____/                  \\/____/                                                                                    \n                                                                                                                             ";
        }
        System.out.println(string);
        System.exit(1);
    }
}

