/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.model;

import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCData;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCParams;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonArray;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.properties.QfsObservableMap;
import de.qfs.lib.properties.QfsObservableMapWrapper;
import de.qfs.lib.properties.QfsProperty;
import de.qfs.lib.util.CommentLineStrippingInputStream;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class CCModel {
    private static CCModel CCModelInstance;
    private static final int WIDTH = 350;
    private static final int HEIGHT = 400;
    private boolean m_exitOnClose = true;
    private static MapResourceBundle rb;
    private int m_language;
    private static final int GERMAN = 0;
    private static final int ENGLISH = 1;
    private static final int LOADTEST_WAITTIME = 3000;
    private NumberFormat m_numberFormatter;
    private NumberFormat m_currencyFormatter;
    private int sortedBy = 1;
    private static AtomicInteger nextUniqueId;
    private boolean modelInitialized = false;
    CCParams m_params;
    private static final int VEHICLE_NAME_INDEX = 0;
    private static final int VEHICLE_ID_INDEX = 1;
    private static final int VEHICLE_PRICE_INDEX = 2;
    private static final int VEHICLE_KEY_INDEX = 3;
    private List vehicleCells;
    private QfsObservableMap vehicleCellsBase = new QfsObservableMapWrapper(new HashMap());
    private QfsObservableMap vehicleCellsDialog = new QfsObservableMapWrapper(new HashMap());
    private String[] vehicleColumnNames;
    private Integer[] vehicleColumnMaxWidth = new Integer[]{-1, 30, 100};
    private QfsObservableMap specialsCellsBase = new QfsObservableMapWrapper(new HashMap());
    private QfsObservableMap specialsCellsDialog = new QfsObservableMapWrapper(new HashMap());
    private List specialsEntries;
    private String[] specialsColumnNames;
    private Integer[] specialsColumnMaxWidth = new Integer[]{-1};
    private static final int SPECIALS_TOTAL = 4;
    private static final int SPECIALS_NAME_INDEX = 0;
    private static final int SPECIALS_DESCRIPTION_INDEX = 1;
    private static final int SPECIALS_PRICE_INDEX = 2;
    private static final int SPECIALS_FEATURES_INDEX = 3;
    private static final int SPECIALS_KEY_INDEX = 4;
    private QfsObservableMap accessoryCellsBase = new QfsObservableMapWrapper(new HashMap());
    private QfsObservableMap accessoryCellsDialog = new QfsObservableMapWrapper(new HashMap());
    private List accessoryEntries;
    private String[] accessoryColumnNames;
    private Integer[] accessoryColumnMaxWidth = new Integer[]{30, -1, 30, 100};
    private static final int ACCESSORY_SELECT_INDEX = 0;
    private static final int ACCESSORY_NAME_INDEX = 1;
    private static final int ACCESSORY_ID_INDEX = 2;
    private static final int ACCESSORY_PRICE_INDEX = 3;
    private static final int ACCESSORY_KEY_INDEX = 4;
    private QfsProperty takeAccessoryPriceIntoAccount = new QfsProperty((Object)true);
    private String[] statisticsColumnNames;
    private Integer[] statisticsColumnMaxWidth = new Integer[]{-1, -1};
    private QfsProperty m_baseprice = new QfsProperty((Object)0.0);
    private QfsProperty m_specialprice = new QfsProperty((Object)0.0);
    private Set special_accessories;
    private QfsProperty m_discount = new QfsProperty((Object)0);

    private CCModel() {
    }

    public static CCModel getInstance() {
        if (CCModelInstance == null) {
            CCModelInstance = new CCModel();
        }
        return CCModelInstance;
    }

    public void setSortedBy(int n) {
        this.sortedBy = n;
    }

    public static int getNextUniqueId() {
        return nextUniqueId.getAndIncrement();
    }

    public void initTableData() {
        this.vehicleCellsBase.clear();
        this.vehicleCellsDialog.clear();
        this.specialsCellsBase.clear();
        this.specialsCellsDialog.clear();
        this.accessoryCellsBase.clear();
        this.accessoryCellsDialog.clear();
        for (CCData cCData : this.vehicleCells) {
            this.vehicleCellsBase.put((Object)((CCVehicle)cCData).getKey(), (Object)cCData);
            this.vehicleCellsDialog.put((Object)((CCVehicle)cCData).getKey(), (Object)cCData);
        }
        for (CCData cCData : this.specialsEntries) {
            this.specialsCellsBase.put((Object)((CCSpecial)cCData).getKey(), (Object)cCData);
            this.specialsCellsDialog.put((Object)((CCSpecial)cCData).getKey(), (Object)cCData);
        }
        for (CCData cCData : this.accessoryEntries) {
            this.accessoryCellsBase.put((Object)((CCAccessory)cCData).getKey(), (Object)cCData);
            this.accessoryCellsDialog.put((Object)((CCAccessory)cCData).getKey(), (Object)cCData);
        }
        if (!this.modelInitialized) {
            this.modelInitialized = true;
        }
    }

    public void setM_params(CCParams cCParams) {
        this.m_params = this.m_params == null ? cCParams : this.m_params;
    }

    public QfsProperty takeAccessoryPriceIntoAccountProperty() {
        return this.takeAccessoryPriceIntoAccount;
    }

    public boolean isTakeAccessoryPriceIntoAccount() {
        return (Boolean)this.takeAccessoryPriceIntoAccount.get();
    }

    public void setTakeAccessoryPriceIntoAccount(boolean bl) {
        this.takeAccessoryPriceIntoAccount.set((Object)bl);
    }

    public QfsProperty m_basepriceProperty() {
        return this.m_baseprice;
    }

    public double getM_baseprice() {
        return (Double)this.m_baseprice.get();
    }

    public void setM_baseprice(double d) {
        this.m_baseprice.set((Object)d);
    }

    public QfsProperty m_specialpriceProperty() {
        return this.m_specialprice;
    }

    public double getM_specialprice() {
        return (Double)this.m_specialprice.get();
    }

    public void setM_specialprice(double d) {
        this.m_specialprice.set((Object)d);
    }

    public QfsProperty m_discountProperty() {
        return this.m_discount;
    }

    public int getM_discount() {
        return (Integer)this.m_discount.get();
    }

    public void setM_discount(int n) {
        this.m_discount.set((Object)n);
    }

    public void initRb() {
        rb = new MapResourceBundle();
        if (this.m_params.getLang().equalsIgnoreCase("de")) {
            this.m_language = 0;
            rb.fetchProperties("/de/qfs/apps/qftest/demo/multi/resources/properties/carconfig", Locale.GERMANY, this.getClass());
        } else {
            this.m_language = 1;
            rb.fetchProperties("/de/qfs/apps/qftest/demo/multi/resources/properties/carconfig", Locale.US, this.getClass());
        }
    }

    public void initializeDataFromJson() {
        int n;
        String[] stringArray;
        Object object;
        JsonValue jsonValue;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        JsonObject jsonObject;
        try {
            jsonObject = (JsonObject)Json.parse((Reader)new InputStreamReader((InputStream)new CommentLineStrippingInputStream(Objects.requireNonNull(this.getClass().getResourceAsStream("/de/qfs/apps/qftest/demo/multi/resources/properties/carconfig.json"))), StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        String string = this.getM_language() == 0 ? "name_de" : "name_en";
        String string2 = this.getM_language() == 0 ? "desc_de" : "desc_en";
        JsonObject jsonObject2 = jsonObject.get("data").asObject();
        JsonArray jsonArray = jsonObject2.get("vehicles").asArray();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object52 : jsonArray) {
            object4 = CCVehicle.builder().key(CCModel.getNextUniqueId()).name(object52.asObject().getString("name", "")).m_id(object52.asObject().getString("id", "")).price(object52.asObject().getDouble("price", 0.0)).build();
            arrayList.add(object4);
        }
        this.setVehicleCells(arrayList);
        Iterator iterator = jsonObject2.get("specials").asArray();
        object52 = new ArrayList();
        object4 = iterator.iterator();
        while (object4.hasNext()) {
            object3 = (JsonValue)object4.next();
            object2 = CCSpecial.builder().key(CCModel.getNextUniqueId()).name(object3.asObject().getString(string, "")).description(object3.asObject().getString(string2, "")).price(object3.asObject().getDouble("price", 0.0)).accessories(Misc.setOf((Object[])Misc.fastSplit((String)object3.asObject().getString("acs", ""), (char)' '))).build();
            object52.add(object2);
        }
        this.setSpecialsEntries((List)object52);
        object4 = jsonObject2.get("accessories").asArray();
        object3 = new ArrayList();
        object2 = object4.iterator();
        while (object2.hasNext()) {
            jsonValue = (JsonValue)object2.next();
            object = CCAccessory.builder().key(CCModel.getNextUniqueId()).selected(jsonValue.asObject().getBoolean("selected", false)).name(jsonValue.asObject().getString(string, "")).accessoryID(jsonValue.asObject().getString("id", "")).price(jsonValue.asObject().getDouble("price", 0.0)).build();
            object3.add(object);
        }
        this.setAccessoryEntries((List)object3);
        object2 = jsonObject2.asObject();
        if (object2.contains("vehicleColumn_new")) {
            jsonValue = object2.get("vehicleColumn_new").asObject();
            object = jsonValue.get(string).asArray();
            stringArray = new String[object.size()];
            for (n = 0; n < object.size(); ++n) {
                stringArray[n] = object.get(n).asString();
            }
            this.setVehicleColumnNames(stringArray);
        }
        if (object2.contains("specialColumn")) {
            jsonValue = object2.get("specialColumn").asObject();
            object = jsonValue.get(string).asArray();
            stringArray = new String[object.size()];
            for (n = 0; n < object.size(); ++n) {
                stringArray[n] = object.get(n).asString();
            }
            this.setSpecialsColumnNames(stringArray);
        }
        if (object2.contains("accessoryColumn")) {
            jsonValue = object2.get("accessoryColumn").asObject();
            object = jsonValue.get(string).asArray();
            stringArray = new String[object.size()];
            for (n = 0; n < object.size(); ++n) {
                stringArray[n] = object.get(n).asString();
            }
            this.setAccessoryColumnNames(stringArray);
        }
        if (object2.contains("statisticsColumn")) {
            jsonValue = object2.get("statisticsColumn").asObject();
            object = jsonValue.get(string).asArray();
            stringArray = new String[object.size()];
            for (n = 0; n < object.size(); ++n) {
                stringArray[n] = object.get(n).asString();
            }
            this.setStatisticsColumnNames(stringArray);
        }
    }

    public static int getWIDTH() {
        return 350;
    }

    public static int getHEIGHT() {
        return 400;
    }

    public boolean isM_exitOnClose() {
        return this.m_exitOnClose;
    }

    public CCModel setM_exitOnClose(boolean bl) {
        this.m_exitOnClose = bl;
        return this;
    }

    public static MapResourceBundle getRb() {
        return rb;
    }

    public static void setRb(MapResourceBundle mapResourceBundle) {
        rb = mapResourceBundle;
    }

    public int getM_language() {
        return this.m_language;
    }

    public CCModel setM_language(int n) {
        this.m_language = n;
        return this;
    }

    public static int getGERMAN() {
        return 0;
    }

    public static int getENGLISH() {
        return 1;
    }

    public static int getLOADTEST_WAITTIME() {
        return 3000;
    }

    public NumberFormat getM_numberFormatter() {
        return this.m_numberFormatter;
    }

    public CCModel setM_numberFormatter(NumberFormat numberFormat) {
        this.m_numberFormatter = numberFormat;
        return this;
    }

    public NumberFormat getM_currencyFormatter() {
        return this.m_currencyFormatter;
    }

    public CCModel setM_currencyFormatter(NumberFormat numberFormat) {
        this.m_currencyFormatter = numberFormat;
        return this;
    }

    public int getSortedBy() {
        return this.sortedBy;
    }

    public boolean isModelInitialized() {
        return this.modelInitialized;
    }

    public CCParams getM_params() {
        return this.m_params;
    }

    public static int getVEHICLE_NAME_INDEX() {
        return 0;
    }

    public static int getVEHICLE_ID_INDEX() {
        return 1;
    }

    public static int getVEHICLE_PRICE_INDEX() {
        return 2;
    }

    public static int getVEHICLE_KEY_INDEX() {
        return 3;
    }

    public List getVehicleCells() {
        return this.vehicleCells;
    }

    public CCModel setVehicleCells(List list) {
        this.vehicleCells = list;
        return this;
    }

    public QfsObservableMap getVehicleCellsBase() {
        return this.vehicleCellsBase;
    }

    public CCModel setVehicleCellsBase(QfsObservableMap qfsObservableMap) {
        this.vehicleCellsBase = qfsObservableMap;
        return this;
    }

    public QfsObservableMap getVehicleCellsDialog() {
        return this.vehicleCellsDialog;
    }

    public CCModel setVehicleCellsDialog(QfsObservableMap qfsObservableMap) {
        this.vehicleCellsDialog = qfsObservableMap;
        return this;
    }

    public String[] getVehicleColumnNames() {
        return this.vehicleColumnNames;
    }

    public CCModel setVehicleColumnNames(String[] stringArray) {
        this.vehicleColumnNames = stringArray;
        return this;
    }

    public Integer[] getVehicleColumnMaxWidth() {
        return this.vehicleColumnMaxWidth;
    }

    public CCModel setVehicleColumnMaxWidth(Integer[] integerArray) {
        this.vehicleColumnMaxWidth = integerArray;
        return this;
    }

    public QfsObservableMap getSpecialsCellsBase() {
        return this.specialsCellsBase;
    }

    public CCModel setSpecialsCellsBase(QfsObservableMap qfsObservableMap) {
        this.specialsCellsBase = qfsObservableMap;
        return this;
    }

    public QfsObservableMap getSpecialsCellsDialog() {
        return this.specialsCellsDialog;
    }

    public CCModel setSpecialsCellsDialog(QfsObservableMap qfsObservableMap) {
        this.specialsCellsDialog = qfsObservableMap;
        return this;
    }

    public List getSpecialsEntries() {
        return this.specialsEntries;
    }

    public CCModel setSpecialsEntries(List list) {
        this.specialsEntries = list;
        return this;
    }

    public String[] getSpecialsColumnNames() {
        return this.specialsColumnNames;
    }

    public CCModel setSpecialsColumnNames(String[] stringArray) {
        this.specialsColumnNames = stringArray;
        return this;
    }

    public Integer[] getSpecialsColumnMaxWidth() {
        return this.specialsColumnMaxWidth;
    }

    public CCModel setSpecialsColumnMaxWidth(Integer[] integerArray) {
        this.specialsColumnMaxWidth = integerArray;
        return this;
    }

    public static int getSPECIALS_TOTAL() {
        return 4;
    }

    public static int getSPECIALS_NAME_INDEX() {
        return 0;
    }

    public static int getSPECIALS_DESCRIPTION_INDEX() {
        return 1;
    }

    public static int getSPECIALS_PRICE_INDEX() {
        return 2;
    }

    public static int getSPECIALS_FEATURES_INDEX() {
        return 3;
    }

    public static int getSPECIALS_KEY_INDEX() {
        return 4;
    }

    public QfsObservableMap getAccessoryCellsBase() {
        return this.accessoryCellsBase;
    }

    public CCModel setAccessoryCellsBase(QfsObservableMap qfsObservableMap) {
        this.accessoryCellsBase = qfsObservableMap;
        return this;
    }

    public QfsObservableMap getAccessoryCellsDialog() {
        return this.accessoryCellsDialog;
    }

    public CCModel setAccessoryCellsDialog(QfsObservableMap qfsObservableMap) {
        this.accessoryCellsDialog = qfsObservableMap;
        return this;
    }

    public List getAccessoryEntries() {
        return this.accessoryEntries;
    }

    public CCModel setAccessoryEntries(List list) {
        this.accessoryEntries = list;
        return this;
    }

    public String[] getAccessoryColumnNames() {
        return this.accessoryColumnNames;
    }

    public CCModel setAccessoryColumnNames(String[] stringArray) {
        this.accessoryColumnNames = stringArray;
        return this;
    }

    public Integer[] getAccessoryColumnMaxWidth() {
        return this.accessoryColumnMaxWidth;
    }

    public CCModel setAccessoryColumnMaxWidth(Integer[] integerArray) {
        this.accessoryColumnMaxWidth = integerArray;
        return this;
    }

    public static int getACCESSORY_SELECT_INDEX() {
        return 0;
    }

    public static int getACCESSORY_NAME_INDEX() {
        return 1;
    }

    public static int getACCESSORY_ID_INDEX() {
        return 2;
    }

    public static int getACCESSORY_PRICE_INDEX() {
        return 3;
    }

    public static int getACCESSORY_KEY_INDEX() {
        return 4;
    }

    public String[] getStatisticsColumnNames() {
        return this.statisticsColumnNames;
    }

    public CCModel setStatisticsColumnNames(String[] stringArray) {
        this.statisticsColumnNames = stringArray;
        return this;
    }

    public Integer[] getStatisticsColumnMaxWidth() {
        return this.statisticsColumnMaxWidth;
    }

    public CCModel setStatisticsColumnMaxWidth(Integer[] integerArray) {
        this.statisticsColumnMaxWidth = integerArray;
        return this;
    }

    public Set getSpecial_accessories() {
        return this.special_accessories;
    }

    public CCModel setSpecial_accessories(Set set) {
        this.special_accessories = set;
        return this;
    }

    static {
        nextUniqueId = new AtomicInteger(0);
    }

    public static class CCAccessory
    extends CCData
    implements Comparable {
        Boolean selected;
        String name;
        String accessoryID;
        Double price;
        final Integer key;

        @Override
        public int size() {
            return 5;
        }

        @Override
        public Integer getKeyForSort() {
            return this.key;
        }

        @Override
        public String toString() {
            return this.name;
        }

        public int compareTo(CCAccessory cCAccessory) {
            if (cCAccessory == null) {
                return 1;
            }
            if (this.name == null) {
                return -1;
            }
            return this.name.compareTo(cCAccessory.getName());
        }

        @Override
        public Object[] getValuesAsArray() {
            Object[] objectArray = new Object[this.size()];
            objectArray[0] = this.selected;
            objectArray[1] = this.name;
            objectArray[2] = this.accessoryID;
            objectArray[3] = this.price;
            objectArray[4] = this.key;
            return objectArray;
        }

        public CCAccessory cloneAccessory() {
            CCAccessory cCAccessory = CCAccessory.builder().selected(this.selected).name(this.name).accessoryID(this.accessoryID).price(this.price).key(this.key).build();
            return cCAccessory;
        }

        CCAccessory(Boolean bl, String string, String string2, Double d, Integer n) {
            this.selected = bl;
            this.name = string;
            this.accessoryID = string2;
            this.price = d;
            this.key = n;
        }

        public static CCAccessoryBuilder builder() {
            return new CCAccessoryBuilder();
        }

        public Boolean getSelected() {
            return this.selected;
        }

        public String getName() {
            return this.name;
        }

        public String getAccessoryID() {
            return this.accessoryID;
        }

        public Double getPrice() {
            return this.price;
        }

        public Integer getKey() {
            return this.key;
        }

        public CCAccessory setSelected(Boolean bl) {
            this.selected = bl;
            return this;
        }

        public CCAccessory setName(String string) {
            this.name = string;
            return this;
        }

        public CCAccessory setAccessoryID(String string) {
            this.accessoryID = string;
            return this;
        }

        public CCAccessory setPrice(Double d) {
            this.price = d;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CCAccessory)) {
                return false;
            }
            CCAccessory cCAccessory = (CCAccessory)object;
            if (!cCAccessory.canEqual(this)) {
                return false;
            }
            Boolean bl = this.getSelected();
            Boolean bl2 = cCAccessory.getSelected();
            if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
                return false;
            }
            Double d = this.getPrice();
            Double d2 = cCAccessory.getPrice();
            if (d == null ? d2 != null : !((Object)d).equals(d2)) {
                return false;
            }
            Integer n = this.getKey();
            Integer n2 = cCAccessory.getKey();
            if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                return false;
            }
            String string = this.getName();
            String string2 = cCAccessory.getName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getAccessoryID();
            String string4 = cCAccessory.getAccessoryID();
            return !(string3 == null ? string4 != null : !string3.equals(string4));
        }

        @Override
        protected boolean canEqual(Object object) {
            return object instanceof CCAccessory;
        }

        @Override
        public int hashCode() {
            int n = 1;
            Boolean bl = this.getSelected();
            n = n * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
            Double d = this.getPrice();
            n = n * 59 + (d == null ? 43 : ((Object)d).hashCode());
            Integer n2 = this.getKey();
            n = n * 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
            String string = this.getName();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getAccessoryID();
            n = n * 59 + (string2 == null ? 43 : string2.hashCode());
            return n;
        }

        public static class CCAccessoryBuilder {
            private Boolean selected;
            private String name;
            private String accessoryID;
            private Double price;
            private Integer key;

            CCAccessoryBuilder() {
            }

            public CCAccessoryBuilder selected(Boolean bl) {
                this.selected = bl;
                return this;
            }

            public CCAccessoryBuilder name(String string) {
                this.name = string;
                return this;
            }

            public CCAccessoryBuilder accessoryID(String string) {
                this.accessoryID = string;
                return this;
            }

            public CCAccessoryBuilder price(Double d) {
                this.price = d;
                return this;
            }

            public CCAccessoryBuilder key(Integer n) {
                this.key = n;
                return this;
            }

            public CCAccessory build() {
                return new CCAccessory(this.selected, this.name, this.accessoryID, this.price, this.key);
            }

            public String toString() {
                return "CCModel.CCAccessory.CCAccessoryBuilder(selected=" + this.selected + ", name=" + this.name + ", accessoryID=" + this.accessoryID + ", price=" + this.price + ", key=" + this.key + ")";
            }
        }
    }

    public static class CCSpecial
    extends CCData
    implements Comparable {
        String name;
        String description;
        Double price;
        Set accessories;
        final Integer key;

        @Override
        public int size() {
            return 5;
        }

        @Override
        public Integer getKeyForSort() {
            return this.key;
        }

        @Override
        public String toString() {
            return this.name;
        }

        public int compareTo(CCSpecial cCSpecial) {
            if (cCSpecial == null) {
                return 1;
            }
            if (this.name == null) {
                return -1;
            }
            return this.name.compareTo(cCSpecial.getName());
        }

        @Override
        public Object[] getValuesAsArray() {
            Object[] objectArray = new Object[this.size()];
            objectArray[0] = this.name;
            objectArray[1] = this.description;
            objectArray[2] = this.price;
            objectArray[3] = this.accessories;
            objectArray[4] = this.key;
            return objectArray;
        }

        CCSpecial(String string, String string2, Double d, Set set, Integer n) {
            this.name = string;
            this.description = string2;
            this.price = d;
            this.accessories = set;
            this.key = n;
        }

        public static CCSpecialBuilder builder() {
            return new CCSpecialBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Double getPrice() {
            return this.price;
        }

        public Set getAccessories() {
            return this.accessories;
        }

        public Integer getKey() {
            return this.key;
        }

        public CCSpecial setName(String string) {
            this.name = string;
            return this;
        }

        public CCSpecial setDescription(String string) {
            this.description = string;
            return this;
        }

        public CCSpecial setPrice(Double d) {
            this.price = d;
            return this;
        }

        public CCSpecial setAccessories(Set set) {
            this.accessories = set;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CCSpecial)) {
                return false;
            }
            CCSpecial cCSpecial = (CCSpecial)object;
            if (!cCSpecial.canEqual(this)) {
                return false;
            }
            Double d = this.getPrice();
            Double d2 = cCSpecial.getPrice();
            if (d == null ? d2 != null : !((Object)d).equals(d2)) {
                return false;
            }
            Integer n = this.getKey();
            Integer n2 = cCSpecial.getKey();
            if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                return false;
            }
            String string = this.getName();
            String string2 = cCSpecial.getName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getDescription();
            String string4 = cCSpecial.getDescription();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                return false;
            }
            Set set = this.getAccessories();
            Set set2 = cCSpecial.getAccessories();
            return !(set == null ? set2 != null : !((Object)set).equals(set2));
        }

        @Override
        protected boolean canEqual(Object object) {
            return object instanceof CCSpecial;
        }

        @Override
        public int hashCode() {
            int n = 1;
            Double d = this.getPrice();
            n = n * 59 + (d == null ? 43 : ((Object)d).hashCode());
            Integer n2 = this.getKey();
            n = n * 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
            String string = this.getName();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getDescription();
            n = n * 59 + (string2 == null ? 43 : string2.hashCode());
            Set set = this.getAccessories();
            n = n * 59 + (set == null ? 43 : ((Object)set).hashCode());
            return n;
        }

        public static class CCSpecialBuilder {
            private String name;
            private String description;
            private Double price;
            private Set accessories;
            private Integer key;

            CCSpecialBuilder() {
            }

            public CCSpecialBuilder name(String string) {
                this.name = string;
                return this;
            }

            public CCSpecialBuilder description(String string) {
                this.description = string;
                return this;
            }

            public CCSpecialBuilder price(Double d) {
                this.price = d;
                return this;
            }

            public CCSpecialBuilder accessories(Set set) {
                this.accessories = set;
                return this;
            }

            public CCSpecialBuilder key(Integer n) {
                this.key = n;
                return this;
            }

            public CCSpecial build() {
                return new CCSpecial(this.name, this.description, this.price, this.accessories, this.key);
            }

            public String toString() {
                return "CCModel.CCSpecial.CCSpecialBuilder(name=" + this.name + ", description=" + this.description + ", price=" + this.price + ", accessories=" + this.accessories + ", key=" + this.key + ")";
            }
        }
    }

    public static class CCVehicle
    extends CCData
    implements Comparable {
        String name;
        String m_id;
        Double price;
        final Integer key;

        @Override
        public int size() {
            return 4;
        }

        @Override
        public Integer getKeyForSort() {
            return this.key;
        }

        @Override
        public String toString() {
            return this.name;
        }

        public int compareTo(CCVehicle cCVehicle) {
            if (cCVehicle == null) {
                return 1;
            }
            if (this.name == null) {
                return -1;
            }
            return this.name.compareTo(cCVehicle.getName());
        }

        @Override
        public Object[] getValuesAsArray() {
            Object[] objectArray = new Object[this.size()];
            objectArray[0] = this.name;
            objectArray[1] = this.m_id;
            objectArray[2] = this.price;
            objectArray[3] = this.key;
            return objectArray;
        }

        CCVehicle(String string, String string2, Double d, Integer n) {
            this.name = string;
            this.m_id = string2;
            this.price = d;
            this.key = n;
        }

        public static CCVehicleBuilder builder() {
            return new CCVehicleBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getM_id() {
            return this.m_id;
        }

        public Double getPrice() {
            return this.price;
        }

        public Integer getKey() {
            return this.key;
        }

        public CCVehicle setName(String string) {
            this.name = string;
            return this;
        }

        public CCVehicle setM_id(String string) {
            this.m_id = string;
            return this;
        }

        public CCVehicle setPrice(Double d) {
            this.price = d;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CCVehicle)) {
                return false;
            }
            CCVehicle cCVehicle = (CCVehicle)object;
            if (!cCVehicle.canEqual(this)) {
                return false;
            }
            Double d = this.getPrice();
            Double d2 = cCVehicle.getPrice();
            if (d == null ? d2 != null : !((Object)d).equals(d2)) {
                return false;
            }
            Integer n = this.getKey();
            Integer n2 = cCVehicle.getKey();
            if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                return false;
            }
            String string = this.getName();
            String string2 = cCVehicle.getName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getM_id();
            String string4 = cCVehicle.getM_id();
            return !(string3 == null ? string4 != null : !string3.equals(string4));
        }

        @Override
        protected boolean canEqual(Object object) {
            return object instanceof CCVehicle;
        }

        @Override
        public int hashCode() {
            int n = 1;
            Double d = this.getPrice();
            n = n * 59 + (d == null ? 43 : ((Object)d).hashCode());
            Integer n2 = this.getKey();
            n = n * 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
            String string = this.getName();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getM_id();
            n = n * 59 + (string2 == null ? 43 : string2.hashCode());
            return n;
        }

        public static class CCVehicleBuilder {
            private String name;
            private String m_id;
            private Double price;
            private Integer key;

            CCVehicleBuilder() {
            }

            public CCVehicleBuilder name(String string) {
                this.name = string;
                return this;
            }

            public CCVehicleBuilder m_id(String string) {
                this.m_id = string;
                return this;
            }

            public CCVehicleBuilder price(Double d) {
                this.price = d;
                return this;
            }

            public CCVehicleBuilder key(Integer n) {
                this.key = n;
                return this;
            }

            public CCVehicle build() {
                return new CCVehicle(this.name, this.m_id, this.price, this.key);
            }

            public String toString() {
                return "CCModel.CCVehicle.CCVehicleBuilder(name=" + this.name + ", m_id=" + this.m_id + ", price=" + this.price + ", key=" + this.key + ")";
            }
        }
    }
}

