/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.AccessoryDialogTablePane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.ChangeButtonPane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.DialogButtonActions;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.OptionStageFX;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;

public class AccessoriesDialog
extends OptionStageFX {
    private EventHandler newAction;
    private EventHandler changeAction;
    private EventHandler deleteAction;
    private EventHandler cancelAction;
    private EventHandler okAction;
    private AccessoryDialogTablePane accessoryDialogPane;

    public AccessoriesDialog(Window window, CCControllerFX cCControllerFX) {
        super(window, false, cCControllerFX);
        this.setTitle(CCModel.getRb().getString("dialog.accessories.name"));
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(cCControllerFX.getCSSString());
        borderPane.setId(CCModel.getRb().getString("dialog.accessories.id"));
        borderPane.setPadding(Insets.EMPTY);
        borderPane.setPrefHeight(400.0);
        borderPane.setPrefWidth(600.0);
        this.setupActions();
        this.accessoryDialogPane = new AccessoryDialogTablePane(cCControllerFX);
        borderPane.setCenter((Node)this.accessoryDialogPane);
        DialogButtonActions dialogButtonActions = new DialogButtonActions(this.newAction, this.changeAction, this.deleteAction, this.cancelAction, this.okAction);
        borderPane.setRight((Node)new ChangeButtonPane(this, dialogButtonActions));
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        this.dialogWindow = this.getScene().getWindow();
        this.dialogWindow.setOnCloseRequest(windowEvent -> this.cancelActionPerformed());
    }

    private void setupActions() {
        this.newAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                AccessoriesDialog.this.newActionPerformed();
            }
        };
        this.changeAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                AccessoriesDialog.this.changeActionPerformed();
            }
        };
        this.deleteAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                AccessoriesDialog.this.deleteActionPerformed();
            }
        };
        this.cancelAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                AccessoriesDialog.this.cancelActionPerformed();
            }
        };
        this.okAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                AccessoriesDialog.this.okActionPerformed();
            }
        };
    }

    @Override
    public void newActionPerformed() {
        this.cccontroller.sleepForLoadtesting();
        Double d = this.accessoryDialogPane.getAccessoryPrice();
        if (d <= 0.0) {
            this.showInvalidPriceDialog();
            return;
        }
        String string = this.accessoryDialogPane.getAccessoryName();
        String string2 = this.accessoryDialogPane.getAccessoryID();
        this.cccontroller.accessoryDialogNewAction(d, string, string2);
        this.accessoryDialogPane.updateAccessoryViewTable();
        this.accessoryDialogPane.reset();
    }

    @Override
    public void changeActionPerformed() {
        if (!this.accessoryDialogPane.getAccessoriesTablePanelTableView().getSelectionModel().isEmpty()) {
            Double d = this.accessoryDialogPane.getAccessoryPrice();
            if (d <= 0.0) {
                this.showInvalidPriceDialog();
                return;
            }
            String string = this.accessoryDialogPane.getAccessoryName();
            String string2 = this.accessoryDialogPane.getAccessoryID();
            int n = ((CCModel.CCAccessory)this.accessoryDialogPane.getAccessoriesTablePanelTableView().getSelectionModel().getSelectedItem()).getKey();
            this.cccontroller.accessoryDialogChangeAction(n, string, string2, d);
            this.accessoryDialogPane.updateAccessoryViewTable();
            this.accessoryDialogPane.reset();
        }
    }

    @Override
    public void deleteActionPerformed() {
        if (!this.accessoryDialogPane.getAccessoriesTablePanelTableView().getSelectionModel().isEmpty()) {
            int n = ((CCModel.CCAccessory)this.accessoryDialogPane.getAccessoriesTablePanelTableView().getSelectionModel().getSelectedItem()).getKey();
            this.cccontroller.accessoryDialogDeleteAction(n);
        }
        this.accessoryDialogPane.updateAccessoryViewTable();
        this.accessoryDialogPane.reset();
    }

    @Override
    public void cancelActionPerformed() {
        this.cccontroller.accessoryDialogCancelAction();
        this.dialogWindow.hide();
    }

    @Override
    public void okActionPerformed() {
        this.cccontroller.accessoryDialogConfirmAction();
        this.dialogWindow.hide();
        this.cccontroller.getView().updateAllPanes();
    }

    @Override
    public void detailsActionPerformed() {
    }

    @Override
    public void overviewActionPerformed() {
    }

    public String getBusinessId() {
        return "ACCESSORIESDIALOG";
    }
}

