/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCLoginControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.CCViewFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.LoginDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.SplashStage;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class FXRunner
extends Application {
    static CCControllerFX cccontroller;
    static CCLoginControllerFX cclogincontroller;

    public FXRunner() {
    }

    public FXRunner(CCControllerFX cCControllerFX) {
        cccontroller = cCControllerFX;
    }

    public void start(Stage stage) throws Exception {
        if (cccontroller.isShowSplash()) {
            this.showSplashFor(5000L);
        }
        this.setupStage(stage);
    }

    private void showSplashFor(long l) {
        SplashStage splashStage = new SplashStage(cccontroller.getCcmodel().getM_params().getLang(), l);
    }

    public void setupStage(Stage stage) {
        cccontroller.setFont(Font.getDefault());
        cccontroller.setFontSize(cccontroller.getCcmodel().getM_params().getMinimumFontsize());
        if (cccontroller.getCcmodel().getM_params().isLogin()) {
            this.showLoginDialog();
        }
        stage.setTitle("CarConfigurator JavaFX");
        CCViewFX cCViewFX = CCViewFX.getInstance(cccontroller);
        cccontroller.setView(cCViewFX);
        cCViewFX.build();
        Scene scene = cCViewFX.getScene() == null ? new Scene((Parent)cCViewFX) : cCViewFX.getScene();
        stage.setScene(scene);
        this.setPosition(stage);
        this.setIcon(stage);
        stage.setOnCloseRequest(windowEvent -> {
            windowEvent.consume();
            cccontroller.exit(0);
        });
        stage.show();
    }

    public void showLoginDialog() {
        LoginDialog loginDialog = new LoginDialog(cccontroller);
        loginDialog.showAndWait();
    }

    private void setIcon(Stage stage) {
        Image image = FXRunner.getImage("icon.CarConfigFx.frame32");
        stage.getIcons().add((Object)image);
    }

    private void setPosition(Stage stage) {
        stage.setX((double)cccontroller.getCcmodel().getM_params().getXpos());
        stage.setY((double)cccontroller.getCcmodel().getM_params().getYpos());
    }

    public static Image getImage(String string) {
        String string2 = CCModel.getRb().getString(string, null);
        return new Image(CCViewFX.class.getResourceAsStream("/" + string2));
    }
}

