/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.GeneralStageFX;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import javafx.stage.Window;

public class SpecialOverviewDialog
extends GeneralStageFX {
    CCModel.CCSpecial selectedSpecial;
    ObservableList accessoriesSpecialsDialog;

    public SpecialOverviewDialog(Window window, CCControllerFX cCControllerFX, CCModel.CCSpecial cCSpecial, ObservableList observableList) {
        super(window, cCControllerFX);
        this.selectedSpecial = cCSpecial;
        this.accessoriesSpecialsDialog = observableList;
        String string = CCModel.getRb().getString("dialog.specialoverview.title");
        if (cCSpecial != null) {
            string = string + " " + cCSpecial.getName();
        }
        this.setTitle(string);
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(cCControllerFX.getCSSString());
        Pane pane = this.getSpecialsGraph();
        pane.setId(CCModel.getRb().getString("dialog.specialoverview.graphpane.id"));
        pane.setPrefWidth(600.0);
        pane.setPrefHeight(400.0);
        borderPane.setCenter((Node)pane);
        FlowPane flowPane = new FlowPane();
        flowPane.alignmentProperty().setValue((Object)Pos.CENTER);
        flowPane.setMaxWidth(Double.MAX_VALUE);
        flowPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Button button = new Button(CCModel.getRb().getString("button.ok"));
        button.setId(CCModel.getRb().getString("dialog.specialoverview.closebutton.id"));
        button.setOnAction(actionEvent -> this.dialogWindow.hide());
        flowPane.getChildren().add((Object)button);
        borderPane.setBottom((Node)flowPane);
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        this.dialogWindow = this.getScene().getWindow();
        this.dialogWindow.setOnCloseRequest(windowEvent -> this.dialogWindow.hide());
    }

    public Pane getSpecialsGraph() {
        Pane pane = new Pane();
        pane.setMaxWidth(Double.MAX_VALUE);
        pane.setMaxHeight(Double.MAX_VALUE);
        String string = this.selectedSpecial == null ? "-XXX-" : this.selectedSpecial.getName();
        Node node = this.getNode(string, 200.0, 20.0, 120.0, 30.0);
        pane.getChildren().add((Object)node);
        if (this.selectedSpecial != null) {
            int n = 0;
            for (CCModel.CCAccessory cCAccessory : this.accessoriesSpecialsDialog) {
                for (String string2 : this.selectedSpecial.getAccessories()) {
                    if (!cCAccessory.getAccessoryID().equals(string2)) continue;
                    int n2 = 12;
                    double d = (double)(cCAccessory.getName().length() * n2) * 0.75;
                    Node node2 = this.getNode(cCAccessory.getName(), 50 + 120 * n, n * 50 + 150, d, 30.0);
                    pane.getChildren().add((Object)node2);
                    Line line = this.getEdge(260.0, 35.0, 110 + 120 * n, n * 50 + 165);
                    pane.getChildren().add((Object)line);
                    line.toBack();
                    ++n;
                }
            }
        }
        return pane;
    }

    public Node getNode(String string, double d, double d2, double d3, double d4) {
        FlowPane flowPane = new FlowPane();
        flowPane.setStyle("-fx-border-color: black; -fx-border-style: solid; -fx-border-width: 1; -fx-background-color: white;");
        flowPane.setAlignment(Pos.CENTER);
        flowPane.getChildren().add((Object)new Label(string));
        flowPane.setLayoutX(d);
        flowPane.setLayoutY(d2);
        flowPane.setMaxHeight(d4);
        flowPane.setMaxWidth(d3);
        flowPane.setPrefHeight(d4);
        flowPane.setPrefWidth(d3);
        flowPane.setMinHeight(d4);
        flowPane.setMinWidth(d3);
        return flowPane;
    }

    public Line getEdge(double d, double d2, double d3, double d4) {
        return new Line(d, d2, d3, d4);
    }
}

