/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.ChangeButtonPane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.DialogButtonActions;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.OptionStageFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.SpecialDetailsDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.SpecialOverviewDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.SpecialsDialogTablePane;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;

public class SpecialsDialog
extends OptionStageFX {
    private EventHandler newAction;
    private EventHandler changeAction;
    private EventHandler deleteAction;
    private EventHandler cancelAction;
    private EventHandler okAction;
    private EventHandler detailsAction;
    private EventHandler overviewAction;
    private SpecialsDialogTablePane specialsDialogPane;

    public SpecialsDialog(Window window, CCControllerFX cCControllerFX) {
        super(window, true, cCControllerFX);
        this.setTitle(CCModel.getRb().getString("dialog.specials.name"));
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(cCControllerFX.getCSSString());
        borderPane.setId(CCModel.getRb().getString("dialog.specials.id"));
        borderPane.setPadding(Insets.EMPTY);
        borderPane.setPrefHeight(700.0);
        borderPane.setPrefWidth(700.0);
        this.setupActions();
        this.specialsDialogPane = new SpecialsDialogTablePane(cCControllerFX);
        borderPane.setCenter((Node)this.specialsDialogPane);
        DialogButtonActions dialogButtonActions = new DialogButtonActions(this.newAction, this.changeAction, this.deleteAction, this.detailsAction, this.overviewAction, this.cancelAction, this.okAction);
        borderPane.setRight((Node)new ChangeButtonPane(this, dialogButtonActions));
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        this.dialogWindow = this.getScene().getWindow();
        this.dialogWindow.setOnCloseRequest(windowEvent -> this.cancelActionPerformed());
    }

    private void setupActions() {
        this.newAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                SpecialsDialog.this.newActionPerformed();
            }
        };
        this.changeAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                SpecialsDialog.this.changeActionPerformed();
            }
        };
        this.deleteAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                SpecialsDialog.this.deleteActionPerformed();
            }
        };
        this.detailsAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                SpecialsDialog.this.detailsActionPerformed();
            }
        };
        this.overviewAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                SpecialsDialog.this.overviewActionPerformed();
            }
        };
        this.cancelAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                SpecialsDialog.this.cancelActionPerformed();
            }
        };
        this.okAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                SpecialsDialog.this.okActionPerformed();
            }
        };
    }

    @Override
    public void newActionPerformed() {
        Double d = this.specialsDialogPane.getSpecialsPrice();
        if (d <= 0.0) {
            this.showInvalidPriceDialog();
            return;
        }
        String string = this.specialsDialogPane.getSpecialsName();
        String string2 = this.specialsDialogPane.getSelectedAccessories();
        String string3 = new String(this.specialsDialogPane.getSpecialsDescription());
        this.cccontroller.specialsDialogNewAction(string, string3, d, string2);
        this.specialsDialogPane.updateSpecialsTable();
        this.specialsDialogPane.reset();
    }

    @Override
    public void changeActionPerformed() {
        if (!this.specialsDialogPane.getSpecialsDialogTablePanel().getSelectionModel().isEmpty()) {
            Double d = this.specialsDialogPane.getSpecialsPrice();
            if (d <= 0.0) {
                this.showInvalidPriceDialog();
                return;
            }
            CCModel.CCSpecial cCSpecial = (CCModel.CCSpecial)this.specialsDialogPane.getSpecialsDialogTablePanel().getSelectionModel().getSelectedItem();
            String string = this.specialsDialogPane.getSpecialsName();
            String string2 = this.specialsDialogPane.getSelectedAccessories();
            String string3 = new String(this.specialsDialogPane.getSpecialsDescription());
            int n = cCSpecial.getKey();
            this.cccontroller.specialsDialogChangedAction(string, string3, d, string2, n);
            this.specialsDialogPane.updateSpecialsTable();
            this.specialsDialogPane.reset();
        }
    }

    @Override
    public void deleteActionPerformed() {
        if (!this.specialsDialogPane.getSpecialsDialogTablePanel().getSelectionModel().isEmpty()) {
            int n = ((CCModel.CCSpecial)this.specialsDialogPane.getSpecialsDialogTablePanel().getSelectionModel().getSelectedItem()).getKey();
            this.cccontroller.specialsDialogDeleteAction(n);
        }
        this.specialsDialogPane.updateSpecialsViewTables();
        this.specialsDialogPane.reset();
    }

    @Override
    public void cancelActionPerformed() {
        this.cccontroller.specialsDialogCancelAction();
        this.dialogWindow.hide();
    }

    @Override
    public void okActionPerformed() {
        this.cccontroller.specialsDialogConfirmAction();
        this.dialogWindow.hide();
        this.cccontroller.getView().updateAllPanes();
    }

    @Override
    public void detailsActionPerformed() {
        this.cccontroller.sleepForLoadtesting();
        SpecialDetailsDialog specialDetailsDialog = new SpecialDetailsDialog(this.dialogWindow, this.cccontroller, (CCModel.CCSpecial)this.specialsDialogPane.getSpecialsDialogTablePanel().getSelectionModel().getSelectedItem(), this.specialsDialogPane.getSpecialsDialogAccessoryTableContent());
        specialDetailsDialog.showAndWait();
    }

    @Override
    public void overviewActionPerformed() {
        this.cccontroller.sleepForLoadtesting();
        SpecialOverviewDialog specialOverviewDialog = new SpecialOverviewDialog(this.dialogWindow, this.cccontroller, (CCModel.CCSpecial)this.specialsDialogPane.getSpecialsDialogTablePanel().getSelectionModel().getSelectedItem(), this.specialsDialogPane.getSpecialsDialogAccessoryTableContent());
        specialOverviewDialog.showAndWait();
    }

    public String getBusinessId() {
        return "SPECIALSDIALOG";
    }
}

