/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCData;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public class SpecialsDialogTablePane
extends BorderPane {
    CCControllerFX cccontroller;
    CCModel ccmodel;
    private TextField specialsName;
    private TextField specialsPrice;
    private TextField specialsSeparatePrices;
    private TextArea specialsDescription;
    private TableView specialsDialogTablePanel;
    private TableView specialsDialogAccessoryTable;
    private ObservableList specialsDialogAccessoryTableContent = FXCollections.observableArrayList();

    public SpecialsDialogTablePane(CCControllerFX cCControllerFX) {
        this.cccontroller = cCControllerFX;
        this.ccmodel = cCControllerFX.getCcmodel();
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setVgap(3.0);
        gridPane.setHgap(3.0);
        gridPane.setPrefHeight(600.0);
        gridPane.setPrefWidth(350.0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        gridPane.add(this.createMiddleElementsFirstTableNode(), 0, 1);
        gridPane.add(this.createMiddleElementsSecondTableNode(), 0, 2);
        gridPane.add(this.createMiddleElementsThirdTableNode(), 0, 3);
        gridPane.add(this.createMiddleElementsFourthTableNode(), 0, 4);
        for (Integer n : this.ccmodel.getAccessoryCellsBase().keySet()) {
            this.specialsDialogAccessoryTableContent.add((Object)((CCModel.CCAccessory)this.ccmodel.getAccessoryCellsBase().get((Object)n)).cloneAccessory().setSelected(false));
        }
        Collections.sort(this.specialsDialogAccessoryTableContent, new Comparator(){

            public int compare(CCData cCData, CCData cCData2) {
                return cCData.getKeyForSort().compareTo(cCData2.getKeyForSort());
            }
        });
        this.setCenter((Node)gridPane);
        this.updateSpecialsViewTables();
        this.reset();
    }

    public Node createMiddleElementsFirstTableNode() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setVgap(3.0);
        gridPane.setHgap(3.0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        Label label = new Label(CCModel.getRb().getString("dialog.specials.label"));
        label.setStyle("-fx-text-fill: blue;");
        label.setId(CCModel.getRb().getString("dialog.specials.edit.name.id"));
        gridPane.add((Node)label, 0, 0);
        this.specialsDialogTablePanel = new TableView();
        this.specialsDialogTablePanel.setId("SpecialsTable");
        this.specialsDialogTablePanel.setMinWidth(0.0);
        this.specialsDialogTablePanel.setMinHeight(0.0);
        this.specialsDialogTablePanel.setMaxWidth(Double.MAX_VALUE);
        this.specialsDialogTablePanel.setMaxHeight(Double.MAX_VALUE);
        this.specialsDialogTablePanel.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new SpecialsSelectionChangedEventHandler());
        this.specialsDialogTablePanel.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        if (!this.ccmodel.getM_params().isCleanname()) {
            gridPane.setId(CCModel.getRb().getString("panel.specials.table.id"));
        } else {
            gridPane.setId(CCModel.getRb().getString("dialog.specials.table.id"));
        }
        gridPane.add((Node)this.specialsDialogTablePanel, 0, 1);
        return gridPane;
    }

    public Node createMiddleElementsSecondTableNode() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setVgap(3.0);
        gridPane.setHgap(3.0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints});
        Label label = new Label(CCModel.getRb().getString("dialog.specials.edit.name"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 0);
        this.specialsName = new TextField();
        this.specialsName.setMinHeight(30.0);
        this.specialsName.setId(CCModel.getRb().getString("dialog.specials.edit.name.id"));
        gridPane.add((Node)this.specialsName, 0, 1);
        Label label2 = new Label(CCModel.getRb().getString("dialog.specials.edit.price"));
        label2.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label2, 1, 0);
        this.specialsPrice = new TextField();
        this.specialsPrice.setMinHeight(30.0);
        this.specialsPrice.setId(CCModel.getRb().getString("dialog.specials.edit.price.id"));
        BorderPane borderPane = new BorderPane();
        borderPane.setId(CCModel.getRb().getString("dialog.specials.edit.newpanel.id"));
        borderPane.setCenter((Node)this.specialsPrice);
        gridPane.add((Node)borderPane, 1, 1);
        Label label3 = new Label(CCModel.getRb().getString("dialog.specials.edit.seperateprice"));
        label3.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label3, 1, 2);
        this.specialsSeparatePrices = new TextField();
        this.specialsSeparatePrices.setMinHeight(30.0);
        this.specialsSeparatePrices.setId(CCModel.getRb().getString("dialog.specials.edit.separateprice.id"));
        this.specialsSeparatePrices.setEditable(false);
        gridPane.setId(CCModel.getRb().getString("dialog.specials.edit.id"));
        gridPane.add((Node)this.specialsSeparatePrices, 1, 3);
        return gridPane;
    }

    public Node createMiddleElementsThirdTableNode() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setVgap(3.0);
        gridPane.setHgap(3.0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        Label label = new Label(CCModel.getRb().getString("dialog.specials.edit.desc"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 0);
        this.specialsDescription = new TextArea();
        this.specialsDescription.setId(CCModel.getRb().getString("dialog.specials.area.id"));
        this.specialsDescription.setMinHeight(100.0);
        this.specialsDescription.setMaxWidth(Double.MAX_VALUE);
        this.specialsDescription.setMaxHeight(Double.MAX_VALUE);
        gridPane.add((Node)this.specialsDescription, 0, 1);
        return gridPane;
    }

    public Node createMiddleElementsFourthTableNode() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setVgap(3.0);
        gridPane.setHgap(3.0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        Label label = new Label(CCModel.getRb().getString("dialog.specials.contained"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 0);
        this.specialsDialogAccessoryTable = new TableView();
        this.specialsDialogAccessoryTable.setId("AccessoryTable");
        this.specialsDialogAccessoryTable.setMinHeight(0.0);
        this.specialsDialogAccessoryTable.setMinWidth(0.0);
        this.specialsDialogAccessoryTable.setMaxHeight(Double.MAX_VALUE);
        this.specialsDialogAccessoryTable.setMaxWidth(Double.MAX_VALUE);
        this.specialsDialogAccessoryTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.specialsDialogAccessoryTable.setItems(this.specialsDialogAccessoryTableContent);
        gridPane.setId(CCModel.getRb().getString("dialog.specials.accessory.id"));
        gridPane.add((Node)this.specialsDialogAccessoryTable, 0, 1);
        return gridPane;
    }

    public String getSpecialsName() {
        return this.specialsName.getText();
    }

    public void setSpecialsName(String string) {
        this.specialsName.setText(string);
    }

    public Double getSpecialsPrice() {
        Double d;
        try {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            String string = this.specialsPrice.getText().trim();
            d = numberFormat.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            d = 0.0;
        }
        return d;
    }

    public void setSpecialsPrice(Double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(2);
        this.specialsPrice.setText(numberFormat.format(d));
    }

    private Double getSelectedAccessoriesPrice() {
        Double d = 0.0;
        for (CCModel.CCAccessory cCAccessory : this.specialsDialogAccessoryTable.getItems()) {
            if (!cCAccessory.getSelected().booleanValue()) continue;
            d = d + cCAccessory.getPrice();
        }
        return d;
    }

    public void setSpecialsSeparatePrices(Double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(2);
        this.specialsSeparatePrices.setText(numberFormat.format(d));
    }

    public String getSpecialsDescription() {
        return this.specialsDescription.getText();
    }

    public void setSpecialsDescription(String string) {
        this.specialsDescription.setText(string);
    }

    public String getSelectedAccessories() {
        String string = "";
        for (CCModel.CCAccessory cCAccessory : this.specialsDialogAccessoryTableContent) {
            if (!cCAccessory.getSelected().booleanValue()) continue;
            string = string + " " + cCAccessory.getAccessoryID();
        }
        return string;
    }

    private void updateSpecialsSeparatePrices() {
        this.setSpecialsSeparatePrices(this.getSelectedAccessoriesPrice());
    }

    public void reset() {
        this.specialsName.setText("");
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(2);
        this.specialsPrice.setText(numberFormat.format(0.0));
        this.specialsSeparatePrices.setText(numberFormat.format(0.0));
    }

    public void updateSpecialsViewTables() {
        this.updateSpecialsTable();
        this.updateAccessoryTable();
    }

    public void updateSpecialsTable() {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        if (this.ccmodel.getM_language() == CCModel.getGERMAN()) {
            tableColumn.setText("Modelle");
        } else {
            tableColumn.setText("Models");
        }
        this.specialsDialogTablePanel.getColumns().setAll((Object[])new TableColumn[]{tableColumn});
        ObservableList observableList = FXCollections.observableArrayList();
        for (Integer n : this.ccmodel.getSpecialsCellsDialog().keySet()) {
            observableList.add(this.ccmodel.getSpecialsCellsDialog().get((Object)n));
        }
        Collections.sort(observableList, new Comparator(){

            public int compare(CCData cCData, CCData cCData2) {
                return cCData.getKeyForSort().compareTo(cCData2.getKeyForSort());
            }
        });
        this.specialsDialogTablePanel.setItems(observableList);
    }

    private void updateAccessoryTable() {
        TableColumn tableColumn = new TableColumn();
        TableColumn tableColumn2 = new TableColumn();
        TableColumn tableColumn3 = new TableColumn();
        TableColumn tableColumn4 = new TableColumn();
        tableColumn.setMaxWidth(50.0);
        tableColumn.setMinWidth(50.0);
        tableColumn3.setPrefWidth(50.0);
        tableColumn4.setPrefWidth(100.0);
        tableColumn.setCellValueFactory(new Callback(){

            public ObservableValue call(TableColumn.CellDataFeatures cellDataFeatures) {
                final CCModel.CCAccessory cCAccessory = (CCModel.CCAccessory)cellDataFeatures.getValue();
                CheckBox checkBox = new CheckBox();
                checkBox.selectedProperty().setValue(cCAccessory.getSelected());
                checkBox.selectedProperty().addListener(new ChangeListener(){

                    public void changed(ObservableValue observableValue, Boolean bl, Boolean bl2) {
                        int n = SpecialsDialogTablePane.this.specialsDialogAccessoryTableContent.indexOf((Object)cCAccessory);
                        ((CCModel.CCAccessory)SpecialsDialogTablePane.this.specialsDialogAccessoryTableContent.get(n)).setSelected(bl2);
                        SpecialsDialogTablePane.this.updateSpecialsSeparatePrices();
                    }
                });
                return new SimpleObjectProperty((Object)checkBox);
            }
        });
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("accessoryID"));
        tableColumn4.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        tableColumn3.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER;");
                return tableCell;
            }
        });
        tableColumn4.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(Double d, boolean bl) {
                        super.updateItem((Object)d, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : SpecialsDialogTablePane.this.ccmodel.getM_currencyFormatter().format(this.getItem());
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER-RIGHT;");
                return tableCell;
            }
        });
        if (this.ccmodel.getM_language() == CCModel.getGERMAN()) {
            tableColumn.setText(" ");
            tableColumn2.setText("Beschreibung");
            tableColumn3.setText("ID");
            tableColumn4.setText("Preis");
        } else {
            tableColumn.setText(" ");
            tableColumn2.setText("Description");
            tableColumn3.setText("ID");
            tableColumn4.setText("Price");
        }
        this.specialsDialogAccessoryTable.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3, tableColumn4});
    }

    public TableView getSpecialsDialogTablePanel() {
        return this.specialsDialogTablePanel;
    }

    public ObservableList getSpecialsDialogAccessoryTableContent() {
        return this.specialsDialogAccessoryTableContent;
    }

    public class SpecialsSelectionChangedEventHandler
    implements ChangeListener {
        public void changed(ObservableValue observableValue, CCModel.CCSpecial cCSpecial, CCModel.CCSpecial cCSpecial2) {
            if (SpecialsDialogTablePane.this.ccmodel.getM_params().isBuggy() && SpecialsDialogTablePane.this.specialsDialogTablePanel.getSelectionModel().getSelectedIndex() == SpecialsDialogTablePane.this.specialsDialogTablePanel.getItems().size() - 1) {
                SpecialsDialogTablePane.this.setSpecialsName("");
                SpecialsDialogTablePane.this.setSpecialsPrice(0.0);
                return;
            }
            if (!SpecialsDialogTablePane.this.specialsDialogTablePanel.getSelectionModel().isEmpty()) {
                CCModel.CCSpecial cCSpecial3 = (CCModel.CCSpecial)SpecialsDialogTablePane.this.specialsDialogTablePanel.getSelectionModel().getSelectedItem();
                SpecialsDialogTablePane.this.setSpecialsName(cCSpecial3.getName());
                SpecialsDialogTablePane.this.setSpecialsPrice(cCSpecial3.getPrice());
                SpecialsDialogTablePane.this.setSpecialsDescription(cCSpecial3.getDescription());
                if (!SpecialsDialogTablePane.this.ccmodel.getM_params().isBuggy()) {
                    block0: for (CCModel.CCAccessory cCAccessory : SpecialsDialogTablePane.this.specialsDialogAccessoryTableContent) {
                        for (String string : cCSpecial3.getAccessories()) {
                            if (cCAccessory.getAccessoryID().equals(string)) {
                                cCAccessory.setSelected(true);
                                continue block0;
                            }
                            cCAccessory.setSelected(false);
                        }
                    }
                } else {
                    for (CCModel.CCAccessory cCAccessory : SpecialsDialogTablePane.this.specialsDialogAccessoryTableContent) {
                        cCAccessory.setSelected(false);
                    }
                    SpecialsDialogTablePane.this.updateSpecialsSeparatePrices();
                }
                SpecialsDialogTablePane.this.updateAccessoryTable();
                SpecialsDialogTablePane.this.updateSpecialsSeparatePrices();
            } else {
                for (CCModel.CCAccessory cCAccessory : SpecialsDialogTablePane.this.specialsDialogAccessoryTableContent) {
                    cCAccessory.setSelected(false);
                }
                SpecialsDialogTablePane.this.updateSpecialsSeparatePrices();
            }
        }
    }
}

