/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCData;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.CCViewFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.SpecialsSelectionValueChangedEventHandler;
import java.util.Collections;
import java.util.Comparator;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class SpecialsPane
extends GridPane {
    CCModel ccmodel = CCModel.getInstance();
    CCViewFX ccview;
    CCControllerFX cccontroller;
    private ComboBox specialsSelection;
    private TextArea specialsArea;
    private Boolean specialsPaneEventLocked;

    public SpecialsPane(CCControllerFX cCControllerFX) {
        this.cccontroller = cCControllerFX;
        this.ccview = CCViewFX.getInstance(cCControllerFX);
        this.setPadding(new Insets(7.0, 7.0, 7.0, 7.0));
        this.setHgap(5.0);
        this.setVgap(5.0);
        this.setPrefHeight(Double.MAX_VALUE);
        this.setMaxHeight(Double.MAX_VALUE);
        this.setId(CCModel.getRb().getString("panel.specials.id"));
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        columnConstraints.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        Label label = new Label(CCModel.getRb().getString("panel.specials.name"));
        label.setStyle("-fx-text-fill: blue;");
        this.add((Node)label, 0, 0);
        this.specialsSelection = new ComboBox();
        this.specialsSelection.setId(CCModel.getRb().getString("panel.specials.combo.id"));
        this.specialsSelection.setMaxWidth(Double.MAX_VALUE);
        this.specialsSelection.valueProperty().addListener((ChangeListener)new SpecialsSelectionValueChangedEventHandler(cCControllerFX));
        this.specialsSelection.getSelectionModel().selectedItemProperty().addListener(observable -> {
            if (!this.specialsPaneEventLocked.booleanValue()) {
                cCControllerFX.getView().updateSelectedSpecial();
            }
        });
        this.add((Node)this.specialsSelection, 0, 1);
        this.specialsArea = new TextArea();
        this.specialsArea.setId(CCModel.getRb().getString("panel.specials.textarea.id"));
        this.specialsArea.setEditable(false);
        this.specialsArea.setMaxWidth(Double.MAX_VALUE);
        this.specialsArea.setPrefHeight(2.147483647E9);
        this.specialsArea.setMaxHeight(Double.MAX_VALUE);
        this.add((Node)this.specialsArea, 0, 2);
    }

    public void updateSpecialsPane() {
        this.specialsPaneEventLocked = true;
        this.specialsSelection.getItems().clear();
        ObservableList observableList = FXCollections.observableArrayList();
        for (Integer n : this.ccmodel.getSpecialsCellsBase().keySet()) {
            observableList.add(this.ccmodel.getSpecialsCellsBase().get((Object)n));
        }
        Collections.sort(observableList, new Comparator(){

            public int compare(CCData cCData, CCData cCData2) {
                return cCData.getKeyForSort().compareTo(cCData2.getKeyForSort());
            }
        });
        this.specialsSelection.setItems(observableList);
        Object object = (CCModel.CCSpecial)this.specialsSelection.getSelectionModel().getSelectedItem();
        this.specialsPaneEventLocked = false;
        if (object == null) {
            this.specialsSelection.getSelectionModel().selectFirst();
            object = (CCModel.CCSpecial)this.specialsSelection.getSelectionModel().getSelectedItem();
        }
        this.specialsArea.setText(((CCModel.CCSpecial)object).getDescription());
        this.cccontroller.getView().updateSelectedAccessories();
    }

    public ComboBox getSpecialsSelection() {
        return this.specialsSelection;
    }

    public TextArea getSpecialsArea() {
        return this.specialsArea;
    }

    public Boolean getSpecialsPaneEventLocked() {
        return this.specialsPaneEventLocked;
    }
}

