/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCData;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public class VehicleDialogTablePane
extends BorderPane {
    CCControllerFX cccontroller;
    CCModel ccmodel;
    private TableView vehiclesTablePanelTableView;
    private TextField vehiclesNameTextField;
    private TextField vehiclesIdTextField;
    private TextField vehiclesPriceTextField;

    public VehicleDialogTablePane(CCControllerFX cCControllerFX) {
        this.cccontroller = cCControllerFX;
        this.ccmodel = cCControllerFX.getCcmodel();
        this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        GridPane gridPane = new GridPane();
        if (!this.ccmodel.getM_params().isCleanname()) {
            gridPane.setId(CCModel.getRb().getString("panel.vehicles.table.id"));
        } else {
            gridPane.setId(CCModel.getRb().getString("dialog.vehicles.table.id"));
        }
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        columnConstraints.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        gridPane.setHgap(3.0);
        gridPane.setVgap(3.0);
        gridPane.setPrefWidth(300.0);
        gridPane.setPrefHeight(100.0);
        Label label = new Label(CCModel.getRb().getString("dialog.vehicles.label"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 1);
        this.vehiclesTablePanelTableView = new TableView();
        this.vehiclesTablePanelTableView.setId("VehiclesTable");
        this.vehiclesTablePanelTableView.setMaxHeight(Double.MAX_VALUE);
        this.vehiclesTablePanelTableView.setMaxWidth(Double.MAX_VALUE);
        this.vehiclesTablePanelTableView.setEditable(false);
        this.vehiclesTablePanelTableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.vehiclesTablePanelTableView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new OnVehicleTableColumnClickEventHandler());
        this.vehiclesTablePanelTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        gridPane.add((Node)this.vehiclesTablePanelTableView, 0, 2);
        GridPane gridPane2 = new GridPane();
        gridPane2.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setMaxWidth(Double.NEGATIVE_INFINITY);
        columnConstraints2.setHgrow(Priority.SOMETIMES);
        ColumnConstraints columnConstraints3 = new ColumnConstraints();
        columnConstraints3.setMaxWidth(Double.MAX_VALUE);
        columnConstraints3.setHgrow(Priority.SOMETIMES);
        ColumnConstraints columnConstraints4 = new ColumnConstraints();
        columnConstraints4.setMaxWidth(Double.NEGATIVE_INFINITY);
        columnConstraints4.setHgrow(Priority.SOMETIMES);
        ColumnConstraints columnConstraints5 = new ColumnConstraints();
        columnConstraints5.setMaxWidth(Double.NEGATIVE_INFINITY);
        columnConstraints5.setHgrow(Priority.SOMETIMES);
        gridPane2.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints2, columnConstraints3, columnConstraints4, columnConstraints5});
        gridPane2.setHgap(3.0);
        gridPane2.setId(CCModel.getRb().getString("dialog.vehicles.editpanel.id"));
        Label label2 = new Label(CCModel.getRb().getString("dialog.vehicles.edit.name"));
        label2.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label2, 0, 0);
        this.vehiclesNameTextField = new TextField("");
        this.vehiclesNameTextField.setMaxWidth(400.0);
        this.vehiclesNameTextField.setId(CCModel.getRb().getString("dialog.vehicles.name.id"));
        gridPane2.add((Node)this.vehiclesNameTextField, 0, 1);
        Label label3 = new Label(CCModel.getRb().getString("dialog.vehicles.edit.id"));
        label3.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label3, 2, 0);
        this.vehiclesIdTextField = new TextField("");
        this.vehiclesIdTextField.setMaxWidth(45.0);
        this.vehiclesIdTextField.setId(CCModel.getRb().getString("dialog.vehicles.id.id"));
        gridPane2.add((Node)this.vehiclesIdTextField, 2, 1);
        Label label4 = new Label(CCModel.getRb().getString("dialog.vehicles.edit.price"));
        label4.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label4, 3, 0);
        this.vehiclesPriceTextField = new TextField("");
        this.vehiclesPriceTextField.setMaxWidth(100.0);
        this.vehiclesPriceTextField.setId(CCModel.getRb().getString("dialog.vehicles.price.id"));
        gridPane2.add((Node)this.vehiclesPriceTextField, 3, 1);
        this.setCenter((Node)gridPane);
        this.setBottom((Node)gridPane2);
        this.updateVehicleViewTable();
    }

    public String getVehicleName() {
        return this.vehiclesNameTextField.getText();
    }

    public void setVehicleName(String string) {
        this.vehiclesNameTextField.setText(string);
    }

    public String getVehicleId() {
        return this.vehiclesIdTextField.getText();
    }

    public void setVehicleId(String string) {
        this.vehiclesIdTextField.setText(string);
    }

    public Double getVehiclePrice() {
        Double d;
        try {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            String string = this.vehiclesPriceTextField.getText().trim();
            d = numberFormat.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            d = 0.0;
        }
        return d;
    }

    public void setVehiclePrice(Double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(2);
        this.vehiclesPriceTextField.setText(numberFormat.format(d));
    }

    public void reset() {
        this.vehiclesNameTextField.setText("");
        this.vehiclesIdTextField.setText("");
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(2);
        this.vehiclesPriceTextField.setText(numberFormat.format(0.0));
    }

    public void updateVehicleViewTable() {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setMaxWidth(1.65356240896E11);
        tableColumn.setMinWidth(50.0);
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        TableColumn tableColumn2 = new TableColumn();
        tableColumn2.setMaxWidth(1.9327352832E10);
        tableColumn2.setMinWidth(10.0);
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("m_id"));
        TableColumn tableColumn3 = new TableColumn();
        tableColumn3.setMaxWidth(3.0064771072E10);
        tableColumn3.setMinWidth(50.0);
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        tableColumn2.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER;");
                return tableCell;
            }
        });
        tableColumn3.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(Double d, boolean bl) {
                        super.updateItem((Object)d, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : VehicleDialogTablePane.this.ccmodel.getM_currencyFormatter().format(this.getItem());
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER-RIGHT;");
                return tableCell;
            }
        });
        if (this.ccmodel.getM_language() == CCModel.getGERMAN()) {
            tableColumn.setText("Modell");
            tableColumn2.setText("ID");
            tableColumn3.setText("Preis");
        } else {
            tableColumn.setText("Model");
            tableColumn2.setText("ID");
            tableColumn3.setText("Price");
        }
        this.vehiclesTablePanelTableView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3});
        this.vehiclesTablePanelTableView.getItems().clear();
        ObservableList observableList = FXCollections.observableArrayList();
        for (Integer n : this.ccmodel.getVehicleCellsDialog().keySet()) {
            observableList.add(this.ccmodel.getVehicleCellsDialog().get((Object)n));
        }
        Collections.sort(observableList, new Comparator(){

            public int compare(CCData cCData, CCData cCData2) {
                return cCData.getKeyForSort().compareTo(cCData2.getKeyForSort());
            }
        });
        this.vehiclesTablePanelTableView.setItems(observableList);
    }

    public TableView getVehiclesTablePanelTableView() {
        return this.vehiclesTablePanelTableView;
    }

    public class OnVehicleTableColumnClickEventHandler
    implements ChangeListener {
        public void changed(ObservableValue observableValue, CCData cCData, CCData cCData2) {
            if (VehicleDialogTablePane.this.ccmodel.getM_params().isBuggy() && VehicleDialogTablePane.this.vehiclesTablePanelTableView.getSelectionModel().getSelectedIndex() == VehicleDialogTablePane.this.vehiclesTablePanelTableView.getItems().size() - 1) {
                VehicleDialogTablePane.this.setVehicleName("");
                VehicleDialogTablePane.this.setVehicleId("");
                VehicleDialogTablePane.this.setVehiclePrice(0.0);
                return;
            }
            if (!VehicleDialogTablePane.this.vehiclesTablePanelTableView.getSelectionModel().isEmpty()) {
                CCModel.CCVehicle cCVehicle = (CCModel.CCVehicle)VehicleDialogTablePane.this.vehiclesTablePanelTableView.getSelectionModel().getSelectedItem();
                VehicleDialogTablePane.this.setVehicleName(cCVehicle.getName());
                VehicleDialogTablePane.this.setVehicleId(cCVehicle.getM_id());
                VehicleDialogTablePane.this.setVehiclePrice(cCVehicle.getPrice());
            }
        }
    }
}

