/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.ChangeButtonPane;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.DialogButtonActions;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.OptionStageFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.VehicleDialogTablePane;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;

public class VehiclesDialog
extends OptionStageFX {
    private EventHandler newAction;
    private EventHandler changeAction;
    private EventHandler deleteAction;
    private EventHandler cancelAction;
    private EventHandler okAction;
    private VehicleDialogTablePane vehiclesDialogPane;

    public VehiclesDialog(Window window, CCControllerFX cCControllerFX) {
        super(window, false, cCControllerFX);
        this.setTitle(CCModel.getRb().getString("dialog.vehicles.name"));
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(cCControllerFX.getCSSString());
        borderPane.setId(CCModel.getRb().getString("dialog.vehicles.id"));
        borderPane.setPadding(Insets.EMPTY);
        borderPane.setPrefHeight(400.0);
        borderPane.setPrefWidth(600.0);
        this.setupActions();
        this.vehiclesDialogPane = new VehicleDialogTablePane(cCControllerFX);
        borderPane.setCenter((Node)this.vehiclesDialogPane);
        DialogButtonActions dialogButtonActions = new DialogButtonActions(this.newAction, this.changeAction, this.deleteAction, this.cancelAction, this.okAction);
        borderPane.setRight((Node)new ChangeButtonPane(this, dialogButtonActions));
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        this.dialogWindow = this.getScene().getWindow();
        this.dialogWindow.setOnCloseRequest(windowEvent -> this.cancelActionPerformed());
    }

    private void setupActions() {
        this.newAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                VehiclesDialog.this.newActionPerformed();
            }
        };
        this.changeAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                VehiclesDialog.this.changeActionPerformed();
            }
        };
        this.deleteAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                VehiclesDialog.this.deleteActionPerformed();
            }
        };
        this.cancelAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                VehiclesDialog.this.cancelActionPerformed();
            }
        };
        this.okAction = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                VehiclesDialog.this.okActionPerformed();
            }
        };
    }

    @Override
    public void newActionPerformed() {
        Double d = this.vehiclesDialogPane.getVehiclePrice();
        if (d > 0.0) {
            String string = this.vehiclesDialogPane.getVehicleName();
            String string2 = this.vehiclesDialogPane.getVehicleId();
            this.cccontroller.vehiclesDialogNewAction(d, string2, string);
            this.vehiclesDialogPane.updateVehicleViewTable();
            this.vehiclesDialogPane.reset();
        } else {
            this.showInvalidPriceDialog();
        }
    }

    @Override
    public void changeActionPerformed() {
        if (!this.vehiclesDialogPane.getVehiclesTablePanelTableView().getSelectionModel().isEmpty()) {
            Double d = this.vehiclesDialogPane.getVehiclePrice();
            if (d > 0.0) {
                String string = this.vehiclesDialogPane.getVehicleName();
                int n = ((CCModel.CCVehicle)this.vehiclesDialogPane.getVehiclesTablePanelTableView().getSelectionModel().getSelectedItem()).getKey();
                String string2 = this.vehiclesDialogPane.getVehicleId();
                this.cccontroller.vehiclesDialogChangeAction(n, d, string2, string);
                this.vehiclesDialogPane.updateVehicleViewTable();
                this.vehiclesDialogPane.reset();
            } else {
                this.showInvalidPriceDialog();
            }
        }
    }

    @Override
    public void deleteActionPerformed() {
        if (!this.vehiclesDialogPane.getVehiclesTablePanelTableView().getSelectionModel().isEmpty()) {
            int n = ((CCModel.CCVehicle)this.vehiclesDialogPane.getVehiclesTablePanelTableView().getSelectionModel().getSelectedItem()).getKey();
            this.cccontroller.vehiclesDialogDeleteAction(n);
            this.vehiclesDialogPane.updateVehicleViewTable();
            this.vehiclesDialogPane.reset();
        }
    }

    @Override
    public void cancelActionPerformed() {
        this.cccontroller.vehiclesDialogCancelAction();
        this.dialogWindow.hide();
    }

    @Override
    public void okActionPerformed() {
        this.cccontroller.vehiclesDialogConfirmAction();
        this.dialogWindow.hide();
        this.cccontroller.getView().updateAllPanes();
    }

    @Override
    public void detailsActionPerformed() {
    }

    @Override
    public void overviewActionPerformed() {
    }

    public String getBusinessId() {
        return "VEHICLESDIALOG";
    }
}

