/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCData;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewFX.CCViewFX;
import java.util.Collections;
import java.util.Comparator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public class VehiclesPane
extends GridPane {
    CCModel ccmodel;
    CCViewFX ccview;
    CCControllerFX cccontroller;
    private TableView vehiclesView;

    public VehiclesPane(CCControllerFX cCControllerFX) {
        this.cccontroller = cCControllerFX;
        this.ccview = CCViewFX.getInstance(cCControllerFX);
        this.ccmodel = cCControllerFX.getCcmodel();
        this.setPadding(new Insets(7.0, 7.0, 7.0, 7.0));
        this.setHgap(5.0);
        this.setVgap(5.0);
        this.setId(CCModel.getRb().getString("panel.vehicles.table.id"));
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        columnConstraints.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        Label label = new Label(CCModel.getRb().getString("panel.vehicles.name"));
        label.setStyle("-fx-text-fill: blue;");
        this.add((Node)label, 0, 0);
        this.vehiclesView = new TableView();
        this.vehiclesView.setId("VehicleTable");
        this.vehiclesView.setEditable(false);
        this.vehiclesView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.vehiclesView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new VehiclesTableSelectedChangeListener());
        this.vehiclesView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.add((Node)this.vehiclesView, 0, 1);
    }

    public void updateVehiclesPane() {
        this.getChildren().remove((Object)this.vehiclesView);
        this.vehiclesView = new TableView();
        this.vehiclesView.setId("VehicleTable");
        this.vehiclesView.setEditable(false);
        this.vehiclesView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new VehiclesTableSelectedChangeListener());
        this.vehiclesView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.add((Node)this.vehiclesView, 0, 1);
        TableColumn tableColumn = new TableColumn();
        TableColumn tableColumn2 = new TableColumn();
        TableColumn tableColumn3 = new TableColumn();
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("m_id"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        tableColumn.setMinWidth(50.0);
        tableColumn2.setMinWidth(10.0);
        tableColumn3.setMinWidth(50.0);
        tableColumn2.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER;");
                return tableCell;
            }
        });
        tableColumn3.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(Double d, boolean bl) {
                        super.updateItem((Object)d, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : VehiclesPane.this.ccmodel.getM_currencyFormatter().format(this.getItem());
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER-RIGHT;");
                return tableCell;
            }
        });
        if (this.ccmodel.getM_language() == CCModel.getGERMAN()) {
            tableColumn.setText("Modell");
            tableColumn2.setText("ID");
            tableColumn3.setText("Preis");
        } else {
            tableColumn.setText("Model");
            tableColumn2.setText("ID");
            tableColumn3.setText("Price");
        }
        this.vehiclesView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3});
        this.vehiclesView.getItems().clear();
        ObservableList observableList = FXCollections.observableArrayList();
        for (Integer n : this.ccmodel.getVehicleCellsBase().keySet()) {
            observableList.add(this.ccmodel.getVehicleCellsBase().get((Object)n));
        }
        Collections.sort(observableList, new Comparator(){

            public int compare(CCData cCData, CCData cCData2) {
                return cCData.getKeyForSort().compareTo(cCData2.getKeyForSort());
            }
        });
        this.vehiclesView.setItems(observableList);
        this.cccontroller.getView().updateSelectedVehicle();
    }

    public TableView getVehiclesView() {
        return this.vehiclesView;
    }

    class VehiclesTableSelectedChangeListener
    implements ChangeListener {
        VehiclesTableSelectedChangeListener() {
        }

        public void changed(ObservableValue observableValue, CCData cCData, CCData cCData2) {
            VehiclesPane.this.cccontroller.getView().updateSelectedVehicle();
            int n = VehiclesPane.this.vehiclesView.getSelectionModel().getSelectedIndex();
            boolean bl = VehiclesPane.this.vehiclesView.getSelectionModel().isEmpty();
            boolean bl2 = n == VehiclesPane.this.ccmodel.getVehicleCellsBase().size() - 1;
            int n2 = 0;
            if (!bl) {
                n2 = ((CCModel.CCVehicle)VehiclesPane.this.vehiclesView.getSelectionModel().getSelectedItem()).getKey();
            }
            VehiclesPane.this.cccontroller.vehicleTableSelectionChanged(bl, n2, bl2);
        }
    }
}

