/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import de.qfs.apps.qftest.demo.multi.carconfigurator.chat.component.ChatFrame;
import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwing;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.AccessoryDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.AccessoryTablePanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.CalculatorPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.DerivedFontSet;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SendPurchaseOrderDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SortFilterModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SpecialsDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SpecialsPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.StatisticsDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.VehicleTablePanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.VehiclesDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.ViewPurchaseOrderDialog;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class CCView {
    CCControllerSwing controller;
    private static CCView instance;
    CCModel ccmodel = CCModel.getInstance();
    public JFrame frame;
    VehicleTablePanel vehicleTablePanel;
    AccessoryTablePanel accessoryTablePanel;
    SpecialsPanel specialsPanel;
    CalculatorPanel calculatorPanel;
    private SkyBluer m_theme = new SkyBluer();
    ChatFrame assistantWindow;
    MapResourceBundle rb;
    ImageIcon icon16;
    ImageIcon icon32;
    ImageIcon iconAbout;
    private JCheckBoxMenuItem buggyCheckboxMenuItem;
    private JCheckBoxMenuItem loadtestCheckboxMenuItem;
    private Action vehiclesAction;
    private Action accessoriesAction;
    private Action specialsAction;
    private Action viewStatisticsAction;
    private Action viewPurchaseOrderAction;
    private Action sendPurchaseOrderAction;
    private Action resetAction;
    private Action logoutAction;
    private Action infoAction;
    private Action buggyAction;
    private Action newVersionAction;
    private Action loadtestAction;
    private Action assistantAction;

    private CCView() {
    }

    public static CCView getInstance() {
        if (instance == null) {
            instance = new CCView();
        }
        return instance;
    }

    public void addController(CCControllerSwing cCControllerSwing) {
        this.controller = cCControllerSwing;
    }

    public void build() {
        block6: {
            this.rb = CCModel.getRb();
            FontPolicy fontPolicy = new FontPolicy(){

                public FontSet getFontSet(String string, UIDefaults uIDefaults) {
                    return new DerivedFontSet(FontPolicies.getDefaultPlasticPolicy().getFontSet(string, uIDefaults), CCView.this.ccmodel.getM_params().getMinimumFontsize());
                }
            };
            fontPolicy = FontPolicies.customSettingsPolicy((FontPolicy)fontPolicy);
            PlasticLookAndFeel.setFontPolicy((FontPolicy)fontPolicy);
            try {
                try {
                    Options.setSelectOnFocusGainEnabled((boolean)false);
                    System.getProperty("Plastic.tabStyle");
                    PlasticLookAndFeel.setPlasticTheme((PlasticTheme)this.m_theme);
                    if (Misc.OS_IS_WINDOWS) {
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                        break block6;
                    }
                    UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                }
                catch (Exception exception) {
                    String string = UIManager.getSystemLookAndFeelClassName();
                    if (string.endsWith("MotifLookAndFeel")) {
                        string = UIManager.getCrossPlatformLookAndFeelClassName();
                    }
                    UIManager.setLookAndFeel(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setupActions();
        this.frame = this.makeFrame();
        this.frame.setVisible(true);
    }

    private JFrame makeFrame() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
        this.frame = new JFrame(this.controller.getMainWindowTitle());
        this.frame.setName(this.rb.getString("frame.id"));
        this.icon16 = (ImageIcon)this.rb.getIcon("icon.CarConfig.frame", null);
        this.icon32 = (ImageIcon)this.rb.getIcon("icon.CarConfig.frame32", null);
        this.iconAbout = (ImageIcon)this.rb.getIcon("icon.newCarConfig.about", null);
        if (this.icon16 != null) {
            this.frame.setIconImage(this.icon16.getImage());
        }
        if (this.icon32 != null) {
            this.frame.setIconImage(this.icon32.getImage());
        }
        this.makeMenus(this.frame);
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        this.initContents();
        JTabbedPane jTabbedPane = this.createTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        jPanel.add((Component)this.calculatorPanel, "South");
        Container container = this.frame.getContentPane();
        container.add((Component)jPanel, "Center");
        this.frame.pack();
        this.frame.setSize(CCModel.getWIDTH(), CCModel.getHEIGHT());
        this.frame.setLocation(this.ccmodel.getM_params().getXpos(), this.ccmodel.getM_params().getYpos());
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CCView.this.controller.exit(0);
            }
        });
        return this.frame;
    }

    private void makeMenus(JFrame jFrame) {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setName(this.rb.getString("menu.id"));
        jFrame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu(this.rb.getString("menu.file.name"));
        jMenu.setMnemonic(this.rb.getString("menu.file.mnemonic").charAt(0));
        jMenu.setName(this.rb.getString("menu.file.id"));
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(this.rb.getString("menu.file.reset.name"));
        jMenuItem.setMnemonic(this.rb.getString("menu.file.reset.mnemonic").charAt(0));
        jMenuItem.setName(this.rb.getString("menu.file.reset.id"));
        jMenuItem.addActionListener(this.resetAction);
        jMenu.add(jMenuItem);
        if (this.ccmodel.getM_params().isLogin()) {
            jMenuItem = new JMenuItem(this.rb.getString("menu.file.logout.name"));
            jMenuItem.setMnemonic(this.rb.getString("menu.file.logout.mnemonic").charAt(0));
            jMenuItem.setName(this.rb.getString("menu.file.logout.id"));
            jMenuItem.addActionListener(this.logoutAction);
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem(this.rb.getString("menu.file.exit.name"));
        jMenuItem.setMnemonic('x');
        jMenuItem.setName(this.rb.getString("menu.file.exit.id"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCView.this.controller.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenu = new JMenu(this.rb.getString("menu.options.name"));
        jMenu.setMnemonic(this.rb.getString("menu.options.mnemonic").charAt(0));
        jMenu.setName(this.rb.getString("menu.options.id"));
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem(this.rb.getString("menu.options.vehicles.name"));
        jMenuItem.setMnemonic('f');
        jMenuItem.setName(this.rb.getString("menu.options.vehicles.id"));
        jMenuItem.addActionListener(this.vehiclesAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.rb.getString("menu.options.specials.name"));
        jMenuItem.setMnemonic(this.rb.getString("menu.options.specials.mnemonic").charAt(0));
        jMenuItem.setName(this.rb.getString("menu.options.specials.id"));
        jMenuItem.addActionListener(this.specialsAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.rb.getString("menu.options.accessories.name"));
        jMenuItem.setMnemonic(this.rb.getString("menu.options.accessories.mnemonic").charAt(0));
        jMenuItem.setName(this.rb.getString("menu.options.accessories.id"));
        jMenuItem.addActionListener(this.accessoriesAction);
        jMenu.add(jMenuItem);
        if (this.controller.isStandardUser()) {
            jMenu = new JMenu(this.rb.getString("menu.order.name"));
            jMenu.setMnemonic(this.rb.getString("menu.order.mnemonic").charAt(0));
            jMenu.setName(this.rb.getString("menu.order.id"));
            jMenuBar.add(jMenu);
            jMenuItem = new JMenuItem(this.rb.getString("menu.order.view.name"));
            jMenuItem.setMnemonic(this.rb.getString("menu.order.view.mnemonic").charAt(0));
            jMenuItem.setName(this.rb.getString("menu.order.view.id"));
            jMenuItem.addActionListener(this.viewPurchaseOrderAction);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(this.rb.getString("menu.order.send.name"));
            jMenuItem.setMnemonic(this.rb.getString("menu.order.send.mnemonic").charAt(0));
            jMenuItem.setName(this.rb.getString("menu.order.send.id"));
            jMenuItem.addActionListener(this.sendPurchaseOrderAction);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(this.rb.getString("menu.order.statistics.name"));
            jMenuItem.setMnemonic(this.rb.getString("menu.order.statistics.mnemonic").charAt(0));
            jMenuItem.setName(this.rb.getString("menu.order.stats.id"));
            jMenuItem.addActionListener(this.viewStatisticsAction);
            jMenu.add(jMenuItem);
        }
        jMenu = new JMenu(this.rb.getString("menu.help.name"));
        jMenu.setMnemonic(this.rb.getString("menu.help.mnemonic").charAt(0));
        jMenu.setName(this.rb.getString("menu.help.id"));
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Info");
        jMenuItem.setMnemonic('i');
        jMenuItem.setName(this.rb.getString("menu.help.info.id"));
        jMenuItem.addActionListener(this.infoAction);
        jMenu.add(jMenuItem);
        this.buggyCheckboxMenuItem = new JCheckBoxMenuItem(this.rb.getString("menu.help.buggy.name"), this.ccmodel.getM_params().isBuggy());
        this.buggyCheckboxMenuItem.setMnemonic(this.rb.getString("menu.help.buggy.mnemonic").charAt(0));
        this.buggyCheckboxMenuItem.setName(this.rb.getString("menu.help.buggy.id"));
        this.buggyCheckboxMenuItem.addActionListener(this.buggyAction);
        jMenu.add(this.buggyCheckboxMenuItem);
        this.loadtestCheckboxMenuItem = new JCheckBoxMenuItem(this.rb.getString("menu.help.loadtest.name"), this.ccmodel.getM_params().isLoadtest());
        this.loadtestCheckboxMenuItem.setMnemonic(this.rb.getString("menu.help.loadtest.mnemonic").charAt(0));
        this.loadtestCheckboxMenuItem.setName(this.rb.getString("menu.help.load.id"));
        this.loadtestCheckboxMenuItem.addActionListener(this.loadtestAction);
        jMenu.add(this.loadtestCheckboxMenuItem);
        jMenuItem = new JMenuItem(this.rb.getString("menu.help.carla.name"));
        jMenuItem.setMnemonic(this.rb.getString("menu.help.carla.mnemonic").charAt(0));
        jMenuItem.setName(this.rb.getString("menu.help.carla.id"));
        jMenuItem.addActionListener(this.assistantAction);
        jMenu.add(jMenuItem);
    }

    private void initContents() {
        this.vehicleTablePanel = new VehicleTablePanel(this.rb.getString("panel.vehicles.name"), (Map)this.ccmodel.getVehicleCellsBase(), this.ccmodel.getVehicleColumnNames(), this.ccmodel.getVehicleColumnMaxWidth(), this.controller);
        this.vehicleTablePanel.setName(this.rb.getString("panel.vehicles.table.id"));
        this.ccmodel.getVehicleCellsBase().addObserver((observable, object) -> {
            this.vehicleTablePanel.getModel().setDataVector((Map)this.ccmodel.getVehicleCellsBase(), (Object[])this.ccmodel.getVehicleColumnNames());
            this.vehicleTablePanel.setTableLayout(this.ccmodel.getVehicleColumnNames(), this.ccmodel.getVehicleColumnMaxWidth());
            ((SortFilterModel)this.vehicleTablePanel.getSorter()).tableChanged();
        });
        this.accessoryTablePanel = new AccessoryTablePanel(this.rb.getString("panel.accessories.name"), (Map)this.ccmodel.getAccessoryCellsBase(), this.ccmodel.getAccessoryColumnNames(), this.ccmodel.getAccessoryColumnMaxWidth(), this.controller);
        this.accessoryTablePanel.setName(this.rb.getString("panel.accessories.table.id"));
        this.ccmodel.getAccessoryCellsBase().addObserver((observable, object) -> {
            this.accessoryTablePanel.getModel().setDataVector((Map)this.ccmodel.getAccessoryCellsBase(), (Object[])this.ccmodel.getAccessoryColumnNames());
            this.accessoryTablePanel.setTableLayout(this.ccmodel.getAccessoryColumnNames(), this.ccmodel.getAccessoryColumnMaxWidth());
            ((SortFilterModel)this.accessoryTablePanel.getSorter()).tableChanged();
            this.controller.updateCalculatedPrice();
        });
        this.specialsPanel = new SpecialsPanel(this.rb.getString("panel.specials.name"), (Map)this.ccmodel.getSpecialsCellsBase(), this.controller);
        this.specialsPanel.setName(this.rb.getString("panel.specials.id"));
        this.calculatorPanel = new CalculatorPanel(new String(""), this.controller);
        this.calculatorPanel.setName(this.rb.getString("panel.calculator.id"));
    }

    private JTabbedPane createTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setName(this.rb.getString("panel.tab.id"));
        jTabbedPane.add(this.rb.getString("panel.vehicles.name"), this.vehicleTablePanel);
        jTabbedPane.add(this.rb.getString("panel.specials.name"), this.specialsPanel);
        jTabbedPane.add(this.rb.getString("panel.accessories.name"), this.accessoryTablePanel);
        return jTabbedPane;
    }

    private void setupActions() {
        this.vehiclesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VehiclesDialog vehiclesDialog = new VehiclesDialog(CCView.this.frame, CCView.this.controller);
            }
        };
        this.accessoriesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccessoryDialog accessoryDialog = new AccessoryDialog(CCView.this.frame, CCView.this.controller);
            }
        };
        this.specialsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpecialsDialog specialsDialog = new SpecialsDialog(CCView.this.frame, CCView.this.controller);
            }
        };
        this.viewStatisticsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsDialog statisticsDialog = new StatisticsDialog(CCView.this.frame, CCView.this.controller);
            }
        };
        this.viewPurchaseOrderAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewPurchaseOrderDialog viewPurchaseOrderDialog = new ViewPurchaseOrderDialog(CCView.this.frame, CCView.this.controller);
            }
        };
        this.sendPurchaseOrderAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendPurchaseOrderDialog sendPurchaseOrderDialog = new SendPurchaseOrderDialog(CCView.this.frame, CCView.this.controller);
            }
        };
        this.resetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCView.this.controller.resetAll();
            }
        };
        this.logoutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CCView.this.frame != null) {
                    CCView.this.frame.dispose();
                    CCView.this.frame = null;
                }
                CCView.this.controller.logout();
            }
        };
        this.infoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                long l = System.currentTimeMillis();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
                String string = simpleDateFormat.format(l);
                final JDialog jDialog = new JDialog(CCView.this.frame);
                jDialog.setLocation(CCView.this.ccmodel.getM_params().getXpos(), CCView.this.ccmodel.getM_params().getYpos());
                jDialog.setModal(true);
                jDialog.setTitle("Info");
                JButton jButton = new JButton();
                jButton.setText("OK");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jDialog.dispose();
                    }
                });
                jButton.setPreferredSize(new Dimension(80, 30));
                jButton.setSize(80, 30);
                JLabel jLabel = new JLabel();
                jLabel.setIcon(CCView.this.iconAbout);
                jLabel.setSize(32, 32);
                jLabel.setPreferredSize(new Dimension(32, 32));
                JLabel jLabel2 = new JLabel();
                jLabel2.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;CarConfigurator Swing Version 2.0<br/><br/> &nbsp;&nbsp;&nbsp;&nbsp;Copyright   (C)   2004 - " + string + "<br/>&nbsp;&nbsp;&nbsp;&nbsp;Quality First Software GmbH<br/>&nbsp;&nbsp;&nbsp;&nbsp;Based on C++ implementation by imbus AG<br/><br/>&nbsp;&nbsp;&nbsp;&nbsp;All rights reserved.<br/></html>");
                Grid grid = new Grid();
                grid.add((Component)jLabel);
                grid.add((Component)jLabel2);
                Grid grid2 = new Grid();
                grid2.add((Component)jButton);
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)grid, "Center");
                jDialog.getContentPane().add((Component)grid2, "South");
                jDialog.pack();
                jDialog.setVisible(true);
            }
        };
        this.buggyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCView.this.controller.buggyStateChanged(CCView.this.buggyCheckboxMenuItem.getState());
            }
        };
        this.loadtestAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCView.this.controller.loadtestStateChanged(CCView.this.loadtestCheckboxMenuItem.getState());
            }
        };
        this.assistantAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CCView.this.assistantWindow == null) {
                    CCView.this.assistantWindow = new ChatFrame(CCView.this.controller.getAssistant(), CCView.this.rb);
                }
                if (CCView.this.assistantWindow.isVisible()) {
                    CCView.this.assistantWindow.requestFocus();
                } else {
                    CCView.this.assistantWindow.reset();
                    CCView.this.assistantWindow.setVisible(true);
                }
            }
        };
    }

    private void switchFrame() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
        this.frame = this.makeFrame();
        this.frame.setVisible(true);
    }

    public VehicleTablePanel getVehicleTablePanel() {
        return this.vehicleTablePanel;
    }

    public AccessoryTablePanel getAccessoryTablePanel() {
        return this.accessoryTablePanel;
    }

    public SpecialsPanel getSpecialsPanel() {
        return this.specialsPanel;
    }

    public CalculatorPanel getCalculatorPanel() {
        return this.calculatorPanel;
    }

    public SkyBluer getM_theme() {
        return this.m_theme;
    }

    public ChatFrame getAssistantWindow() {
        return this.assistantWindow;
    }
}

