/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwing;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SortFilterModel
extends AbstractTableModel {
    CCControllerSwing cccontroller;
    private TableModel model;
    private int sortColumn;
    private Row[] rows;
    MouseAdapter sortListenerOnTableHead;

    public SortFilterModel(TableModel tableModel, CCControllerSwing cCControllerSwing) {
        this.cccontroller = cCControllerSwing;
        this.model = tableModel;
        this.updateData();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.model.getValueAt(this.rows[n].index, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.getColumnClass(n2) == Boolean.class;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.model.setValueAt(object, this.rows[n].index, n2);
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int n) {
        return this.model.getValueAt(0, n).getClass();
    }

    @Override
    public int getRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.model.getColumnName(n);
    }

    public void updateData() {
        this.rows = new Row[this.model.getRowCount()];
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i] = new Row();
            this.rows[i].index = i;
        }
    }

    public void tableChanged() {
        this.updateData();
        this.fireTableDataChanged();
    }

    public void sort(int n) {
        this.sortColumn = n;
        this.cccontroller.updateSortedBy(this.sortColumn);
        Arrays.sort(this.rows);
        this.fireTableDataChanged();
    }

    public void addMouseListener(final JTable jTable) {
        this.sortListenerOnTableHead = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    return;
                }
                if (jTable.getModel().getRowCount() > 1) {
                    int n = jTable.columnAtPoint(mouseEvent.getPoint());
                    int n2 = jTable.convertColumnIndexToModel(n);
                    SortFilterModel.this.sort(n2);
                }
            }
        };
        jTable.getTableHeader().addMouseListener(this.sortListenerOnTableHead);
    }

    public void removeMouseListener(JTable jTable) {
        jTable.getTableHeader().removeMouseListener(this.sortListenerOnTableHead);
    }

    private class Row
    implements Comparable {
        public int index;

        private Row() {
        }

        public int compareTo(Object object) {
            Row row = (Row)object;
            Object object2 = SortFilterModel.this.model.getValueAt(this.index, SortFilterModel.this.sortColumn);
            Object object3 = SortFilterModel.this.model.getValueAt(row.index, SortFilterModel.this.sortColumn);
            if (object2 instanceof Comparable) {
                return ((Comparable)object2).compareTo(object3);
            }
            return this.index - row.index;
        }
    }
}

