/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwing;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.AccessoryTablePanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.CCView;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.ChangeButtonPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.OptionDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SortFilterModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SpecialsDetailsDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SpecialsDialogAccessoryTablePanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SpecialsDialogEditPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SpecialsDialogTablePanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SpecialsOverviewDialog;
import de.qfs.lib.properties.QfsObservableMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class SpecialsDialog
extends OptionDialog {
    CCModel ccmodel = CCModel.getInstance();
    CCView ccview = CCView.getInstance();
    private SpecialsDialogTablePanel specialsDialogTablePanel;
    private SpecialsDialogEditPanel specialsDialogEditPanel;
    private JTextArea specialsDialogArea;
    private AccessoryTablePanel specialsDialogAccessoryTablePanel;
    private QfsObservableMap specialsCells;

    public SpecialsDialog(JFrame jFrame, CCControllerSwing cCControllerSwing) {
        super(jFrame, true, cCControllerSwing);
        this.setName(CCModel.getRb().getString("dialog.specials.id"));
        this.setTitle(CCModel.getRb().getString("dialog.specials.name"));
        this.setModal(true);
        this.setSize(420, 500);
        this.setLocation(this.ccmodel.getM_params().getXpos(), this.ccmodel.getM_params().getYpos());
        Container container = this.getContentPane();
        BorderLayout borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        borderLayout = new BorderLayout();
        borderLayout.setHgap(20);
        jPanel2.setLayout(borderLayout);
        this.specialsDialogEditPanel = new SpecialsDialogEditPanel();
        this.specialsDialogEditPanel.setName(CCModel.getRb().getString("dialog.specials.edit.id"));
        jPanel2.add((Component)this.specialsDialogEditPanel, "South");
        JPanel jPanel3 = new JPanel();
        borderLayout = new BorderLayout();
        borderLayout.setHgap(20);
        jPanel3.setLayout(borderLayout);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), CCModel.getRb().getString("dialog.specials.edit.desc")));
        this.specialsDialogArea = new JTextArea();
        this.specialsDialogArea.setName(CCModel.getRb().getString("dialog.specials.area.id"));
        this.specialsDialogArea.setRows(5);
        this.specialsDialogArea.setEditable(true);
        this.specialsDialogArea.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane jScrollPane = new JScrollPane(this.specialsDialogArea);
        if (!this.ccmodel.getM_params().isCleanname()) {
            jScrollPane.setName(CCModel.getRb().getString("dialog.specials.scrollpane.id"));
        }
        jPanel4.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel4, "North");
        this.specialsDialogAccessoryTablePanel = new SpecialsDialogAccessoryTablePanel(CCModel.getRb().getString("dialog.specials.contained"), (Map)this.ccmodel.getAccessoryCellsBase(), this.ccmodel.getAccessoryColumnNames(), this.ccmodel.getAccessoryColumnMaxWidth(), this.specialsDialogEditPanel, cCControllerSwing);
        this.specialsDialogAccessoryTablePanel.setName(CCModel.getRb().getString("dialog.specials.accessory.id"));
        this.specialsDialogAccessoryTablePanel.setPreferredSize(new Dimension(this.specialsDialogAccessoryTablePanel.getPreferredSize().width, this.specialsDialogAccessoryTablePanel.getPreferredSize().height * 2));
        jPanel3.add((Component)this.specialsDialogAccessoryTablePanel, "Center");
        this.specialsCells = this.ccmodel.getSpecialsCellsDialog();
        this.specialsDialogTablePanel = new SpecialsDialogTablePanel(CCModel.getRb().getString("dialog.specials.label"), (Map)this.specialsCells, this.ccmodel.getSpecialsColumnNames(), this.ccmodel.getSpecialsColumnMaxWidth(), this.specialsDialogEditPanel, this.specialsDialogArea, this.specialsDialogAccessoryTablePanel, this.cccontroller);
        this.specialsDialogTablePanel.setName(CCModel.getRb().getString("panel.specials.table.id"));
        this.ccmodel.getSpecialsCellsDialog().addObserver((observable, object) -> {
            Object[] objectArray = this.ccmodel.getSpecialsColumnNames();
            this.specialsDialogTablePanel.getModel().setDataVector((Map)this.ccmodel.getSpecialsCellsDialog(), objectArray);
            ((SortFilterModel)this.specialsDialogTablePanel.getSorter()).tableChanged();
            ((SortFilterModel)this.specialsDialogTablePanel.getSorter()).sort(0);
            this.specialsDialogTablePanel.setTableLayout((String[])objectArray, this.ccmodel.getSpecialsColumnMaxWidth());
        });
        ((SortFilterModel)this.specialsDialogTablePanel.getSorter()).removeMouseListener(this.specialsDialogTablePanel.getTable());
        jPanel2.add((Component)this.specialsDialogTablePanel, "Center");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        container.add((Component)jPanel, "Center");
        container.add((Component)new ChangeButtonPanel(this), "East");
        this.setVisible(true);
    }

    @Override
    public void newActionPerformed() {
        Double d = this.specialsDialogEditPanel.getSpecialsPrice();
        if (d <= 0.0) {
            this.showInvalidPriceDialog();
            return;
        }
        String string = this.specialsDialogEditPanel.getSpecialsName();
        String string2 = this.specialsDialogAccessoryTablePanel.getSelectedAccessories();
        String string3 = new String(this.specialsDialogArea.getText());
        this.cccontroller.specialsDialogNewAction(string, string3, d, string2);
        this.reset();
    }

    @Override
    public void changeActionPerformed() {
        int n = this.specialsDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
        if (n >= 0) {
            Double d = this.specialsDialogEditPanel.getSpecialsPrice();
            if (d > 0.0) {
                String string = this.specialsDialogEditPanel.getSpecialsName();
                String string2 = new String(this.specialsDialogArea.getText());
                String string3 = this.specialsDialogAccessoryTablePanel.getSelectedAccessories();
                int n2 = (Integer)this.specialsDialogTablePanel.table.getModel().getValueAt(n, CCModel.getSPECIALS_KEY_INDEX());
                this.cccontroller.specialsDialogChangedAction(string, string2, d, string3, n2);
                this.reset();
            } else {
                this.showInvalidPriceDialog();
            }
        }
    }

    @Override
    public void deleteActionPerformed() {
        int n = this.specialsDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
        if (n >= 0) {
            int n2 = (Integer)this.specialsDialogTablePanel.table.getModel().getValueAt(n, CCModel.getSPECIALS_KEY_INDEX());
            this.cccontroller.specialsDialogDeleteAction(n2);
        }
        this.reset();
    }

    @Override
    public void cancelActionPerformed() {
        this.cccontroller.specialsDialogCancelAction();
        this.dispose();
    }

    @Override
    public void confirmActionPerformed() {
        this.cccontroller.specialsDialogConfirmAction();
        this.ccview.specialsPanel.reset();
        this.dispose();
    }

    @Override
    public void detailsActionPerformed() {
        this.cccontroller.sleepForLoadtesting();
        SpecialsDetailsDialog specialsDetailsDialog = new SpecialsDetailsDialog(this, (CCModel.CCSpecial)this.ccview.specialsPanel.getSpecialsCombo().getSelectedItem(), this.specialsDialogArea.getText(), this.specialsDialogAccessoryTablePanel.getModel(), this.cccontroller);
    }

    @Override
    public void overviewActionPerformed() {
        this.cccontroller.sleepForLoadtesting();
        SpecialsOverviewDialog specialsOverviewDialog = new SpecialsOverviewDialog((Dialog)this, this.specialsDialogTablePanel.getSelectedSpecial(), this.specialsDialogAccessoryTablePanel.getModel(), this.cccontroller);
    }

    public String getBusinessId() {
        return "SPECIALSDIALOG";
    }

    private void showInvalidPriceDialog() {
        JOptionPane.showMessageDialog(this.ccview.frame, CCModel.getRb().getString("error.price.invalid"), "CarConfigurator - Error", 0);
    }

    private void reset() {
        this.specialsDialogEditPanel.reset();
        this.specialsDialogArea.setText("");
        this.specialsDialogAccessoryTablePanel.reset();
    }
}

