/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwing;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.CCView;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.ChangeButtonPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.OptionDialog;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SortFilterModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.VehicleDialogEditPanel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.VehicleDialogTablePanel;
import de.qfs.lib.properties.QfsObservableMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class VehiclesDialog
extends OptionDialog {
    CCModel ccmodel = CCModel.getInstance();
    CCView ccview = CCView.getInstance();
    protected VehicleDialogTablePanel vehicleDialogTablePanel;
    protected VehicleDialogEditPanel vehicleDialogEditPanel;

    public VehiclesDialog(JFrame jFrame, CCControllerSwing cCControllerSwing) {
        super(jFrame, false, cCControllerSwing);
        this.setContent();
        this.setVisible(true);
    }

    public void setContent() {
        this.setName(CCModel.getRb().getString("dialog.vehicles.id"));
        this.setTitle(CCModel.getRb().getString("dialog.vehicles.name"));
        this.setModal(true);
        this.setSize(420, 300);
        this.setLocation(this.ccmodel.getM_params().getXpos(), this.ccmodel.getM_params().getYpos());
        Container container = this.getContentPane();
        BorderLayout borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        JPanel jPanel = new JPanel();
        borderLayout = new BorderLayout();
        borderLayout.setHgap(20);
        jPanel.setLayout(borderLayout);
        this.vehicleDialogEditPanel = new VehicleDialogEditPanel();
        this.vehicleDialogEditPanel.setName(CCModel.getRb().getString("dialog.vehicles.editpanel.id"));
        jPanel.add((Component)this.vehicleDialogEditPanel, "South");
        QfsObservableMap qfsObservableMap = this.ccmodel.getVehicleCellsDialog();
        this.vehicleDialogTablePanel = new VehicleDialogTablePanel(CCModel.getRb().getString("dialog.vehicles.label"), (Map)qfsObservableMap, this.ccmodel.getVehicleColumnNames(), this.ccmodel.getVehicleColumnMaxWidth(), this.vehicleDialogEditPanel, this.cccontroller);
        qfsObservableMap.addObserver((observable, object) -> {
            this.vehicleDialogTablePanel.getModel().setDataVector((Map)this.ccmodel.getVehicleCellsDialog(), (Object[])this.ccmodel.getVehicleColumnNames());
            ((SortFilterModel)this.vehicleDialogTablePanel.getSorter()).tableChanged();
            this.vehicleDialogTablePanel.setTableLayout(this.ccmodel.getVehicleColumnNames(), this.ccmodel.getVehicleColumnMaxWidth());
        });
        if (!this.ccmodel.getM_params().isCleanname()) {
            this.vehicleDialogTablePanel.setName(CCModel.getRb().getString("panel.vehicles.table.id"));
        }
        jPanel.add((Component)this.vehicleDialogTablePanel, "Center");
        container.add((Component)jPanel, "Center");
        container.add((Component)new ChangeButtonPanel(this), "East");
    }

    @Override
    public void newActionPerformed() {
        Double d = this.vehicleDialogEditPanel.getVehiclePrice();
        if (d <= 0.0) {
            this.showInvalidPriceDialog();
            return;
        }
        String string = this.vehicleDialogEditPanel.getVehicleId();
        String string2 = this.vehicleDialogEditPanel.getVehicleName();
        this.cccontroller.vehiclesDialogNewAction(d, string, string2);
        this.vehicleDialogEditPanel.reset();
    }

    @Override
    public void changeActionPerformed() {
        int n = this.vehicleDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
        if (n >= 0) {
            Double d = this.vehicleDialogEditPanel.getVehiclePrice();
            if (d > 0.0) {
                String string = this.vehicleDialogEditPanel.getVehicleId();
                String string2 = this.vehicleDialogEditPanel.getVehicleName();
                int n2 = (Integer)this.vehicleDialogTablePanel.table.getModel().getValueAt(n, CCModel.getVEHICLE_KEY_INDEX());
                this.cccontroller.vehiclesDialogChangeAction(n2, d, string, string2);
                this.vehicleDialogEditPanel.reset();
            } else {
                this.showInvalidPriceDialog();
            }
        }
    }

    @Override
    public void deleteActionPerformed() {
        int n = this.vehicleDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
        if (n >= 0) {
            int n2 = (Integer)this.vehicleDialogTablePanel.table.getModel().getValueAt(n, CCModel.getVEHICLE_KEY_INDEX());
            this.cccontroller.vehiclesDialogDeleteAction(n2);
        }
    }

    @Override
    public void cancelActionPerformed() {
        this.cccontroller.vehiclesDialogCancelAction();
        this.dispose();
    }

    @Override
    public void confirmActionPerformed() {
        this.cccontroller.vehiclesDialogConfirmAction();
        this.dispose();
    }

    @Override
    public void detailsActionPerformed() {
    }

    @Override
    public void overviewActionPerformed() {
    }

    public String getBusinessId() {
        return "VEHICLESDIALOG";
    }

    protected void showInvalidPriceDialog() {
        JOptionPane.showMessageDialog(this.ccview.frame, CCModel.getRb().getString("error.price.invalid"), "CarConfigurator - Error", 0);
    }

    public VehicleDialogTablePanel getVehicleDialogTablePanel() {
        return this.vehicleDialogTablePanel;
    }

    public VehicleDialogEditPanel getVehicleDialogEditPanel() {
        return this.vehicleDialogEditPanel;
    }
}

