/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwing;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.CCView;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.VehicleTablePanel;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class ViewPurchaseOrderDialog
extends JDialog {
    CCModel ccmodel = CCModel.getInstance();
    MapResourceBundle rb = CCModel.getRb();
    CCView ccview = CCView.getInstance();
    CCControllerSwing cccontroller;
    private AbstractAction okAction;

    public ViewPurchaseOrderDialog(JFrame jFrame, CCControllerSwing cCControllerSwing) {
        super(jFrame);
        this.cccontroller = cCControllerSwing;
        this.setName(CCModel.getRb().getString("dialog.viewpurchaseorder.id"));
        this.setTitle(this.rb.getString("dialog.viewpurchaseorder.name"));
        this.setModal(true);
        this.setSize(640, 400);
        this.setLocation(this.ccmodel.getM_params().getXpos(), this.ccmodel.getM_params().getYpos());
        Container container = this.getContentPane();
        BorderLayout borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = this.initializeAccessoryPanel();
        JPanel jPanel3 = this.initializeSpecialsPanel();
        JPanel jPanel4 = this.initializeVehiclesPanel();
        JPanel jPanel5 = this.initializePricePanel();
        JPanel jPanel6 = this.initializeButtonPanel();
        Box box = Box.createVerticalBox();
        box.add(jPanel4);
        box.add(jPanel3);
        box.add(jPanel2);
        box.add(jPanel5);
        jPanel.add(box);
        if (this.ccmodel.getM_params().isCleanname()) {
            jPanel.setName(CCModel.getRb().getString("dialog.viewpurchaseorder.panel.id"));
        }
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel6, "South");
        this.pack();
        cCControllerSwing.sleepForLoadtesting();
        this.setVisible(true);
    }

    public void okActionPerformed() {
        this.cccontroller.sleepForLoadtesting();
        this.dispose();
    }

    private JPanel initializeButtonPanel() {
        this.setupActions();
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton();
        jButton.setText(CCModel.getRb().getString("button.ok"));
        jButton.setName(CCModel.getRb().getString("dialog.viewpurchaseorder.okbutton.id"));
        jButton.addActionListener(this.okAction);
        jButton.setSize(80, 30);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel initializeSpecialsPanel() {
        Random random = new Random();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(this.rb.getString("dialog.purchaseorder.special.label"));
        jLabel.setName(CCModel.getRb().getString("dialog.viewpurchaseorder.speciallabel.id") + random.nextInt());
        JTextField jTextField = new JTextField(15);
        jTextField.setName(CCModel.getRb().getString("dialog.viewpurchaseorder.specialfield.id") + random.nextInt());
        jTextField.setText(((CCModel.CCSpecial)this.ccview.getSpecialsPanel().getSpecialsCombo().getSelectedItem()).getName());
        jTextField.setEditable(false);
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.rb.getString("dialog.purchaseorder.special.title"));
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    private JPanel initializePricePanel() {
        Random random = new Random();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(this.rb.getString("dialog.purchaseorder.price.label"));
        jLabel.setName(CCModel.getRb().getString("dialog.viewpurchaseorder.pricelabel.id") + random.nextInt());
        JTextField jTextField = new JTextField(15);
        jTextField.setText(this.ccview.getCalculatorPanel().calculatedPrice.getText());
        jTextField.setEditable(false);
        jTextField.setName(CCModel.getRb().getString("dialog.viewpurchaseorder.pricefield.id") + random.nextInt());
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.rb.getString("dialog.purchaseorder.price.title"));
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    private JPanel initializeVehiclesPanel() {
        Object object;
        Random random = new Random();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JTextField jTextField = new JTextField(15);
        VehicleTablePanel vehicleTablePanel = this.ccview.getVehicleTablePanel();
        int n = vehicleTablePanel.table.getSelectedRow();
        String string = "";
        if (n != -1) {
            object = vehicleTablePanel.table.getValueAt(n, CCModel.getVEHICLE_NAME_INDEX());
            if (object != null) {
                string = (String)object;
            }
        } else {
            string = this.rb.getString("error.purchaseorder.novehicle");
        }
        jLabel.setText(this.rb.getString("dialog.purchaseorder.vehicle.label"));
        jLabel.setName(CCModel.getRb().getString("dialog.viewpurchaseorder.modellabel.id") + random.nextInt());
        jTextField.setEditable(false);
        jTextField.setText(string);
        jTextField.setName(CCModel.getRb().getString("dialog.viewpurchaseorder.modelfield.id") + random.nextInt());
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        object = BorderFactory.createTitledBorder(this.rb.getString("dialog.purchaseorder.vehicle.title"));
        jPanel.setBorder((Border)object);
        return jPanel;
    }

    private JPanel initializeAccessoryPanel() {
        JPanel jPanel = new JPanel();
        Box box = Box.createVerticalBox();
        int n = 0;
        for (int i = 0; i < this.ccview.getAccessoryTablePanel().model.getRowCount(); ++i) {
            Boolean bl = (Boolean)this.ccview.getAccessoryTablePanel().model.getValueAt(i, CCModel.getACCESSORY_SELECT_INDEX());
            if (!bl.booleanValue()) continue;
            ++n;
            String string = (String)this.ccview.getAccessoryTablePanel().model.getValueAt(i, CCModel.getACCESSORY_NAME_INDEX());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(1, 2));
            JTextField jTextField = new JTextField();
            JLabel jLabel = new JLabel();
            jLabel.setText(this.rb.getString("dialog.purchaseorder.accessory.label") + " " + n);
            jLabel.setName("label_" + string);
            jTextField.setName("name_" + string);
            jTextField.setEditable(false);
            jTextField.setText(string);
            jPanel2.add(jLabel);
            jPanel2.add(jTextField);
            box.add(jPanel2);
        }
        if (n == 0) {
            box.add(new JLabel(this.rb.getString("error.purchaseorder.noaccessory")));
        }
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.rb.getString("dialog.purchaseorder.accessory.title"));
        jPanel.setBorder(titledBorder);
        jPanel.add(box);
        return jPanel;
    }

    private void setupActions() {
        this.okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewPurchaseOrderDialog.this.okActionPerformed();
            }
        };
    }
}

