/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi.treetable;

import de.qfs.apps.qftest.demo.multi.treetable.TreeTableModel;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.multi.treetable.AbstractTreeTableModel");
    private static final int CHANGED = 0;
    private static final int INSERTED = 1;
    private static final int REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractTreeTableModel(Object object) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "AbstractTreeTableModel(Object)", 42).addDetail("root", object)).log();
        }
        this.root = object;
    }

    @Override
    public Object getRoot() {
        if (AbstractTreeTableModel.logger.level >= 7) {
            logger.lvlBuild(7, "getRoot()", 51).log();
        }
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isLeaf(Object)", 60).addDetail("node", object)).log();
        }
        return this.getChildCount(object) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "valueForPathChanged(TreePath,Object)", 69).addDetail("path", (Object)treePath)).addDetail("newValue", object)).log();
        }
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getIndexOfChild(Object,Object)", 80).addDetail("parent", object)).addDetail("child", object2)).log();
        }
        return 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addTreeModelListener(TreeModelListener)", 89).addDetail("l", (Object)treeModelListener)).log();
        }
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeTreeModelListener(TreeModelListener)", 98).addDetail("l", (Object)treeModelListener)).log();
        }
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    private void fireTreeNode(int n, Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireTreeNode(int,Object,Object[],int[],Object[])", 106).addDetail("changeType", n)).addDetail("source", object)).addDetail("path", (Object)objectArray)).addDetail("childIndices", (Object)nArray)).addDetail("children", (Object)objectArray2)).log();
        }
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        block6: for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            switch (n) {
                case 0: {
                    ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
                    continue block6;
                }
                case 1: {
                    ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
                    continue block6;
                }
                case 2: {
                    ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
                    continue block6;
                }
                case 3: {
                    ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
                    continue block6;
                }
            }
        }
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireTreeNodesChanged(Object,Object[],int[],Object[])", 138).addDetail("source", object)).addDetail("path", (Object)objectArray)).addDetail("childIndices", (Object)nArray)).addDetail("children", (Object)objectArray2)).log();
        }
        this.fireTreeNode(0, object, objectArray, nArray, objectArray2);
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireTreeNodesInserted(Object,Object[],int[],Object[])", 147).addDetail("source", object)).addDetail("path", (Object)objectArray)).addDetail("childIndices", (Object)nArray)).addDetail("children", (Object)objectArray2)).log();
        }
        this.fireTreeNode(1, object, objectArray, nArray, objectArray2);
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireTreeNodesRemoved(Object,Object[],int[],Object[])", 156).addDetail("source", object)).addDetail("path", (Object)objectArray)).addDetail("childIndices", (Object)nArray)).addDetail("children", (Object)objectArray2)).log();
        }
        this.fireTreeNode(2, object, objectArray, nArray, objectArray2);
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (AbstractTreeTableModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireTreeStructureChanged(Object,Object[],int[],Object[])", 165).addDetail("source", object)).addDetail("path", (Object)objectArray)).addDetail("childIndices", (Object)nArray)).addDetail("children", (Object)objectArray2)).log();
        }
        this.fireTreeNode(3, object, objectArray, nArray, objectArray2);
    }
}

