/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.swt.addressbook;

import de.qfs.apps.qftest.demo.swt.addressbook.WidgetRegistry;
import java.util.ResourceBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataEntryDialog {
    private static ResourceBundle resAddressBook = ResourceBundle.getBundle("de/qfs/apps/qftest/demo/swt/addressbook/resources/properties/addressbook");
    public static Button button;
    public static Text textfield;
    Shell shell;
    String[] values;
    String[] labels;

    public DataEntryDialog(Shell shell) {
        this.shell = new Shell(shell, 34912);
        WidgetRegistry.add("DataEntry", this.shell);
        this.shell.setLayout((Layout)new GridLayout());
    }

    private void addTextListener(final Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                Integer n = (Integer)text.getData("index");
                DataEntryDialog.this.values[n.intValue()] = text.getText();
            }
        });
    }

    private void createControlButtons() {
        Composite composite = new Composite((Composite)this.shell, 0);
        WidgetRegistry.add("DataEntry.MainGrid", composite);
        composite.setLayoutData((Object)new GridData(64));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 8);
        WidgetRegistry.add("DataEntry.OK", button);
        button.setText(resAddressBook.getString("OK"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataEntryDialog.this.shell.close();
            }
        });
        button.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                System.err.println("e: " + event + ", code: " + event.keyCode);
            }
        });
        Button button2 = new Button(composite, 8);
        WidgetRegistry.add("DataEntry.Cancel", button2);
        button2.setText(resAddressBook.getString("Cancel"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataEntryDialog.this.values = null;
                DataEntryDialog.this.shell.close();
            }
        });
        DataEntryDialog.button = button2;
        this.shell.setDefaultButton(button);
    }

    private void createTextWidgets() {
        if (this.labels == null) {
            return;
        }
        Composite composite = new Composite((Composite)this.shell, 0);
        WidgetRegistry.add("DataEntry.DataGrid", composite);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        if (this.values == null) {
            this.values = new String[this.labels.length];
        }
        for (int i = 0; i < this.labels.length; ++i) {
            Label label = new Label(composite, 131072);
            WidgetRegistry.add("DataEntry.Label-" + this.labels[i], label);
            label.setText(this.labels[i]);
            Text text = new Text(composite, 2048);
            WidgetRegistry.add("DataEntry.Text-" + this.labels[i], text);
            if (i == 0) {
                textfield = text;
            }
            GridData gridData = new GridData();
            gridData.widthHint = 400;
            text.setLayoutData((Object)gridData);
            if (this.values[i] != null) {
                text.setText(this.values[i]);
            }
            text.setData("index", (Object)i);
            this.addTextListener(text);
        }
    }

    public String[] getLabels() {
        return this.labels;
    }

    public String getTitle() {
        return this.shell.getText();
    }

    public String[] getValues() {
        return this.values;
    }

    public String[] open() {
        this.createTextWidgets();
        this.createControlButtons();
        this.shell.pack();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.getValues();
    }

    public void setLabels(String[] stringArray) {
        this.labels = stringArray;
    }

    public void setTitle(String string) {
        this.shell.setText(string);
    }

    public void setValues(String[] stringArray) {
        if (this.labels == null) {
            return;
        }
        if (this.values == null) {
            this.values = new String[this.labels.length];
        }
        int n = Math.min(this.values.length, stringArray.length);
        for (int i = 0; i < n; ++i) {
            this.values[i] = stringArray[i];
        }
    }
}

