/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.clipboard;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ClipboardExample {
    Clipboard clipboard;
    Shell shell;
    Text copyText;
    Text pasteText;
    Text copyRtfText;
    Text pasteRtfText;
    Text copyHtmlText;
    Text pasteHtmlText;
    Table copyFileTable;
    Table pasteFileTable;
    Text text;
    Combo combo;
    StyledText styledText;
    Label status;
    static final int SIZE = 60;

    public static void main(String[] stringArray) {
        Display display = new Display();
        new ClipboardExample().open(display);
        display.dispose();
    }

    public void open(Display display) {
        this.clipboard = new Clipboard(display);
        this.shell = new Shell(display);
        this.shell.setText("SWT Clipboard");
        this.shell.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.shell, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, true));
        Group group = new Group(composite, 0);
        group.setText("Copy From:");
        GridData gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(3, false));
        Group group2 = new Group(composite, 0);
        group2.setText("Paste To:");
        gridData = new GridData(1808);
        group2.setLayoutData((Object)gridData);
        group2.setLayout((Layout)new GridLayout(3, false));
        Group group3 = new Group(composite, 0);
        group3.setText("Control API:");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        group3.setLayoutData((Object)gridData);
        group3.setLayout((Layout)new GridLayout(5, false));
        Group group4 = new Group(composite, 0);
        group4.setText("Available Types");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        group4.setLayoutData((Object)gridData);
        group4.setLayout((Layout)new GridLayout(2, false));
        this.status = new Label(composite, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 60;
        this.status.setLayoutData((Object)gridData);
        this.createTextTransfer((Composite)group, (Composite)group2);
        this.createRTFTransfer((Composite)group, (Composite)group2);
        this.createHTMLTransfer((Composite)group, (Composite)group2);
        this.createFileTransfer((Composite)group, (Composite)group2);
        this.createMyTransfer((Composite)group, (Composite)group2);
        this.createControlTransfer((Composite)group3);
        this.createAvailableTypes((Composite)group4);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Point point = this.shell.computeSize(-1, -1);
        Rectangle rectangle = this.shell.getMonitor().getClientArea();
        this.shell.setSize(Math.min(point.x, rectangle.width - 20), Math.min(point.y, rectangle.height - 20));
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.clipboard.dispose();
    }

    void createTextTransfer(Composite composite, Composite composite2) {
        Label label = new Label(composite, 0);
        label.setText("TextTransfer:");
        this.copyText = new Text(composite, 2818);
        this.copyText.setText("some\nplain\ntext");
        GridData gridData = new GridData(768);
        gridData.widthHint = 60;
        gridData.heightHint = 60;
        this.copyText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText("Copy");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = ClipboardExample.this.copyText.getText();
                if (string.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("nothing to copy");
                }
            }
        });
        label = new Label(composite2, 0);
        label.setText("TextTransfer:");
        this.pasteText = new Text(composite2, 2826);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        gridData.heightHint = 60;
        this.pasteText.setLayoutData((Object)gridData);
        button = new Button(composite2, 8);
        button.setText("Paste");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = (String)ClipboardExample.this.clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (string != null && string.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.pasteText.setText("begin paste>" + string + "<end paste");
                } else {
                    ClipboardExample.this.status.setText("nothing to paste");
                }
            }
        });
    }

    void createRTFTransfer(Composite composite, Composite composite2) {
        Label label = new Label(composite, 0);
        label.setText("RTFTransfer:");
        this.copyRtfText = new Text(composite, 2818);
        this.copyRtfText.setText("some\nrtf\ntext");
        GridData gridData = new GridData(768);
        gridData.widthHint = 60;
        gridData.heightHint = 60;
        this.copyRtfText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText("Copy");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = ClipboardExample.this.copyRtfText.getText();
                if (string.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    string = "{\\rtf1{\\colortbl;\\red255\\green0\\blue0;}\\uc1\\b\\i " + string + "}";
                    ClipboardExample.this.clipboard.setContents(new Object[]{string}, new Transfer[]{RTFTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("nothing to copy");
                }
            }
        });
        label = new Label(composite2, 0);
        label.setText("RTFTransfer:");
        this.pasteRtfText = new Text(composite2, 2826);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        gridData.heightHint = 60;
        this.pasteRtfText.setLayoutData((Object)gridData);
        button = new Button(composite2, 8);
        button.setText("Paste");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = (String)ClipboardExample.this.clipboard.getContents((Transfer)RTFTransfer.getInstance());
                if (string != null && string.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.pasteRtfText.setText("start paste>" + string + "<end paste");
                } else {
                    ClipboardExample.this.status.setText("nothing to paste");
                }
            }
        });
    }

    void createHTMLTransfer(Composite composite, Composite composite2) {
        Label label = new Label(composite, 0);
        label.setText("HTMLTransfer:");
        this.copyHtmlText = new Text(composite, 2818);
        this.copyHtmlText.setText("<b>Hello World</b>");
        GridData gridData = new GridData(768);
        gridData.widthHint = 60;
        gridData.heightHint = 60;
        this.copyHtmlText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText("Copy");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = ClipboardExample.this.copyHtmlText.getText();
                if (string.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.clipboard.setContents(new Object[]{string}, new Transfer[]{HTMLTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("nothing to copy");
                }
            }
        });
        label = new Label(composite2, 0);
        label.setText("HTMLTransfer:");
        this.pasteHtmlText = new Text(composite2, 2826);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        gridData.heightHint = 60;
        this.pasteHtmlText.setLayoutData((Object)gridData);
        button = new Button(composite2, 8);
        button.setText("Paste");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = (String)ClipboardExample.this.clipboard.getContents((Transfer)HTMLTransfer.getInstance());
                if (string != null && string.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.pasteHtmlText.setText("start paste>" + string + "<end paste");
                } else {
                    ClipboardExample.this.status.setText("nothing to paste");
                }
            }
        });
    }

    void createFileTransfer(Composite composite, Composite composite2) {
        Label label = new Label(composite, 0);
        label.setText("FileTransfer:");
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        this.copyFileTable = new Table(composite3, 2050);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        gridData.heightHint = 60;
        gridData.horizontalSpan = 2;
        this.copyFileTable.setLayoutData((Object)gridData);
        Button button = new Button(composite3, 8);
        button.setText("Select file(s)");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(ClipboardExample.this.shell, 4098);
                String string = fileDialog.open();
                if (string != null && string.length() > 0) {
                    String string2 = System.getProperty("file.separator");
                    String string3 = fileDialog.getFilterPath();
                    String[] stringArray = fileDialog.getFileNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        TableItem tableItem = new TableItem(ClipboardExample.this.copyFileTable, 0);
                        tableItem.setText(string3 + string2 + stringArray[i]);
                    }
                }
            }
        });
        button = new Button(composite3, 8);
        button.setText("Select directory");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(ClipboardExample.this.shell, 4096);
                String string = directoryDialog.open();
                if (string != null && string.length() > 0) {
                    TableItem tableItem = new TableItem(ClipboardExample.this.copyFileTable, 0);
                    tableItem.setText(string);
                }
            }
        });
        button = new Button(composite, 8);
        button.setText("Copy");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = ClipboardExample.this.copyFileTable.getItems();
                if (tableItemArray.length > 0) {
                    ClipboardExample.this.status.setText("");
                    String[] stringArray = new String[tableItemArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = tableItemArray[i].getText();
                    }
                    ClipboardExample.this.clipboard.setContents(new Object[]{stringArray}, new Transfer[]{FileTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("nothing to copy");
                }
            }
        });
        label = new Label(composite2, 0);
        label.setText("FileTransfer:");
        this.pasteFileTable = new Table(composite2, 2050);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        gridData.heightHint = 60;
        this.pasteFileTable.setLayoutData((Object)gridData);
        button = new Button(composite2, 8);
        button.setText("Paste");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray = (String[])ClipboardExample.this.clipboard.getContents((Transfer)FileTransfer.getInstance());
                if (stringArray != null && stringArray.length > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.pasteFileTable.removeAll();
                    for (int i = 0; i < stringArray.length; ++i) {
                        TableItem tableItem = new TableItem(ClipboardExample.this.pasteFileTable, 0);
                        tableItem.setText(stringArray[i]);
                    }
                } else {
                    ClipboardExample.this.status.setText("nothing to paste");
                }
            }
        });
    }

    void createMyTransfer(Composite composite, Composite composite2) {
    }

    void createControlTransfer(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Text:");
        Button button = new Button(composite, 8);
        button.setText("Cut");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ClipboardExample.this.text.cut();
            }
        });
        button = new Button(composite, 8);
        button.setText("Copy");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ClipboardExample.this.text.copy();
            }
        });
        button = new Button(composite, 8);
        button.setText("Paste");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ClipboardExample.this.text.paste();
            }
        });
        this.text = new Text(composite, 2818);
        GridData gridData = new GridData(768);
        gridData.widthHint = 60;
        gridData.heightHint = 60;
        this.text.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Combo:");
        button = new Button(composite, 8);
        button.setText("Cut");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ClipboardExample.this.combo.cut();
            }
        });
        button = new Button(composite, 8);
        button.setText("Copy");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ClipboardExample.this.combo.copy();
            }
        });
        button = new Button(composite, 8);
        button.setText("Paste");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ClipboardExample.this.combo.paste();
            }
        });
        this.combo = new Combo(composite, 0);
        this.combo.setItems(new String[]{"Item 1", "Item 2", "Item 3", "A longer Item"});
        label = new Label(composite, 0);
        label.setText("StyledText:");
        label = new Label(composite, 0);
        label.setVisible(false);
        button = new Button(composite, 8);
        button.setText("Copy");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ClipboardExample.this.styledText.copy();
            }
        });
        button = new Button(composite, 8);
        button.setText("Paste");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ClipboardExample.this.styledText.paste();
            }
        });
        this.styledText = new StyledText(composite, 2818);
        gridData = new GridData(768);
        gridData.widthHint = 60;
        gridData.heightHint = 60;
        this.styledText.setLayoutData((Object)gridData);
    }

    void createAvailableTypes(Composite composite) {
        final List list = new List(composite, 2816);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 100;
        list.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText("Get Available Types");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                list.removeAll();
                String[] stringArray = ClipboardExample.this.clipboard.getAvailableTypeNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    list.add(stringArray[i]);
                }
            }
        });
    }
}

