/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TabFolder;

class CanvasTab
extends Tab {
    static int[] colors = new int[]{3, 5, 9, 11, 7, 13, 4, 6, 10, 12, 8, 14};
    Canvas canvas;
    Group canvasGroup;
    Button horizontalButton;
    Button verticalButton;
    Button noBackgroundButton;
    Button noFocusButton;
    Button noMergePaintsButton;
    Button noRedrawResizeButton;
    Button caretButton;
    Button fillDamageButton;
    int paintCount;
    int cx;
    int cy;
    int maxX;
    int maxY;

    CanvasTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.caretButton = new Button((Composite)this.otherGroup, 32);
        this.caretButton.setText(ControlExample.getResourceString("Caret"));
        this.fillDamageButton = new Button((Composite)this.otherGroup, 32);
        this.fillDamageButton.setText(ControlExample.getResourceString("FillDamage"));
        this.caretButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CanvasTab.this.setCaret();
            }
        });
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.canvasGroup = new Group((Composite)this.exampleGroup, 0);
        this.canvasGroup.setLayout((Layout)new GridLayout());
        this.canvasGroup.setLayoutData((Object)new GridData(784));
        this.canvasGroup.setText("Canvas");
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.horizontalButton.getSelection()) {
            n |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            n |= 0x200;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.noBackgroundButton.getSelection()) {
            n |= 0x40000;
        }
        if (this.noFocusButton.getSelection()) {
            n |= 0x80000;
        }
        if (this.noMergePaintsButton.getSelection()) {
            n |= 0x200000;
        }
        if (this.noRedrawResizeButton.getSelection()) {
            n |= 0x100000;
        }
        this.paintCount = 0;
        this.cx = 0;
        this.cy = 0;
        this.canvas = new Canvas((Composite)this.canvasGroup, n);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Point point;
                ++CanvasTab.this.paintCount;
                GC gC = paintEvent.gc;
                if (CanvasTab.this.fillDamageButton.getSelection()) {
                    point = paintEvent.display.getSystemColor(colors[CanvasTab.this.paintCount % colors.length]);
                    gC.setBackground((Color)point);
                    gC.fillRectangle(paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
                }
                point = CanvasTab.this.canvas.getSize();
                gC.drawArc(CanvasTab.this.cx + 1, CanvasTab.this.cy + 1, point.x - 2, point.y - 2, 0, 360);
                gC.drawRectangle(CanvasTab.this.cx + (point.x - 10) / 2, CanvasTab.this.cy + (point.y - 10) / 2, 10, 10);
            }
        });
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Point point = CanvasTab.this.canvas.getSize();
                CanvasTab.this.maxX = point.x * 3 / 2;
                CanvasTab.this.maxY = point.y * 3 / 2;
                CanvasTab.this.resizeScrollBars();
            }
        });
        ScrollBar scrollBar = this.canvas.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CanvasTab.this.scrollHorizontal((ScrollBar)selectionEvent.widget);
                }
            });
        }
        if ((scrollBar = this.canvas.getVerticalBar()) != null) {
            scrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CanvasTab.this.scrollVertical((ScrollBar)selectionEvent.widget);
                }
            });
        }
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.horizontalButton = new Button((Composite)this.styleGroup, 32);
        this.horizontalButton.setText("SWT.H_SCROLL");
        this.horizontalButton.setSelection(true);
        this.verticalButton = new Button((Composite)this.styleGroup, 32);
        this.verticalButton.setText("SWT.V_SCROLL");
        this.verticalButton.setSelection(true);
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        this.noBackgroundButton = new Button((Composite)this.styleGroup, 32);
        this.noBackgroundButton.setText("SWT.NO_BACKGROUND");
        this.noFocusButton = new Button((Composite)this.styleGroup, 32);
        this.noFocusButton.setText("SWT.NO_FOCUS");
        this.noMergePaintsButton = new Button((Composite)this.styleGroup, 32);
        this.noMergePaintsButton.setText("SWT.NO_MERGE_PAINTS");
        this.noRedrawResizeButton = new Button((Composite)this.styleGroup, 32);
        this.noRedrawResizeButton.setText("SWT.NO_REDRAW_RESIZE");
    }

    @Override
    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                CanvasTab.this.setExampleWidgetSize();
            }
        });
        return this.tabFolderPage;
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.canvas};
    }

    @Override
    String getTabText() {
        return "Canvas";
    }

    void resizeScrollBars() {
        Rectangle rectangle = this.canvas.getClientArea();
        ScrollBar scrollBar = this.canvas.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setMaximum(this.maxX);
            scrollBar.setThumb(rectangle.width);
            scrollBar.setPageIncrement(rectangle.width);
        }
        if ((scrollBar = this.canvas.getVerticalBar()) != null) {
            scrollBar.setMaximum(this.maxY);
            scrollBar.setThumb(rectangle.height);
            scrollBar.setPageIncrement(rectangle.height);
        }
    }

    void scrollHorizontal(ScrollBar scrollBar) {
        Rectangle rectangle = this.canvas.getClientArea();
        int n = -scrollBar.getSelection();
        if (n + this.maxX < rectangle.width) {
            n = rectangle.width - this.maxX;
        }
        this.canvas.scroll(n, this.cy, this.cx, this.cy, this.maxX, this.maxY, false);
        this.cx = n;
    }

    void scrollVertical(ScrollBar scrollBar) {
        Rectangle rectangle = this.canvas.getClientArea();
        int n = -scrollBar.getSelection();
        if (n + this.maxY < rectangle.height) {
            n = rectangle.height - this.maxY;
        }
        this.canvas.scroll(this.cx, n, this.cx, this.cy, this.maxX, this.maxY, false);
        this.cy = n;
    }

    void setCaret() {
        Caret caret = this.canvas.getCaret();
        if (this.caretButton.getSelection()) {
            Caret caret2 = new Caret(this.canvas, 0);
            Font font = this.canvas.getFont();
            caret2.setFont(font);
            GC gC = new GC((Drawable)this.canvas);
            gC.setFont(font);
            caret2.setBounds(1, 1, 1, gC.getFontMetrics().getHeight());
            gC.dispose();
            this.canvas.setCaret(caret2);
            this.canvas.setFocus();
        } else {
            this.canvas.setCaret(null);
        }
        if (caret != null) {
            caret.dispose();
        }
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.horizontalButton.setSelection((this.canvas.getStyle() & 0x100) != 0);
        this.verticalButton.setSelection((this.canvas.getStyle() & 0x200) != 0);
        this.borderButton.setSelection((this.canvas.getStyle() & 0x800) != 0);
        this.noBackgroundButton.setSelection((this.canvas.getStyle() & 0x40000) != 0);
        this.noFocusButton.setSelection((this.canvas.getStyle() & 0x80000) != 0);
        this.noMergePaintsButton.setSelection((this.canvas.getStyle() & 0x200000) != 0);
        this.noRedrawResizeButton.setSelection((this.canvas.getStyle() & 0x100000) != 0);
        this.setCaret();
    }
}

