/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;

class ComboTab
extends Tab {
    Combo combo1;
    Group comboGroup;
    Button dropDownButton;
    Button readOnlyButton;
    Button simpleButton;
    static String[] ListData = new String[]{ControlExample.getResourceString("ListData0_0"), ControlExample.getResourceString("ListData0_1"), ControlExample.getResourceString("ListData0_2"), ControlExample.getResourceString("ListData0_3"), ControlExample.getResourceString("ListData0_4"), ControlExample.getResourceString("ListData0_5"), ControlExample.getResourceString("ListData0_6"), ControlExample.getResourceString("ListData0_7"), ControlExample.getResourceString("ListData0_8")};

    ComboTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.comboGroup = new Group((Composite)this.exampleGroup, 0);
        this.comboGroup.setLayout((Layout)new GridLayout());
        this.comboGroup.setLayoutData((Object)new GridData(784));
        this.comboGroup.setText("Combo");
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.dropDownButton.getSelection()) {
            n |= 4;
        }
        if (this.readOnlyButton.getSelection()) {
            n |= 8;
        }
        if (this.simpleButton.getSelection()) {
            n |= 0x40;
        }
        this.combo1 = new Combo((Composite)this.comboGroup, n);
        this.combo1.setItems(ListData);
        if (ListData.length >= 3) {
            this.combo1.setText(ListData[2]);
            this.combo1.select(2);
        }
    }

    @Override
    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                ComboTab.this.setExampleWidgetSize();
            }
        });
        return this.tabFolderPage;
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.dropDownButton = new Button((Composite)this.styleGroup, 16);
        this.dropDownButton.setText("SWT.DROP_DOWN");
        this.simpleButton = new Button((Composite)this.styleGroup, 16);
        this.simpleButton.setText("SWT.SIMPLE");
        this.readOnlyButton = new Button((Composite)this.styleGroup, 32);
        this.readOnlyButton.setText("SWT.READ_ONLY");
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.combo1};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Items", "Orientation", "Selection", "Text", "TextLimit", "VisibleItemCount"};
    }

    @Override
    String getTabText() {
        return "Combo";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.dropDownButton.setSelection((this.combo1.getStyle() & 4) != 0);
        this.simpleButton.setSelection((this.combo1.getStyle() & 0x40) != 0);
        this.readOnlyButton.setSelection((this.combo1.getStyle() & 8) != 0);
        this.readOnlyButton.setEnabled(!this.simpleButton.getSelection());
    }
}

