/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class CoolBarTab
extends Tab {
    CoolBar coolBar;
    CoolItem pushItem;
    CoolItem dropDownItem;
    CoolItem radioItem;
    CoolItem checkItem;
    CoolItem textItem;
    Group coolBarGroup;
    Button dropDownButton;
    Button flatButton;
    Button lockedButton;
    Point[] sizes;
    int[] wrapIndices;
    int[] order;

    CoolBarTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.lockedButton = new Button((Composite)this.otherGroup, 32);
        this.lockedButton.setText(ControlExample.getResourceString("Locked"));
        this.lockedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CoolBarTab.this.setWidgetLocked();
            }
        });
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.coolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.coolBarGroup.setLayout((Layout)new GridLayout());
        this.coolBarGroup.setLayoutData((Object)new GridData(784));
        this.coolBarGroup.setText("CoolBar");
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        int n2 = 0;
        int n3 = 0x800000;
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.flatButton.getSelection()) {
            n |= 0x800000;
        }
        if (this.dropDownButton.getSelection()) {
            n2 |= 4;
        }
        this.coolBar = new CoolBar((Composite)this.coolBarGroup, n);
        ToolBar toolBar = new ToolBar((Composite)this.coolBar, n3);
        ToolItem toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.PUSH");
        toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(this.instance.images[1]);
        toolItem.setToolTipText("SWT.PUSH");
        toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(this.instance.images[2]);
        toolItem.setToolTipText("SWT.PUSH");
        toolItem = new ToolItem(toolBar, 2);
        toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.PUSH");
        toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(this.instance.images[1]);
        toolItem.setToolTipText("SWT.PUSH");
        this.pushItem = new CoolItem(this.coolBar, n2);
        this.pushItem.setControl((Control)toolBar);
        Point point = toolBar.computeSize(-1, -1);
        point = this.pushItem.computeSize(point.x, point.y);
        this.pushItem.setSize(point);
        this.pushItem.setMinimumSize(toolItem.getWidth(), point.y);
        this.pushItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        toolBar = new ToolBar((Composite)this.coolBar, n3);
        toolItem = new ToolItem(toolBar, 4);
        toolItem.setImage(this.instance.images[1]);
        toolItem.setToolTipText("SWT.DROP_DOWN");
        toolItem.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        toolItem = new ToolItem(toolBar, 4);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.DROP_DOWN");
        toolItem.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        this.dropDownItem = new CoolItem(this.coolBar, n2);
        this.dropDownItem.setControl((Control)toolBar);
        Point point2 = toolBar.computeSize(-1, -1);
        point2 = this.dropDownItem.computeSize(point2.x, point2.y);
        this.dropDownItem.setSize(point2);
        this.dropDownItem.setMinimumSize(toolItem.getWidth(), point2.y);
        this.dropDownItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        toolBar = new ToolBar((Composite)this.coolBar, n3);
        toolItem = new ToolItem(toolBar, 16);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(toolBar, 16);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(toolBar, 16);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.RADIO");
        this.radioItem = new CoolItem(this.coolBar, n2);
        this.radioItem.setControl((Control)toolBar);
        Point point3 = toolBar.computeSize(-1, -1);
        point3 = this.radioItem.computeSize(point3.x, point3.y);
        this.radioItem.setSize(point3);
        this.radioItem.setMinimumSize(toolItem.getWidth(), point3.y);
        this.radioItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        toolBar = new ToolBar((Composite)this.coolBar, n3);
        toolItem = new ToolItem(toolBar, 32);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.CHECK");
        toolItem = new ToolItem(toolBar, 32);
        toolItem.setImage(this.instance.images[2]);
        toolItem.setToolTipText("SWT.CHECK");
        toolItem = new ToolItem(toolBar, 32);
        toolItem.setImage(this.instance.images[1]);
        toolItem.setToolTipText("SWT.CHECK");
        toolItem = new ToolItem(toolBar, 32);
        toolItem.setImage(this.instance.images[2]);
        toolItem.setToolTipText("SWT.CHECK");
        this.checkItem = new CoolItem(this.coolBar, n2);
        this.checkItem.setControl((Control)toolBar);
        Point point4 = toolBar.computeSize(-1, -1);
        point4 = this.checkItem.computeSize(point4.x, point4.y);
        this.checkItem.setSize(point4);
        this.checkItem.setMinimumSize(toolItem.getWidth(), point4.y);
        this.checkItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        Text text = new Text((Composite)this.coolBar, 2052);
        this.textItem = new CoolItem(this.coolBar, n2);
        this.textItem.setControl((Control)text);
        Point point5 = text.computeSize(-1, -1);
        point5 = this.textItem.computeSize(point5.x, point5.y);
        this.textItem.setSize(point5);
        this.textItem.setMinimumSize(point5);
        this.textItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        if (this.order != null) {
            this.coolBar.setItemLayout(this.order, this.wrapIndices, this.sizes);
            this.pushItem.setPreferredSize(point);
            this.dropDownItem.setPreferredSize(point2);
            this.radioItem.setPreferredSize(point3);
            this.checkItem.setPreferredSize(point4);
            this.textItem.setPreferredSize(point5);
        } else {
            this.coolBar.setWrapIndices(new int[]{1, 3});
        }
        this.coolBar.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CoolBarTab.this.exampleGroup.layout();
            }
        });
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        this.flatButton = new Button((Composite)this.styleGroup, 32);
        this.flatButton.setText("SWT.FLAT");
        Group group = new Group((Composite)this.styleGroup, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(272));
        group.setText(ControlExample.getResourceString("Item_Styles"));
        this.dropDownButton = new Button((Composite)group, 32);
        this.dropDownButton.setText("SWT.DROP_DOWN");
        this.dropDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CoolBarTab.this.recreateExampleWidgets();
            }
        });
    }

    @Override
    void disposeExampleWidgets() {
        if (this.coolBar != null) {
            this.sizes = this.coolBar.getItemSizes();
            this.wrapIndices = this.coolBar.getWrapIndices();
            this.order = this.coolBar.getItemOrder();
        }
        super.disposeExampleWidgets();
    }

    @Override
    Item[] getExampleWidgetItems() {
        return this.coolBar.getItems();
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.coolBar};
    }

    @Override
    String getTabText() {
        return "CoolBar";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.borderButton.setSelection((this.coolBar.getStyle() & 0x800) != 0);
        this.flatButton.setSelection((this.coolBar.getStyle() & 0x800000) != 0);
        this.dropDownButton.setSelection((this.coolBar.getItem(0).getStyle() & 4) != 0);
        this.setWidgetLocked();
    }

    void setWidgetLocked() {
        this.coolBar.setLocked(this.lockedButton.getSelection());
    }

    class CoolItemSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;

        CoolItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.detail == 4) {
                ToolItem toolItem;
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                    return;
                }
                CoolItem coolItem = (CoolItem)selectionEvent.widget;
                Rectangle rectangle = coolItem.getBounds();
                rectangle.width = selectionEvent.x - rectangle.x;
                Point point = CoolBarTab.this.coolBar.toDisplay(new Point(rectangle.x, rectangle.y));
                rectangle.x = point.x;
                rectangle.y = point.y;
                ToolBar toolBar = (ToolBar)coolItem.getControl();
                ToolItem[] toolItemArray = toolBar.getItems();
                int n = toolItemArray.length;
                for (int i = 0; i < n; ++i) {
                    Rectangle rectangle2 = toolItemArray[i].getBounds();
                    point = toolBar.toDisplay(new Point(rectangle2.x, rectangle2.y));
                    rectangle2.x = point.x;
                    rectangle2.y = point.y;
                    toolItem = rectangle.intersection(rectangle2);
                    if (!toolItem.equals((Object)rectangle2)) break;
                }
                this.menu = new Menu((Control)CoolBarTab.this.coolBar);
                for (int i = i; i < n; ++i) {
                    String string;
                    MenuItem menuItem;
                    toolItem = toolItemArray[i];
                    Image image = toolItem.getImage();
                    if (image == null) {
                        new MenuItem(this.menu, 2);
                        continue;
                    }
                    if ((toolItem.getStyle() & 4) != 0) {
                        menuItem = new MenuItem(this.menu, 64);
                        menuItem.setImage(image);
                        string = toolItem.getToolTipText();
                        if (string != null) {
                            menuItem.setText(string);
                        }
                        Menu menu = new Menu(this.menu);
                        menuItem.setMenu(menu);
                        for (int j = 0; j < 9; ++j) {
                            string = ControlExample.getResourceString("DropDownData_" + j);
                            if (string.length() != 0) {
                                MenuItem menuItem2 = new MenuItem(menu, 0);
                                menuItem2.setText(string);
                                continue;
                            }
                            new MenuItem(menu, 2);
                        }
                        continue;
                    }
                    menuItem = new MenuItem(this.menu, 0);
                    menuItem.setImage(image);
                    string = toolItem.getToolTipText();
                    if (string == null) continue;
                    menuItem.setText(string);
                }
                point = CoolBarTab.this.coolBar.toDisplay(new Point(selectionEvent.x, selectionEvent.y));
                this.menu.setLocation(point.x, point.y);
                this.menu.setVisible(true);
                Display display = CoolBarTab.this.coolBar.getDisplay();
                while (this.menu != null && !this.menu.isDisposed() && this.menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }
        }
    }

    class DropDownSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;
        private boolean visible = false;

        DropDownSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Point point;
            Object object;
            Shell shell;
            if (this.menu == null) {
                shell = CoolBarTab.this.tabFolderPage.getShell();
                this.menu = new Menu((Control)shell);
                this.menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuHidden(MenuEvent menuEvent) {
                        DropDownSelectionListener.this.visible = false;
                    }
                });
                for (int i = 0; i < 9; ++i) {
                    object = ControlExample.getResourceString("DropDownData_" + i);
                    if (((String)object).length() != 0) {
                        point = new MenuItem(this.menu, 0);
                        point.setText((String)object);
                        point.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                DropDownSelectionListener.this.setMenuVisible(false);
                            }
                        });
                        continue;
                    }
                    new MenuItem(this.menu, 2);
                }
            }
            if (selectionEvent.detail == 4) {
                if (this.visible) {
                    this.setMenuVisible(false);
                } else {
                    shell = (ToolItem)selectionEvent.widget;
                    ToolBar toolBar = shell.getParent();
                    object = shell.getBounds();
                    point = toolBar.toDisplay(new Point(((Rectangle)object).x, ((Rectangle)object).y));
                    this.menu.setLocation(point.x, point.y + ((Rectangle)object).height);
                    this.setMenuVisible(true);
                }
            }
        }

        private void setMenuVisible(boolean bl) {
            this.menu.setVisible(bl);
            this.visible = bl;
        }
    }
}

