/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.AlignableTab;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class LabelTab
extends AlignableTab {
    Label label1;
    Label label2;
    Label label3;
    Label label4;
    Label label5;
    Label label6;
    Group textLabelGroup;
    Group imageLabelGroup;
    Button wrapButton;
    Button separatorButton;
    Button horizontalButton;
    Button verticalButton;
    Button shadowInButton;
    Button shadowOutButton;
    Button shadowNoneButton;

    LabelTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.textLabelGroup = new Group((Composite)this.exampleGroup, 0);
        GridLayout gridLayout = new GridLayout();
        this.textLabelGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.textLabelGroup.setLayoutData((Object)new GridData(784));
        this.textLabelGroup.setText(ControlExample.getResourceString("Text_Labels"));
        this.imageLabelGroup = new Group((Composite)this.exampleGroup, 32);
        gridLayout = new GridLayout();
        this.imageLabelGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.imageLabelGroup.setLayoutData((Object)new GridData(784));
        this.imageLabelGroup.setText(ControlExample.getResourceString("Image_Labels"));
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.wrapButton.getSelection()) {
            n |= 0x40;
        }
        if (this.separatorButton.getSelection()) {
            n |= 2;
        }
        if (this.horizontalButton.getSelection()) {
            n |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            n |= 0x200;
        }
        if (this.shadowInButton.getSelection()) {
            n |= 4;
        }
        if (this.shadowOutButton.getSelection()) {
            n |= 8;
        }
        if (this.shadowNoneButton.getSelection()) {
            n |= 0x20;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.leftButton.getSelection()) {
            n |= 0x4000;
        }
        if (this.centerButton.getSelection()) {
            n |= 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            n |= 0x20000;
        }
        this.label1 = new Label((Composite)this.textLabelGroup, n);
        this.label1.setText(ControlExample.getResourceString("One"));
        this.label2 = new Label((Composite)this.textLabelGroup, n);
        this.label2.setText(ControlExample.getResourceString("Two"));
        this.label3 = new Label((Composite)this.textLabelGroup, n);
        if (this.wrapButton.getSelection()) {
            this.label3.setText(ControlExample.getResourceString("Wrap_Text"));
        } else {
            this.label3.setText(ControlExample.getResourceString("Three"));
        }
        this.label4 = new Label((Composite)this.imageLabelGroup, n);
        this.label4.setImage(this.instance.images[0]);
        this.label5 = new Label((Composite)this.imageLabelGroup, n);
        this.label5.setImage(this.instance.images[1]);
        this.label6 = new Label((Composite)this.imageLabelGroup, n);
        this.label6.setImage(this.instance.images[2]);
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.separatorButton = new Button((Composite)this.styleGroup, 32);
        this.separatorButton.setText("SWT.SEPARATOR");
        this.horizontalButton = new Button((Composite)this.styleGroup, 16);
        this.horizontalButton.setText("SWT.HORIZONTAL");
        this.verticalButton = new Button((Composite)this.styleGroup, 16);
        this.verticalButton.setText("SWT.VERTICAL");
        Group group = new Group((Composite)this.styleGroup, 0);
        group.setLayout((Layout)new GridLayout());
        this.shadowInButton = new Button((Composite)group, 16);
        this.shadowInButton.setText("SWT.SHADOW_IN");
        this.shadowOutButton = new Button((Composite)group, 16);
        this.shadowOutButton.setText("SWT.SHADOW_OUT");
        this.shadowNoneButton = new Button((Composite)group, 16);
        this.shadowNoneButton.setText("SWT.SHADOW_NONE");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if ((selectionEvent.widget.getStyle() & 0x10) != 0 && !((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
                LabelTab.this.recreateExampleWidgets();
            }
        };
        this.shadowInButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.shadowOutButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.shadowNoneButton.addSelectionListener((SelectionListener)selectionAdapter);
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.label1, this.label2, this.label3, this.label4, this.label5, this.label6};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Text"};
    }

    @Override
    String getTabText() {
        return "Label";
    }

    @Override
    void setExampleWidgetAlignment() {
        int n = 0;
        if (this.leftButton.getSelection()) {
            n = 16384;
        }
        if (this.centerButton.getSelection()) {
            n = 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            n = 131072;
        }
        this.label1.setAlignment(n);
        this.label2.setAlignment(n);
        this.label3.setAlignment(n);
        this.label4.setAlignment(n);
        this.label5.setAlignment(n);
        this.label6.setAlignment(n);
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        boolean bl = (this.label1.getStyle() & 2) != 0;
        this.wrapButton.setSelection(!bl && (this.label1.getStyle() & 0x40) != 0);
        this.leftButton.setSelection(!bl && (this.label1.getStyle() & 0x4000) != 0);
        this.centerButton.setSelection(!bl && (this.label1.getStyle() & 0x1000000) != 0);
        this.rightButton.setSelection(!bl && (this.label1.getStyle() & 0x20000) != 0);
        this.shadowInButton.setSelection(bl && (this.label1.getStyle() & 4) != 0);
        this.shadowOutButton.setSelection(bl && (this.label1.getStyle() & 8) != 0);
        this.shadowNoneButton.setSelection(bl && (this.label1.getStyle() & 0x20) != 0);
        this.horizontalButton.setSelection(bl && (this.label1.getStyle() & 0x100) != 0);
        this.verticalButton.setSelection(bl && (this.label1.getStyle() & 0x200) != 0);
        this.wrapButton.setEnabled(!bl);
        this.leftButton.setEnabled(!bl);
        this.centerButton.setEnabled(!bl);
        this.rightButton.setEnabled(!bl);
        this.shadowInButton.setEnabled(bl);
        this.shadowOutButton.setEnabled(bl);
        this.shadowNoneButton.setEnabled(bl);
        this.horizontalButton.setEnabled(bl);
        this.verticalButton.setEnabled(bl);
    }
}

