/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class MenuTab
extends Tab {
    Button barButton;
    Button dropDownButton;
    Button popUpButton;
    Button noRadioGroupButton;
    Button leftToRightButton;
    Button rightToLeftButton;
    Button checkButton;
    Button cascadeButton;
    Button pushButton;
    Button radioButton;
    Button separatorButton;
    Button imagesButton;
    Button acceleratorsButton;
    Button mnemonicsButton;
    Button subMenuButton;
    Button subSubMenuButton;
    Button createButton;
    Button closeAllButton;
    Group menuItemStyleGroup;
    int shellCount = 0;
    Shell[] shells = new Shell[4];

    MenuTab(ControlExample controlExample) {
        super(controlExample);
    }

    void closeAllShells() {
        for (int i = 0; i < this.shellCount; ++i) {
            if (!(this.shells[i] != null & !this.shells[i].isDisposed())) continue;
            this.shells[i].dispose();
        }
        this.shellCount = 0;
    }

    public void anotherCreateButtonSelected(SelectionEvent selectionEvent) {
        final Shell shell = new Shell(16480);
        shell.setSize(200, 200);
        shell.setText("Another popup menu");
        final Label label = new Label((Composite)shell, 0);
        label.setBounds(20, 30, 160, 20);
        label.setText("Another popup menu: Click here.");
        Button button = new Button((Composite)shell, 0);
        button.setText("Ok");
        button.setBounds(80, 120, 40, 25);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.close();
            }
        });
        shell.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                AnotherPopupMenu anotherPopupMenu = new AnotherPopupMenu(new String[]{"One", "Two", "Three"});
                if (anotherPopupMenu.show((Control)shell)) {
                    label.setText(anotherPopupMenu.getResult());
                } else {
                    label.setText("Menu cancelled");
                }
            }
        });
        shell.open();
    }

    public void createButtonSelected(SelectionEvent selectionEvent) {
        Menu menu;
        Shell shell;
        if (this.shellCount >= this.shells.length) {
            Shell[] shellArray = new Shell[this.shells.length + 4];
            System.arraycopy(this.shells, 0, shellArray, 0, this.shells.length);
            this.shells = shellArray;
        }
        int n = 0;
        if (this.leftToRightButton.getSelection()) {
            n |= 0x2000000;
        }
        if (this.rightToLeftButton.getSelection()) {
            n |= 0x4000000;
        }
        int n2 = 0;
        if (this.noRadioGroupButton.getSelection()) {
            n2 |= 0x400000;
        }
        this.shells[this.shellCount] = shell = new Shell(0x4F0 | n);
        if (this.barButton.getSelection()) {
            menu = new Menu((Decorations)shell, 2 | n2);
            shell.setMenuBar(menu);
            this.hookListeners((Widget)menu);
            if (this.dropDownButton.getSelection() && this.cascadeButton.getSelection()) {
                MenuItem menuItem = new MenuItem(menu, 64);
                menuItem.setText(this.getMenuItemText("Cascade"));
                if (this.imagesButton.getSelection()) {
                    menuItem.setImage(this.instance.images[1]);
                }
                this.hookListeners((Widget)menuItem);
                Menu menu2 = new Menu((Decorations)shell, 4 | n2);
                menuItem.setMenu(menu2);
                this.hookListeners((Widget)menu2);
                this.createMenuItems(menu2, this.subMenuButton.getSelection(), this.subSubMenuButton.getSelection());
            }
        }
        if (this.popUpButton.getSelection()) {
            menu = new Menu((Decorations)shell, 8 | n2);
            shell.setMenu(menu);
            this.hookListeners((Widget)menu);
            this.createMenuItems(menu, this.subMenuButton.getSelection(), this.subSubMenuButton.getSelection());
        }
        shell.setSize(300, 100);
        shell.setText(ControlExample.getResourceString("Title") + this.shellCount);
        shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                paintEvent.gc.drawString(ControlExample.getResourceString("PopupMenuHere"), 20, 20);
            }
        });
        shell.open();
        ++this.shellCount;
    }

    @Override
    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        this.controlGroup.setLayout((Layout)new GridLayout(2, true));
        this.controlGroup.setLayoutData((Object)new GridData(272));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.styleGroup = new Group((Composite)this.controlGroup, 0);
        this.styleGroup.setLayout((Layout)new GridLayout());
        this.styleGroup.setLayoutData((Object)new GridData(272));
        this.styleGroup.setText(ControlExample.getResourceString("Menu_Styles"));
        this.menuItemStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.menuItemStyleGroup.setLayout((Layout)new GridLayout());
        this.menuItemStyleGroup.setLayoutData((Object)new GridData(272));
        this.menuItemStyleGroup.setText(ControlExample.getResourceString("MenuItem_Styles"));
        this.otherGroup = new Group((Composite)this.controlGroup, 0);
        this.otherGroup.setLayout((Layout)new GridLayout());
        this.otherGroup.setLayoutData((Object)new GridData(272));
        this.otherGroup.setText(ControlExample.getResourceString("Other"));
    }

    @Override
    void createControlWidgets() {
        this.barButton = new Button((Composite)this.styleGroup, 32);
        this.barButton.setText("SWT.BAR");
        this.dropDownButton = new Button((Composite)this.styleGroup, 32);
        this.dropDownButton.setText("SWT.DROP_DOWN");
        this.popUpButton = new Button((Composite)this.styleGroup, 32);
        this.popUpButton.setText("SWT.POP_UP");
        this.noRadioGroupButton = new Button((Composite)this.styleGroup, 32);
        this.noRadioGroupButton.setText("SWT.NO_RADIO_GROUP");
        this.leftToRightButton = new Button((Composite)this.styleGroup, 16);
        this.leftToRightButton.setText("SWT.LEFT_TO_RIGHT");
        this.leftToRightButton.setSelection(true);
        this.rightToLeftButton = new Button((Composite)this.styleGroup, 16);
        this.rightToLeftButton.setText("SWT.RIGHT_TO_LEFT");
        this.cascadeButton = new Button((Composite)this.menuItemStyleGroup, 32);
        this.cascadeButton.setText("SWT.CASCADE");
        this.checkButton = new Button((Composite)this.menuItemStyleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
        this.pushButton = new Button((Composite)this.menuItemStyleGroup, 32);
        this.pushButton.setText("SWT.PUSH");
        this.radioButton = new Button((Composite)this.menuItemStyleGroup, 32);
        this.radioButton.setText("SWT.RADIO");
        this.separatorButton = new Button((Composite)this.menuItemStyleGroup, 32);
        this.separatorButton.setText("SWT.SEPARATOR");
        this.imagesButton = new Button((Composite)this.otherGroup, 32);
        this.imagesButton.setText(ControlExample.getResourceString("Images"));
        this.acceleratorsButton = new Button((Composite)this.otherGroup, 32);
        this.acceleratorsButton.setText(ControlExample.getResourceString("Accelerators"));
        this.mnemonicsButton = new Button((Composite)this.otherGroup, 32);
        this.mnemonicsButton.setText(ControlExample.getResourceString("Mnemonics"));
        this.subMenuButton = new Button((Composite)this.otherGroup, 32);
        this.subMenuButton.setText(ControlExample.getResourceString("SubMenu"));
        this.subSubMenuButton = new Button((Composite)this.otherGroup, 32);
        this.subSubMenuButton.setText(ControlExample.getResourceString("SubSubMenu"));
        new Label((Composite)this.controlGroup, 0);
        this.createButton = new Button((Composite)this.controlGroup, 0);
        this.createButton.setLayoutData((Object)new GridData(128));
        this.createButton.setText(ControlExample.getResourceString("Create_Shell"));
        this.closeAllButton = new Button((Composite)this.controlGroup, 0);
        this.closeAllButton.setLayoutData((Object)new GridData(32));
        this.closeAllButton.setText(ControlExample.getResourceString("Close_All_Shells"));
        Button button = new Button((Composite)this.controlGroup, 0);
        button.setLayoutData((Object)new GridData(8));
        button.setText("Another Shell");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuTab.this.anotherCreateButtonSelected(selectionEvent);
            }
        });
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuTab.this.createButtonSelected(selectionEvent);
            }
        });
        this.closeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuTab.this.closeAllShells();
            }
        });
        this.subMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuTab.this.subSubMenuButton.setEnabled(MenuTab.this.subMenuButton.getSelection());
            }
        });
        this.barButton.setSelection(true);
        this.dropDownButton.setSelection(true);
        this.popUpButton.setSelection(true);
        this.cascadeButton.setSelection(true);
        this.checkButton.setSelection(true);
        this.pushButton.setSelection(true);
        this.radioButton.setSelection(true);
        this.separatorButton.setSelection(true);
        this.subSubMenuButton.setEnabled(this.subMenuButton.getSelection());
    }

    void createMenuItems(Menu menu, boolean bl, boolean bl2) {
        MenuItem menuItem;
        if (this.pushButton.getSelection()) {
            menuItem = new MenuItem(menu, 8);
            menuItem.setText(this.getMenuItemText("Push"));
            if (this.acceleratorsButton.getSelection()) {
                menuItem.setAccelerator(SWT.MOD1 + SWT.MOD2 + 80);
            }
            if (this.imagesButton.getSelection()) {
                menuItem.setImage(this.instance.images[0]);
            }
            this.hookListeners((Widget)menuItem);
        }
        if (this.separatorButton.getSelection()) {
            new MenuItem(menu, 2);
        }
        if (this.checkButton.getSelection()) {
            menuItem = new MenuItem(menu, 32);
            menuItem.setText(this.getMenuItemText("Check"));
            if (this.acceleratorsButton.getSelection()) {
                menuItem.setAccelerator(SWT.MOD1 + SWT.MOD2 + 67);
            }
            if (this.imagesButton.getSelection()) {
                menuItem.setImage(this.instance.images[1]);
            }
            this.hookListeners((Widget)menuItem);
        }
        if (this.radioButton.getSelection()) {
            menuItem = new MenuItem(menu, 16);
            menuItem.setText(this.getMenuItemText("1Radio"));
            if (this.acceleratorsButton.getSelection()) {
                menuItem.setAccelerator(SWT.MOD1 + SWT.MOD2 + 49);
            }
            if (this.imagesButton.getSelection()) {
                menuItem.setImage(this.instance.images[2]);
            }
            menuItem.setSelection(true);
            this.hookListeners((Widget)menuItem);
            menuItem = new MenuItem(menu, 16);
            menuItem.setText(this.getMenuItemText("2Radio"));
            if (this.acceleratorsButton.getSelection()) {
                menuItem.setAccelerator(SWT.MOD1 + SWT.MOD2 + 50);
            }
            if (this.imagesButton.getSelection()) {
                menuItem.setImage(this.instance.images[2]);
            }
            this.hookListeners((Widget)menuItem);
        }
        if (bl && this.cascadeButton.getSelection()) {
            menuItem = new MenuItem(menu, 64);
            menuItem.setText(this.getMenuItemText("Cascade"));
            if (this.imagesButton.getSelection()) {
                menuItem.setImage(this.instance.images[1]);
            }
            this.hookListeners((Widget)menuItem);
            Menu menu2 = new Menu((Decorations)menu.getShell(), 4);
            menuItem.setMenu(menu2);
            this.hookListeners((Widget)menu2);
            this.createMenuItems(menu2, bl2, false);
        }
    }

    String getMenuItemText(String string) {
        boolean bl = string.equals("Cascade");
        boolean bl2 = this.mnemonicsButton.getSelection();
        boolean bl3 = this.acceleratorsButton.getSelection();
        char c = string.charAt(0);
        if (bl2 && bl3 && !bl) {
            return ControlExample.getResourceString(string + "WithMnemonic") + "\tCtrl+Shift+" + c;
        }
        if (bl3 && !bl) {
            return ControlExample.getResourceString(string) + "\tCtrl+Shift+" + c;
        }
        if (bl2) {
            return ControlExample.getResourceString(string + "WithMnemonic");
        }
        return ControlExample.getResourceString(string);
    }

    @Override
    String getTabText() {
        return "Menu";
    }

    Control[] getExampleWidgetsXXX() {
        Button button = new Button((Composite)this.exampleGroup, 0);
        button.setText("Another popup menu");
        return new Control[]{button};
    }

    public class AnotherPopupMenu {
        private String[] content;
        private String result = null;

        public AnotherPopupMenu(String[] stringArray) {
            this.content = stringArray;
        }

        public boolean show(Control control) {
            Menu menu = new Menu(control);
            this.createMenuItems(menu);
            menu.setVisible(true);
            Display display = menu.getDisplay();
            while (!menu.isDisposed() && menu.isVisible()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (!menu.isDisposed()) {
                menu.dispose();
                if (this.getResult() != null) {
                    return true;
                }
            } else {
                System.out.println("Menu disposed!");
            }
            return false;
        }

        protected void createMenuItems(Menu menu) {
            for (int i = 0; i < this.content.length; ++i) {
                final String string = this.content[i];
                MenuItem menuItem = new MenuItem(menu, 0);
                menuItem.setText(string);
                menuItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        AnotherPopupMenu.this.setResult(string);
                    }

                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        AnotherPopupMenu.this.setResult(string);
                    }
                });
            }
        }

        public String getResult() {
            return this.result;
        }

        protected void setResult(String string) {
            this.result = string;
        }
    }
}

