/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.RangeTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;

class SpinnerTab
extends RangeTab {
    Spinner spinner1;
    Group spinnerGroup;
    Button readOnlyButton;
    Button wrapButton;
    Scale incrementScale;
    Scale pageIncrementScale;
    Scale digitsScale;

    SpinnerTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createControlWidgets() {
        super.createControlWidgets();
        this.createIncrementGroup();
        this.createPageIncrementGroup();
        this.createDigitsGroup();
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.spinnerGroup = new Group((Composite)this.exampleGroup, 0);
        this.spinnerGroup.setLayout((Layout)new GridLayout());
        this.spinnerGroup.setLayoutData((Object)new GridData(784));
        this.spinnerGroup.setText("Spinner");
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.readOnlyButton.getSelection()) {
            n |= 8;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.wrapButton.getSelection()) {
            n |= 0x40;
        }
        this.spinner1 = new Spinner((Composite)this.spinnerGroup, n);
    }

    @Override
    void createMaximumGroup() {
        super.createMaximumGroup();
        this.maximumScale.setMaximum(1000);
        this.maximumScale.setPageIncrement(100);
    }

    @Override
    void createSelectionGroup() {
        super.createSelectionGroup();
        this.selectionScale.setMaximum(1000);
        this.selectionScale.setPageIncrement(100);
    }

    void createIncrementGroup() {
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(ControlExample.getResourceString("Increment"));
        group.setLayoutData((Object)new GridData(768));
        this.incrementScale = new Scale((Composite)group, 0);
        this.incrementScale.setMaximum(100);
        this.incrementScale.setSelection(1);
        this.incrementScale.setPageIncrement(10);
        this.incrementScale.setIncrement(5);
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        this.incrementScale.setLayoutData((Object)gridData);
        this.incrementScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpinnerTab.this.setWidgetIncrement();
            }
        });
    }

    void createPageIncrementGroup() {
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(ControlExample.getResourceString("Page_Increment"));
        group.setLayoutData((Object)new GridData(768));
        this.pageIncrementScale = new Scale((Composite)group, 0);
        this.pageIncrementScale.setMaximum(100);
        this.pageIncrementScale.setSelection(10);
        this.pageIncrementScale.setPageIncrement(10);
        this.pageIncrementScale.setIncrement(5);
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        this.pageIncrementScale.setLayoutData((Object)gridData);
        this.pageIncrementScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpinnerTab.this.setWidgetPageIncrement();
            }
        });
    }

    void createDigitsGroup() {
        Group group = new Group((Composite)this.controlGroup, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(ControlExample.getResourceString("Digits"));
        group.setLayoutData((Object)new GridData(768));
        this.digitsScale = new Scale((Composite)group, 0);
        this.digitsScale.setMaximum(8);
        this.digitsScale.setSelection(0);
        this.digitsScale.setPageIncrement(10);
        this.digitsScale.setIncrement(5);
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        this.digitsScale.setLayoutData((Object)gridData);
        this.digitsScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpinnerTab.this.setWidgetDigits();
            }
        });
    }

    @Override
    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                SpinnerTab.this.setExampleWidgetSize();
            }
        });
        return this.tabFolderPage;
    }

    @Override
    void createStyleGroup() {
        this.orientationButtons = false;
        super.createStyleGroup();
        this.readOnlyButton = new Button((Composite)this.styleGroup, 32);
        this.readOnlyButton.setText("SWT.READ_ONLY");
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.spinner1};
    }

    @Override
    String getTabText() {
        return "Spinner";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.readOnlyButton.setSelection((this.spinner1.getStyle() & 8) != 0);
        this.wrapButton.setSelection((this.spinner1.getStyle() & 0x40) != 0);
        this.setWidgetIncrement();
        this.setWidgetPageIncrement();
        this.setWidgetDigits();
    }

    void setWidgetIncrement() {
        this.spinner1.setIncrement(this.incrementScale.getSelection());
    }

    @Override
    void setWidgetMaximum() {
        this.spinner1.setMaximum(this.maximumScale.getSelection());
    }

    @Override
    void setWidgetMinimum() {
        this.spinner1.setMinimum(this.minimumScale.getSelection());
    }

    void setWidgetPageIncrement() {
        this.spinner1.setPageIncrement(this.pageIncrementScale.getSelection());
    }

    void setWidgetDigits() {
        this.spinner1.setDigits(this.digitsScale.getSelection());
    }

    @Override
    void setWidgetSelection() {
        this.spinner1.setSelection(this.selectionScale.getSelection());
    }
}

