/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

abstract class Tab {
    Button borderButton;
    Button enabledButton;
    Button visibleButton;
    Button preferredButton;
    Button tooSmallButton;
    Button smallButton;
    Button largeButton;
    Button fillButton;
    Composite tabFolderPage;
    Group exampleGroup;
    Group controlGroup;
    Group listenersGroup;
    Group otherGroup;
    Group sizeGroup;
    Group styleGroup;
    Group colorGroup;
    final ControlExample instance;
    static final int TOO_SMALL_SIZE = 10;
    static final int SMALL_SIZE = 50;
    static final int LARGE_SIZE = 100;
    static final boolean RTL_SUPPORT_ENABLE = false;
    Group orientationGroup;
    Button rtlButton;
    Button ltrButton;
    Button defaultOrietationButton;
    Button foregroundButton;
    Button backgroundButton;
    Button fontButton;
    Image foregroundImage;
    Image backgroundImage;
    Color foregroundColor;
    Color backgroundColor;
    Font font;
    Text eventConsole;
    boolean logging = false;
    boolean[] eventsFilter;
    Combo nameCombo;
    Label returnTypeLabel;
    Button getButton;
    Button setButton;
    Text setText;
    Text getText;
    static final String[] EVENT_NAMES = new String[]{"None", "KeyDown", "KeyUp", "MouseDown", "MouseUp", "MouseMove", "MouseEnter", "MouseExit", "MouseDoubleClick", "Paint", "Move", "Resize", "Dispose", "Selection", "DefaultSelection", "FocusIn", "FocusOut", "Expand", "Collapse", "Iconify", "Deiconify", "Close", "Show", "Hide", "Modify", "Verify", "Activate", "Deactivate", "Help", "DragDetect", "Arm", "Traverse", "MouseHover", "HardKeyDown", "HardKeyUp", "MenuDetect", "SetData", "MouseWheel"};

    Tab(ControlExample controlExample) {
        this.instance = controlExample;
    }

    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        this.controlGroup.setLayout((Layout)new GridLayout(2, true));
        this.controlGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.createStyleGroup();
        this.createOtherGroup();
        this.createSetGetGroup();
        this.createSizeGroup();
        this.createColorGroup();
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if ((selectionEvent.widget.getStyle() & 0x10) != 0 && !((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
                Tab.this.recreateExampleWidgets();
            }
        };
        Control[] controlArray = this.styleGroup.getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            if (!(controlArray[i] instanceof Button)) continue;
            Button button = (Button)controlArray[i];
            button.addSelectionListener((SelectionListener)selectionAdapter);
        }
    }

    void createSetGetGroup() {
        final String[] stringArray = this.getMethodNames();
        if (stringArray != null) {
            Button button = new Button((Composite)this.otherGroup, 8);
            button.setText(ControlExample.getResourceString("Set_Get"));
            button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button = (Button)selectionEvent.widget;
                    Point point = button.getLocation();
                    point = selectionEvent.display.map((Control)button, null, point);
                    Tab.this.createSetGetDialog(point.x, point.y, stringArray);
                }
            });
        }
    }

    void createControlWidgets() {
    }

    void createColorGroup() {
        this.colorGroup = new Group((Composite)this.controlGroup, 0);
        this.colorGroup.setLayout((Layout)new GridLayout(2, false));
        this.colorGroup.setLayoutData((Object)new GridData(272));
        this.colorGroup.setText(ControlExample.getResourceString("Colors"));
        new Label((Composite)this.colorGroup, 0).setText(ControlExample.getResourceString("Foreground_Color"));
        this.foregroundButton = new Button((Composite)this.colorGroup, 8);
        new Label((Composite)this.colorGroup, 0).setText(ControlExample.getResourceString("Background_Color"));
        this.backgroundButton = new Button((Composite)this.colorGroup, 8);
        this.fontButton = new Button((Composite)this.colorGroup, 8);
        this.fontButton.setText(ControlExample.getResourceString("Font"));
        this.fontButton.setLayoutData((Object)new GridData(256));
        Button button = new Button((Composite)this.colorGroup, 8);
        button.setText(ControlExample.getResourceString("Defaults"));
        Shell shell = this.controlGroup.getShell();
        final ColorDialog colorDialog = new ColorDialog(shell);
        final ColorDialog colorDialog2 = new ColorDialog(shell);
        final FontDialog fontDialog = new FontDialog(shell);
        int n = 12;
        Display display = shell.getDisplay();
        this.foregroundImage = new Image((Device)display, n, n);
        this.backgroundImage = new Image((Device)display, n, n);
        this.foregroundButton.setImage(this.foregroundImage);
        this.foregroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RGB rGB;
                Color color = Tab.this.foregroundColor;
                if (color == null && ((Control[])(rGB = Tab.this.getExampleWidgets())).length > 0) {
                    color = rGB[0].getForeground();
                }
                if (color != null) {
                    colorDialog.setRGB(color.getRGB());
                }
                if ((rGB = colorDialog.open()) == null) {
                    return;
                }
                color = Tab.this.foregroundColor;
                Tab.this.foregroundColor = new Color((Device)selectionEvent.display, rGB);
                Tab.this.setExampleWidgetForeground();
                if (color != null) {
                    color.dispose();
                }
            }
        });
        this.backgroundButton.setImage(this.backgroundImage);
        this.backgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RGB rGB;
                Color color = Tab.this.backgroundColor;
                if (color == null && ((Control[])(rGB = Tab.this.getExampleWidgets())).length > 0) {
                    color = rGB[0].getBackground();
                }
                if (color != null) {
                    colorDialog2.setRGB(color.getRGB());
                }
                if ((rGB = colorDialog2.open()) == null) {
                    return;
                }
                color = Tab.this.backgroundColor;
                Tab.this.backgroundColor = new Color((Device)selectionEvent.display, rGB);
                Tab.this.setExampleWidgetBackground();
                if (color != null) {
                    color.dispose();
                }
            }
        });
        this.fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FontData fontData;
                Font font = Tab.this.font;
                if (font == null && ((Control[])(fontData = Tab.this.getExampleWidgets())).length > 0) {
                    font = fontData[0].getFont();
                }
                if (font != null) {
                    fontDialog.setFontList(font.getFontData());
                }
                if ((fontData = fontDialog.open()) == null) {
                    return;
                }
                font = Tab.this.font;
                Tab.this.font = new Font((Device)selectionEvent.display, fontData);
                Tab.this.setExampleWidgetFont();
                Tab.this.setExampleWidgetSize();
                if (font != null) {
                    font.dispose();
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.resetColorsAndFonts();
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (Tab.this.foregroundImage != null) {
                    Tab.this.foregroundImage.dispose();
                }
                if (Tab.this.backgroundImage != null) {
                    Tab.this.backgroundImage.dispose();
                }
                if (Tab.this.foregroundColor != null) {
                    Tab.this.foregroundColor.dispose();
                }
                if (Tab.this.backgroundColor != null) {
                    Tab.this.backgroundColor.dispose();
                }
                if (Tab.this.font != null) {
                    Tab.this.font.dispose();
                }
                Tab.this.foregroundColor = null;
                Tab.this.backgroundColor = null;
                Tab.this.font = null;
            }
        });
    }

    void createOtherGroup() {
        this.otherGroup = new Group((Composite)this.controlGroup, 0);
        this.otherGroup.setLayout((Layout)new GridLayout());
        this.otherGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.otherGroup.setText(ControlExample.getResourceString("Other"));
        this.enabledButton = new Button((Composite)this.otherGroup, 32);
        this.enabledButton.setText(ControlExample.getResourceString("Enabled"));
        this.visibleButton = new Button((Composite)this.otherGroup, 32);
        this.visibleButton.setText(ControlExample.getResourceString("Visible"));
        this.enabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.setExampleWidgetEnabled();
            }
        });
        this.visibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.setExampleWidgetVisibility();
            }
        });
        this.enabledButton.setSelection(true);
        this.visibleButton.setSelection(true);
    }

    void createEventConsolePopup() {
        Menu menu = new Menu((Decorations)this.eventConsole.getShell(), 8);
        this.eventConsole.setMenu(menu);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(ControlExample.getResourceString("MenuItem_Cut"));
        menuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Tab.this.eventConsole.cut();
            }
        });
        MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.setText(ControlExample.getResourceString("MenuItem_Copy"));
        menuItem2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Tab.this.eventConsole.copy();
            }
        });
        MenuItem menuItem3 = new MenuItem(menu, 8);
        menuItem3.setText(ControlExample.getResourceString("MenuItem_Paste"));
        menuItem3.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Tab.this.eventConsole.paste();
            }
        });
        new MenuItem(menu, 2);
        MenuItem menuItem4 = new MenuItem(menu, 8);
        menuItem4.setText(ControlExample.getResourceString("MenuItem_SelectAll"));
        menuItem4.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Tab.this.eventConsole.selectAll();
            }
        });
    }

    void createExampleGroup() {
        this.exampleGroup = new Group(this.tabFolderPage, 0);
        this.exampleGroup.setLayout((Layout)new GridLayout());
        this.exampleGroup.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    void createExampleWidgets() {
    }

    void createListenerSelectionDialog() {
        TableItem tableItem;
        final Shell shell = new Shell(this.tabFolderPage.getShell(), 67680);
        shell.setText(ControlExample.getResourceString("Select_Listeners"));
        shell.setLayout((Layout)new GridLayout(2, false));
        final Table table = new Table((Composite)shell, 2592);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 2;
        table.setLayoutData((Object)gridData);
        for (int i = 0; i < EVENT_NAMES.length; ++i) {
            TableItem tableItem2 = new TableItem(table, 0);
            tableItem2.setText(EVENT_NAMES[i]);
            tableItem2.setChecked(this.eventsFilter[i]);
        }
        final String[] stringArray = this.getCustomEventNames();
        for (int i = 0; i < stringArray.length; ++i) {
            tableItem = new TableItem(table, 0);
            tableItem.setText(stringArray[i]);
            tableItem.setChecked(this.eventsFilter[EVENT_NAMES.length + i]);
        }
        Button button = new Button((Composite)shell, 8);
        button.setText(ControlExample.getResourceString("Select_All"));
        button.setLayoutData((Object)new GridData(256));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                TableItem[] tableItemArray = table.getItems();
                for (n = 0; n < EVENT_NAMES.length; ++n) {
                    tableItemArray[n].setChecked(true);
                }
                for (n = 0; n < stringArray.length; ++n) {
                    tableItemArray[EVENT_NAMES.length + n].setChecked(true);
                }
            }
        });
        tableItem = new Button((Composite)shell, 8);
        tableItem.setText(ControlExample.getResourceString("Deselect_All"));
        tableItem.setLayoutData((Object)new GridData(258));
        tableItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                TableItem[] tableItemArray = table.getItems();
                for (n = 0; n < EVENT_NAMES.length; ++n) {
                    tableItemArray[n].setChecked(false);
                }
                for (n = 0; n < stringArray.length; ++n) {
                    tableItemArray[EVENT_NAMES.length + n].setChecked(false);
                }
            }
        });
        new Label((Composite)shell, 0);
        Button button2 = new Button((Composite)shell, 8);
        button2.setText(ControlExample.getResourceString("OK"));
        shell.setDefaultButton(button2);
        button2.setLayoutData((Object)new GridData(256));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                TableItem[] tableItemArray = table.getItems();
                for (n = 0; n < EVENT_NAMES.length; ++n) {
                    Tab.this.eventsFilter[n] = tableItemArray[n].getChecked();
                }
                for (n = 0; n < stringArray.length; ++n) {
                    Tab.this.eventsFilter[Tab.EVENT_NAMES.length + n] = tableItemArray[EVENT_NAMES.length + n].getChecked();
                }
                shell.dispose();
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
    }

    void createListenersGroup() {
        this.listenersGroup = new Group(this.tabFolderPage, 0);
        this.listenersGroup.setLayout((Layout)new GridLayout(3, false));
        this.listenersGroup.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        this.listenersGroup.setText(ControlExample.getResourceString("Listeners"));
        Button button = new Button((Composite)this.listenersGroup, 8);
        button.setText(ControlExample.getResourceString("Select_Listeners"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.createListenerSelectionDialog();
                Tab.this.recreateExampleWidgets();
            }
        });
        final Button button2 = new Button((Composite)this.listenersGroup, 32);
        button2.setText(ControlExample.getResourceString("Listen"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.logging = button2.getSelection();
                Tab.this.recreateExampleWidgets();
            }
        });
        Button button3 = new Button((Composite)this.listenersGroup, 8);
        button3.setText(ControlExample.getResourceString("Clear"));
        button3.setLayoutData((Object)new GridData(128));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.eventConsole.setText("");
            }
        });
        int n = this.getCustomEventNames().length;
        this.eventsFilter = new boolean[EVENT_NAMES.length + n];
        for (int i = 0; i < EVENT_NAMES.length + n; ++i) {
            this.eventsFilter[i] = true;
        }
        this.eventConsole = new Text((Composite)this.listenersGroup, 2818);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 80;
        this.eventConsole.setLayoutData((Object)gridData);
        this.createEventConsolePopup();
        this.eventConsole.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if ((keyEvent.keyCode == 65 || keyEvent.keyCode == 97) && (keyEvent.stateMask & SWT.MOD1) != 0) {
                    Tab.this.eventConsole.selectAll();
                    keyEvent.doit = false;
                }
            }
        });
    }

    String[] getMethodNames() {
        return null;
    }

    void createSetGetDialog(int n, int n2, String[] stringArray) {
        Shell shell = new Shell(this.eventConsole.getShell(), 2160);
        shell.setLayout((Layout)new GridLayout(2, false));
        shell.setText(this.getTabText() + " " + ControlExample.getResourceString("Set_Get"));
        this.nameCombo = new Combo((Composite)shell, 0);
        this.nameCombo.setItems(stringArray);
        this.nameCombo.setText(stringArray[0]);
        this.nameCombo.setVisibleItemCount(stringArray.length);
        this.nameCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.nameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.resetLabels();
            }
        });
        this.returnTypeLabel = new Label((Composite)shell, 0);
        this.returnTypeLabel.setLayoutData((Object)new GridData(4, 1, false, false));
        this.setButton = new Button((Composite)shell, 8);
        this.setButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.setValue();
            }
        });
        this.setText = new Text((Composite)shell, 2052);
        this.setText.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.getButton = new Button((Composite)shell, 8);
        this.getButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.getButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Tab.this.getValue();
            }
        });
        this.getText = new Text((Composite)shell, 2826);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 240;
        gridData.heightHint = 200;
        this.getText.setLayoutData((Object)gridData);
        this.resetLabels();
        shell.setDefaultButton(this.setButton);
        shell.pack();
        shell.setLocation(n, n2);
        shell.open();
    }

    void resetLabels() {
        String string = this.nameCombo.getText();
        this.returnTypeLabel.setText(this.parameterInfo(string));
        this.setButton.setText(this.setMethodName(string));
        this.getButton.setText("get" + string);
        this.setText.setText("");
        this.getText.setText("");
        this.getValue();
        this.setText.setFocus();
    }

    String setMethodName(String string) {
        return "set" + string;
    }

    String parameterInfo(String string) {
        String string2 = null;
        Class clazz = this.getReturnType(string);
        boolean bl = clazz.isArray();
        string2 = bl ? clazz.getComponentType().getName() : clazz.getName();
        String string3 = string2;
        int n = string2.lastIndexOf(46);
        if (n != -1 && n + 1 < string2.length()) {
            string3 = string2.substring(n + 1);
        }
        String string4 = ControlExample.getResourceString("Info_" + string3 + (bl ? "A" : ""));
        if (bl) {
            string3 = string3 + "[]";
        }
        return ControlExample.getResourceString("Parameter_Info", new Object[]{string3, string4});
    }

    void getValue() {
        String string = "get" + this.nameCombo.getText();
        this.getText.setText("");
        Control[] controlArray = this.getExampleWidgets();
        for (int i = 0; i < controlArray.length; ++i) {
            try {
                Method method = controlArray[i].getClass().getMethod(string, null);
                Object object = method.invoke((Object)controlArray[i], (Object[])null);
                if (object == null) {
                    this.getText.append("null");
                } else if (object.getClass().isArray()) {
                    Object[] objectArray = (Object[])object;
                    for (int j = 0; j < objectArray.length; ++j) {
                        this.getText.append(objectArray[j].toString() + "\n");
                    }
                } else {
                    this.getText.append(object.toString());
                }
            }
            catch (Exception exception) {
                this.getText.append(exception.toString());
            }
            if (i + 1 >= controlArray.length) continue;
            this.getText.append("\n\n");
        }
    }

    Class getReturnType(String string) {
        Class<?> clazz = null;
        String string2 = "get" + string;
        Control[] controlArray = this.getExampleWidgets();
        try {
            Method method = controlArray[0].getClass().getMethod(string2, null);
            clazz = method.getReturnType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    void setValue() {
        String string = this.nameCombo.getText();
        Class clazz = this.getReturnType(string);
        String string2 = this.setMethodName(string);
        String string3 = this.setText.getText();
        Control[] controlArray = this.getExampleWidgets();
        for (int i = 0; i < controlArray.length; ++i) {
            try {
                Method method = controlArray[i].getClass().getMethod(string2, clazz);
                String string4 = clazz.getName();
                Object[] objectArray = null;
                if (string4.equals("int")) {
                    objectArray = new Object[]{Integer.valueOf(string3)};
                } else if (string4.equals("long")) {
                    objectArray = new Object[]{Long.valueOf(string3)};
                } else if (string4.equals("char")) {
                    objectArray = new Object[]{string3.length() == 1 ? Character.valueOf(string3.charAt(0)) : Character.valueOf('\u0000')};
                } else if (string4.equals("boolean")) {
                    objectArray = new Object[]{Boolean.valueOf(string3)};
                } else if (string4.equals("java.lang.String")) {
                    objectArray = new Object[]{string3};
                } else if (string4.equals("org.eclipse.swt.graphics.Point")) {
                    String[] stringArray = string3.split(",");
                    objectArray = new Object[]{new Point(Integer.valueOf(stringArray[0]).intValue(), Integer.valueOf(stringArray[1]).intValue())};
                } else {
                    objectArray = string4.equals("[Ljava.lang.String;") ? new Object[]{string3.split(",")} : this.parameterForType(string4, string3, controlArray[i]);
                }
                method.invoke((Object)controlArray[i], objectArray);
                continue;
            }
            catch (Exception exception) {
                this.getText.setText(exception.toString());
            }
        }
    }

    Object[] parameterForType(String string, String string2, Control control) {
        return new Object[]{string2};
    }

    void createOrientationGroup() {
        this.orientationGroup = new Group((Composite)this.controlGroup, 0);
        this.orientationGroup.setLayout((Layout)new GridLayout());
        this.orientationGroup.setLayoutData((Object)new GridData(272));
        this.orientationGroup.setText(ControlExample.getResourceString("Orientation"));
        this.defaultOrietationButton = new Button((Composite)this.orientationGroup, 16);
        this.defaultOrietationButton.setText(ControlExample.getResourceString("Default"));
        this.defaultOrietationButton.setSelection(true);
        this.ltrButton = new Button((Composite)this.orientationGroup, 16);
        this.ltrButton.setText("SWT.LEFT_TO_RIGHT");
        this.rtlButton = new Button((Composite)this.orientationGroup, 16);
        this.rtlButton.setText("SWT.RIGHT_TO_LEFT");
    }

    void createSizeGroup() {
        this.sizeGroup = new Group((Composite)this.controlGroup, 0);
        this.sizeGroup.setLayout((Layout)new GridLayout());
        this.sizeGroup.setLayoutData((Object)new GridData(272));
        this.sizeGroup.setText(ControlExample.getResourceString("Size"));
        this.preferredButton = new Button((Composite)this.sizeGroup, 16);
        this.preferredButton.setText(ControlExample.getResourceString("Preferred"));
        this.tooSmallButton = new Button((Composite)this.sizeGroup, 16);
        this.tooSmallButton.setText("10 X 10");
        this.smallButton = new Button((Composite)this.sizeGroup, 16);
        this.smallButton.setText("50 X 50");
        this.largeButton = new Button((Composite)this.sizeGroup, 16);
        this.largeButton.setText("100 X 100");
        this.fillButton = new Button((Composite)this.sizeGroup, 16);
        this.fillButton.setText(ControlExample.getResourceString("Fill"));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
                Tab.this.setExampleWidgetSize();
            }
        };
        this.preferredButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.tooSmallButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.smallButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.largeButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.fillButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.preferredButton.setSelection(true);
    }

    void createStyleGroup() {
        this.styleGroup = new Group((Composite)this.controlGroup, 0);
        this.styleGroup.setLayout((Layout)new GridLayout());
        this.styleGroup.setLayoutData((Object)new GridData(272));
        this.styleGroup.setText(ControlExample.getResourceString("Styles"));
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        this.tabFolderPage = new Composite((Composite)tabFolder, 0);
        this.tabFolderPage.setLayout((Layout)new GridLayout(2, false));
        this.createExampleGroup();
        this.createControlGroup();
        this.createListenersGroup();
        this.createExampleWidgets();
        this.hookExampleWidgetListeners();
        this.createControlWidgets();
        this.setExampleWidgetState();
        return this.tabFolderPage;
    }

    void disposeExampleWidgets() {
        Control[] controlArray = this.getExampleWidgets();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].dispose();
        }
    }

    void drawImage(Image image, Color color) {
        GC gC = new GC((Drawable)image);
        gC.setBackground(color);
        Rectangle rectangle = image.getBounds();
        gC.fillRectangle(0, 0, rectangle.width, rectangle.height);
        gC.drawRectangle(0, 0, rectangle.width - 1, rectangle.height - 1);
        gC.dispose();
    }

    String[] getCustomEventNames() {
        return new String[0];
    }

    int getDefaultStyle() {
        if (this.ltrButton != null && this.ltrButton.getSelection()) {
            return 0x2000000;
        }
        if (this.rtlButton != null && this.rtlButton.getSelection()) {
            return 0x4000000;
        }
        return 0;
    }

    Control[] getExampleWidgets() {
        return new Control[0];
    }

    Item[] getExampleWidgetItems() {
        return new Item[0];
    }

    String getTabText() {
        return "";
    }

    void hookExampleWidgetListeners() {
        if (this.logging) {
            Control[] controlArray = this.getExampleWidgets();
            for (int i = 0; i < controlArray.length; ++i) {
                this.hookListeners((Widget)controlArray[i]);
            }
            Item[] itemArray = this.getExampleWidgetItems();
            for (int i = 0; i < itemArray.length; ++i) {
                this.hookListeners((Widget)itemArray[i]);
            }
            String[] stringArray = this.getCustomEventNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.eventsFilter[EVENT_NAMES.length + i]) continue;
                this.hookCustomListener(stringArray[i]);
            }
        }
    }

    void hookCustomListener(String string) {
    }

    void hookListeners(Widget widget) {
        if (this.logging) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    Tab.this.log(event);
                }
            };
            for (int i = 0; i < EVENT_NAMES.length; ++i) {
                if (!this.eventsFilter[i]) continue;
                widget.addListener(i, listener);
            }
        }
    }

    void log(Event event) {
        String string = EVENT_NAMES[event.type] + " [" + event.type + "]: ";
        switch (event.type) {
            case 1: 
            case 2: {
                string = string + new KeyEvent(event).toString();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 32: 
            case 37: {
                string = string + new MouseEvent(event).toString();
                break;
            }
            case 9: {
                string = string + new PaintEvent(event).toString();
                break;
            }
            case 10: 
            case 11: {
                string = string + new ControlEvent(event).toString();
                break;
            }
            case 12: {
                string = string + new DisposeEvent(event).toString();
                break;
            }
            case 13: 
            case 14: {
                string = string + new SelectionEvent(event).toString();
                break;
            }
            case 15: 
            case 16: {
                string = string + new FocusEvent(event).toString();
                break;
            }
            case 17: 
            case 18: {
                string = string + new TreeEvent(event).toString();
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                string = string + new ShellEvent(event).toString();
                break;
            }
            case 22: 
            case 23: {
                string = string + (event.widget instanceof Menu ? new MenuEvent(event).toString() : event.toString());
                break;
            }
            case 24: {
                string = string + new ModifyEvent(event).toString();
                break;
            }
            case 25: {
                string = string + new VerifyEvent(event).toString();
                break;
            }
            case 28: {
                string = string + new HelpEvent(event).toString();
                break;
            }
            case 30: {
                string = string + new ArmEvent(event).toString();
                break;
            }
            case 31: {
                string = string + new TraverseEvent(event).toString();
                break;
            }
            default: {
                string = string + event.toString();
            }
        }
        this.eventConsole.append(string);
        this.eventConsole.append("\n");
    }

    void log(String string) {
        this.eventConsole.append(string);
        this.eventConsole.append("\n");
    }

    void log(String string, TypedEvent typedEvent) {
        this.eventConsole.append(string + ": ");
        this.eventConsole.append(typedEvent.toString());
        this.eventConsole.append("\n");
    }

    void recreateExampleWidgets() {
        this.disposeExampleWidgets();
        this.createExampleWidgets();
        this.hookExampleWidgetListeners();
        this.setExampleWidgetState();
    }

    void resetColorsAndFonts() {
        Color color = this.foregroundColor;
        this.foregroundColor = null;
        this.setExampleWidgetForeground();
        if (color != null) {
            color.dispose();
        }
        color = this.backgroundColor;
        this.backgroundColor = null;
        this.setExampleWidgetBackground();
        if (color != null) {
            color.dispose();
        }
        Font font = this.font;
        this.font = null;
        this.setExampleWidgetFont();
        this.setExampleWidgetSize();
        if (font != null) {
            font.dispose();
        }
    }

    void setExampleWidgetBackground() {
        if (this.backgroundButton == null) {
            return;
        }
        Control[] controlArray = this.getExampleWidgets();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].setBackground(this.backgroundColor);
        }
        Color color = this.backgroundColor;
        if (controlArray.length == 0) {
            return;
        }
        if (color == null) {
            color = controlArray[0].getBackground();
        }
        this.drawImage(this.backgroundImage, color);
        this.backgroundButton.setImage(this.backgroundImage);
    }

    void setExampleWidgetEnabled() {
        Control[] controlArray = this.getExampleWidgets();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].setEnabled(this.enabledButton.getSelection());
        }
    }

    void setExampleWidgetFont() {
        if (this.instance.startup) {
            return;
        }
        if (this.fontButton == null) {
            return;
        }
        Control[] controlArray = this.getExampleWidgets();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            control.setFont(this.font);
        }
    }

    void setExampleWidgetForeground() {
        if (this.foregroundButton == null) {
            return;
        }
        Control[] controlArray = this.getExampleWidgets();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].setForeground(this.foregroundColor);
        }
        Color color = this.foregroundColor;
        if (controlArray.length == 0) {
            return;
        }
        if (color == null) {
            color = controlArray[0].getForeground();
        }
        this.drawImage(this.foregroundImage, color);
        this.foregroundButton.setImage(this.foregroundImage);
    }

    void setExampleWidgetSize() {
        int n = -1;
        if (this.preferredButton == null) {
            return;
        }
        if (this.preferredButton.getSelection()) {
            n = -1;
        }
        if (this.tooSmallButton.getSelection()) {
            n = 10;
        }
        if (this.smallButton.getSelection()) {
            n = 50;
        }
        if (this.largeButton.getSelection()) {
            n = 100;
        }
        Control[] controlArray = this.getExampleWidgets();
        for (int i = 0; i < controlArray.length; ++i) {
            GridData gridData;
            if (this.fillButton.getSelection()) {
                gridData = new GridData(1808);
            } else {
                gridData = new GridData();
                gridData.widthHint = n;
                gridData.heightHint = n;
            }
            controlArray[i].setLayoutData((Object)gridData);
        }
        this.tabFolderPage.layout(controlArray);
    }

    void setExampleWidgetState() {
        this.setExampleWidgetEnabled();
        this.setExampleWidgetVisibility();
        this.setExampleWidgetBackground();
        this.setExampleWidgetForeground();
        this.setExampleWidgetFont();
        this.setExampleWidgetSize();
    }

    void setExampleWidgetVisibility() {
        Control[] controlArray = this.getExampleWidgets();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].setVisible(this.visibleButton.getSelection());
        }
    }
}

