/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

class TabFolderTab
extends Tab {
    TabFolder tabFolder1;
    Group tabFolderGroup;
    Button topButton;
    Button bottomButton;
    static String[] TabItems1 = new String[]{ControlExample.getResourceString("TabItem1_0"), ControlExample.getResourceString("TabItem1_1"), ControlExample.getResourceString("TabItem1_2")};

    TabFolderTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.tabFolderGroup = new Group((Composite)this.exampleGroup, 0);
        this.tabFolderGroup.setLayout((Layout)new GridLayout());
        this.tabFolderGroup.setLayoutData((Object)new GridData(784));
        this.tabFolderGroup.setText("TabFolder");
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.topButton.getSelection()) {
            n |= 0x80;
        }
        if (this.bottomButton.getSelection()) {
            n |= 0x400;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        this.tabFolder1 = new TabFolder((Composite)this.tabFolderGroup, n);
        for (int i = 0; i < TabItems1.length; ++i) {
            TabItem tabItem = new TabItem(this.tabFolder1, 0);
            tabItem.setText(TabItems1[i]);
            Text text = new Text((Composite)this.tabFolder1, 66);
            text.setText(ControlExample.getResourceString("TabItem_content") + ": " + i);
            tabItem.setControl((Control)text);
        }
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.topButton = new Button((Composite)this.styleGroup, 16);
        this.topButton.setText("SWT.TOP");
        this.topButton.setSelection(true);
        this.bottomButton = new Button((Composite)this.styleGroup, 16);
        this.bottomButton.setText("SWT.BOTTOM");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
                TabFolderTab.this.recreateExampleWidgets();
            }
        };
        this.topButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.bottomButton.addSelectionListener((SelectionListener)selectionAdapter);
    }

    @Override
    Item[] getExampleWidgetItems() {
        return this.tabFolder1.getItems();
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.tabFolder1};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Selection", "SelectionIndex"};
    }

    @Override
    String setMethodName(String string) {
        return string.equals("SelectionIndex") ? "setSelection" : "set" + string;
    }

    @Override
    Object[] parameterForType(String string, String string2, Control control) {
        String[] stringArray;
        if (string2.equals("")) {
            return new Object[]{new TabItem[0]};
        }
        if (string.equals("org.eclipse.swt.widgets.TabItem") && (stringArray = this.findItem(string2, ((TabFolder)control).getItems())) != null) {
            return new Object[]{stringArray};
        }
        if (string.equals("[Lorg.eclipse.swt.widgets.TabItem;")) {
            stringArray = string2.split(",");
            TabItem[] tabItemArray = new TabItem[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                tabItemArray[i] = this.findItem(stringArray[i], ((TabFolder)control).getItems());
            }
            return new Object[]{tabItemArray};
        }
        return super.parameterForType(string, string2, control);
    }

    TabItem findItem(String string, TabItem[] tabItemArray) {
        for (int i = 0; i < tabItemArray.length; ++i) {
            TabItem tabItem = tabItemArray[i];
            if (!tabItem.getText().equals(string)) continue;
            return tabItem;
        }
        return null;
    }

    @Override
    String getTabText() {
        return "TabFolder";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.topButton.setSelection((this.tabFolder1.getStyle() & 0x80) != 0);
        this.bottomButton.setSelection((this.tabFolder1.getStyle() & 0x400) != 0);
        this.borderButton.setSelection((this.tabFolder1.getStyle() & 0x800) != 0);
    }
}

