/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class TableTab
extends ScrollableTab {
    Table table1;
    Group tableGroup;
    Group itemGroup;
    Button checkButton;
    Button fullSelectionButton;
    Button hideSelectionButton;
    Button multipleColumns;
    Button moveableColumns;
    Button headerVisibleButton;
    Button linesVisibleButton;
    Button itemForegroundButton;
    Button itemBackgroundButton;
    Button itemFontButton;
    Color itemForegroundColor;
    Color itemBackgroundColor;
    Image itemForegroundImage;
    Image itemBackgroundImage;
    Font itemFont;
    static String[] columnTitles = new String[]{ControlExample.getResourceString("TableTitle_0"), ControlExample.getResourceString("TableTitle_1"), ControlExample.getResourceString("TableTitle_2"), ControlExample.getResourceString("TableTitle_3")};
    static String[][] tableData = new String[][]{{ControlExample.getResourceString("TableLine0_0"), ControlExample.getResourceString("TableLine0_1"), ControlExample.getResourceString("TableLine0_2"), ControlExample.getResourceString("TableLine0_3")}, {ControlExample.getResourceString("TableLine1_0"), ControlExample.getResourceString("TableLine1_1"), ControlExample.getResourceString("TableLine1_2"), ControlExample.getResourceString("TableLine1_3")}, {ControlExample.getResourceString("TableLine2_0"), ControlExample.getResourceString("TableLine2_1"), ControlExample.getResourceString("TableLine2_2"), ControlExample.getResourceString("TableLine2_3")}};

    TableTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createColorGroup() {
        super.createColorGroup();
        this.itemGroup = new Group((Composite)this.colorGroup, 0);
        this.itemGroup.setText(ControlExample.getResourceString("Table_Item_Colors"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.itemGroup.setLayoutData((Object)gridData);
        this.itemGroup.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this.itemGroup, 0).setText(ControlExample.getResourceString("Foreground_Color"));
        this.itemForegroundButton = new Button((Composite)this.itemGroup, 8);
        new Label((Composite)this.itemGroup, 0).setText(ControlExample.getResourceString("Background_Color"));
        this.itemBackgroundButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton.setText(ControlExample.getResourceString("Font"));
        this.itemFontButton.setLayoutData((Object)new GridData(256));
        Shell shell = this.colorGroup.getShell();
        final ColorDialog colorDialog = new ColorDialog(shell);
        final ColorDialog colorDialog2 = new ColorDialog(shell);
        final FontDialog fontDialog = new FontDialog(shell);
        int n = 12;
        Display display = shell.getDisplay();
        this.itemForegroundImage = new Image((Device)display, n, n);
        this.itemBackgroundImage = new Image((Device)display, n, n);
        this.itemForegroundButton.setImage(this.itemForegroundImage);
        this.itemForegroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Color color = TableTab.this.itemForegroundColor;
                if (color == null) {
                    color = TableTab.this.table1.getItem(0).getForeground();
                }
                colorDialog.setRGB(color.getRGB());
                RGB rGB = colorDialog.open();
                if (rGB == null) {
                    return;
                }
                color = TableTab.this.itemForegroundColor;
                TableTab.this.itemForegroundColor = new Color((Device)selectionEvent.display, rGB);
                TableTab.this.setItemForeground();
                if (color != null) {
                    color.dispose();
                }
            }
        });
        this.itemBackgroundButton.setImage(this.itemBackgroundImage);
        this.itemBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Color color = TableTab.this.itemBackgroundColor;
                if (color == null) {
                    color = TableTab.this.table1.getItem(0).getBackground();
                }
                colorDialog2.setRGB(color.getRGB());
                RGB rGB = colorDialog2.open();
                if (rGB == null) {
                    return;
                }
                color = TableTab.this.itemBackgroundColor;
                TableTab.this.itemBackgroundColor = new Color((Device)selectionEvent.display, rGB);
                TableTab.this.setItemBackground();
                if (color != null) {
                    color.dispose();
                }
            }
        });
        this.itemFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Font font = TableTab.this.itemFont;
                if (font == null) {
                    font = TableTab.this.table1.getItem(0).getFont();
                }
                fontDialog.setFontList(font.getFontData());
                FontData fontData = fontDialog.open();
                if (fontData == null) {
                    return;
                }
                font = TableTab.this.itemFont;
                TableTab.this.itemFont = new Font((Device)selectionEvent.display, fontData);
                TableTab.this.setItemFont();
                TableTab.this.setExampleWidgetSize();
                if (font != null) {
                    font.dispose();
                }
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (TableTab.this.itemBackgroundImage != null) {
                    TableTab.this.itemBackgroundImage.dispose();
                }
                if (TableTab.this.itemForegroundImage != null) {
                    TableTab.this.itemForegroundImage.dispose();
                }
                if (TableTab.this.itemBackgroundColor != null) {
                    TableTab.this.itemBackgroundColor.dispose();
                }
                if (TableTab.this.itemForegroundColor != null) {
                    TableTab.this.itemForegroundColor.dispose();
                }
                if (TableTab.this.itemFont != null) {
                    TableTab.this.itemFont.dispose();
                }
                TableTab.this.itemBackgroundColor = null;
                TableTab.this.itemForegroundColor = null;
                TableTab.this.itemFont = null;
            }
        });
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.headerVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.headerVisibleButton.setText(ControlExample.getResourceString("Header_Visible"));
        this.multipleColumns = new Button((Composite)this.otherGroup, 32);
        this.multipleColumns.setText(ControlExample.getResourceString("Multiple_Columns"));
        this.multipleColumns.setSelection(true);
        this.moveableColumns = new Button((Composite)this.otherGroup, 32);
        this.moveableColumns.setText(ControlExample.getResourceString("Moveable_Columns"));
        this.moveableColumns.setSelection(false);
        this.linesVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.linesVisibleButton.setText(ControlExample.getResourceString("Lines_Visible"));
        this.headerVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableTab.this.setWidgetHeaderVisible();
            }
        });
        this.multipleColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableTab.this.recreateExampleWidgets();
            }
        });
        this.moveableColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableTab.this.setColumnsMoveable();
            }
        });
        this.linesVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableTab.this.setWidgetLinesVisible();
            }
        });
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.tableGroup = new Group((Composite)this.exampleGroup, 0);
        this.tableGroup.setLayout((Layout)new GridLayout());
        this.tableGroup.setLayoutData((Object)new GridData(784));
        this.tableGroup.setText("Table");
    }

    @Override
    void createExampleWidgets() {
        TableColumn tableColumn;
        int n;
        int n2 = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            n2 |= 4;
        }
        if (this.multiButton.getSelection()) {
            n2 |= 2;
        }
        if (this.verticalButton.getSelection()) {
            n2 |= 0x200;
        }
        if (this.horizontalButton.getSelection()) {
            n2 |= 0x100;
        }
        if (this.checkButton.getSelection()) {
            n2 |= 0x20;
        }
        if (this.fullSelectionButton.getSelection()) {
            n2 |= 0x10000;
        }
        if (this.hideSelectionButton.getSelection()) {
            n2 |= 0x8000;
        }
        if (this.borderButton.getSelection()) {
            n2 |= 0x800;
        }
        this.table1 = new Table((Composite)this.tableGroup, n2);
        if (this.multipleColumns.getSelection()) {
            for (n = 0; n < columnTitles.length; ++n) {
                tableColumn = new TableColumn(this.table1, 0);
                tableColumn.setText(columnTitles[n]);
            }
        } else {
            new TableColumn(this.table1, 0);
        }
        this.setColumnsMoveable();
        for (n = 0; n < 16; ++n) {
            tableColumn = new TableItem(this.table1, 0);
            tableColumn.setImage(this.instance.images[n % 3]);
            this.setItemText((TableItem)tableColumn, n, ControlExample.getResourceString("Index") + n);
        }
        this.packColumns();
    }

    void setItemText(TableItem tableItem, int n, String string) {
        int n2 = n % 3;
        if (this.multipleColumns.getSelection()) {
            TableTab.tableData[n2][0] = string;
            tableItem.setText(tableData[n2]);
        } else {
            tableItem.setText(string);
        }
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.checkButton = new Button((Composite)this.styleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
        this.hideSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.hideSelectionButton.setText("SWT.HIDE_SELECTION");
    }

    @Override
    Item[] getExampleWidgetItems() {
        TableColumn[] tableColumnArray = this.table1.getColumns();
        TableItem[] tableItemArray = this.table1.getItems();
        Item[] itemArray = new Item[tableColumnArray.length + tableItemArray.length];
        System.arraycopy(tableColumnArray, 0, itemArray, 0, tableColumnArray.length);
        System.arraycopy(tableItemArray, 0, itemArray, tableColumnArray.length, tableItemArray.length);
        return itemArray;
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.table1};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"ItemCount", "Selection", "SelectionIndex", "TopIndex"};
    }

    @Override
    String setMethodName(String string) {
        return string.equals("SelectionIndex") ? "setSelection" : "set" + string;
    }

    @Override
    Object[] parameterForType(String string, String string2, Control control) {
        String[] stringArray;
        if (string2.equals("")) {
            return new Object[]{new TableItem[0]};
        }
        if (string.equals("org.eclipse.swt.widgets.TableItem") && (stringArray = this.findItem(string2, ((Table)control).getItems())) != null) {
            return new Object[]{stringArray};
        }
        if (string.equals("[Lorg.eclipse.swt.widgets.TableItem;")) {
            stringArray = string2.split(",");
            TableItem[] tableItemArray = new TableItem[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                tableItemArray[i] = this.findItem(stringArray[i], ((Table)control).getItems());
            }
            return new Object[]{tableItemArray};
        }
        return super.parameterForType(string, string2, control);
    }

    TableItem findItem(String string, TableItem[] tableItemArray) {
        for (int i = 0; i < tableItemArray.length; ++i) {
            TableItem tableItem = tableItemArray[i];
            if (!tableItem.getText().equals(string)) continue;
            return tableItem;
        }
        return null;
    }

    @Override
    String getTabText() {
        return "Table";
    }

    @Override
    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        Color color = this.itemForegroundColor;
        this.itemForegroundColor = null;
        this.setItemForeground();
        if (color != null) {
            color.dispose();
        }
        color = this.itemBackgroundColor;
        this.itemBackgroundColor = null;
        this.setItemBackground();
        if (color != null) {
            color.dispose();
        }
        Font font = this.font;
        this.itemFont = null;
        this.setItemFont();
        this.setExampleWidgetSize();
        if (font != null) {
            font.dispose();
        }
    }

    void setItemBackground() {
        this.table1.getItem(0).setBackground(this.itemBackgroundColor);
        Color color = this.itemBackgroundColor;
        if (color == null) {
            color = this.table1.getItem(0).getBackground();
        }
        this.drawImage(this.itemBackgroundImage, color);
        this.itemBackgroundButton.setImage(this.itemBackgroundImage);
    }

    void setItemForeground() {
        this.table1.getItem(0).setForeground(this.itemForegroundColor);
        Color color = this.itemForegroundColor;
        if (color == null) {
            color = this.table1.getItem(0).getForeground();
        }
        this.drawImage(this.itemForegroundImage, color);
        this.itemForegroundButton.setImage(this.itemForegroundImage);
    }

    void setItemFont() {
        if (this.instance.startup) {
            return;
        }
        this.table1.getItem(0).setFont(this.itemFont);
        this.packColumns();
    }

    @Override
    void setExampleWidgetFont() {
        super.setExampleWidgetFont();
        this.packColumns();
    }

    void packColumns() {
        int n = this.table1.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table1.getColumn(i);
            tableColumn.pack();
        }
    }

    void setColumnsMoveable() {
        boolean bl = this.moveableColumns.getSelection();
        TableColumn[] tableColumnArray = this.table1.getColumns();
        for (int i = 0; i < tableColumnArray.length; ++i) {
            tableColumnArray[i].setMoveable(bl);
        }
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setItemBackground();
        this.setItemForeground();
        this.setItemFont();
        this.setExampleWidgetSize();
        this.setWidgetHeaderVisible();
        this.setWidgetLinesVisible();
        this.checkButton.setSelection((this.table1.getStyle() & 0x20) != 0);
        this.fullSelectionButton.setSelection((this.table1.getStyle() & 0x10000) != 0);
        this.hideSelectionButton.setSelection((this.table1.getStyle() & 0x8000) != 0);
    }

    void setWidgetHeaderVisible() {
        this.table1.setHeaderVisible(this.headerVisibleButton.getSelection());
    }

    void setWidgetLinesVisible() {
        this.table1.setLinesVisible(this.linesVisibleButton.getSelection());
    }
}

