/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;

class TextTab
extends ScrollableTab {
    Text text;
    Group textGroup;
    Button wrapButton;
    Button readOnlyButton;
    Button passwordButton;

    TextTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.textGroup = new Group((Composite)this.exampleGroup, 0);
        this.textGroup.setLayout((Layout)new GridLayout());
        this.textGroup.setLayoutData((Object)new GridData(784));
        this.textGroup.setText("Text");
    }

    @Override
    void createExampleWidgets() {
        int n = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            n |= 4;
        }
        if (this.multiButton.getSelection()) {
            n |= 2;
        }
        if (this.horizontalButton.getSelection()) {
            n |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            n |= 0x200;
        }
        if (this.wrapButton.getSelection()) {
            n |= 0x40;
        }
        if (this.readOnlyButton.getSelection()) {
            n |= 8;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.passwordButton.getSelection()) {
            n |= 0x400000;
        }
        this.text = new Text((Composite)this.textGroup, n);
        this.text.setText(ControlExample.getResourceString("Example_string") + Text.DELIMITER + ControlExample.getResourceString("One_Two_Three") + Text.DELIMITER + "Dirk war hier" + Text.DELIMITER + "ganz lang" + Text.DELIMITER + "noch l\u00e4nger" + Text.DELIMITER + "wir brauchen 6 Zeilen");
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.readOnlyButton = new Button((Composite)this.styleGroup, 32);
        this.readOnlyButton.setText("SWT.READ_ONLY");
        this.passwordButton = new Button((Composite)this.styleGroup, 32);
        this.passwordButton.setText("SWT.PASSWORD");
    }

    @Override
    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                TextTab.this.setExampleWidgetSize();
            }
        });
        return this.tabFolderPage;
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.text};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"DoubleClickEnabled", "EchoChar", "Editable", "Orientation", "Selection", "Tabs", "Text", "TextLimit", "TopIndex"};
    }

    @Override
    String getTabText() {
        return "Text";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.wrapButton.setSelection((this.text.getStyle() & 0x40) != 0);
        this.readOnlyButton.setSelection((this.text.getStyle() & 8) != 0);
        this.passwordButton.setSelection((this.text.getStyle() & 0x400000) != 0);
        this.wrapButton.setEnabled((this.text.getStyle() & 2) != 0);
        this.horizontalButton.setEnabled((this.text.getStyle() & 2) != 0);
        this.verticalButton.setEnabled((this.text.getStyle() & 2) != 0);
    }
}

