/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class ToolBarTab
extends Tab {
    ToolBar imageToolBar;
    ToolBar textToolBar;
    ToolBar imageTextToolBar;
    Group imageToolBarGroup;
    Group textToolBarGroup;
    Group imageTextToolBarGroup;
    Button horizontalButton;
    Button verticalButton;
    Button flatButton;
    Button shadowOutButton;
    Button wrapButton;
    Button rightButton;
    Button comboChildButton;

    ToolBarTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.imageToolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.imageToolBarGroup.setLayout((Layout)new GridLayout());
        this.imageToolBarGroup.setLayoutData((Object)new GridData(784));
        this.imageToolBarGroup.setText(ControlExample.getResourceString("Image_ToolBar"));
        this.textToolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.textToolBarGroup.setLayout((Layout)new GridLayout());
        this.textToolBarGroup.setLayoutData((Object)new GridData(784));
        this.textToolBarGroup.setText(ControlExample.getResourceString("Text_ToolBar"));
        this.imageTextToolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.imageTextToolBarGroup.setLayout((Layout)new GridLayout());
        this.imageTextToolBarGroup.setLayoutData((Object)new GridData(784));
        this.imageTextToolBarGroup.setText(ControlExample.getResourceString("ImageText_ToolBar"));
    }

    @Override
    void createExampleWidgets() {
        Combo combo;
        int n = this.getDefaultStyle();
        if (this.horizontalButton.getSelection()) {
            n |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            n |= 0x200;
        }
        if (this.flatButton.getSelection()) {
            n |= 0x800000;
        }
        if (this.wrapButton.getSelection()) {
            n |= 0x40;
        }
        if (this.borderButton.getSelection()) {
            n |= 0x800;
        }
        if (this.shadowOutButton.getSelection()) {
            n |= 8;
        }
        if (this.rightButton.getSelection()) {
            n |= 0x20000;
        }
        this.imageToolBar = new ToolBar((Composite)this.imageToolBarGroup, n);
        ToolItem toolItem = new ToolItem(this.imageToolBar, 8);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.PUSH");
        toolItem = new ToolItem(this.imageToolBar, 8);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.PUSH");
        toolItem = new ToolItem(this.imageToolBar, 16);
        toolItem.setImage(this.instance.images[1]);
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.imageToolBar, 16);
        toolItem.setImage(this.instance.images[1]);
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.imageToolBar, 32);
        toolItem.setImage(this.instance.images[2]);
        toolItem.setToolTipText("SWT.CHECK");
        toolItem = new ToolItem(this.imageToolBar, 16);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.imageToolBar, 16);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.imageToolBar, 2);
        toolItem.setToolTipText("SWT.SEPARATOR");
        if (this.comboChildButton.getSelection()) {
            combo = new Combo((Composite)this.imageToolBar, 0);
            combo.setItems(new String[]{"250", "500", "750"});
            combo.setText(combo.getItem(0));
            combo.pack();
            toolItem.setWidth(combo.getSize().x);
            toolItem.setControl((Control)combo);
        }
        toolItem = new ToolItem(this.imageToolBar, 4);
        toolItem.setImage(this.instance.images[2]);
        toolItem.setToolTipText("SWT.DROP_DOWN");
        toolItem.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        this.textToolBar = new ToolBar((Composite)this.textToolBarGroup, n);
        toolItem = new ToolItem(this.textToolBar, 8);
        toolItem.setText(ControlExample.getResourceString("Push"));
        toolItem.setToolTipText("SWT.PUSH");
        toolItem = new ToolItem(this.textToolBar, 8);
        toolItem.setText(ControlExample.getResourceString("Push"));
        toolItem.setToolTipText("SWT.PUSH");
        toolItem = new ToolItem(this.textToolBar, 16);
        toolItem.setText(ControlExample.getResourceString("Radio"));
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.textToolBar, 16);
        toolItem.setText(ControlExample.getResourceString("Radio"));
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.textToolBar, 32);
        toolItem.setText(ControlExample.getResourceString("Check"));
        toolItem.setToolTipText("SWT.CHECK");
        toolItem = new ToolItem(this.textToolBar, 16);
        toolItem.setText(ControlExample.getResourceString("Radio"));
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.textToolBar, 16);
        toolItem.setText(ControlExample.getResourceString("Radio"));
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.textToolBar, 2);
        toolItem.setToolTipText("SWT.SEPARATOR");
        if (this.comboChildButton.getSelection()) {
            combo = new Combo((Composite)this.textToolBar, 0);
            combo.setItems(new String[]{"250", "500", "750"});
            combo.setText(combo.getItem(0));
            combo.pack();
            toolItem.setWidth(combo.getSize().x);
            toolItem.setControl((Control)combo);
        }
        toolItem = new ToolItem(this.textToolBar, 4);
        toolItem.setText(ControlExample.getResourceString("Drop_Down"));
        toolItem.setToolTipText("SWT.DROP_DOWN");
        toolItem.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        this.imageTextToolBar = new ToolBar((Composite)this.imageTextToolBarGroup, n);
        toolItem = new ToolItem(this.imageTextToolBar, 8);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setText(ControlExample.getResourceString("Push"));
        toolItem.setToolTipText("SWT.PUSH");
        toolItem = new ToolItem(this.imageTextToolBar, 8);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setText(ControlExample.getResourceString("Push"));
        toolItem.setToolTipText("SWT.PUSH");
        toolItem = new ToolItem(this.imageTextToolBar, 16);
        toolItem.setImage(this.instance.images[1]);
        toolItem.setText(ControlExample.getResourceString("Radio"));
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.imageTextToolBar, 16);
        toolItem.setImage(this.instance.images[1]);
        toolItem.setText(ControlExample.getResourceString("Radio"));
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.imageTextToolBar, 32);
        toolItem.setImage(this.instance.images[2]);
        toolItem.setText(ControlExample.getResourceString("Check"));
        toolItem.setToolTipText("SWT.CHECK");
        toolItem = new ToolItem(this.imageTextToolBar, 16);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setText(ControlExample.getResourceString("Radio"));
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.imageTextToolBar, 16);
        toolItem.setImage(this.instance.images[0]);
        toolItem.setText(ControlExample.getResourceString("Radio"));
        toolItem.setToolTipText("SWT.RADIO");
        toolItem = new ToolItem(this.imageTextToolBar, 2);
        toolItem.setToolTipText("SWT.SEPARATOR");
        if (this.comboChildButton.getSelection()) {
            combo = new Combo((Composite)this.imageTextToolBar, 0);
            combo.setItems(new String[]{"250", "500", "750"});
            combo.setText(combo.getItem(0));
            combo.pack();
            toolItem.setWidth(combo.getSize().x);
            toolItem.setControl((Control)combo);
        }
        toolItem = new ToolItem(this.imageTextToolBar, 4);
        toolItem.setImage(this.instance.images[2]);
        toolItem.setText(ControlExample.getResourceString("Drop_Down"));
        toolItem.setToolTipText("SWT.DROP_DOWN");
        toolItem.addSelectionListener((SelectionListener)new DropDownSelectionListener());
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.comboChildButton = new Button((Composite)this.otherGroup, 32);
        this.comboChildButton.setText(ControlExample.getResourceString("Combo_child"));
        this.comboChildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarTab.this.recreateExampleWidgets();
            }
        });
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.horizontalButton = new Button((Composite)this.styleGroup, 16);
        this.horizontalButton.setText("SWT.HORIZONTAL");
        this.verticalButton = new Button((Composite)this.styleGroup, 16);
        this.verticalButton.setText("SWT.VERTICAL");
        this.flatButton = new Button((Composite)this.styleGroup, 32);
        this.flatButton.setText("SWT.FLAT");
        this.shadowOutButton = new Button((Composite)this.styleGroup, 32);
        this.shadowOutButton.setText("SWT.SHADOW_OUT");
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.rightButton = new Button((Composite)this.styleGroup, 32);
        this.rightButton.setText("SWT.RIGHT");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    @Override
    void disposeExampleWidgets() {
        super.disposeExampleWidgets();
    }

    @Override
    Item[] getExampleWidgetItems() {
        ToolItem[] toolItemArray = this.imageToolBar.getItems();
        ToolItem[] toolItemArray2 = this.textToolBar.getItems();
        ToolItem[] toolItemArray3 = this.imageTextToolBar.getItems();
        Item[] itemArray = new Item[toolItemArray.length + toolItemArray2.length + toolItemArray3.length];
        System.arraycopy(toolItemArray, 0, itemArray, 0, toolItemArray.length);
        System.arraycopy(toolItemArray2, 0, itemArray, toolItemArray.length, toolItemArray2.length);
        System.arraycopy(toolItemArray3, 0, itemArray, toolItemArray.length + toolItemArray2.length, toolItemArray3.length);
        return itemArray;
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.imageToolBar, this.textToolBar, this.imageTextToolBar};
    }

    @Override
    String getTabText() {
        return "ToolBar";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.horizontalButton.setSelection((this.imageToolBar.getStyle() & 0x100) != 0);
        this.verticalButton.setSelection((this.imageToolBar.getStyle() & 0x200) != 0);
        this.flatButton.setSelection((this.imageToolBar.getStyle() & 0x800000) != 0);
        this.wrapButton.setSelection((this.imageToolBar.getStyle() & 0x40) != 0);
        this.shadowOutButton.setSelection((this.imageToolBar.getStyle() & 8) != 0);
        this.borderButton.setSelection((this.imageToolBar.getStyle() & 0x800) != 0);
        this.rightButton.setSelection((this.imageToolBar.getStyle() & 0x20000) != 0);
    }

    class DropDownSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;
        private boolean visible = false;

        DropDownSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Point point;
            Object object;
            Shell shell;
            if (this.menu == null) {
                shell = ToolBarTab.this.tabFolderPage.getShell();
                this.menu = new Menu((Control)shell);
                for (int i = 0; i < 9; ++i) {
                    object = ControlExample.getResourceString("DropDownData_" + i);
                    if (((String)object).length() != 0) {
                        point = new MenuItem(this.menu, 0);
                        point.setText((String)object);
                        point.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                DropDownSelectionListener.this.setMenuVisible(false);
                            }
                        });
                        continue;
                    }
                    new MenuItem(this.menu, 2);
                }
            }
            if (selectionEvent.detail == 4) {
                if (this.visible) {
                    this.setMenuVisible(false);
                } else {
                    shell = (ToolItem)selectionEvent.widget;
                    ToolBar toolBar = shell.getParent();
                    object = shell.getBounds();
                    point = toolBar.toDisplay(new Point(((Rectangle)object).x, ((Rectangle)object).y));
                    this.menu.setLocation(point.x, point.y + ((Rectangle)object).height);
                    this.setMenuVisible(true);
                }
            }
        }

        private void setMenuVisible(boolean bl) {
            this.menu.setVisible(bl);
            this.visible = bl;
        }
    }
}

