/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

class TreeTab
extends ScrollableTab {
    Tree tree1;
    Tree tree2;
    TreeItem textNode1;
    TreeItem imageNode1;
    Group treeGroup;
    Group imageTreeGroup;
    Group itemGroup;
    Button checkButton;
    Button fullSelectionButton;
    Button multipleColumns;
    Button headerVisibleButton;
    Button linesVisibleButton;
    Button itemForegroundButton;
    Button itemBackgroundButton;
    Button itemFontButton;
    Color itemForegroundColor;
    Color itemBackgroundColor;
    Image itemForegroundImage;
    Image itemBackgroundImage;
    Font itemFont;
    static String[] columnTitles = new String[]{ControlExample.getResourceString("TableTitle_0"), ControlExample.getResourceString("TableTitle_1"), ControlExample.getResourceString("TableTitle_2"), ControlExample.getResourceString("TableTitle_3")};
    static String[][] tableData = new String[][]{{ControlExample.getResourceString("TableLine0_0"), ControlExample.getResourceString("TableLine0_1"), ControlExample.getResourceString("TableLine0_2"), ControlExample.getResourceString("TableLine0_3")}, {ControlExample.getResourceString("TableLine1_0"), ControlExample.getResourceString("TableLine1_1"), ControlExample.getResourceString("TableLine1_2"), ControlExample.getResourceString("TableLine1_3")}, {ControlExample.getResourceString("TableLine2_0"), ControlExample.getResourceString("TableLine2_1"), ControlExample.getResourceString("TableLine2_2"), ControlExample.getResourceString("TableLine2_3")}};

    TreeTab(ControlExample controlExample) {
        super(controlExample);
    }

    @Override
    void createColorGroup() {
        super.createColorGroup();
        this.itemGroup = new Group((Composite)this.colorGroup, 0);
        this.itemGroup.setText(ControlExample.getResourceString("Tree_Item_Colors"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.itemGroup.setLayoutData((Object)gridData);
        this.itemGroup.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this.itemGroup, 0).setText(ControlExample.getResourceString("Foreground_Color"));
        this.itemForegroundButton = new Button((Composite)this.itemGroup, 8);
        new Label((Composite)this.itemGroup, 0).setText(ControlExample.getResourceString("Background_Color"));
        this.itemBackgroundButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton.setText(ControlExample.getResourceString("Font"));
        this.itemFontButton.setLayoutData((Object)new GridData(256));
        Shell shell = this.colorGroup.getShell();
        final ColorDialog colorDialog = new ColorDialog(shell);
        final ColorDialog colorDialog2 = new ColorDialog(shell);
        final FontDialog fontDialog = new FontDialog(shell);
        int n = 12;
        Display display = shell.getDisplay();
        this.itemForegroundImage = new Image((Device)display, n, n);
        this.itemBackgroundImage = new Image((Device)display, n, n);
        this.itemForegroundButton.setImage(this.itemForegroundImage);
        this.itemForegroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Color color = TreeTab.this.itemForegroundColor;
                if (color == null) {
                    color = TreeTab.this.textNode1.getForeground();
                }
                colorDialog.setRGB(color.getRGB());
                RGB rGB = colorDialog.open();
                if (rGB == null) {
                    return;
                }
                color = TreeTab.this.itemForegroundColor;
                TreeTab.this.itemForegroundColor = new Color((Device)selectionEvent.display, rGB);
                TreeTab.this.setItemForeground();
                if (color != null) {
                    color.dispose();
                }
            }
        });
        this.itemBackgroundButton.setImage(this.itemBackgroundImage);
        this.itemBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Color color = TreeTab.this.itemBackgroundColor;
                if (color == null) {
                    color = TreeTab.this.textNode1.getBackground();
                }
                colorDialog2.setRGB(color.getRGB());
                RGB rGB = colorDialog2.open();
                if (rGB == null) {
                    return;
                }
                color = TreeTab.this.itemBackgroundColor;
                TreeTab.this.itemBackgroundColor = new Color((Device)selectionEvent.display, rGB);
                TreeTab.this.setItemBackground();
                if (color != null) {
                    color.dispose();
                }
            }
        });
        this.itemFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Font font = TreeTab.this.itemFont;
                if (font == null) {
                    font = TreeTab.this.textNode1.getFont();
                }
                fontDialog.setFontList(font.getFontData());
                FontData fontData = fontDialog.open();
                if (fontData == null) {
                    return;
                }
                font = TreeTab.this.itemFont;
                TreeTab.this.itemFont = new Font((Device)selectionEvent.display, fontData);
                TreeTab.this.setItemFont();
                TreeTab.this.setExampleWidgetSize();
                if (font != null) {
                    font.dispose();
                }
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (TreeTab.this.itemBackgroundImage != null) {
                    TreeTab.this.itemBackgroundImage.dispose();
                }
                if (TreeTab.this.itemForegroundImage != null) {
                    TreeTab.this.itemForegroundImage.dispose();
                }
                if (TreeTab.this.itemBackgroundColor != null) {
                    TreeTab.this.itemBackgroundColor.dispose();
                }
                if (TreeTab.this.itemForegroundColor != null) {
                    TreeTab.this.itemForegroundColor.dispose();
                }
                if (TreeTab.this.itemFont != null) {
                    TreeTab.this.itemFont.dispose();
                }
                TreeTab.this.itemBackgroundColor = null;
                TreeTab.this.itemForegroundColor = null;
                TreeTab.this.itemFont = null;
            }
        });
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.multipleColumns = new Button((Composite)this.otherGroup, 32);
        this.multipleColumns.setText(ControlExample.getResourceString("Multiple_Columns"));
        this.headerVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.headerVisibleButton.setText(ControlExample.getResourceString("Header_Visible"));
        this.linesVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.linesVisibleButton.setText(ControlExample.getResourceString("Lines_Visible"));
        this.multipleColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeTab.this.recreateExampleWidgets();
            }
        });
        this.headerVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeTab.this.setWidgetHeaderVisible();
            }
        });
        this.linesVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeTab.this.setWidgetLinesVisible();
            }
        });
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.treeGroup = new Group((Composite)this.exampleGroup, 0);
        this.treeGroup.setLayout((Layout)new GridLayout());
        this.treeGroup.setLayoutData((Object)new GridData(784));
        this.treeGroup.setText("Tree");
        this.imageTreeGroup = new Group((Composite)this.exampleGroup, 0);
        this.imageTreeGroup.setLayout((Layout)new GridLayout());
        this.imageTreeGroup.setLayoutData((Object)new GridData(784));
        this.imageTreeGroup.setText(ControlExample.getResourceString("Tree_With_Images"));
    }

    @Override
    void createExampleWidgets() {
        TreeColumn treeColumn;
        int n;
        TreeItem treeItem;
        TreeItem treeItem2;
        int n2;
        int n3 = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            n3 |= 4;
        }
        if (this.multiButton.getSelection()) {
            n3 |= 2;
        }
        if (this.checkButton.getSelection()) {
            n3 |= 0x20;
        }
        if (this.fullSelectionButton.getSelection()) {
            n3 |= 0x10000;
        }
        if (this.borderButton.getSelection()) {
            n3 |= 0x800;
        }
        this.tree1 = new Tree((Composite)this.treeGroup, n3);
        if (this.multipleColumns.getSelection()) {
            for (n2 = 0; n2 < columnTitles.length; ++n2) {
                treeItem2 = new TreeColumn(this.tree1, 0);
                if (n2 == 0) {
                    treeItem2.setWidth(80);
                }
                treeItem2.setText(columnTitles[n2]);
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            treeItem2 = new TreeItem(this.tree1, 0);
            this.setItemText(treeItem2, n2, ControlExample.getResourceString("Node_" + (n2 + 1)));
            if (n2 >= 3) continue;
            treeItem = new TreeItem(treeItem2, 0);
            this.setItemText(treeItem, n2, ControlExample.getResourceString("Node_" + (n2 + 1) + "_1"));
        }
        TreeItem[] treeItemArray = this.tree1.getItems();
        treeItem2 = new TreeItem(treeItemArray[1], 0);
        this.setItemText(treeItem2, 1, ControlExample.getResourceString("Node_2_2"));
        treeItem2 = new TreeItem(treeItem2, 0);
        this.setItemText(treeItem2, 1, ControlExample.getResourceString("Node_2_2_1"));
        this.textNode1 = treeItemArray[0];
        this.packColumns(this.tree1);
        this.tree2 = new Tree((Composite)this.imageTreeGroup, n3);
        treeItem = this.instance.images[0];
        if (this.multipleColumns.getSelection()) {
            for (n = 0; n < columnTitles.length; ++n) {
                treeColumn = new TreeColumn(this.tree2, 0);
                treeColumn.setText(columnTitles[n]);
            }
        }
        for (n = 0; n < 4; ++n) {
            treeItem2 = new TreeItem(this.tree2, 0);
            this.setItemText(treeItem2, n, ControlExample.getResourceString("Node_" + (n + 1)));
            treeItem2.setImage((Image)treeItem);
            if (n >= 3) continue;
            treeColumn = new TreeItem(treeItem2, 0);
            this.setItemText((TreeItem)treeColumn, n, ControlExample.getResourceString("Node_" + (n + 1) + "_1"));
            treeColumn.setImage((Image)treeItem);
        }
        treeItemArray = this.tree2.getItems();
        treeItem2 = new TreeItem(treeItemArray[1], 0);
        this.setItemText(treeItem2, 1, ControlExample.getResourceString("Node_2_2"));
        treeItem2.setImage((Image)treeItem);
        treeItem2 = new TreeItem(treeItem2, 0);
        this.setItemText(treeItem2, 1, ControlExample.getResourceString("Node_2_2_1"));
        treeItem2.setImage((Image)treeItem);
        this.imageNode1 = treeItemArray[0];
        this.packColumns(this.tree2);
    }

    void setItemText(TreeItem treeItem, int n, String string) {
        int n2 = n % 3;
        if (this.multipleColumns.getSelection()) {
            TreeTab.tableData[n2][0] = string;
            treeItem.setText(tableData[n2]);
        } else {
            treeItem.setText(string);
        }
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.checkButton = new Button((Composite)this.styleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
    }

    @Override
    Item[] getExampleWidgetItems() {
        TreeColumn[] treeColumnArray = this.tree1.getColumns();
        TreeColumn[] treeColumnArray2 = this.tree2.getColumns();
        Item[] itemArray = new Item[treeColumnArray.length + treeColumnArray2.length];
        System.arraycopy(treeColumnArray, 0, itemArray, 0, treeColumnArray.length);
        System.arraycopy(treeColumnArray2, 0, itemArray, treeColumnArray.length, treeColumnArray2.length);
        return itemArray;
    }

    @Override
    Control[] getExampleWidgets() {
        return new Control[]{this.tree1, this.tree2};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Selection", "TopItem"};
    }

    @Override
    Object[] parameterForType(String string, String string2, Control control) {
        String[] stringArray;
        if (string.equals("org.eclipse.swt.widgets.TreeItem") && (stringArray = this.findItem(string2, ((Tree)control).getItems())) != null) {
            return new Object[]{stringArray};
        }
        if (string.equals("[Lorg.eclipse.swt.widgets.TreeItem;")) {
            TreeItem treeItem;
            stringArray = string2.split(",");
            TreeItem[] treeItemArray = new TreeItem[stringArray.length];
            for (int i = 0; i < stringArray.length && (treeItem = this.findItem(stringArray[i], ((Tree)control).getItems())) != null; ++i) {
                treeItemArray[i] = treeItem;
            }
            return new Object[]{treeItemArray};
        }
        return super.parameterForType(string, string2, control);
    }

    TreeItem findItem(String string, TreeItem[] treeItemArray) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItem treeItem = treeItemArray[i];
            if (treeItem.getText().equals(string)) {
                return treeItem;
            }
            if ((treeItem = this.findItem(string, treeItem.getItems())) == null) continue;
            return treeItem;
        }
        return null;
    }

    @Override
    String getTabText() {
        return "Tree";
    }

    void packColumns(Tree tree) {
        if (this.multipleColumns.getSelection()) {
            int n = tree.getColumnCount();
            for (int i = 0; i < n; ++i) {
                TreeColumn treeColumn = tree.getColumn(i);
                treeColumn.pack();
            }
        }
    }

    @Override
    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        Color color = this.itemForegroundColor;
        this.itemForegroundColor = null;
        this.setItemForeground();
        if (color != null) {
            color.dispose();
        }
        color = this.itemBackgroundColor;
        this.itemBackgroundColor = null;
        this.setItemBackground();
        if (color != null) {
            color.dispose();
        }
        Font font = this.font;
        this.itemFont = null;
        this.setItemFont();
        this.setExampleWidgetSize();
        if (font != null) {
            font.dispose();
        }
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setItemBackground();
        this.setItemForeground();
        this.setItemFont();
        this.setExampleWidgetSize();
        this.setWidgetHeaderVisible();
        this.setWidgetLinesVisible();
        this.checkButton.setSelection((this.tree1.getStyle() & 0x20) != 0);
        this.checkButton.setSelection((this.tree2.getStyle() & 0x20) != 0);
        this.fullSelectionButton.setSelection((this.tree1.getStyle() & 0x10000) != 0);
        this.fullSelectionButton.setSelection((this.tree2.getStyle() & 0x10000) != 0);
    }

    void setItemBackground() {
        this.textNode1.setBackground(this.itemBackgroundColor);
        this.imageNode1.setBackground(this.itemBackgroundColor);
        Color color = this.itemBackgroundColor;
        if (color == null) {
            color = this.textNode1.getBackground();
        }
        this.drawImage(this.itemBackgroundImage, color);
        this.itemBackgroundButton.setImage(this.itemBackgroundImage);
    }

    void setItemForeground() {
        this.textNode1.setForeground(this.itemForegroundColor);
        this.imageNode1.setForeground(this.itemForegroundColor);
        Color color = this.itemForegroundColor;
        if (color == null) {
            color = this.textNode1.getForeground();
        }
        this.drawImage(this.itemForegroundImage, color);
        this.itemForegroundButton.setImage(this.itemForegroundImage);
    }

    void setItemFont() {
        if (this.instance.startup) {
            return;
        }
        this.textNode1.setFont(this.itemFont);
        this.imageNode1.setFont(this.itemFont);
    }

    void setWidgetHeaderVisible() {
        this.tree1.setHeaderVisible(this.headerVisibleButton.getSelection());
        this.tree2.setHeaderVisible(this.headerVisibleButton.getSelection());
    }

    void setWidgetLinesVisible() {
        this.tree1.setLinesVisible(this.linesVisibleButton.getSelection());
        this.tree2.setLinesVisible(this.linesVisibleButton.getSelection());
    }
}

