/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class AdvancedGraphics {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("examples_graphics");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image loadImage(Display display, Class clazz, String string) {
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        Image image = null;
        try {
            image = new Image((Device)display, inputStream);
        }
        catch (SWTException sWTException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return image;
    }

    public Shell open(final Display display) {
        Path path;
        Shell shell = new Shell(display);
        shell.setText(RESOURCE_BUNDLE.getString("AdvancedGraphics"));
        try {
            path = new Path((Device)display);
            path.dispose();
        }
        catch (SWTException sWTException) {
            MessageBox messageBox = new MessageBox(shell, 40);
            messageBox.setText(RESOURCE_BUNDLE.getString("Warning"));
            messageBox.setMessage(RESOURCE_BUNDLE.getString("LibNotFound"));
            messageBox.open();
            shell.dispose();
            return null;
        }
        path = shell.getFont().getFontData()[0];
        final Font font = new Font((Device)display, path.getName(), 96, 3);
        final Image image = AdvancedGraphics.loadImage(display, AdvancedGraphics.class, "irmaos.jpg");
        final Rectangle rectangle = image.getBounds();
        shell.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                GC gC = event.gc;
                Transform transform = new Transform((Device)display);
                transform.translate((float)(rectangle.width / 4), (float)(rectangle.height / 2));
                transform.rotate(-30.0f);
                if (image != null) {
                    gC.drawImage(image, 0, 0, rectangle.width, rectangle.height, 0, 0, rectangle.width, rectangle.height);
                }
                gC.setAlpha(100);
                gC.setTransform(transform);
                Path path = new Path((Device)display);
                path.addString("SWT", 0.0f, 0.0f, font);
                gC.setBackground(display.getSystemColor(5));
                gC.setForeground(display.getSystemColor(9));
                gC.fillPath(path);
                gC.drawPath(path);
                transform.dispose();
                path.dispose();
            }
        });
        shell.setSize(shell.computeSize(rectangle.width, rectangle.height));
        shell.open();
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (image != null) {
                    image.dispose();
                }
                font.dispose();
            }
        });
        return shell;
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new AdvancedGraphics().open(display);
        while (shell != null && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

