/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.util.Random;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class IntroTab
extends GraphicsTab {
    Font font;
    Image image;
    Random random = new Random();
    float x;
    float y;
    float incX = 10.0f;
    float incY = 5.0f;
    int textWidth;
    int textHeight;
    String text = "SWT";

    public IntroTab(GraphicsExample graphicsExample) {
        super(graphicsExample);
    }

    @Override
    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = null;
        if (this.font != null) {
            this.font.dispose();
        }
        this.font = null;
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Introduction");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("SWT");
    }

    @Override
    public boolean isAnimated() {
        return true;
    }

    @Override
    public void next(int n, int n2) {
        this.x += this.incX;
        this.y += this.incY;
        float f = (float)Math.random();
        if (this.x + (float)this.textWidth > (float)n) {
            this.x = n - this.textWidth;
            this.incX = f * (float)(-n) / 16.0f - 1.0f;
        }
        if (this.x < 0.0f) {
            this.x = 0.0f;
            this.incX = f * (float)n / 16.0f + 1.0f;
        }
        if (this.y + (float)this.textHeight > (float)n2) {
            this.y = n2 - this.textHeight - 2;
            this.incY = f * (float)(-n2) / 16.0f - 1.0f;
        }
        if (this.y < 0.0f) {
            this.y = 0.0f;
            this.incY = f * (float)n2 / 16.0f + 1.0f;
        }
    }

    @Override
    public void paint(GC gC, int n, int n2) {
        FontData fontData;
        Path path;
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Display display = Display.getCurrent();
        if (this.image == null) {
            this.image = this.example.loadImage(Display.getCurrent(), "irmaos.jpg");
            path = this.image.getBounds();
            fontData = display.getSystemFont().getFontData()[0];
            this.font = new Font((Device)display, fontData.getName(), path.height / 4, 1);
            gC.setFont(this.font);
            Point point = gC.stringExtent(this.text);
            this.textWidth = point.x;
            this.textHeight = point.y;
        }
        path = new Path((Device)display);
        path.addString(this.text, this.x, this.y, this.font);
        gC.setClipping(path);
        fontData = this.image.getBounds();
        gC.drawImage(this.image, 0, 0, fontData.width, fontData.height, 0, 0, n, n2);
        gC.setClipping((Rectangle)null);
        gC.setForeground(display.getSystemColor(9));
        gC.drawPath(path);
    }
}

