/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class StarPolyTab
extends GraphicsTab {
    int[] radial = new int[22];
    static final int POINTS = 11;
    Combo fillRuleCb;

    public StarPolyTab(GraphicsExample graphicsExample) {
        super(graphicsExample);
    }

    @Override
    public void createControlPanel(Composite composite) {
        new Label(composite, 0).setText(GraphicsExample.getResourceString("FillRule"));
        this.fillRuleCb = new Combo(composite, 4);
        this.fillRuleCb.add("FILL_EVEN_ODD");
        this.fillRuleCb.add("FILL_WINDING");
        this.fillRuleCb.select(0);
        this.fillRuleCb.addListener(13, this.example.getRedrawListener());
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Polygons");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("StarPolygon");
    }

    @Override
    public void paint(GC gC, int n, int n2) {
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = 0;
        for (int i = 0; i < 11; ++i) {
            double d = Math.PI * 2 * (double)n5 / 11.0;
            this.radial[i * 2] = (int)((1.0 + Math.cos(d)) * (double)n3);
            this.radial[i * 2 + 1] = (int)((1.0 + Math.sin(d)) * (double)n4);
            n5 = (n5 + 5) % 11;
        }
        Display display = Display.getCurrent();
        gC.setFillRule(this.fillRuleCb.getSelectionIndex() != 0 ? 2 : 1);
        gC.setBackground(display.getSystemColor(1));
        gC.fillPolygon(this.radial);
        gC.drawPolygon(this.radial);
    }
}

