/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.hoverhelp;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class HoverHelp {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_hoverhelp");
    static final int hhiInformation = 0;
    static final int hhiWarning = 1;
    static final String[] imageLocations = new String[]{"information.gif", "warning.gif"};
    Image[] images;

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new HoverHelp().open(display);
        while (shell != null && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display display) {
        Class<HoverHelp> clazz = HoverHelp.class;
        try {
            if (this.images == null) {
                this.images = new Image[imageLocations.length];
                for (int i = 0; i < imageLocations.length; ++i) {
                    InputStream inputStream = clazz.getResourceAsStream(imageLocations[i]);
                    ImageData imageData = new ImageData(inputStream);
                    ImageData imageData2 = imageData.getTransparencyMask();
                    this.images[i] = new Image((Device)display, imageData, imageData2);
                    try {
                        inputStream.close();
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println(this.getResourceString("error.CouldNotLoadResources", new Object[]{exception.getMessage()}));
            return null;
        }
        Shell shell = new Shell();
        this.createPartControl((Composite)shell);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (HoverHelp.this.images != null) {
                    for (int i = 0; i < HoverHelp.this.images.length; ++i) {
                        Image image = HoverHelp.this.images[i];
                        if (image == null) continue;
                        image.dispose();
                    }
                    HoverHelp.this.images = null;
                }
            }
        });
        shell.pack();
        shell.open();
        return shell;
    }

    public String getResourceString(String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    public String getResourceString(String string, Object[] objectArray) {
        try {
            return MessageFormat.format(this.getResourceString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + string + "!";
        }
    }

    public void createPartControl(Composite composite) {
        ToolItem toolItem;
        ToolTipHandler toolTipHandler = new ToolTipHandler(composite.getShell());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        ToolBar toolBar = new ToolBar(composite, 2048);
        for (int i = 0; i < 5; ++i) {
            toolItem = new ToolItem(toolBar, 8);
            toolItem.setText(this.getResourceString("ToolItem.text", new Object[]{i}));
            toolItem.setData("TIP_TEXT", (Object)this.getResourceString("ToolItem.tooltip", new Object[]{toolItem.getText()}));
            toolItem.setData("TIP_HELPTEXTHANDLER", (Object)new ToolTipHelpTextHandler(){

                @Override
                public String getHelpText(Widget widget) {
                    Item item = (Item)widget;
                    return HoverHelp.this.getResourceString("ToolItem.help", new Object[]{item.getText()});
                }
            });
        }
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        toolBar.setLayoutData((Object)gridData);
        toolTipHandler.activateHoverHelp((Control)toolBar);
        toolItem = new Table(composite, 2048);
        for (int i = 0; i < 4; ++i) {
            TableItem tableItem = new TableItem((Table)toolItem, 8);
            tableItem.setText(this.getResourceString("Item", new Object[]{i}));
            tableItem.setData("TIP_IMAGE", (Object)this.images[0]);
            tableItem.setText(this.getResourceString("TableItem.text", new Object[]{i}));
            tableItem.setData("TIP_TEXT", (Object)this.getResourceString("TableItem.tooltip", new Object[]{tableItem.getText()}));
            tableItem.setData("TIP_HELPTEXTHANDLER", (Object)new ToolTipHelpTextHandler(){

                @Override
                public String getHelpText(Widget widget) {
                    Item item = (Item)widget;
                    return HoverHelp.this.getResourceString("TableItem.help", new Object[]{item.getText()});
                }
            });
        }
        toolItem.setLayoutData((Object)new GridData(16));
        toolTipHandler.activateHoverHelp((Control)toolItem);
        Tree tree = new Tree(composite, 2048);
        for (int i = 0; i < 4; ++i) {
            TreeItem treeItem = new TreeItem(tree, 8);
            treeItem.setText(this.getResourceString("Item", new Object[]{i}));
            treeItem.setData("TIP_IMAGE", (Object)this.images[1]);
            treeItem.setText(this.getResourceString("TreeItem.text", new Object[]{i}));
            treeItem.setData("TIP_TEXT", (Object)this.getResourceString("TreeItem.tooltip", new Object[]{treeItem.getText()}));
            treeItem.setData("TIP_HELPTEXTHANDLER", (Object)new ToolTipHelpTextHandler(){

                @Override
                public String getHelpText(Widget widget) {
                    Item item = (Item)widget;
                    return HoverHelp.this.getResourceString("TreeItem.help", new Object[]{item.getText()});
                }
            });
        }
        tree.setLayoutData((Object)new GridData(16));
        toolTipHandler.activateHoverHelp((Control)tree);
        Button button = new Button(composite, 8);
        button.setText(this.getResourceString("Hello.text"));
        button.setData("TIP_TEXT", (Object)this.getResourceString("Hello.tooltip"));
        toolTipHandler.activateHoverHelp((Control)button);
    }

    protected static interface ToolTipHelpTextHandler {
        public String getHelpText(Widget var1);
    }

    protected static class ToolTipHandler {
        private Shell parentShell;
        private Shell tipShell;
        private Label tipLabelImage;
        private Label tipLabelText;
        private Widget tipWidget;
        private Point tipPosition;

        public ToolTipHandler(Shell shell) {
            Display display = shell.getDisplay();
            this.parentShell = shell;
            this.tipShell = new Shell(shell, 16388);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 2;
            gridLayout.marginHeight = 2;
            this.tipShell.setLayout((Layout)gridLayout);
            this.tipShell.setBackground(display.getSystemColor(29));
            this.tipLabelImage = new Label((Composite)this.tipShell, 0);
            this.tipLabelImage.setForeground(display.getSystemColor(28));
            this.tipLabelImage.setBackground(display.getSystemColor(29));
            this.tipLabelImage.setLayoutData((Object)new GridData(772));
            this.tipLabelText = new Label((Composite)this.tipShell, 0);
            this.tipLabelText.setForeground(display.getSystemColor(28));
            this.tipLabelText.setBackground(display.getSystemColor(29));
            this.tipLabelText.setLayoutData((Object)new GridData(772));
        }

        public void activateHoverHelp(final Control control) {
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    if (tipShell.isVisible()) {
                        tipShell.setVisible(false);
                    }
                }
            });
            control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent mouseEvent) {
                    if (tipShell.isVisible()) {
                        tipShell.setVisible(false);
                    }
                    tipWidget = null;
                }

                public void mouseHover(MouseEvent mouseEvent) {
                    Object object;
                    Point point = new Point(mouseEvent.x, mouseEvent.y);
                    Widget widget = mouseEvent.widget;
                    if (widget instanceof ToolBar) {
                        object = (ToolBar)widget;
                        widget = object.getItem(point);
                    }
                    if (widget instanceof Table) {
                        object = (Table)widget;
                        widget = object.getItem(point);
                    }
                    if (widget instanceof Tree) {
                        object = (Tree)widget;
                        widget = object.getItem(point);
                    }
                    if (widget == null) {
                        tipShell.setVisible(false);
                        tipWidget = null;
                        return;
                    }
                    if (widget == tipWidget) {
                        return;
                    }
                    tipWidget = widget;
                    tipPosition = control.toDisplay(point);
                    object = (String)widget.getData("TIP_TEXT");
                    Image image = (Image)widget.getData("TIP_IMAGE");
                    tipLabelText.setText((String)(object != null ? object : ""));
                    tipLabelImage.setImage(image);
                    tipShell.pack();
                    this.setHoverLocation(tipShell, tipPosition);
                    tipShell.setVisible(true);
                }
            });
            control.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent helpEvent) {
                    if (tipWidget == null) {
                        return;
                    }
                    ToolTipHelpTextHandler toolTipHelpTextHandler = (ToolTipHelpTextHandler)tipWidget.getData("TIP_HELPTEXTHANDLER");
                    if (toolTipHelpTextHandler == null) {
                        return;
                    }
                    String string = toolTipHelpTextHandler.getHelpText(tipWidget);
                    if (string == null) {
                        return;
                    }
                    if (tipShell.isVisible()) {
                        tipShell.setVisible(false);
                        Shell shell = new Shell(parentShell, 1264);
                        shell.setLayout((Layout)new FillLayout());
                        Label label = new Label((Composite)shell, 0);
                        label.setText(string);
                        shell.pack();
                        this.setHoverLocation(shell, tipPosition);
                        shell.open();
                    }
                }
            });
        }

        private void setHoverLocation(Shell shell, Point point) {
            Rectangle rectangle = shell.getDisplay().getBounds();
            Rectangle rectangle2 = shell.getBounds();
            rectangle2.x = Math.max(Math.min(point.x, rectangle.width - rectangle2.width), 0);
            rectangle2.y = Math.max(Math.min(point.y + 16, rectangle.height - rectangle2.height), 0);
            shell.setBounds(rectangle2);
        }
    }
}

