/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.imageanalyzer;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImageAnalyzer {
    static ResourceBundle bundle = ResourceBundle.getBundle("examples_images");
    Display display;
    Shell shell;
    Canvas imageCanvas;
    Canvas paletteCanvas;
    Label typeLabel;
    Label sizeLabel;
    Label depthLabel;
    Label transparentPixelLabel;
    Label timeToLoadLabel;
    Label screenSizeLabel;
    Label backgroundPixelLabel;
    Label locationLabel;
    Label disposalMethodLabel;
    Label delayTimeLabel;
    Label repeatCountLabel;
    Label paletteLabel;
    Label dataLabel;
    Label statusLabel;
    Combo backgroundCombo;
    Combo scaleXCombo;
    Combo scaleYCombo;
    Combo alphaCombo;
    Button incrementalCheck;
    Button transparentCheck;
    Button maskCheck;
    Button backgroundCheck;
    Button previousButton;
    Button nextButton;
    Button animateButton;
    StyledText dataText;
    Sash sash;
    Color whiteColor;
    Color blackColor;
    Color redColor;
    Color greenColor;
    Color blueColor;
    Color canvasBackground;
    Font fixedWidthFont;
    Cursor crossCursor;
    GC imageCanvasGC;
    int paletteWidth = 140;
    int ix = 0;
    int iy = 0;
    int py = 0;
    float xscale = 1.0f;
    float yscale = 1.0f;
    int alpha = 255;
    boolean incremental = false;
    boolean transparent = true;
    boolean showMask = false;
    boolean showBackground = false;
    boolean animate = false;
    Thread animateThread;
    Thread incrementalThread;
    String lastPath;
    String currentName;
    String fileName;
    ImageLoader loader;
    ImageData[] imageDataArray;
    int imageDataIndex;
    ImageData imageData;
    Image image;
    Vector incrementalEvents;
    long loadTime = 0L;
    static final int INDEX_DIGITS = 4;
    static final int ALPHA_CONSTANT = 0;
    static final int ALPHA_X = 1;
    static final int ALPHA_Y = 2;

    public static void main(String[] stringArray) {
        Display display = new Display();
        ImageAnalyzer imageAnalyzer = new ImageAnalyzer();
        Shell shell = imageAnalyzer.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display display) {
        this.display = display;
        this.shell = new Shell(this.display);
        this.shell.setText(bundle.getString("Image_analyzer"));
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                ImageAnalyzer.this.resizeShell(controlEvent);
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                ImageAnalyzer.this.animate = false;
                if (ImageAnalyzer.this.animateThread != null) {
                    while (ImageAnalyzer.this.animateThread.isAlive()) {
                        if (ImageAnalyzer.this.display.readAndDispatch()) continue;
                        ImageAnalyzer.this.display.sleep();
                    }
                }
                shellEvent.doit = true;
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.image.dispose();
                }
                ImageAnalyzer.this.whiteColor.dispose();
                ImageAnalyzer.this.blackColor.dispose();
                ImageAnalyzer.this.redColor.dispose();
                ImageAnalyzer.this.greenColor.dispose();
                ImageAnalyzer.this.blueColor.dispose();
                ImageAnalyzer.this.fixedWidthFont.dispose();
                ImageAnalyzer.this.crossCursor.dispose();
            }
        });
        this.whiteColor = new Color((Device)this.display, 255, 255, 255);
        this.blackColor = new Color((Device)this.display, 0, 0, 0);
        this.redColor = new Color((Device)this.display, 255, 0, 0);
        this.greenColor = new Color((Device)this.display, 0, 255, 0);
        this.blueColor = new Color((Device)this.display, 0, 0, 255);
        this.fixedWidthFont = new Font((Device)this.display, "courier", 10, 0);
        this.crossCursor = new Cursor((Device)this.display, 2);
        this.createMenuBar();
        this.createWidgets();
        this.shell.pack();
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ImageAnalyzer.this.imageCanvasGC.dispose();
            }
        });
        this.shell.open();
        return this.shell;
    }

    void createWidgets() {
        int n;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.shell.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this.shell, 258);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        Composite composite = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 5;
        rowLayout.spacing = 8;
        composite.setLayout((Layout)rowLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Background"));
        this.backgroundCombo = new Combo((Composite)group, 12);
        this.backgroundCombo.setItems(new String[]{bundle.getString("None"), bundle.getString("White"), bundle.getString("Black"), bundle.getString("Red"), bundle.getString("Green"), bundle.getString("Blue")});
        this.backgroundCombo.select(this.backgroundCombo.indexOf(bundle.getString("White")));
        this.backgroundCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.changeBackground();
            }
        });
        String[] stringArray = new String[]{"0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.7", "1.8", "1.9", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        group = new Group(composite, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("X_scale"));
        this.scaleXCombo = new Combo((Composite)group, 4);
        for (n = 0; n < stringArray.length; ++n) {
            this.scaleXCombo.add(stringArray[n]);
        }
        this.scaleXCombo.select(this.scaleXCombo.indexOf("1"));
        this.scaleXCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.scaleX();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Y_scale"));
        this.scaleYCombo = new Combo((Composite)group, 4);
        for (n = 0; n < stringArray.length; ++n) {
            this.scaleYCombo.add(stringArray[n]);
        }
        this.scaleYCombo.select(this.scaleYCombo.indexOf("1"));
        this.scaleYCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.scaleY();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Alpha_K"));
        this.alphaCombo = new Combo((Composite)group, 12);
        for (n = 0; n <= 255; n += 5) {
            this.alphaCombo.add(String.valueOf(n));
        }
        this.alphaCombo.select(this.alphaCombo.indexOf("255"));
        this.alphaCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.alpha();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Display"));
        this.incrementalCheck = new Button((Composite)group, 32);
        this.incrementalCheck.setText(bundle.getString("Incremental"));
        this.incrementalCheck.setSelection(this.incremental);
        this.incrementalCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.incremental = ((Button)selectionEvent.widget).getSelection();
            }
        });
        this.transparentCheck = new Button((Composite)group, 32);
        this.transparentCheck.setText(bundle.getString("Transparent"));
        this.transparentCheck.setSelection(this.transparent);
        this.transparentCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.transparent = ((Button)selectionEvent.widget).getSelection();
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.imageCanvas.redraw();
                }
            }
        });
        this.maskCheck = new Button((Composite)group, 32);
        this.maskCheck.setText(bundle.getString("Mask"));
        this.maskCheck.setSelection(this.showMask);
        this.maskCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.showMask = ((Button)selectionEvent.widget).getSelection();
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.imageCanvas.redraw();
                }
            }
        });
        this.backgroundCheck = new Button((Composite)group, 32);
        this.backgroundCheck.setText(bundle.getString("Background"));
        this.backgroundCheck.setSelection(this.showBackground);
        this.backgroundCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.showBackground = ((Button)selectionEvent.widget).getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Animation"));
        this.previousButton = new Button((Composite)group, 8);
        this.previousButton.setText(bundle.getString("Previous"));
        this.previousButton.setEnabled(false);
        this.previousButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.previous();
            }
        });
        this.nextButton = new Button((Composite)group, 8);
        this.nextButton.setText(bundle.getString("Next"));
        this.nextButton.setEnabled(false);
        this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.next();
            }
        });
        this.animateButton = new Button((Composite)group, 8);
        this.animateButton.setText(bundle.getString("Animate"));
        this.animateButton.setEnabled(false);
        this.animateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.animate();
            }
        });
        this.typeLabel = new Label((Composite)this.shell, 0);
        this.typeLabel.setText(bundle.getString("Type_initial"));
        this.typeLabel.setLayoutData((Object)new GridData(256));
        this.imageCanvas = new Canvas((Composite)this.shell, 0x100300);
        this.imageCanvas.setBackground(this.whiteColor);
        this.imageCanvas.setCursor(this.crossCursor);
        gridData = new GridData();
        gridData.verticalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.imageCanvas.setLayoutData((Object)gridData);
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.paintImage(paintEvent);
                }
            }
        });
        this.imageCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.showColorAt(mouseEvent.x, mouseEvent.y);
                }
            }
        });
        ScrollBar scrollBar = this.imageCanvas.getHorizontalBar();
        scrollBar.setVisible(true);
        scrollBar.setMinimum(0);
        scrollBar.setEnabled(false);
        scrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.scrollHorizontally((ScrollBar)selectionEvent.widget);
            }
        });
        ScrollBar scrollBar2 = this.imageCanvas.getVerticalBar();
        scrollBar2.setVisible(true);
        scrollBar2.setMinimum(0);
        scrollBar2.setEnabled(false);
        scrollBar2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.scrollVertically((ScrollBar)selectionEvent.widget);
            }
        });
        this.sizeLabel = new Label((Composite)this.shell, 0);
        this.sizeLabel.setText(bundle.getString("Size_initial"));
        this.sizeLabel.setLayoutData((Object)new GridData(256));
        this.depthLabel = new Label((Composite)this.shell, 0);
        this.depthLabel.setText(bundle.getString("Depth_initial"));
        this.depthLabel.setLayoutData((Object)new GridData(256));
        this.transparentPixelLabel = new Label((Composite)this.shell, 0);
        this.transparentPixelLabel.setText(bundle.getString("Transparent_pixel_initial"));
        this.transparentPixelLabel.setLayoutData((Object)new GridData(256));
        this.timeToLoadLabel = new Label((Composite)this.shell, 0);
        this.timeToLoadLabel.setText(bundle.getString("Time_to_load_initial"));
        this.timeToLoadLabel.setLayoutData((Object)new GridData(256));
        label = new Label((Composite)this.shell, 258);
        label.setLayoutData((Object)new GridData(256));
        this.screenSizeLabel = new Label((Composite)this.shell, 0);
        this.screenSizeLabel.setText(bundle.getString("Animation_size_initial"));
        this.screenSizeLabel.setLayoutData((Object)new GridData(256));
        this.backgroundPixelLabel = new Label((Composite)this.shell, 0);
        this.backgroundPixelLabel.setText(bundle.getString("Background_pixel_initial"));
        this.backgroundPixelLabel.setLayoutData((Object)new GridData(256));
        this.locationLabel = new Label((Composite)this.shell, 0);
        this.locationLabel.setText(bundle.getString("Image_location_initial"));
        this.locationLabel.setLayoutData((Object)new GridData(256));
        this.disposalMethodLabel = new Label((Composite)this.shell, 0);
        this.disposalMethodLabel.setText(bundle.getString("Disposal_initial"));
        this.disposalMethodLabel.setLayoutData((Object)new GridData(256));
        this.delayTimeLabel = new Label((Composite)this.shell, 0);
        this.delayTimeLabel.setText(bundle.getString("Delay_initial"));
        this.delayTimeLabel.setLayoutData((Object)new GridData(256));
        this.repeatCountLabel = new Label((Composite)this.shell, 0);
        this.repeatCountLabel.setText(bundle.getString("Repeats_initial"));
        this.repeatCountLabel.setLayoutData((Object)new GridData(256));
        label = new Label((Composite)this.shell, 258);
        label.setLayoutData((Object)new GridData(256));
        this.paletteLabel = new Label((Composite)this.shell, 0);
        this.paletteLabel.setText(bundle.getString("Palette_initial"));
        this.paletteLabel.setLayoutData((Object)new GridData(256));
        this.paletteCanvas = new Canvas((Composite)this.shell, 0x100A00);
        this.paletteCanvas.setFont(this.fixedWidthFont);
        this.paletteCanvas.getVerticalBar().setVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        GC gC = new GC((Drawable)this.paletteLabel);
        this.paletteWidth = gC.stringExtent((String)ImageAnalyzer.bundle.getString((String)"Max_length_string")).x;
        gC.dispose();
        gridData.widthHint = this.paletteWidth;
        gridData.heightHint = 176;
        this.paletteCanvas.setLayoutData((Object)gridData);
        this.paletteCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.paintPalette(paintEvent);
                }
            }
        });
        scrollBar2 = this.paletteCanvas.getVerticalBar();
        scrollBar2.setVisible(true);
        scrollBar2.setMinimum(0);
        scrollBar2.setIncrement(10);
        scrollBar2.setEnabled(false);
        scrollBar2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.scrollPalette((ScrollBar)selectionEvent.widget);
            }
        });
        this.sash = new Sash((Composite)this.shell, 256);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.sash.setLayoutData((Object)gridData);
        this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail != 1) {
                    ((GridData)ImageAnalyzer.this.paletteCanvas.getLayoutData()).heightHint = -1;
                    Rectangle rectangle = ImageAnalyzer.this.paletteCanvas.getBounds();
                    int n = rectangle.y + 20;
                    Rectangle rectangle2 = ImageAnalyzer.this.dataLabel.getBounds();
                    int n2 = ImageAnalyzer.this.statusLabel.getBounds().y - rectangle2.height - 20;
                    if (selectionEvent.y > n && selectionEvent.y < n2) {
                        Rectangle rectangle3 = ImageAnalyzer.this.sash.getBounds();
                        ImageAnalyzer.this.sash.setBounds(selectionEvent.x, selectionEvent.y, selectionEvent.width, selectionEvent.height);
                        int n3 = selectionEvent.y - rectangle3.y;
                        Rectangle rectangle4 = ImageAnalyzer.this.imageCanvas.getBounds();
                        ImageAnalyzer.this.imageCanvas.setBounds(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height + n3);
                        rectangle4 = rectangle;
                        ImageAnalyzer.this.paletteCanvas.setBounds(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height + n3);
                        rectangle4 = rectangle2;
                        ImageAnalyzer.this.dataLabel.setBounds(rectangle4.x, rectangle4.y + n3, rectangle4.width, rectangle4.height);
                        rectangle4 = ImageAnalyzer.this.dataText.getBounds();
                        ImageAnalyzer.this.dataText.setBounds(rectangle4.x, rectangle4.y + n3, rectangle4.width, rectangle4.height - n3);
                    }
                }
            }
        });
        this.dataLabel = new Label((Composite)this.shell, 0);
        this.dataLabel.setText(bundle.getString("Pixel_data_initial"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.dataLabel.setLayoutData((Object)gridData);
        this.dataText = new StyledText((Composite)this.shell, 2826);
        this.dataText.setBackground(this.display.getSystemColor(22));
        this.dataText.setFont(this.fixedWidthFont);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.heightHint = 128;
        gridData.grabExcessVerticalSpace = true;
        this.dataText.setLayoutData((Object)gridData);
        this.dataText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (ImageAnalyzer.this.image != null && mouseEvent.button == 1) {
                    ImageAnalyzer.this.showColorForData();
                }
            }
        });
        this.dataText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.showColorForData();
                }
            }
        });
        this.statusLabel = new Label((Composite)this.shell, 0);
        this.statusLabel.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.statusLabel.setLayoutData((Object)gridData);
    }

    Menu createMenuBar() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menu);
        this.createFileMenu(menu);
        this.createAlphaMenu(menu);
        return menu;
    }

    void createFileMenu(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(bundle.getString("File"));
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        menuItem.setMenu(menu2);
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(bundle.getString("OpenFile"));
        menuItem.setAccelerator(SWT.MOD1 + 79);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.menuOpenFile();
            }
        });
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(bundle.getString("OpenURL"));
        menuItem.setAccelerator(SWT.MOD1 + 85);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.menuOpenURL();
            }
        });
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(bundle.getString("Reopen"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.menuReopen();
            }
        });
        new MenuItem(menu2, 2);
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(bundle.getString("Save"));
        menuItem.setAccelerator(SWT.MOD1 + 83);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.menuSave();
            }
        });
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(bundle.getString("Save_as"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.menuSaveAs();
            }
        });
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(bundle.getString("Save_mask_as"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.menuSaveMaskAs();
            }
        });
        new MenuItem(menu2, 2);
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(bundle.getString("Print"));
        menuItem.setAccelerator(SWT.MOD1 + 80);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.menuPrint();
            }
        });
        new MenuItem(menu2, 2);
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText(bundle.getString("Exit"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.shell.close();
            }
        });
    }

    void createAlphaMenu(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(bundle.getString("Alpha"));
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        menuItem.setMenu(menu2);
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText("K");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.menuComposeAlpha(0);
            }
        });
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText("(K + x) % 256");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.menuComposeAlpha(1);
            }
        });
        menuItem = new MenuItem(menu2, 8);
        menuItem.setText("(K + y) % 256");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageAnalyzer.this.menuComposeAlpha(2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void menuComposeAlpha(int n) {
        if (this.image == null) {
            return;
        }
        this.animate = false;
        Cursor cursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(cursor);
        this.imageCanvas.setCursor(cursor);
        try {
            if (n == 0) {
                this.imageData.alpha = this.alpha;
            } else {
                this.imageData.alpha = -1;
                switch (n) {
                    case 1: {
                        for (int i = 0; i < this.imageData.height; ++i) {
                            for (int j = 0; j < this.imageData.width; ++j) {
                                this.imageData.setAlpha(j, i, (j + this.alpha) % 256);
                            }
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < this.imageData.height; ++i) {
                            for (int j = 0; j < this.imageData.width; ++j) {
                                this.imageData.setAlpha(j, i, (i + this.alpha) % 256);
                            }
                        }
                        break;
                    }
                }
            }
            this.displayImage(this.imageData);
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            cursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void menuOpenFile() {
        this.animate = false;
        this.resetScaleCombos();
        FileDialog fileDialog = new FileDialog(this.shell, 4096);
        if (this.lastPath != null) {
            fileDialog.setFilterPath(this.lastPath);
        }
        fileDialog.setFilterExtensions(new String[]{"*.bmp; *.gif; *.ico; *.jpg; *.pcx; *.png; *.tif", "*.bmp", "*.gif", "*.ico", "*.jpg", "*.pcx", "*.png", "*.tif"});
        fileDialog.setFilterNames(new String[]{bundle.getString("All_images") + " (bmp, gif, ico, jpg, pcx, png, tif)", "BMP (*.bmp)", "GIF (*.gif)", "ICO (*.ico)", "JPEG (*.jpg)", "PCX (*.pcx)", "PNG (*.png)", "TIFF (*.tif)"});
        String string = fileDialog.open();
        this.lastPath = fileDialog.getFilterPath();
        if (string == null) {
            return;
        }
        Cursor cursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(cursor);
        this.imageCanvas.setCursor(cursor);
        try {
            this.loader = new ImageLoader();
            if (this.incremental) {
                this.loader.addImageLoaderListener(new ImageLoaderListener(){

                    public void imageDataLoaded(ImageLoaderEvent imageLoaderEvent) {
                        ImageAnalyzer.this.incrementalDataLoaded(imageLoaderEvent);
                    }
                });
                this.incrementalThreadStart();
            }
            long l = System.currentTimeMillis();
            this.imageDataArray = this.loader.load(string);
            this.loadTime = System.currentTimeMillis() - l;
            if (this.imageDataArray.length > 0) {
                this.currentName = string;
                this.fileName = string;
                this.previousButton.setEnabled(this.imageDataArray.length > 1);
                this.nextButton.setEnabled(this.imageDataArray.length > 1);
                this.animateButton.setEnabled(this.imageDataArray.length > 1 && this.loader.logicalScreenWidth > 0 && this.loader.logicalScreenHeight > 0);
                this.imageDataIndex = 0;
                this.displayImage(this.imageDataArray[this.imageDataIndex]);
                this.resetScrollBars();
            }
        }
        catch (SWTException sWTException) {
            this.showErrorDialog(bundle.getString("Loading_lc"), string, sWTException);
        }
        catch (SWTError sWTError) {
            this.showErrorDialog(bundle.getString("Loading_lc"), string, sWTError);
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            cursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void menuOpenURL() {
        this.animate = false;
        this.resetScaleCombos();
        TextPrompter textPrompter = new TextPrompter(this.shell, 67680);
        textPrompter.setText(bundle.getString("OpenURLDialog"));
        textPrompter.setMessage(bundle.getString("EnterURL"));
        String string = textPrompter.open();
        if (string == null) {
            return;
        }
        Cursor cursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(cursor);
        this.imageCanvas.setCursor(cursor);
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            this.loader = new ImageLoader();
            if (this.incremental) {
                this.loader.addImageLoaderListener(new ImageLoaderListener(){

                    public void imageDataLoaded(ImageLoaderEvent imageLoaderEvent) {
                        ImageAnalyzer.this.incrementalDataLoaded(imageLoaderEvent);
                    }
                });
                this.incrementalThreadStart();
            }
            long l = System.currentTimeMillis();
            this.imageDataArray = this.loader.load(inputStream);
            inputStream.close();
            this.loadTime = System.currentTimeMillis() - l;
            if (this.imageDataArray.length > 0) {
                this.currentName = string;
                this.fileName = null;
                this.previousButton.setEnabled(this.imageDataArray.length > 1);
                this.nextButton.setEnabled(this.imageDataArray.length > 1);
                this.animateButton.setEnabled(this.imageDataArray.length > 1 && this.loader.logicalScreenWidth > 0 && this.loader.logicalScreenHeight > 0);
                this.imageDataIndex = 0;
                this.displayImage(this.imageDataArray[this.imageDataIndex]);
                this.resetScrollBars();
            }
        }
        catch (Exception exception) {
            this.showErrorDialog(bundle.getString("Loading_lc"), string, exception);
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            cursor.dispose();
        }
    }

    void incrementalThreadStart() {
        this.incrementalEvents = new Vector();
        this.incrementalThread = new Thread("Incremental"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (ImageAnalyzer.this.incrementalEvents != null) {
                    ImageAnalyzer imageAnalyzer = ImageAnalyzer.this;
                    synchronized (imageAnalyzer) {
                        if (ImageAnalyzer.this.incrementalEvents != null) {
                            if (ImageAnalyzer.this.incrementalEvents.size() > 0) {
                                ImageLoaderEvent imageLoaderEvent = (ImageLoaderEvent)ImageAnalyzer.this.incrementalEvents.remove(0);
                                if (ImageAnalyzer.this.image != null) {
                                    ImageAnalyzer.this.image.dispose();
                                }
                                ImageAnalyzer.this.image = new Image((Device)ImageAnalyzer.this.display, imageLoaderEvent.imageData);
                                ImageAnalyzer.this.imageData = imageLoaderEvent.imageData;
                                ImageAnalyzer.this.imageCanvasGC.drawImage(ImageAnalyzer.this.image, 0, 0, ImageAnalyzer.this.imageData.width, ImageAnalyzer.this.imageData.height, ImageAnalyzer.this.imageData.x, ImageAnalyzer.this.imageData.y, ImageAnalyzer.this.imageData.width, ImageAnalyzer.this.imageData.height);
                            } else {
                                38.yield();
                            }
                        }
                    }
                }
                ImageAnalyzer.this.display.wake();
            }
        };
        this.incrementalThread.setDaemon(true);
        this.incrementalThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementalDataLoaded(ImageLoaderEvent imageLoaderEvent) {
        ImageAnalyzer imageAnalyzer = this;
        synchronized (imageAnalyzer) {
            this.incrementalEvents.addElement(imageLoaderEvent);
        }
    }

    void menuSave() {
        if (this.image == null) {
            return;
        }
        this.animate = false;
        if (this.imageData.type == -1 || this.fileName == null) {
            this.menuSaveAs();
            return;
        }
        Cursor cursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(cursor);
        this.imageCanvas.setCursor(cursor);
        try {
            this.loader.data = new ImageData[]{this.imageData};
            this.loader.save(this.fileName, this.imageData.type);
        }
        catch (SWTException sWTException) {
            this.showErrorDialog(bundle.getString("Saving_lc"), this.fileName, sWTException);
        }
        catch (SWTError sWTError) {
            this.showErrorDialog(bundle.getString("Saving_lc"), this.fileName, sWTError);
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            cursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void menuSaveAs() {
        MessageBox messageBox;
        int n;
        String string;
        if (this.image == null) {
            return;
        }
        this.animate = false;
        FileDialog fileDialog = new FileDialog(this.shell, 8192);
        fileDialog.setFilterPath(this.lastPath);
        if (this.fileName != null) {
            string = this.fileName;
            n = string.lastIndexOf(File.separatorChar);
            if (n > -1) {
                string = string.substring(n + 1);
            }
            fileDialog.setFileName(string);
        }
        fileDialog.setFilterExtensions(new String[]{"*.bmp", "*.gif", "*.ico", "*.jpg", "*.png"});
        fileDialog.setFilterNames(new String[]{"BMP (*.bmp)", "GIF (*.gif)", "ICO (*.ico)", "JPEG (*.jpg)", "PNG (*.png)"});
        string = fileDialog.open();
        this.lastPath = fileDialog.getFilterPath();
        if (string == null) {
            return;
        }
        n = this.determineFileType(string);
        if (n == -1) {
            MessageBox messageBox2 = new MessageBox(this.shell, 1);
            messageBox2.setMessage(ImageAnalyzer.createMsg(bundle.getString("Unknown_extension"), string.substring(string.lastIndexOf(46) + 1)));
            messageBox2.open();
            return;
        }
        if (new File(string).exists()) {
            messageBox = new MessageBox(this.shell, 292);
            messageBox.setMessage(ImageAnalyzer.createMsg(bundle.getString("Overwrite"), string));
            if (messageBox.open() == 256) {
                return;
            }
        }
        messageBox = new Cursor((Device)this.display, 1);
        this.shell.setCursor((Cursor)messageBox);
        this.imageCanvas.setCursor((Cursor)messageBox);
        try {
            this.loader.data = new ImageData[]{this.imageData};
            this.loader.save(string, n);
            this.fileName = string;
            this.shell.setText(ImageAnalyzer.createMsg(bundle.getString("Analyzer_on"), string));
            this.typeLabel.setText(ImageAnalyzer.createMsg(bundle.getString("Type_string"), this.fileTypeString(n)));
        }
        catch (SWTException sWTException) {
            this.showErrorDialog(bundle.getString("Saving_lc"), string, sWTException);
        }
        catch (SWTError sWTError) {
            this.showErrorDialog(bundle.getString("Saving_lc"), string, sWTError);
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            messageBox.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void menuSaveMaskAs() {
        MessageBox messageBox;
        if (this.image == null || !this.showMask) {
            return;
        }
        if (this.imageData.getTransparencyType() == 0) {
            return;
        }
        this.animate = false;
        FileDialog fileDialog = new FileDialog(this.shell, 8192);
        fileDialog.setFilterPath(this.lastPath);
        if (this.fileName != null) {
            fileDialog.setFileName(this.fileName);
        }
        fileDialog.setFilterExtensions(new String[]{"*.bmp", "*.gif", "*.ico", "*.jpg", "*.png"});
        fileDialog.setFilterNames(new String[]{"BMP (*.bmp)", "GIF (*.gif)", "ICO (*.ico)", "JPEG (*.jpg)", "PNG (*.png)"});
        String string = fileDialog.open();
        this.lastPath = fileDialog.getFilterPath();
        if (string == null) {
            return;
        }
        int n = this.determineFileType(string);
        if (n == -1) {
            MessageBox messageBox2 = new MessageBox(this.shell, 1);
            messageBox2.setMessage(ImageAnalyzer.createMsg(bundle.getString("Unknown_extension"), string.substring(string.lastIndexOf(46) + 1)));
            messageBox2.open();
            return;
        }
        if (new File(string).exists()) {
            messageBox = new MessageBox(this.shell, 292);
            messageBox.setMessage(ImageAnalyzer.createMsg(bundle.getString("Overwrite"), string));
            if (messageBox.open() == 256) {
                return;
            }
        }
        messageBox = new Cursor((Device)this.display, 1);
        this.shell.setCursor((Cursor)messageBox);
        this.imageCanvas.setCursor((Cursor)messageBox);
        try {
            ImageData imageData = this.imageData.getTransparencyMask();
            this.loader.data = new ImageData[]{imageData};
            this.loader.save(string, n);
        }
        catch (SWTException sWTException) {
            this.showErrorDialog(bundle.getString("Saving_lc"), string, sWTException);
        }
        catch (SWTError sWTError) {
            this.showErrorDialog(bundle.getString("Saving_lc"), string, sWTError);
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            messageBox.dispose();
        }
    }

    void menuPrint() {
        if (this.image == null) {
            return;
        }
        try {
            PrintDialog printDialog = new PrintDialog(this.shell, 0);
            PrinterData printerData = printDialog.open();
            if (printerData == null) {
                return;
            }
            Printer printer = new Printer(printerData);
            Point point = this.display.getDPI();
            Point point2 = printer.getDPI();
            int n = point2.x / point.x;
            Rectangle rectangle = printer.computeTrim(0, 0, 0, 0);
            if (printer.startJob(this.currentName)) {
                if (printer.startPage()) {
                    GC gC = new GC((Drawable)printer);
                    int n2 = this.imageData.transparentPixel;
                    if (n2 != -1 && !this.transparent) {
                        this.imageData.transparentPixel = -1;
                    }
                    Image image = new Image((Device)printer, this.imageData);
                    gC.drawImage(image, 0, 0, this.imageData.width, this.imageData.height, -rectangle.x, -rectangle.y, n * this.imageData.width, n * this.imageData.height);
                    if (n2 != -1 && !this.transparent) {
                        this.imageData.transparentPixel = n2;
                    }
                    image.dispose();
                    gC.dispose();
                    printer.endPage();
                }
                printer.endJob();
            }
            printer.dispose();
        }
        catch (SWTError sWTError) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setMessage(bundle.getString("Printing_error") + sWTError.getMessage());
            messageBox.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void menuReopen() {
        if (this.currentName == null) {
            return;
        }
        this.animate = false;
        this.resetScrollBars();
        this.resetScaleCombos();
        Cursor cursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(cursor);
        this.imageCanvas.setCursor(cursor);
        try {
            ImageData[] imageDataArray;
            this.loader = new ImageLoader();
            long l = System.currentTimeMillis();
            if (this.fileName == null) {
                URL uRL = new URL(this.currentName);
                InputStream inputStream = uRL.openStream();
                imageDataArray = this.loader.load(inputStream);
                inputStream.close();
            } else {
                imageDataArray = this.loader.load(this.fileName);
            }
            this.loadTime = System.currentTimeMillis() - l;
            this.imageDataIndex = 0;
            this.displayImage(imageDataArray[this.imageDataIndex]);
        }
        catch (Exception exception) {
            this.showErrorDialog(bundle.getString("Reloading_lc"), this.currentName, exception);
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            cursor.dispose();
        }
    }

    void changeBackground() {
        String string = this.backgroundCombo.getText();
        if (string.equals(bundle.getString("White"))) {
            this.imageCanvas.setBackground(this.whiteColor);
        } else if (string.equals(bundle.getString("Black"))) {
            this.imageCanvas.setBackground(this.blackColor);
        } else if (string.equals(bundle.getString("Red"))) {
            this.imageCanvas.setBackground(this.redColor);
        } else if (string.equals(bundle.getString("Green"))) {
            this.imageCanvas.setBackground(this.greenColor);
        } else if (string.equals(bundle.getString("Blue"))) {
            this.imageCanvas.setBackground(this.blueColor);
        } else {
            this.imageCanvas.setBackground(null);
        }
    }

    void scaleX() {
        try {
            this.xscale = Float.parseFloat(this.scaleXCombo.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.xscale = 1.0f;
            this.scaleXCombo.select(this.scaleXCombo.indexOf("1"));
        }
        if (this.image != null) {
            this.resizeScrollBars();
            this.imageCanvas.redraw();
        }
    }

    void scaleY() {
        try {
            this.yscale = Float.parseFloat(this.scaleYCombo.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.yscale = 1.0f;
            this.scaleYCombo.select(this.scaleYCombo.indexOf("1"));
        }
        if (this.image != null) {
            this.resizeScrollBars();
            this.imageCanvas.redraw();
        }
    }

    void alpha() {
        try {
            this.alpha = Integer.parseInt(this.alphaCombo.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.alphaCombo.select(this.alphaCombo.indexOf("255"));
            this.alpha = 255;
        }
    }

    void showColorAt(int n, int n2) {
        int n3 = n - this.imageData.x - this.ix;
        int n4 = n2 - this.imageData.y - this.iy;
        this.showColorForPixel(n3, n4);
    }

    void showColorForData() {
        int n;
        int n2 = this.dataText.getLineDelimiter().length();
        int n3 = 6 + 3 * this.imageData.bytesPerLine + n2;
        int n4 = this.dataText.getCaretOffset();
        if (n4 - (n = n4 / n3) * n3 < 6 || (n + 1) * n3 - n4 <= n2) {
            this.statusLabel.setText("");
            return;
        }
        int n5 = n4 - 6 * (n + 1) - n2 * n;
        int n6 = n5 / 3;
        int n7 = n5 - n6 * 3;
        int n8 = n6 % this.imageData.bytesPerLine;
        int n9 = -1;
        int n10 = this.imageData.depth;
        if (n10 == 1) {
            if (n7 == 0) {
                n9 = n8 * 8;
            }
            if (n7 == 1) {
                n9 = n8 * 8 + 3;
            }
            if (n7 == 2) {
                n9 = n8 * 8 + 7;
            }
        }
        if (n10 == 2) {
            if (n7 == 0) {
                n9 = n8 * 4;
            }
            if (n7 == 1) {
                n9 = n8 * 4 + 1;
            }
            if (n7 == 2) {
                n9 = n8 * 4 + 3;
            }
        }
        if (n10 == 4) {
            if (n7 == 0) {
                n9 = n8 * 2;
            }
            if (n7 == 1) {
                n9 = n8 * 2;
            }
            if (n7 == 2) {
                n9 = n8 * 2 + 1;
            }
        }
        if (n10 == 8) {
            n9 = n8;
        }
        if (n10 == 16) {
            n9 = n8 / 2;
        }
        if (n10 == 24) {
            n9 = n8 / 3;
        }
        if (n10 == 32) {
            n9 = n8 / 4;
        }
        if (n9 != -1) {
            this.showColorForPixel(n9, n);
        } else {
            this.statusLabel.setText("");
        }
    }

    void showColorForPixel(int n, int n2) {
        if (n >= 0 && n < this.imageData.width && n2 >= 0 && n2 < this.imageData.height) {
            int n3 = this.imageData.getPixel(n, n2);
            RGB rGB = this.imageData.palette.getRGB(n3);
            Object[] objectArray = new Object[]{n, n2, n3, Integer.toHexString(n3), rGB};
            if (n3 == this.imageData.transparentPixel) {
                this.statusLabel.setText(ImageAnalyzer.createMsg(bundle.getString("Color_at_trans"), objectArray));
            } else {
                this.statusLabel.setText(ImageAnalyzer.createMsg(bundle.getString("Color_at"), objectArray));
            }
        } else {
            this.statusLabel.setText("");
        }
    }

    void animate() {
        boolean bl = this.animate = !this.animate;
        if (this.animate && this.image != null && this.imageDataArray.length > 1) {
            this.animateThread = new Thread(bundle.getString("Animation")){

                @Override
                public void run() {
                    ImageAnalyzer.this.preAnimation();
                    try {
                        ImageAnalyzer.this.animateLoop();
                    }
                    catch (SWTException sWTException) {
                        ImageAnalyzer.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ImageAnalyzer.this.showErrorDialog(ImageAnalyzer.createMsg(bundle.getString("Creating_image"), ImageAnalyzer.this.imageDataIndex + 1), ImageAnalyzer.this.currentName, (Throwable)sWTException);
                            }
                        });
                    }
                    ImageAnalyzer.this.postAnimation();
                }
            };
            this.animateThread.setDaemon(true);
            this.animateThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void animateLoop() {
        Image image = new Image((Device)this.display, this.loader.logicalScreenWidth, this.loader.logicalScreenHeight);
        GC gC = new GC((Drawable)image);
        try {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ImageAnalyzer.this.canvasBackground = ImageAnalyzer.this.imageCanvas.getBackground();
                }
            });
            gC.setBackground(this.canvasBackground);
            gC.fillRectangle(0, 0, this.loader.logicalScreenWidth, this.loader.logicalScreenHeight);
            gC.drawImage(this.image, 0, 0, this.imageData.width, this.imageData.height, this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
            int n = this.loader.repeatCount;
            while (this.animate && (this.loader.repeatCount == 0 || n > 0)) {
                if (this.imageData.disposalMethod == 2) {
                    Color color = null;
                    int n2 = this.loader.backgroundPixel;
                    if (this.showBackground && n2 != -1) {
                        RGB rGB = this.imageData.palette.getRGB(n2);
                        color = new Color(null, rGB);
                    }
                    try {
                        gC.setBackground(color != null ? color : this.canvasBackground);
                        gC.fillRectangle(this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
                    }
                    finally {
                        if (color != null) {
                            color.dispose();
                        }
                    }
                } else if (this.imageData.disposalMethod == 3) {
                    gC.drawImage(this.image, 0, 0, this.imageData.width, this.imageData.height, this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
                }
                this.imageDataIndex = (this.imageDataIndex + 1) % this.imageDataArray.length;
                this.imageData = this.imageDataArray[this.imageDataIndex];
                this.image.dispose();
                this.image = new Image((Device)this.display, this.imageData);
                gC.drawImage(this.image, 0, 0, this.imageData.width, this.imageData.height, this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
                this.imageCanvasGC.drawImage(image, 0, 0);
                try {
                    Thread.sleep(ImageAnalyzer.visibleDelay(this.imageData.delayTime * 10));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.imageDataIndex != this.imageDataArray.length - 1) continue;
                --n;
            }
        }
        finally {
            image.dispose();
            gC.dispose();
        }
    }

    void preAnimation() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                ImageAnalyzer.this.animateButton.setText(bundle.getString("Stop"));
                ImageAnalyzer.this.previousButton.setEnabled(false);
                ImageAnalyzer.this.nextButton.setEnabled(false);
                ImageAnalyzer.this.backgroundCombo.setEnabled(false);
                ImageAnalyzer.this.scaleXCombo.setEnabled(false);
                ImageAnalyzer.this.scaleYCombo.setEnabled(false);
                ImageAnalyzer.this.alphaCombo.setEnabled(false);
                ImageAnalyzer.this.incrementalCheck.setEnabled(false);
                ImageAnalyzer.this.transparentCheck.setEnabled(false);
                ImageAnalyzer.this.maskCheck.setEnabled(false);
                ImageAnalyzer.this.resetScaleCombos();
                ImageAnalyzer.this.resetScrollBars();
            }
        });
    }

    void postAnimation() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                ImageAnalyzer.this.previousButton.setEnabled(true);
                ImageAnalyzer.this.nextButton.setEnabled(true);
                ImageAnalyzer.this.backgroundCombo.setEnabled(true);
                ImageAnalyzer.this.scaleXCombo.setEnabled(true);
                ImageAnalyzer.this.scaleYCombo.setEnabled(true);
                ImageAnalyzer.this.alphaCombo.setEnabled(true);
                ImageAnalyzer.this.incrementalCheck.setEnabled(true);
                ImageAnalyzer.this.transparentCheck.setEnabled(true);
                ImageAnalyzer.this.maskCheck.setEnabled(true);
                ImageAnalyzer.this.animateButton.setText(bundle.getString("Animate"));
                if (ImageAnalyzer.this.animate) {
                    ImageAnalyzer.this.animate = false;
                } else {
                    ImageAnalyzer.this.displayImage(ImageAnalyzer.this.imageDataArray[ImageAnalyzer.this.imageDataIndex]);
                }
            }
        });
    }

    void previous() {
        if (this.image != null && this.imageDataArray.length > 1) {
            if (this.imageDataIndex == 0) {
                this.imageDataIndex = this.imageDataArray.length;
            }
            --this.imageDataIndex;
            this.displayImage(this.imageDataArray[this.imageDataIndex]);
        }
    }

    void next() {
        if (this.image != null && this.imageDataArray.length > 1) {
            this.imageDataIndex = (this.imageDataIndex + 1) % this.imageDataArray.length;
            this.displayImage(this.imageDataArray[this.imageDataIndex]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayImage(ImageData imageData) {
        Object object;
        if (this.incremental && this.incrementalThread != null) {
            object = this;
            synchronized (object) {
                this.incrementalEvents = null;
            }
            while (this.incrementalThread.isAlive()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
        }
        if (this.image != null) {
            this.image.dispose();
        }
        try {
            this.image = new Image((Device)this.display, imageData);
            this.imageData = imageData;
        }
        catch (SWTException sWTException) {
            this.showErrorDialog(bundle.getString("Creating_from") + " ", this.currentName, sWTException);
            this.image = null;
            return;
        }
        object = ImageAnalyzer.createMsg(bundle.getString("Analyzer_on"), this.currentName);
        this.shell.setText((String)object);
        object = this.imageDataArray.length > 1 ? ImageAnalyzer.createMsg(bundle.getString("Type_index"), new Object[]{this.fileTypeString(this.imageData.type), this.imageDataIndex + 1, this.imageDataArray.length}) : ImageAnalyzer.createMsg(bundle.getString("Type_string"), this.fileTypeString(this.imageData.type));
        this.typeLabel.setText((String)object);
        object = ImageAnalyzer.createMsg(bundle.getString("Size_value"), new Object[]{this.imageData.width, this.imageData.height});
        this.sizeLabel.setText((String)object);
        object = ImageAnalyzer.createMsg(bundle.getString("Depth_value"), this.imageData.depth);
        this.depthLabel.setText((String)object);
        object = ImageAnalyzer.createMsg(bundle.getString("Transparent_pixel_value"), ImageAnalyzer.pixelInfo(this.imageData.transparentPixel));
        this.transparentPixelLabel.setText((String)object);
        object = ImageAnalyzer.createMsg(bundle.getString("Time_to_load_value"), this.loadTime);
        this.timeToLoadLabel.setText((String)object);
        object = ImageAnalyzer.createMsg(bundle.getString("Animation_size_value"), new Object[]{this.loader.logicalScreenWidth, this.loader.logicalScreenHeight});
        this.screenSizeLabel.setText((String)object);
        object = ImageAnalyzer.createMsg(bundle.getString("Background_pixel_value"), ImageAnalyzer.pixelInfo(this.loader.backgroundPixel));
        this.backgroundPixelLabel.setText((String)object);
        object = ImageAnalyzer.createMsg(bundle.getString("Image_location_value"), new Object[]{this.imageData.x, this.imageData.y});
        this.locationLabel.setText((String)object);
        object = ImageAnalyzer.createMsg(bundle.getString("Disposal_value"), new Object[]{this.imageData.disposalMethod, ImageAnalyzer.disposalString(this.imageData.disposalMethod)});
        this.disposalMethodLabel.setText((String)object);
        int n = this.imageData.delayTime * 10;
        int n2 = ImageAnalyzer.visibleDelay(n);
        object = n != n2 ? ImageAnalyzer.createMsg(bundle.getString("Delay_value"), new Object[]{n, n2}) : ImageAnalyzer.createMsg(bundle.getString("Delay_used"), n);
        this.delayTimeLabel.setText((String)object);
        object = this.loader.repeatCount == 0 ? ImageAnalyzer.createMsg(bundle.getString("Repeats_forever"), this.loader.repeatCount) : ImageAnalyzer.createMsg(bundle.getString("Repeats_value"), this.loader.repeatCount);
        this.repeatCountLabel.setText((String)object);
        object = this.imageData.palette.isDirect ? bundle.getString("Palette_direct") : ImageAnalyzer.createMsg(bundle.getString("Palette_value"), this.imageData.palette.getRGBs().length);
        this.paletteLabel.setText((String)object);
        object = ImageAnalyzer.createMsg(bundle.getString("Pixel_data_value"), new Object[]{this.imageData.bytesPerLine, this.imageData.scanlinePad, ImageAnalyzer.depthInfo(this.imageData.depth)});
        this.dataLabel.setText((String)object);
        String string = this.dataHexDump(this.dataText.getLineDelimiter());
        this.dataText.setText(string);
        int n3 = 0;
        while ((n3 = string.indexOf(58, n3 + 1)) != -1) {
            this.dataText.setStyleRange(new StyleRange(n3 - 4, 4, this.dataText.getForeground(), this.dataText.getBackground(), 1));
        }
        this.statusLabel.setText("");
        this.paletteCanvas.redraw();
        this.imageCanvas.redraw();
    }

    void paintImage(PaintEvent paintEvent) {
        Image image = this.image;
        int n = this.imageData.transparentPixel;
        if (n != -1 && !this.transparent) {
            this.imageData.transparentPixel = -1;
            image = new Image((Device)this.display, this.imageData);
        }
        int n2 = Math.round((float)this.imageData.width * this.xscale);
        int n3 = Math.round((float)this.imageData.height * this.yscale);
        paintEvent.gc.drawImage(image, 0, 0, this.imageData.width, this.imageData.height, this.ix + this.imageData.x, this.iy + this.imageData.y, n2, n3);
        if (this.showMask && this.imageData.getTransparencyType() != 0) {
            ImageData imageData = this.imageData.getTransparencyMask();
            Image image2 = new Image((Device)this.display, imageData);
            paintEvent.gc.drawImage(image2, 0, 0, this.imageData.width, this.imageData.height, n2 + 10 + this.ix + this.imageData.x, this.iy + this.imageData.y, n2, n3);
            image2.dispose();
        }
        if (n != -1 && !this.transparent) {
            this.imageData.transparentPixel = n;
            image.dispose();
        }
    }

    void paintPalette(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        gC.fillRectangle(this.paletteCanvas.getClientArea());
        if (this.imageData.palette.isDirect) {
            int n = this.py + 10;
            int n2 = 50;
            gC.drawString("rMsk", 10, n, true);
            gC.drawString(ImageAnalyzer.toHex4ByteString(this.imageData.palette.redMask), n2, n, true);
            gC.drawString("gMsk", 10, n += 12, true);
            gC.drawString(ImageAnalyzer.toHex4ByteString(this.imageData.palette.greenMask), n2, n, true);
            gC.drawString("bMsk", 10, n += 12, true);
            gC.drawString(ImageAnalyzer.toHex4ByteString(this.imageData.palette.blueMask), n2, n, true);
            gC.drawString("rShf", 10, n += 12, true);
            gC.drawString(Integer.toString(this.imageData.palette.redShift), n2, n, true);
            gC.drawString("gShf", 10, n += 12, true);
            gC.drawString(Integer.toString(this.imageData.palette.greenShift), n2, n, true);
            gC.drawString("bShf", 10, n += 12, true);
            gC.drawString(Integer.toString(this.imageData.palette.blueShift), n2, n, true);
        } else {
            RGB[] rGBArray = this.imageData.palette.getRGBs();
            if (rGBArray != null) {
                int n = 40;
                int n3 = 100;
                for (int i = 0; i < rGBArray.length; ++i) {
                    int n4 = (i + 1) * 10 + this.py;
                    gC.drawString(String.valueOf(i), 10, n4, true);
                    gC.drawString(ImageAnalyzer.toHexByteString(rGBArray[i].red) + ImageAnalyzer.toHexByteString(rGBArray[i].green) + ImageAnalyzer.toHexByteString(rGBArray[i].blue), n, n4, true);
                    Color color = new Color((Device)this.display, rGBArray[i]);
                    gC.setBackground(color);
                    gC.fillRectangle(n3, n4 + 2, 10, 10);
                    color.dispose();
                }
            }
        }
    }

    void resizeShell(ControlEvent controlEvent) {
        if (this.image == null || this.shell.isDisposed()) {
            return;
        }
        this.resizeScrollBars();
    }

    void resetScaleCombos() {
        this.xscale = 1.0f;
        this.yscale = 1.0f;
        this.scaleXCombo.select(this.scaleXCombo.indexOf("1"));
        this.scaleYCombo.select(this.scaleYCombo.indexOf("1"));
    }

    void resetScrollBars() {
        if (this.image == null) {
            return;
        }
        this.ix = 0;
        this.iy = 0;
        this.py = 0;
        this.resizeScrollBars();
        this.imageCanvas.getHorizontalBar().setSelection(0);
        this.imageCanvas.getVerticalBar().setSelection(0);
        this.paletteCanvas.getVerticalBar().setSelection(0);
    }

    void resizeScrollBars() {
        ScrollBar scrollBar = this.imageCanvas.getHorizontalBar();
        ScrollBar scrollBar2 = this.imageCanvas.getVerticalBar();
        Rectangle rectangle = this.imageCanvas.getClientArea();
        int n = Math.round((float)this.imageData.width * this.xscale);
        if (n > rectangle.width) {
            scrollBar.setEnabled(true);
            scrollBar.setMaximum(n);
            scrollBar.setThumb(rectangle.width);
            scrollBar.setPageIncrement(rectangle.width);
        } else {
            scrollBar.setEnabled(false);
            if (this.ix != 0) {
                this.ix = 0;
                this.imageCanvas.redraw();
            }
        }
        int n2 = Math.round((float)this.imageData.height * this.yscale);
        if (n2 > rectangle.height) {
            scrollBar2.setEnabled(true);
            scrollBar2.setMaximum(n2);
            scrollBar2.setThumb(rectangle.height);
            scrollBar2.setPageIncrement(rectangle.height);
        } else {
            scrollBar2.setEnabled(false);
            if (this.iy != 0) {
                this.iy = 0;
                this.imageCanvas.redraw();
            }
        }
        scrollBar2 = this.paletteCanvas.getVerticalBar();
        if (this.imageData.palette.isDirect) {
            scrollBar2.setEnabled(false);
        } else {
            rectangle = this.paletteCanvas.getClientArea();
            int n3 = this.imageData.palette.getRGBs().length * 10 + 20;
            scrollBar2.setEnabled(true);
            scrollBar2.setMaximum(n3);
            scrollBar2.setThumb(rectangle.height);
            scrollBar2.setPageIncrement(rectangle.height);
        }
    }

    void scrollHorizontally(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle rectangle = this.imageCanvas.getClientArea();
        int n = Math.round((float)this.imageData.width * this.xscale);
        int n2 = Math.round((float)this.imageData.height * this.yscale);
        if (n > rectangle.width) {
            int n3 = -scrollBar.getSelection();
            if (n3 + n < rectangle.width) {
                n3 = rectangle.width - n;
            }
            this.imageCanvas.scroll(n3, this.iy, this.ix, this.iy, n, n2, false);
            this.ix = n3;
        }
    }

    void scrollVertically(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle rectangle = this.imageCanvas.getClientArea();
        int n = Math.round((float)this.imageData.width * this.xscale);
        int n2 = Math.round((float)this.imageData.height * this.yscale);
        if (n2 > rectangle.height) {
            int n3 = -scrollBar.getSelection();
            if (n3 + n2 < rectangle.height) {
                n3 = rectangle.height - n2;
            }
            this.imageCanvas.scroll(this.ix, n3, this.ix, this.iy, n, n2, false);
            this.iy = n3;
        }
    }

    void scrollPalette(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle rectangle = this.paletteCanvas.getClientArea();
        int n = this.imageData.palette.getRGBs().length * 10 + 20;
        if (n > rectangle.height) {
            int n2 = -scrollBar.getSelection();
            if (n2 + n < rectangle.height) {
                n2 = rectangle.height - n;
            }
            this.paletteCanvas.scroll(0, n2, 0, this.py, this.paletteWidth, n, false);
            this.py = n2;
        }
    }

    String dataHexDump(String string) {
        if (this.image == null) {
            return "";
        }
        char[] cArray = new char[this.imageData.height * (6 + 3 * this.imageData.bytesPerLine + string.length())];
        int n = 0;
        for (int i = 0; i < this.imageData.data.length; ++i) {
            int n2;
            if (i % this.imageData.bytesPerLine == 0) {
                n2 = i / this.imageData.bytesPerLine;
                cArray[n++] = Character.forDigit(n2 / 1000 % 10, 10);
                cArray[n++] = Character.forDigit(n2 / 100 % 10, 10);
                cArray[n++] = Character.forDigit(n2 / 10 % 10, 10);
                cArray[n++] = Character.forDigit(n2 % 10, 10);
                cArray[n++] = 58;
                cArray[n++] = 32;
            }
            n2 = this.imageData.data[i];
            cArray[n++] = Character.forDigit((n2 & 0xF0) >> 4, 16);
            cArray[n++] = Character.forDigit(n2 & 0xF, 16);
            cArray[n++] = 32;
            if ((i + 1) % this.imageData.bytesPerLine != 0) continue;
            cArray[n++] = string.charAt(0);
            if (string.length() <= 1) continue;
            cArray[n++] = string.charAt(1);
        }
        String string2 = "";
        try {
            string2 = new String(cArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            string2 = new String(cArray, 0, 0x400000) + "\n ...data dump truncated at 4M...";
        }
        return string2;
    }

    void showErrorDialog(String string, String string2, Throwable throwable) {
        MessageBox messageBox = new MessageBox(this.shell, 1);
        String string3 = ImageAnalyzer.createMsg(bundle.getString("Error"), new String[]{string, string2});
        String string4 = "";
        if (throwable != null) {
            if (throwable instanceof SWTException) {
                SWTException sWTException = (SWTException)throwable;
                string4 = sWTException.getMessage();
                if (sWTException.throwable != null) {
                    string4 = string4 + ":\n" + sWTException.throwable.toString();
                }
            } else if (throwable instanceof SWTError) {
                SWTError sWTError = (SWTError)throwable;
                string4 = sWTError.getMessage();
                if (sWTError.throwable != null) {
                    string4 = string4 + ":\n" + sWTError.throwable.toString();
                }
            } else {
                string4 = throwable.toString();
            }
        }
        messageBox.setMessage(string3 + string4);
        messageBox.open();
    }

    int showBMPDialog() {
        final int[] nArray = new int[]{0};
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    nArray[0] = (Integer)button.getData();
                }
            }
        };
        final Shell shell = new Shell(this.shell, 2144);
        shell.setText(bundle.getString("Save_as_type"));
        shell.setLayout((Layout)new GridLayout());
        Label label = new Label((Composite)shell, 0);
        label.setText(bundle.getString("Save_as_type_label"));
        Button button = new Button((Composite)shell, 16);
        button.setText(bundle.getString("Save_as_type_no_compress"));
        button.setSelection(true);
        button.setData((Object)0);
        button.addSelectionListener((SelectionListener)selectionAdapter);
        button = new Button((Composite)shell, 16);
        button.setText(bundle.getString("Save_as_type_rle_compress"));
        button.setData((Object)1);
        button.addSelectionListener((SelectionListener)selectionAdapter);
        button = new Button((Composite)shell, 16);
        button.setText(bundle.getString("Save_as_type_os2"));
        button.setData((Object)7);
        button.addSelectionListener((SelectionListener)selectionAdapter);
        label = new Label((Composite)shell, 258);
        label.setLayoutData((Object)new GridData(768));
        Button button2 = new Button((Composite)shell, 8);
        button2.setText(bundle.getString("OK"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.widthHint = 75;
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.close();
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return nArray[0];
    }

    static String depthInfo(int n) {
        Object[] objectArray = new Object[]{n, ""};
        switch (n) {
            case 1: {
                objectArray[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_pixels"), new Object[]{8, " [01234567]"});
                break;
            }
            case 2: {
                objectArray[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_pixels"), new Object[]{4, "[00112233]"});
                break;
            }
            case 4: {
                objectArray[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_pixels"), new Object[]{2, "[00001111]"});
                break;
            }
            case 8: {
                objectArray[1] = bundle.getString("One_byte");
                break;
            }
            case 16: {
                objectArray[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_bytes"), 2);
                break;
            }
            case 24: {
                objectArray[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_bytes"), 3);
                break;
            }
            case 32: {
                objectArray[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_bytes"), 4);
                break;
            }
            default: {
                objectArray[1] = bundle.getString("Unsupported_lc");
            }
        }
        return ImageAnalyzer.createMsg(bundle.getString("Depth_info"), objectArray);
    }

    static int visibleDelay(int n) {
        if (n < 20) {
            return n + 30;
        }
        if (n < 30) {
            return n + 10;
        }
        return n;
    }

    static String toHexByteString(int n) {
        if (n <= 15) {
            return "0" + Integer.toHexString(n);
        }
        return Integer.toHexString(n & 0xFF);
    }

    static String toHex4ByteString(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            return "0000000" + string;
        }
        if (string.length() == 2) {
            return "000000" + string;
        }
        if (string.length() == 3) {
            return "00000" + string;
        }
        if (string.length() == 4) {
            return "0000" + string;
        }
        if (string.length() == 5) {
            return "000" + string;
        }
        if (string.length() == 6) {
            return "00" + string;
        }
        if (string.length() == 7) {
            return "0" + string;
        }
        return string;
    }

    static String pixelInfo(int n) {
        if (n == -1) {
            return n + " (" + bundle.getString("None_lc") + ")";
        }
        return n + " (0x" + Integer.toHexString(n) + ")";
    }

    static String disposalString(int n) {
        switch (n) {
            case 1: {
                return bundle.getString("None_lc");
            }
            case 2: {
                return bundle.getString("Background_lc");
            }
            case 3: {
                return bundle.getString("Previous_lc");
            }
        }
        return bundle.getString("Unspecified_lc");
    }

    String fileTypeString(int n) {
        if (n == 0) {
            return "BMP";
        }
        if (n == 1) {
            return "RLE" + this.imageData.depth + " BMP";
        }
        if (n == 7) {
            return "OS/2 BMP";
        }
        if (n == 2) {
            return "GIF";
        }
        if (n == 3) {
            return "ICO";
        }
        if (n == 4) {
            return "JPEG";
        }
        if (n == 5) {
            return "PNG";
        }
        return bundle.getString("Unknown_ac");
    }

    int determineFileType(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        if (string2.equalsIgnoreCase("bmp")) {
            return this.showBMPDialog();
        }
        if (string2.equalsIgnoreCase("gif")) {
            return 2;
        }
        if (string2.equalsIgnoreCase("ico")) {
            return 3;
        }
        if (string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("jpeg")) {
            return 4;
        }
        if (string2.equalsIgnoreCase("png")) {
            return 5;
        }
        return -1;
    }

    static String createMsg(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    static String createMsg(String string, Object object) {
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(new Object[]{object});
    }

    class TextPrompter
    extends Dialog {
        String message;
        String result;
        Shell dialog;
        Text text;

        public TextPrompter(Shell shell, int n) {
            super(shell, n);
            this.message = "";
            this.result = null;
        }

        public TextPrompter(Shell shell) {
            this(shell, 65536);
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String string) {
            this.message = string;
        }

        public String open() {
            this.dialog = new Shell(this.getParent(), this.getStyle());
            this.dialog.setText(this.getText());
            this.dialog.setLayout((Layout)new GridLayout());
            Label label = new Label((Composite)this.dialog, 0);
            label.setText(this.message);
            label.setLayoutData((Object)new GridData(768));
            this.text = new Text((Composite)this.dialog, 2052);
            GridData gridData = new GridData(768);
            gridData.widthHint = 300;
            this.text.setLayoutData((Object)gridData);
            Composite composite = new Composite((Composite)this.dialog, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(128));
            Button button = new Button(composite, 8);
            button.setText(bundle.getString("OK"));
            gridData = new GridData();
            gridData.widthHint = 75;
            button.setLayoutData((Object)gridData);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TextPrompter.this.result = TextPrompter.this.text.getText();
                    TextPrompter.this.dialog.dispose();
                }
            });
            Button button2 = new Button(composite, 8);
            button2.setText(bundle.getString("Cancel"));
            gridData = new GridData();
            gridData.widthHint = 75;
            button2.setLayoutData((Object)gridData);
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TextPrompter.this.dialog.dispose();
                }
            });
            this.dialog.setDefaultButton(button);
            this.dialog.pack();
            this.dialog.open();
            while (!this.dialog.isDisposed()) {
                if (ImageAnalyzer.this.display.readAndDispatch()) continue;
                ImageAnalyzer.this.display.sleep();
            }
            return this.result;
        }
    }
}

